# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.address import Address
from solomonai_backend_client_sdk.models.audit_log import AuditLog
from solomonai_backend_client_sdk.models.tags import Tags
from solomonai_backend_client_sdk.models.team_invites import TeamInvites
from solomonai_backend_client_sdk.models.team_member import TeamMember
from solomonai_backend_client_sdk.models.team_ownership import TeamOwnership
from solomonai_backend_client_sdk.models.team_resource import TeamResource
from solomonai_backend_client_sdk.models.team_type import TeamType
from typing import Optional, Set
from typing_extensions import Self

class Team(BaseModel):
    """
    Team: represents a team within the context of solomon-ai.
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the team.")
    name: StrictStr = Field(description="Name of the team.")
    description: Optional[StrictStr] = Field(default=None, description="Description of the team, providing additional details or purpose.")
    tags: Optional[List[Tags]] = Field(default=None, description="Tags associated with the team, useful for categorization or filtering.")
    team_type: Optional[TeamType] = Field(default=TeamType.UNSPECIFIED, alias="teamType")
    is_active: Optional[StrictBool] = Field(default=None, description="Indicates if the team is currently active.", alias="isActive")
    metadata: Optional[Dict[str, Any]] = Field(default=None, description="Metadata in JSON format, allowing flexible storage for additional team-related information.")
    created_at: Optional[datetime] = Field(default=None, description="Timestamp indicating when the team was created.", alias="createdAt")
    updated_at: Optional[datetime] = Field(default=None, description="Timestamp indicating the last update time for the team.", alias="updatedAt")
    team_members: Optional[List[TeamMember]] = Field(default=None, description="Team Roles and Members --------------------- List of team members, with each member having specific roles and permissions.", alias="teamMembers")
    address: Optional[Address] = None
    audit_logs: Optional[List[AuditLog]] = Field(default=None, description="Audit logs related to the team, used for tracking changes and events.", alias="auditLogs")
    team_invites: Optional[List[TeamInvites]] = Field(default=None, alias="teamInvites")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    ownership: Optional[TeamOwnership] = None
    resources: Optional[List[TeamResource]] = None
    max_members: Optional[StrictInt] = Field(default=None, alias="maxMembers")
    joined_at: Optional[datetime] = Field(default=None, alias="joinedAt")
    last_active: Optional[datetime] = Field(default=None, alias="lastActive")
    __properties: ClassVar[List[str]] = ["id", "name", "description", "tags", "teamType", "isActive", "metadata", "createdAt", "updatedAt", "teamMembers", "address", "auditLogs", "teamInvites", "deletedAt", "ownership", "resources", "maxMembers", "joinedAt", "lastActive"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Team from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item in self.tags:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tags'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in team_members (list)
        _items = []
        if self.team_members:
            for _item in self.team_members:
                if _item:
                    _items.append(_item.to_dict())
            _dict['teamMembers'] = _items
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict['address'] = self.address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in audit_logs (list)
        _items = []
        if self.audit_logs:
            for _item in self.audit_logs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['auditLogs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in team_invites (list)
        _items = []
        if self.team_invites:
            for _item in self.team_invites:
                if _item:
                    _items.append(_item.to_dict())
            _dict['teamInvites'] = _items
        # override the default output from pydantic by calling `to_dict()` of ownership
        if self.ownership:
            _dict['ownership'] = self.ownership.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in resources (list)
        _items = []
        if self.resources:
            for _item in self.resources:
                if _item:
                    _items.append(_item.to_dict())
            _dict['resources'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Team from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "tags": [Tags.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "teamType": obj.get("teamType") if obj.get("teamType") is not None else TeamType.UNSPECIFIED,
            "isActive": obj.get("isActive"),
            "metadata": obj.get("metadata"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "teamMembers": [TeamMember.from_dict(_item) for _item in obj["teamMembers"]] if obj.get("teamMembers") is not None else None,
            "address": Address.from_dict(obj["address"]) if obj.get("address") is not None else None,
            "auditLogs": [AuditLog.from_dict(_item) for _item in obj["auditLogs"]] if obj.get("auditLogs") is not None else None,
            "teamInvites": [TeamInvites.from_dict(_item) for _item in obj["teamInvites"]] if obj.get("teamInvites") is not None else None,
            "deletedAt": obj.get("deletedAt"),
            "ownership": TeamOwnership.from_dict(obj["ownership"]) if obj.get("ownership") is not None else None,
            "resources": [TeamResource.from_dict(_item) for _item in obj["resources"]] if obj.get("resources") is not None else None,
            "maxMembers": obj.get("maxMembers"),
            "joinedAt": obj.get("joinedAt"),
            "lastActive": obj.get("lastActive")
        })
        return _obj


