# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from solomonai_backend_client_sdk.models.account_type import AccountType
from solomonai_backend_client_sdk.models.category import Category
from solomonai_backend_client_sdk.models.comment import Comment
from solomonai_backend_client_sdk.models.note import Note
from solomonai_backend_client_sdk.models.post_type import PostType
from solomonai_backend_client_sdk.models.reaction import Reaction
from solomonai_backend_client_sdk.models.thread import Thread
from typing import Optional, Set
from typing_extensions import Self

class SharedPost(BaseModel):
    """
    SharedPost
    """ # noqa: E501
    id: Optional[StrictStr] = None
    original_post_id: Annotated[str, Field(min_length=1, strict=True)] = Field(alias="originalPostId")
    original_author_username: Optional[StrictStr] = Field(default=None, alias="originalAuthorUsername")
    created_at: Optional[StrictStr] = Field(default=None, alias="createdAt")
    content: StrictStr
    mentions: Optional[List[StrictStr]] = None
    hashtags: Optional[List[StrictStr]] = None
    extra: Optional[Dict[str, StrictStr]] = None
    comments: Optional[List[Comment]] = None
    backend_platform_user_id: Optional[StrictStr] = Field(default=None, alias="backendPlatformUserId")
    profile_id: Optional[StrictStr] = Field(default=None, alias="profileId")
    tags: Optional[List[StrictStr]] = None
    author_username: Optional[StrictStr] = Field(default=None, alias="authorUsername")
    affinity_score: Optional[StrictStr] = Field(default=None, alias="affinityScore")
    quality_score: Optional[StrictStr] = Field(default=None, alias="qualityScore")
    user_id_to_affinity_score_map: Optional[Dict[str, StrictStr]] = Field(default=None, alias="userIdToAffinityScoreMap")
    user_id_to_reports_map: Optional[Dict[str, StrictStr]] = Field(default=None, description="AccountType is the account type of the creator of this piece of  content", alias="userIdToReportsMap")
    notes: Optional[List[Note]] = None
    thread: Optional[Thread] = None
    author_account_type: Optional[AccountType] = Field(default=AccountType.UNSPECIFIED, alias="authorAccountType")
    user_id_to_reaction_map: Optional[Dict[str, Reaction]] = Field(default=None, alias="userIdToReactionMap")
    action: PostType
    original_post_user_profile_id: Optional[StrictStr] = Field(default=None, alias="originalPostUserProfileId")
    original_post_userbackend_plaform_id: Optional[StrictStr] = Field(default=None, alias="originalPostUserbackendPlaformId")
    original_post_action: PostType = Field(alias="originalPostAction")
    category: Optional[Category] = Category.UNSPECIFIED
    __properties: ClassVar[List[str]] = ["id", "originalPostId", "originalAuthorUsername", "createdAt", "content", "mentions", "hashtags", "extra", "comments", "backendPlatformUserId", "profileId", "tags", "authorUsername", "affinityScore", "qualityScore", "userIdToAffinityScoreMap", "userIdToReportsMap", "notes", "thread", "authorAccountType", "userIdToReactionMap", "action", "originalPostUserProfileId", "originalPostUserbackendPlaformId", "originalPostAction", "category"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SharedPost from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in comments (list)
        _items = []
        if self.comments:
            for _item in self.comments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['comments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in notes (list)
        _items = []
        if self.notes:
            for _item in self.notes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['notes'] = _items
        # override the default output from pydantic by calling `to_dict()` of thread
        if self.thread:
            _dict['thread'] = self.thread.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SharedPost from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "originalPostId": obj.get("originalPostId"),
            "originalAuthorUsername": obj.get("originalAuthorUsername"),
            "createdAt": obj.get("createdAt"),
            "content": obj.get("content"),
            "mentions": obj.get("mentions"),
            "hashtags": obj.get("hashtags"),
            "extra": obj.get("extra"),
            "comments": [Comment.from_dict(_item) for _item in obj["comments"]] if obj.get("comments") is not None else None,
            "backendPlatformUserId": obj.get("backendPlatformUserId"),
            "profileId": obj.get("profileId"),
            "tags": obj.get("tags"),
            "authorUsername": obj.get("authorUsername"),
            "affinityScore": obj.get("affinityScore"),
            "qualityScore": obj.get("qualityScore"),
            "userIdToAffinityScoreMap": obj.get("userIdToAffinityScoreMap"),
            "userIdToReportsMap": obj.get("userIdToReportsMap"),
            "notes": [Note.from_dict(_item) for _item in obj["notes"]] if obj.get("notes") is not None else None,
            "thread": Thread.from_dict(obj["thread"]) if obj.get("thread") is not None else None,
            "authorAccountType": obj.get("authorAccountType") if obj.get("authorAccountType") is not None else AccountType.UNSPECIFIED,
            "userIdToReactionMap": dict((_k, _v) for _k, _v in obj.get("userIdToReactionMap").items()),
            "action": obj.get("action") if obj.get("action") is not None else PostType.UNSPECIFIED,
            "originalPostUserProfileId": obj.get("originalPostUserProfileId"),
            "originalPostUserbackendPlaformId": obj.get("originalPostUserbackendPlaformId"),
            "originalPostAction": obj.get("originalPostAction") if obj.get("originalPostAction") is not None else PostType.UNSPECIFIED,
            "category": obj.get("category") if obj.get("category") is not None else Category.UNSPECIFIED
        })
        return _obj


