# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class SharePermission(str, Enum):
    """
    SharePermission defines the access levels available for shared resources. Used to control what actions users can perform on shared files and workspaces.  Values: - UNSPECIFIED: Default value, indicates no permissions set - VIEW: Read-only access to view content - COMMENT: Can view and add comments - EDIT: Full edit access to modify content  Usage example: ```go sharing := &FileSharing{   PermissionLevel: SharePermission_SHARE_PERMISSION_VIEW } ```   - SHARE_PERMISSION_UNSPECIFIED: Default value, no permissions specified  - SHARE_PERMISSION_VIEW: Read-only access to content  - SHARE_PERMISSION_COMMENT: Can view content and add comments  - SHARE_PERMISSION_EDIT: Full edit access to content  - SHARE_PERMISSION_SHARE: Can share with others and manage sharing settings  - SHARE_PERMISSION_DELETE: Can delete the resource  - SHARE_PERMISSION_MOVE: Can move/relocate the resource  - SHARE_PERMISSION_RENAME: Can rename the resource  - SHARE_PERMISSION_VERSION: Can create and manage versions  - SHARE_PERMISSION_TAG: Can add/remove tags  - SHARE_PERMISSION_METADATA: Can modify resource metadata  - SHARE_PERMISSION_DOWNLOAD: Can download/export the resource  - SHARE_PERMISSION_PRINT: Can print the resource  - SHARE_PERMISSION_ADMIN: Full administrative access including permission management  - SHARE_PERMISSION_OWNER: Complete ownership with all permissions
    """

    """
    allowed enum values
    """
    SHARE_PERMISSION_UNSPECIFIED = 'SHARE_PERMISSION_UNSPECIFIED'
    SHARE_PERMISSION_VIEW = 'SHARE_PERMISSION_VIEW'
    SHARE_PERMISSION_COMMENT = 'SHARE_PERMISSION_COMMENT'
    SHARE_PERMISSION_EDIT = 'SHARE_PERMISSION_EDIT'
    SHARE_PERMISSION_SHARE = 'SHARE_PERMISSION_SHARE'
    SHARE_PERMISSION_DELETE = 'SHARE_PERMISSION_DELETE'
    SHARE_PERMISSION_MOVE = 'SHARE_PERMISSION_MOVE'
    SHARE_PERMISSION_RENAME = 'SHARE_PERMISSION_RENAME'
    SHARE_PERMISSION_VERSION = 'SHARE_PERMISSION_VERSION'
    SHARE_PERMISSION_TAG = 'SHARE_PERMISSION_TAG'
    SHARE_PERMISSION_METADATA = 'SHARE_PERMISSION_METADATA'
    SHARE_PERMISSION_DOWNLOAD = 'SHARE_PERMISSION_DOWNLOAD'
    SHARE_PERMISSION_PRINT = 'SHARE_PERMISSION_PRINT'
    SHARE_PERMISSION_ADMIN = 'SHARE_PERMISSION_ADMIN'
    SHARE_PERMISSION_OWNER = 'SHARE_PERMISSION_OWNER'

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of SharePermission from a JSON string"""
        return cls(json.loads(json_str))


