# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.role_audit_events import RoleAuditEvents
from solomonai_backend_client_sdk.models.role_type import RoleType
from typing import Optional, Set
from typing_extensions import Self

class Role(BaseModel):
    """
    Role defines the role of a user in the system with specific permissions.
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the role.")
    name: Optional[StrictStr] = Field(default=None, description="Name of the role.")
    type: Optional[RoleType] = RoleType.UNSPECIFIED
    can_create_users: Optional[StrictBool] = Field(default=None, description="Permissions related to user management.", alias="canCreateUsers")
    can_read_users: Optional[StrictBool] = Field(default=None, alias="canReadUsers")
    can_update_users: Optional[StrictBool] = Field(default=None, alias="canUpdateUsers")
    can_delete_users: Optional[StrictBool] = Field(default=None, alias="canDeleteUsers")
    can_create_projects: Optional[StrictBool] = Field(default=None, description="Permissions related to project management.", alias="canCreateProjects")
    can_read_projects: Optional[StrictBool] = Field(default=None, alias="canReadProjects")
    can_update_projects: Optional[StrictBool] = Field(default=None, alias="canUpdateProjects")
    can_delete_projects: Optional[StrictBool] = Field(default=None, alias="canDeleteProjects")
    can_create_reports: Optional[StrictBool] = Field(default=None, description="Permissions related to report management.", alias="canCreateReports")
    can_read_reports: Optional[StrictBool] = Field(default=None, alias="canReadReports")
    can_update_reports: Optional[StrictBool] = Field(default=None, alias="canUpdateReports")
    can_delete_reports: Optional[StrictBool] = Field(default=None, alias="canDeleteReports")
    created_at: Optional[datetime] = Field(default=None, description="Add more permissions as necessary for other modules or features. Timestamps for tracking creation and modification times.", alias="createdAt")
    updated_at: Optional[datetime] = Field(default=None, alias="updatedAt")
    audit_log: Optional[List[RoleAuditEvents]] = Field(default=None, description="Audit log for this role.", alias="auditLog")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    assignment_reason: Optional[StrictStr] = Field(default=None, alias="assignmentReason")
    assigned_at: Optional[datetime] = Field(default=None, alias="assignedAt")
    expires_at: Optional[datetime] = Field(default=None, alias="expiresAt")
    is_active: Optional[StrictBool] = Field(default=None, alias="isActive")
    limitations: Optional[List[StrictStr]] = None
    role_settings: Optional[Dict[str, Any]] = Field(default=None, alias="roleSettings")
    __properties: ClassVar[List[str]] = ["id", "name", "type", "canCreateUsers", "canReadUsers", "canUpdateUsers", "canDeleteUsers", "canCreateProjects", "canReadProjects", "canUpdateProjects", "canDeleteProjects", "canCreateReports", "canReadReports", "canUpdateReports", "canDeleteReports", "createdAt", "updatedAt", "auditLog", "deletedAt", "assignmentReason", "assignedAt", "expiresAt", "isActive", "limitations", "roleSettings"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Role from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in audit_log (list)
        _items = []
        if self.audit_log:
            for _item in self.audit_log:
                if _item:
                    _items.append(_item.to_dict())
            _dict['auditLog'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Role from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "type": obj.get("type") if obj.get("type") is not None else RoleType.UNSPECIFIED,
            "canCreateUsers": obj.get("canCreateUsers"),
            "canReadUsers": obj.get("canReadUsers"),
            "canUpdateUsers": obj.get("canUpdateUsers"),
            "canDeleteUsers": obj.get("canDeleteUsers"),
            "canCreateProjects": obj.get("canCreateProjects"),
            "canReadProjects": obj.get("canReadProjects"),
            "canUpdateProjects": obj.get("canUpdateProjects"),
            "canDeleteProjects": obj.get("canDeleteProjects"),
            "canCreateReports": obj.get("canCreateReports"),
            "canReadReports": obj.get("canReadReports"),
            "canUpdateReports": obj.get("canUpdateReports"),
            "canDeleteReports": obj.get("canDeleteReports"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "auditLog": [RoleAuditEvents.from_dict(_item) for _item in obj["auditLog"]] if obj.get("auditLog") is not None else None,
            "deletedAt": obj.get("deletedAt"),
            "assignmentReason": obj.get("assignmentReason"),
            "assignedAt": obj.get("assignedAt"),
            "expiresAt": obj.get("expiresAt"),
            "isActive": obj.get("isActive"),
            "limitations": obj.get("limitations"),
            "roleSettings": obj.get("roleSettings")
        })
        return _obj


