# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from solomonai_backend_client_sdk.models.account_type import AccountType
from solomonai_backend_client_sdk.models.category import Category
from solomonai_backend_client_sdk.models.comment import Comment
from solomonai_backend_client_sdk.models.content_insights import ContentInsights
from solomonai_backend_client_sdk.models.media import Media
from solomonai_backend_client_sdk.models.note import Note
from solomonai_backend_client_sdk.models.poll_response import PollResponse
from solomonai_backend_client_sdk.models.post_type import PostType
from solomonai_backend_client_sdk.models.reaction import Reaction
from solomonai_backend_client_sdk.models.thread import Thread
from solomonai_backend_client_sdk.models.thread_participant_type import ThreadParticipantType
from typing import Optional, Set
from typing_extensions import Self

class PollPost(BaseModel):
    """
    PollPost
    """ # noqa: E501
    id: Optional[StrictStr] = None
    created_at: Optional[StrictStr] = Field(default=None, alias="createdAt")
    action: PostType
    content: StrictStr
    mentions: Optional[List[StrictStr]] = None
    hashtags: Optional[List[StrictStr]] = None
    media: Optional[Media] = None
    extra: Optional[Dict[str, StrictStr]] = None
    comments: Optional[List[Comment]] = None
    backend_platform_user_id: Optional[StrictStr] = Field(default=None, alias="backendPlatformUserId")
    profile_id: Optional[StrictStr] = Field(default=None, alias="profileId")
    title: Optional[StrictStr] = None
    tags: Optional[List[StrictStr]] = None
    topic_name: Optional[StrictStr] = Field(default=None, alias="topicName")
    author_username: Optional[StrictStr] = Field(default=None, alias="authorUsername")
    author_profile_image: Optional[StrictStr] = Field(default=None, alias="authorProfileImage")
    affinity_score: Optional[StrictStr] = Field(default=None, alias="affinityScore")
    quality_score: Optional[StrictStr] = Field(default=None, alias="qualityScore")
    user_id_to_affinity_score_map: Optional[Dict[str, StrictStr]] = Field(default=None, alias="userIdToAffinityScoreMap")
    insights: Optional[ContentInsights] = None
    user_id_to_reports_map: Optional[Dict[str, StrictStr]] = Field(default=None, alias="userIdToReportsMap")
    background_image_url: Optional[StrictStr] = Field(default=None, alias="backgroundImageUrl")
    author_account_type: Optional[AccountType] = Field(default=AccountType.UNSPECIFIED, alias="authorAccountType")
    user_id_to_poll_responses_map: Optional[Dict[str, PollResponse]] = Field(default=None, alias="userIdToPollResponsesMap")
    poll_options: List[StrictStr] = Field(alias="pollOptions")
    poll_distribution: Optional[Dict[str, Union[StrictFloat, StrictInt]]] = Field(default=None, alias="pollDistribution")
    poll_end_date: Optional[datetime] = Field(default=None, alias="pollEndDate")
    notes: Optional[List[Note]] = None
    thread: Optional[Thread] = None
    thread_participant_type: Optional[ThreadParticipantType] = Field(default=ThreadParticipantType.UNSPECIFIED, alias="threadParticipantType")
    user_id_to_reaction_map: Optional[Dict[str, Reaction]] = Field(default=None, alias="userIdToReactionMap")
    category: Optional[Category] = Category.UNSPECIFIED
    __properties: ClassVar[List[str]] = ["id", "createdAt", "action", "content", "mentions", "hashtags", "media", "extra", "comments", "backendPlatformUserId", "profileId", "title", "tags", "topicName", "authorUsername", "authorProfileImage", "affinityScore", "qualityScore", "userIdToAffinityScoreMap", "insights", "userIdToReportsMap", "backgroundImageUrl", "authorAccountType", "userIdToPollResponsesMap", "pollOptions", "pollDistribution", "pollEndDate", "notes", "thread", "threadParticipantType", "userIdToReactionMap", "category"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PollPost from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of media
        if self.media:
            _dict['media'] = self.media.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in comments (list)
        _items = []
        if self.comments:
            for _item in self.comments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['comments'] = _items
        # override the default output from pydantic by calling `to_dict()` of insights
        if self.insights:
            _dict['insights'] = self.insights.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in user_id_to_poll_responses_map (dict)
        _field_dict = {}
        if self.user_id_to_poll_responses_map:
            for _key in self.user_id_to_poll_responses_map:
                if self.user_id_to_poll_responses_map[_key]:
                    _field_dict[_key] = self.user_id_to_poll_responses_map[_key].to_dict()
            _dict['userIdToPollResponsesMap'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each item in notes (list)
        _items = []
        if self.notes:
            for _item in self.notes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['notes'] = _items
        # override the default output from pydantic by calling `to_dict()` of thread
        if self.thread:
            _dict['thread'] = self.thread.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PollPost from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "createdAt": obj.get("createdAt"),
            "action": obj.get("action") if obj.get("action") is not None else PostType.UNSPECIFIED,
            "content": obj.get("content"),
            "mentions": obj.get("mentions"),
            "hashtags": obj.get("hashtags"),
            "media": Media.from_dict(obj["media"]) if obj.get("media") is not None else None,
            "extra": obj.get("extra"),
            "comments": [Comment.from_dict(_item) for _item in obj["comments"]] if obj.get("comments") is not None else None,
            "backendPlatformUserId": obj.get("backendPlatformUserId"),
            "profileId": obj.get("profileId"),
            "title": obj.get("title"),
            "tags": obj.get("tags"),
            "topicName": obj.get("topicName"),
            "authorUsername": obj.get("authorUsername"),
            "authorProfileImage": obj.get("authorProfileImage"),
            "affinityScore": obj.get("affinityScore"),
            "qualityScore": obj.get("qualityScore"),
            "userIdToAffinityScoreMap": obj.get("userIdToAffinityScoreMap"),
            "insights": ContentInsights.from_dict(obj["insights"]) if obj.get("insights") is not None else None,
            "userIdToReportsMap": obj.get("userIdToReportsMap"),
            "backgroundImageUrl": obj.get("backgroundImageUrl"),
            "authorAccountType": obj.get("authorAccountType") if obj.get("authorAccountType") is not None else AccountType.UNSPECIFIED,
            "userIdToPollResponsesMap": dict(
                (_k, PollResponse.from_dict(_v))
                for _k, _v in obj["userIdToPollResponsesMap"].items()
            )
            if obj.get("userIdToPollResponsesMap") is not None
            else None,
            "pollOptions": obj.get("pollOptions"),
            "pollDistribution": obj.get("pollDistribution"),
            "pollEndDate": obj.get("pollEndDate"),
            "notes": [Note.from_dict(_item) for _item in obj["notes"]] if obj.get("notes") is not None else None,
            "thread": Thread.from_dict(obj["thread"]) if obj.get("thread") is not None else None,
            "threadParticipantType": obj.get("threadParticipantType") if obj.get("threadParticipantType") is not None else ThreadParticipantType.UNSPECIFIED,
            "userIdToReactionMap": dict((_k, _v) for _k, _v in obj.get("userIdToReactionMap").items()),
            "category": obj.get("category") if obj.get("category") is not None else Category.UNSPECIFIED
        })
        return _obj


