# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.accounting_integration_merge_link import AccountingIntegrationMergeLink
from solomonai_backend_client_sdk.models.business_actionable_insight import BusinessActionableInsight
from solomonai_backend_client_sdk.models.hris_integration_merge_link import HrisIntegrationMergeLink
from typing import Optional, Set
from typing_extensions import Self

class MergeBusinessProfile(BaseModel):
    """
    MergeBusinessProfile
    """ # noqa: E501
    id: Optional[StrictStr] = None
    auth_zero_user_id: StrictStr = Field(alias="authZeroUserId")
    company_name: Optional[StrictStr] = Field(default=None, alias="companyName")
    org_id: StrictStr = Field(alias="orgId")
    tenant_id: StrictStr = Field(alias="tenantId")
    email: StrictStr
    accounting_integration_merge_link: Optional[List[AccountingIntegrationMergeLink]] = Field(default=None, alias="accountingIntegrationMergeLink")
    payroll_integration_merge_link: Optional[List[HrisIntegrationMergeLink]] = Field(default=None, alias="payrollIntegrationMergeLink")
    actionable_personal_insights: Optional[List[BusinessActionableInsight]] = Field(default=None, alias="actionablePersonalInsights")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "authZeroUserId", "companyName", "orgId", "tenantId", "email", "accountingIntegrationMergeLink", "payrollIntegrationMergeLink", "actionablePersonalInsights", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MergeBusinessProfile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in accounting_integration_merge_link (list)
        _items = []
        if self.accounting_integration_merge_link:
            for _item in self.accounting_integration_merge_link:
                if _item:
                    _items.append(_item.to_dict())
            _dict['accountingIntegrationMergeLink'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in payroll_integration_merge_link (list)
        _items = []
        if self.payroll_integration_merge_link:
            for _item in self.payroll_integration_merge_link:
                if _item:
                    _items.append(_item.to_dict())
            _dict['payrollIntegrationMergeLink'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in actionable_personal_insights (list)
        _items = []
        if self.actionable_personal_insights:
            for _item in self.actionable_personal_insights:
                if _item:
                    _items.append(_item.to_dict())
            _dict['actionablePersonalInsights'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MergeBusinessProfile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "authZeroUserId": obj.get("authZeroUserId"),
            "companyName": obj.get("companyName"),
            "orgId": obj.get("orgId"),
            "tenantId": obj.get("tenantId"),
            "email": obj.get("email"),
            "accountingIntegrationMergeLink": [AccountingIntegrationMergeLink.from_dict(_item) for _item in obj["accountingIntegrationMergeLink"]] if obj.get("accountingIntegrationMergeLink") is not None else None,
            "payrollIntegrationMergeLink": [HrisIntegrationMergeLink.from_dict(_item) for _item in obj["payrollIntegrationMergeLink"]] if obj.get("payrollIntegrationMergeLink") is not None else None,
            "actionablePersonalInsights": [BusinessActionableInsight.from_dict(_item) for _item in obj["actionablePersonalInsights"]] if obj.get("actionablePersonalInsights") is not None else None,
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


