# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.bank_account import BankAccount
from solomonai_backend_client_sdk.models.category_metrics_financial_sub_profile import CategoryMetricsFinancialSubProfile
from solomonai_backend_client_sdk.models.credit_account import CreditAccount
from solomonai_backend_client_sdk.models.expense_metrics_financial_sub_profile_metrics import ExpenseMetricsFinancialSubProfileMetrics
from solomonai_backend_client_sdk.models.financial_user_profile_type import FinancialUserProfileType
from solomonai_backend_client_sdk.models.income_metrics_financial_sub_profile import IncomeMetricsFinancialSubProfile
from solomonai_backend_client_sdk.models.investment_account import InvestmentAccount
from solomonai_backend_client_sdk.models.location_financial_sub_profile import LocationFinancialSubProfile
from solomonai_backend_client_sdk.models.merchant_metrics_financial_sub_profile import MerchantMetricsFinancialSubProfile
from solomonai_backend_client_sdk.models.mortgage_account import MortgageAccount
from solomonai_backend_client_sdk.models.payment_channel_metrics_financial_sub_profile import PaymentChannelMetricsFinancialSubProfile
from solomonai_backend_client_sdk.models.student_loan_account import StudentLoanAccount
from typing import Optional, Set
from typing_extensions import Self

class MelodyFinancialContext(BaseModel):
    """
    MelodyFinancialContext represents the financial context of a user. This message is used to represent the financial context of a user.
    """ # noqa: E501
    categories: Optional[List[CategoryMetricsFinancialSubProfile]] = None
    expenses: Optional[List[ExpenseMetricsFinancialSubProfileMetrics]] = None
    income: Optional[List[IncomeMetricsFinancialSubProfile]] = None
    locations: Optional[List[LocationFinancialSubProfile]] = None
    merchants: Optional[List[MerchantMetricsFinancialSubProfile]] = None
    payment_channels: Optional[List[PaymentChannelMetricsFinancialSubProfile]] = Field(default=None, alias="paymentChannels")
    bank_accounts: Optional[List[BankAccount]] = Field(default=None, alias="bankAccounts")
    investment_accounts: Optional[List[InvestmentAccount]] = Field(default=None, alias="investmentAccounts")
    credit_accounts: Optional[List[CreditAccount]] = Field(default=None, alias="creditAccounts")
    mortgage_loan_accounts: Optional[List[MortgageAccount]] = Field(default=None, alias="mortgageLoanAccounts")
    student_loan_accounts: Optional[List[StudentLoanAccount]] = Field(default=None, alias="studentLoanAccounts")
    financial_user_profile_type: Optional[FinancialUserProfileType] = Field(default=FinancialUserProfileType.UNSPECIFIED, alias="financialUserProfileType")
    __properties: ClassVar[List[str]] = ["categories", "expenses", "income", "locations", "merchants", "paymentChannels", "bankAccounts", "investmentAccounts", "creditAccounts", "mortgageLoanAccounts", "studentLoanAccounts", "financialUserProfileType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MelodyFinancialContext from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in categories (list)
        _items = []
        if self.categories:
            for _item in self.categories:
                if _item:
                    _items.append(_item.to_dict())
            _dict['categories'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in expenses (list)
        _items = []
        if self.expenses:
            for _item in self.expenses:
                if _item:
                    _items.append(_item.to_dict())
            _dict['expenses'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in income (list)
        _items = []
        if self.income:
            for _item in self.income:
                if _item:
                    _items.append(_item.to_dict())
            _dict['income'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in locations (list)
        _items = []
        if self.locations:
            for _item in self.locations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['locations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in merchants (list)
        _items = []
        if self.merchants:
            for _item in self.merchants:
                if _item:
                    _items.append(_item.to_dict())
            _dict['merchants'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in payment_channels (list)
        _items = []
        if self.payment_channels:
            for _item in self.payment_channels:
                if _item:
                    _items.append(_item.to_dict())
            _dict['paymentChannels'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in bank_accounts (list)
        _items = []
        if self.bank_accounts:
            for _item in self.bank_accounts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['bankAccounts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in investment_accounts (list)
        _items = []
        if self.investment_accounts:
            for _item in self.investment_accounts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['investmentAccounts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in credit_accounts (list)
        _items = []
        if self.credit_accounts:
            for _item in self.credit_accounts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['creditAccounts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in mortgage_loan_accounts (list)
        _items = []
        if self.mortgage_loan_accounts:
            for _item in self.mortgage_loan_accounts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['mortgageLoanAccounts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in student_loan_accounts (list)
        _items = []
        if self.student_loan_accounts:
            for _item in self.student_loan_accounts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['studentLoanAccounts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MelodyFinancialContext from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "categories": [CategoryMetricsFinancialSubProfile.from_dict(_item) for _item in obj["categories"]] if obj.get("categories") is not None else None,
            "expenses": [ExpenseMetricsFinancialSubProfileMetrics.from_dict(_item) for _item in obj["expenses"]] if obj.get("expenses") is not None else None,
            "income": [IncomeMetricsFinancialSubProfile.from_dict(_item) for _item in obj["income"]] if obj.get("income") is not None else None,
            "locations": [LocationFinancialSubProfile.from_dict(_item) for _item in obj["locations"]] if obj.get("locations") is not None else None,
            "merchants": [MerchantMetricsFinancialSubProfile.from_dict(_item) for _item in obj["merchants"]] if obj.get("merchants") is not None else None,
            "paymentChannels": [PaymentChannelMetricsFinancialSubProfile.from_dict(_item) for _item in obj["paymentChannels"]] if obj.get("paymentChannels") is not None else None,
            "bankAccounts": [BankAccount.from_dict(_item) for _item in obj["bankAccounts"]] if obj.get("bankAccounts") is not None else None,
            "investmentAccounts": [InvestmentAccount.from_dict(_item) for _item in obj["investmentAccounts"]] if obj.get("investmentAccounts") is not None else None,
            "creditAccounts": [CreditAccount.from_dict(_item) for _item in obj["creditAccounts"]] if obj.get("creditAccounts") is not None else None,
            "mortgageLoanAccounts": [MortgageAccount.from_dict(_item) for _item in obj["mortgageLoanAccounts"]] if obj.get("mortgageLoanAccounts") is not None else None,
            "studentLoanAccounts": [StudentLoanAccount.from_dict(_item) for _item in obj["studentLoanAccounts"]] if obj.get("studentLoanAccounts") is not None else None,
            "financialUserProfileType": obj.get("financialUserProfileType") if obj.get("financialUserProfileType") is not None else FinancialUserProfileType.UNSPECIFIED
        })
        return _obj


