# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.bank_account import BankAccount
from solomonai_backend_client_sdk.models.credit_account import CreditAccount
from solomonai_backend_client_sdk.models.investment_account import InvestmentAccount
from solomonai_backend_client_sdk.models.link_status import LinkStatus
from solomonai_backend_client_sdk.models.link_type import LinkType
from solomonai_backend_client_sdk.models.mortgage_account import MortgageAccount
from solomonai_backend_client_sdk.models.plaid_link import PlaidLink
from solomonai_backend_client_sdk.models.plaid_sync import PlaidSync
from solomonai_backend_client_sdk.models.student_loan_account import StudentLoanAccount
from solomonai_backend_client_sdk.models.token import Token
from typing import Optional, Set
from typing_extensions import Self

class Link(BaseModel):
    """
    A Link represents a login at a financial institution. A single end-user of your application might have accounts at different financial institutions, which means they would have multiple different Items. An Item is not the same as a financial institution account, although every account will be associated with an Item. For example, if a user has one login at their bank that allows them to access both their checking account and their savings account, a single Item would be associated with both of those accounts. Each Item linked within your application will have a corresponding access_token, which is a token that you can use to make API requests related to that specific Item. Two Items created for the same set of credentials at the same institution will be considered different and not share the same item_id.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    plaid_sync: Optional[PlaidSync] = Field(default=None, alias="plaidSync")
    link_status: Optional[LinkStatus] = Field(default=LinkStatus.UNSPECIFIED, alias="linkStatus")
    plaid_link: Optional[PlaidLink] = Field(default=None, alias="plaidLink")
    plaid_new_accounts_available: Optional[StrictBool] = Field(default=None, alias="plaidNewAccountsAvailable")
    expiration_date: Optional[StrictStr] = Field(default=None, alias="expirationDate")
    institution_name: Optional[StrictStr] = Field(default=None, alias="institutionName")
    custom_institution_name: Optional[StrictStr] = Field(default=None, alias="customInstitutionName")
    description: Optional[StrictStr] = None
    last_manual_sync: Optional[StrictStr] = Field(default=None, alias="lastManualSync")
    last_successful_update: Optional[StrictStr] = Field(default=None, alias="lastSuccessfulUpdate")
    token: Optional[Token] = None
    bank_accounts: Optional[List[BankAccount]] = Field(default=None, alias="bankAccounts")
    investment_accounts: Optional[List[InvestmentAccount]] = Field(default=None, alias="investmentAccounts")
    credit_accounts: Optional[List[CreditAccount]] = Field(default=None, alias="creditAccounts")
    mortgage_accounts: Optional[List[MortgageAccount]] = Field(default=None, alias="mortgageAccounts")
    student_loan_accounts: Optional[List[StudentLoanAccount]] = Field(default=None, alias="studentLoanAccounts")
    plaid_institution_id: Optional[StrictStr] = Field(default=None, alias="plaidInstitutionId")
    link_type: Optional[LinkType] = Field(default=LinkType.UNSPECIFIED, alias="linkType")
    error_code: Optional[StrictStr] = Field(default=None, alias="errorCode")
    updated_at: Optional[StrictStr] = Field(default=None, alias="updatedAt")
    new_accounts_available: Optional[StrictBool] = Field(default=None, alias="newAccountsAvailable")
    should_be_updated: Optional[StrictBool] = Field(default=None, alias="shouldBeUpdated")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "plaidSync", "linkStatus", "plaidLink", "plaidNewAccountsAvailable", "expirationDate", "institutionName", "customInstitutionName", "description", "lastManualSync", "lastSuccessfulUpdate", "token", "bankAccounts", "investmentAccounts", "creditAccounts", "mortgageAccounts", "studentLoanAccounts", "plaidInstitutionId", "linkType", "errorCode", "updatedAt", "newAccountsAvailable", "shouldBeUpdated", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Link from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of plaid_sync
        if self.plaid_sync:
            _dict['plaidSync'] = self.plaid_sync.to_dict()
        # override the default output from pydantic by calling `to_dict()` of plaid_link
        if self.plaid_link:
            _dict['plaidLink'] = self.plaid_link.to_dict()
        # override the default output from pydantic by calling `to_dict()` of token
        if self.token:
            _dict['token'] = self.token.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in bank_accounts (list)
        _items = []
        if self.bank_accounts:
            for _item in self.bank_accounts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['bankAccounts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in investment_accounts (list)
        _items = []
        if self.investment_accounts:
            for _item in self.investment_accounts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['investmentAccounts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in credit_accounts (list)
        _items = []
        if self.credit_accounts:
            for _item in self.credit_accounts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['creditAccounts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in mortgage_accounts (list)
        _items = []
        if self.mortgage_accounts:
            for _item in self.mortgage_accounts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['mortgageAccounts'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in student_loan_accounts (list)
        _items = []
        if self.student_loan_accounts:
            for _item in self.student_loan_accounts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['studentLoanAccounts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Link from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "plaidSync": PlaidSync.from_dict(obj["plaidSync"]) if obj.get("plaidSync") is not None else None,
            "linkStatus": obj.get("linkStatus") if obj.get("linkStatus") is not None else LinkStatus.UNSPECIFIED,
            "plaidLink": PlaidLink.from_dict(obj["plaidLink"]) if obj.get("plaidLink") is not None else None,
            "plaidNewAccountsAvailable": obj.get("plaidNewAccountsAvailable"),
            "expirationDate": obj.get("expirationDate"),
            "institutionName": obj.get("institutionName"),
            "customInstitutionName": obj.get("customInstitutionName"),
            "description": obj.get("description"),
            "lastManualSync": obj.get("lastManualSync"),
            "lastSuccessfulUpdate": obj.get("lastSuccessfulUpdate"),
            "token": Token.from_dict(obj["token"]) if obj.get("token") is not None else None,
            "bankAccounts": [BankAccount.from_dict(_item) for _item in obj["bankAccounts"]] if obj.get("bankAccounts") is not None else None,
            "investmentAccounts": [InvestmentAccount.from_dict(_item) for _item in obj["investmentAccounts"]] if obj.get("investmentAccounts") is not None else None,
            "creditAccounts": [CreditAccount.from_dict(_item) for _item in obj["creditAccounts"]] if obj.get("creditAccounts") is not None else None,
            "mortgageAccounts": [MortgageAccount.from_dict(_item) for _item in obj["mortgageAccounts"]] if obj.get("mortgageAccounts") is not None else None,
            "studentLoanAccounts": [StudentLoanAccount.from_dict(_item) for _item in obj["studentLoanAccounts"]] if obj.get("studentLoanAccounts") is not None else None,
            "plaidInstitutionId": obj.get("plaidInstitutionId"),
            "linkType": obj.get("linkType") if obj.get("linkType") is not None else LinkType.UNSPECIFIED,
            "errorCode": obj.get("errorCode"),
            "updatedAt": obj.get("updatedAt"),
            "newAccountsAvailable": obj.get("newAccountsAvailable"),
            "shouldBeUpdated": obj.get("shouldBeUpdated"),
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


