# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from solomonai_backend_client_sdk.models.invoice_line_item import InvoiceLineItem
from typing import Optional, Set
from typing_extensions import Self

class Invoice(BaseModel):
    """
    The Invoice object represents an itemized record of goods and/or services sold to a customer.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    type: Optional[StrictStr] = Field(default=None, description="Whether the invoice is an accounts receivable or accounts payable  If type is accounts_payable, the invoice is a bill. If type is  accounts_receivable, it is an invoice. Possible values include: ACCOUNTS_RECEIVABLE, ACCOUNTS_PAYABLE.")
    contact: Optional[StrictStr] = Field(default=None, description="The invoice's contact.")
    number: Optional[StrictStr] = Field(default=None, description="The invoice's number.")
    issue_date: Optional[datetime] = Field(default=None, description="The invoice's issue date.", alias="issueDate")
    due_date: Optional[datetime] = Field(default=None, description="The invoice's due date.", alias="dueDate")
    paid_on_date: Optional[datetime] = Field(default=None, description="The invoice's paid date.", alias="paidOnDate")
    memo: Optional[StrictStr] = Field(default=None, description="The invoice's private note.")
    company: Optional[StrictStr] = Field(default=None, description="The company the invoice belongs to.")
    currency: Optional[StrictStr] = None
    exchange_rate: Optional[StrictStr] = Field(default=None, description="The invoice's exchange rate.", alias="exchangeRate")
    total_discount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The total discounts applied to the total cost.", alias="totalDiscount")
    sub_total: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The total amount being paid before taxes.", alias="subTotal")
    status: Optional[StrictStr] = None
    total_tax_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The total amount being paid in taxes.", alias="totalTaxAmount")
    total_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The invoice's total amount.", alias="totalAmount")
    balance: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The invoice's remaining balance.")
    remote_updated_at: Optional[datetime] = Field(default=None, description="When the third party's invoice entry was updated.", alias="remoteUpdatedAt")
    tracking_categories: Optional[List[StrictStr]] = Field(default=None, alias="trackingCategories")
    payments: Optional[List[StrictStr]] = Field(default=None, description="Array of Payment object IDs.")
    line_items: Optional[List[InvoiceLineItem]] = Field(default=None, alias="lineItems")
    remote_was_deleted: Optional[StrictBool] = Field(default=None, alias="remoteWasDeleted")
    accounting_period: Optional[StrictStr] = Field(default=None, description="The accounting period that the Invoice was generated in.", alias="accountingPeriod")
    purchase_orders: Optional[List[StrictStr]] = Field(default=None, alias="purchaseOrders")
    remote_id: Optional[StrictStr] = Field(default=None, description="The third-party API ID of the matching object.", alias="remoteId")
    modified_at: Optional[datetime] = Field(default=None, alias="modifiedAt")
    merge_record_id: Optional[StrictStr] = Field(default=None, alias="mergeRecordId")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "type", "contact", "number", "issueDate", "dueDate", "paidOnDate", "memo", "company", "currency", "exchangeRate", "totalDiscount", "subTotal", "status", "totalTaxAmount", "totalAmount", "balance", "remoteUpdatedAt", "trackingCategories", "payments", "lineItems", "remoteWasDeleted", "accountingPeriod", "purchaseOrders", "remoteId", "modifiedAt", "mergeRecordId", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Invoice from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in line_items (list)
        _items = []
        if self.line_items:
            for _item in self.line_items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['lineItems'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Invoice from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "contact": obj.get("contact"),
            "number": obj.get("number"),
            "issueDate": obj.get("issueDate"),
            "dueDate": obj.get("dueDate"),
            "paidOnDate": obj.get("paidOnDate"),
            "memo": obj.get("memo"),
            "company": obj.get("company"),
            "currency": obj.get("currency"),
            "exchangeRate": obj.get("exchangeRate"),
            "totalDiscount": obj.get("totalDiscount"),
            "subTotal": obj.get("subTotal"),
            "status": obj.get("status"),
            "totalTaxAmount": obj.get("totalTaxAmount"),
            "totalAmount": obj.get("totalAmount"),
            "balance": obj.get("balance"),
            "remoteUpdatedAt": obj.get("remoteUpdatedAt"),
            "trackingCategories": obj.get("trackingCategories"),
            "payments": obj.get("payments"),
            "lineItems": [InvoiceLineItem.from_dict(_item) for _item in obj["lineItems"]] if obj.get("lineItems") is not None else None,
            "remoteWasDeleted": obj.get("remoteWasDeleted"),
            "accountingPeriod": obj.get("accountingPeriod"),
            "purchaseOrders": obj.get("purchaseOrders"),
            "remoteId": obj.get("remoteId"),
            "modifiedAt": obj.get("modifiedAt"),
            "mergeRecordId": obj.get("mergeRecordId"),
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


