# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class InvesmentHolding(BaseModel):
    """
    InvesmentHolding
    """ # noqa: E501
    id: Optional[StrictStr] = None
    name: Optional[Annotated[str, Field(min_length=3, strict=True)]] = None
    plaid_account_id: Optional[StrictStr] = Field(default=None, alias="plaidAccountId")
    cost_basis: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="costBasis")
    institution_price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="institutionPrice")
    institution_price_as_of: Optional[StrictStr] = Field(default=None, alias="institutionPriceAsOf")
    institution_price_datetime: Optional[StrictStr] = Field(default=None, alias="institutionPriceDatetime")
    institution_value: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="institutionValue")
    iso_currency_code: Optional[StrictStr] = Field(default=None, alias="isoCurrencyCode")
    quantity: Optional[Union[StrictFloat, StrictInt]] = None
    security_id: Optional[StrictStr] = Field(default=None, alias="securityId")
    unofficial_currency_code: Optional[StrictStr] = Field(default=None, alias="unofficialCurrencyCode")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "name", "plaidAccountId", "costBasis", "institutionPrice", "institutionPriceAsOf", "institutionPriceDatetime", "institutionValue", "isoCurrencyCode", "quantity", "securityId", "unofficialCurrencyCode", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InvesmentHolding from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InvesmentHolding from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "plaidAccountId": obj.get("plaidAccountId"),
            "costBasis": obj.get("costBasis"),
            "institutionPrice": obj.get("institutionPrice"),
            "institutionPriceAsOf": obj.get("institutionPriceAsOf"),
            "institutionPriceDatetime": obj.get("institutionPriceDatetime"),
            "institutionValue": obj.get("institutionValue"),
            "isoCurrencyCode": obj.get("isoCurrencyCode"),
            "quantity": obj.get("quantity"),
            "securityId": obj.get("securityId"),
            "unofficialCurrencyCode": obj.get("unofficialCurrencyCode"),
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


