# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from solomonai_backend_client_sdk.models.report_item import ReportItem
from typing import Optional, Set
from typing_extensions import Self

class IncomeStatement(BaseModel):
    """
    The IncomeStatement object is used to represent a company’s income, the cost of sales, operating expenses, and other non-operating expenses. The object also includes other important values like gross profit, gross operating profit, and net income. This represents a period of time (month, quarter, or year).
    """ # noqa: E501
    id: Optional[StrictStr] = None
    remote_id: Optional[StrictStr] = Field(default=None, description="The third-party API ID of the matching object.", alias="remoteId")
    name: Optional[StrictStr] = Field(default=None, description="The income statement's name.")
    currency: Optional[StrictStr] = Field(default=None, description="The income statement's currency.")
    company: Optional[StrictStr] = Field(default=None, description="The company the income statement belongs to.")
    start_period: Optional[datetime] = Field(default=None, description="The income statement's start period.", alias="startPeriod")
    end_period: Optional[datetime] = Field(default=None, description="The income statement's end period.", alias="endPeriod")
    income: Optional[List[ReportItem]] = None
    cost_of_sales: Optional[List[ReportItem]] = Field(default=None, alias="costOfSales")
    gross_profit: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The revenue minus the cost of sale.", alias="grossProfit")
    operating_expenses: Optional[List[ReportItem]] = Field(default=None, alias="operatingExpenses")
    net_operating_income: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The revenue minus the operating expenses.", alias="netOperatingIncome")
    non_operating_expenses: Optional[List[ReportItem]] = Field(default=None, alias="nonOperatingExpenses")
    net_income: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The gross profit minus the total expenses.", alias="netIncome")
    remote_was_deleted: Optional[StrictBool] = Field(default=None, description="Indicates whether or not this object has been deleted by third party webhooks.", alias="remoteWasDeleted")
    modified_at: Optional[datetime] = Field(default=None, alias="modifiedAt")
    merge_record_id: Optional[StrictStr] = Field(default=None, alias="mergeRecordId")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "remoteId", "name", "currency", "company", "startPeriod", "endPeriod", "income", "costOfSales", "grossProfit", "operatingExpenses", "netOperatingIncome", "nonOperatingExpenses", "netIncome", "remoteWasDeleted", "modifiedAt", "mergeRecordId", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IncomeStatement from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in income (list)
        _items = []
        if self.income:
            for _item in self.income:
                if _item:
                    _items.append(_item.to_dict())
            _dict['income'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cost_of_sales (list)
        _items = []
        if self.cost_of_sales:
            for _item in self.cost_of_sales:
                if _item:
                    _items.append(_item.to_dict())
            _dict['costOfSales'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in operating_expenses (list)
        _items = []
        if self.operating_expenses:
            for _item in self.operating_expenses:
                if _item:
                    _items.append(_item.to_dict())
            _dict['operatingExpenses'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in non_operating_expenses (list)
        _items = []
        if self.non_operating_expenses:
            for _item in self.non_operating_expenses:
                if _item:
                    _items.append(_item.to_dict())
            _dict['nonOperatingExpenses'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IncomeStatement from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "remoteId": obj.get("remoteId"),
            "name": obj.get("name"),
            "currency": obj.get("currency"),
            "company": obj.get("company"),
            "startPeriod": obj.get("startPeriod"),
            "endPeriod": obj.get("endPeriod"),
            "income": [ReportItem.from_dict(_item) for _item in obj["income"]] if obj.get("income") is not None else None,
            "costOfSales": [ReportItem.from_dict(_item) for _item in obj["costOfSales"]] if obj.get("costOfSales") is not None else None,
            "grossProfit": obj.get("grossProfit"),
            "operatingExpenses": [ReportItem.from_dict(_item) for _item in obj["operatingExpenses"]] if obj.get("operatingExpenses") is not None else None,
            "netOperatingIncome": obj.get("netOperatingIncome"),
            "nonOperatingExpenses": [ReportItem.from_dict(_item) for _item in obj["nonOperatingExpenses"]] if obj.get("nonOperatingExpenses") is not None else None,
            "netIncome": obj.get("netIncome"),
            "remoteWasDeleted": obj.get("remoteWasDeleted"),
            "modifiedAt": obj.get("modifiedAt"),
            "mergeRecordId": obj.get("mergeRecordId"),
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


