# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.actionable_insight import ActionableInsight
from solomonai_backend_client_sdk.models.financial_user_profile_type import FinancialUserProfileType
from solomonai_backend_client_sdk.models.link import Link
from solomonai_backend_client_sdk.models.personal_actionable_insight import PersonalActionableInsight
from solomonai_backend_client_sdk.models.smart_note import SmartNote
from solomonai_backend_client_sdk.models.stripe_subscription import StripeSubscription
from typing import Optional, Set
from typing_extensions import Self

class FinancialUserProfile(BaseModel):
    """
    FinancialUserProfile
    """ # noqa: E501
    id: Optional[StrictStr] = None
    user_id: Optional[StrictStr] = Field(default=None, alias="userId")
    stripe_customer_id: Optional[StrictStr] = Field(default=None, alias="stripeCustomerId")
    stripe_subscriptions: Optional[StripeSubscription] = Field(default=None, alias="stripeSubscriptions")
    link: Optional[List[Link]] = None
    actionable_insights: Optional[List[ActionableInsight]] = Field(default=None, alias="actionableInsights")
    email: Optional[StrictStr] = None
    actionable_personal_insights: Optional[List[PersonalActionableInsight]] = Field(default=None, alias="actionablePersonalInsights")
    profile_type: Optional[FinancialUserProfileType] = Field(default=FinancialUserProfileType.UNSPECIFIED, alias="profileType")
    notes: Optional[List[SmartNote]] = None
    org_id: StrictStr = Field(alias="orgId")
    tenant_id: StrictStr = Field(alias="tenantId")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "userId", "stripeCustomerId", "stripeSubscriptions", "link", "actionableInsights", "email", "actionablePersonalInsights", "profileType", "notes", "orgId", "tenantId", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FinancialUserProfile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of stripe_subscriptions
        if self.stripe_subscriptions:
            _dict['stripeSubscriptions'] = self.stripe_subscriptions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in link (list)
        _items = []
        if self.link:
            for _item in self.link:
                if _item:
                    _items.append(_item.to_dict())
            _dict['link'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in actionable_insights (list)
        _items = []
        if self.actionable_insights:
            for _item in self.actionable_insights:
                if _item:
                    _items.append(_item.to_dict())
            _dict['actionableInsights'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in actionable_personal_insights (list)
        _items = []
        if self.actionable_personal_insights:
            for _item in self.actionable_personal_insights:
                if _item:
                    _items.append(_item.to_dict())
            _dict['actionablePersonalInsights'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in notes (list)
        _items = []
        if self.notes:
            for _item in self.notes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['notes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FinancialUserProfile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "userId": obj.get("userId"),
            "stripeCustomerId": obj.get("stripeCustomerId"),
            "stripeSubscriptions": StripeSubscription.from_dict(obj["stripeSubscriptions"]) if obj.get("stripeSubscriptions") is not None else None,
            "link": [Link.from_dict(_item) for _item in obj["link"]] if obj.get("link") is not None else None,
            "actionableInsights": [ActionableInsight.from_dict(_item) for _item in obj["actionableInsights"]] if obj.get("actionableInsights") is not None else None,
            "email": obj.get("email"),
            "actionablePersonalInsights": [PersonalActionableInsight.from_dict(_item) for _item in obj["actionablePersonalInsights"]] if obj.get("actionablePersonalInsights") is not None else None,
            "profileType": obj.get("profileType") if obj.get("profileType") is not None else FinancialUserProfileType.UNSPECIFIED,
            "notes": [SmartNote.from_dict(_item) for _item in obj["notes"]] if obj.get("notes") is not None else None,
            "orgId": obj.get("orgId"),
            "tenantId": obj.get("tenantId"),
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


