# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.actor import Actor
from solomonai_backend_client_sdk.models.poll_post import PollPost
from solomonai_backend_client_sdk.models.post import Post
from solomonai_backend_client_sdk.models.post_type import PostType
from solomonai_backend_client_sdk.models.shared_post import SharedPost
from typing import Optional, Set
from typing_extensions import Self

class FeedActivity(BaseModel):
    """
    FeedActivity
    """ # noqa: E501
    actor: Actor
    verb: Optional[PostType] = PostType.UNSPECIFIED
    regular_post: Optional[Post] = Field(default=None, alias="regularPost")
    shared_post: Optional[SharedPost] = Field(default=None, alias="sharedPost")
    poll_post: Optional[PollPost] = Field(default=None, alias="pollPost")
    foreign_id: Optional[StrictStr] = Field(default=None, alias="foreignId")
    target: Optional[StrictStr] = Field(default=None, description="Object Describes the target of the activity. The precise meaning of the activity's target is dependent on the activities verb, but will often be the object the English preposition \"to\". For instance, in the activity, \"John saved a movie to his wishlist\", the target of the activity is \"wishlist\".")
    time: Optional[StrictStr] = None
    origin: Optional[StrictStr] = None
    to: Optional[List[StrictStr]] = Field(default=None, description="The TO field allows you to specify a list of feeds to which the activity should be copied. One way to think about it is as the CC functionality of email.")
    score: Optional[StrictStr] = None
    extra: Optional[Dict[str, StrictStr]] = None
    getstream_activity_id: StrictStr = Field(alias="getstreamActivityId")
    __properties: ClassVar[List[str]] = ["actor", "verb", "regularPost", "sharedPost", "pollPost", "foreignId", "target", "time", "origin", "to", "score", "extra", "getstreamActivityId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FeedActivity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of actor
        if self.actor:
            _dict['actor'] = self.actor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of regular_post
        if self.regular_post:
            _dict['regularPost'] = self.regular_post.to_dict()
        # override the default output from pydantic by calling `to_dict()` of shared_post
        if self.shared_post:
            _dict['sharedPost'] = self.shared_post.to_dict()
        # override the default output from pydantic by calling `to_dict()` of poll_post
        if self.poll_post:
            _dict['pollPost'] = self.poll_post.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FeedActivity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "actor": Actor.from_dict(obj["actor"]) if obj.get("actor") is not None else None,
            "verb": obj.get("verb") if obj.get("verb") is not None else PostType.UNSPECIFIED,
            "regularPost": Post.from_dict(obj["regularPost"]) if obj.get("regularPost") is not None else None,
            "sharedPost": SharedPost.from_dict(obj["sharedPost"]) if obj.get("sharedPost") is not None else None,
            "pollPost": PollPost.from_dict(obj["pollPost"]) if obj.get("pollPost") is not None else None,
            "foreignId": obj.get("foreignId"),
            "target": obj.get("target"),
            "time": obj.get("time"),
            "origin": obj.get("origin"),
            "to": obj.get("to"),
            "score": obj.get("score"),
            "extra": obj.get("extra"),
            "getstreamActivityId": obj.get("getstreamActivityId")
        })
        return _obj


