# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from solomonai_backend_client_sdk.models.expense_line import ExpenseLine
from typing import Optional, Set
from typing_extensions import Self

class Expense(BaseModel):
    """
    The Expense object is used to represent a direct purchase by a business, typically made with a check, credit card, or cash. Each Expense object is dedicated to a grouping of expenses, with each expense recorded in the lines object.  The Expense object is used also used to represent refunds to direct purchases. Refunds can be distinguished from purchases by the amount sign of the records. Expense objects with a negative amount are purchases and Expense objects with a positive amount are refunds to those purchases.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    remote_id: Optional[StrictStr] = Field(default=None, description="The third-party API ID of the matching object.", alias="remoteId")
    transaction_date: Optional[datetime] = Field(default=None, description="When the transaction occurred.  Consider using google.protobuf.Timestamp", alias="transactionDate")
    remote_created_at: Optional[datetime] = Field(default=None, description="When the expense was created.  Consider using google.protobuf.Timestamp", alias="remoteCreatedAt")
    account: Optional[StrictStr] = Field(default=None, description="The expense's payment account.")
    contact: Optional[StrictStr] = Field(default=None, description="The expense's contact.")
    total_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The expense's total amount.", alias="totalAmount")
    sub_total: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The expense's total amount before tax.", alias="subTotal")
    total_tax_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The expense's total tax amount.", alias="totalTaxAmount")
    currency: Optional[StrictStr] = None
    exchange_rate: Optional[StrictStr] = Field(default=None, description="The expense's exchange rate.  Consider using double or float if this represents a number", alias="exchangeRate")
    company: Optional[StrictStr] = Field(default=None, description="The company the expense belongs to.")
    memo: Optional[StrictStr] = Field(default=None, description="The expense's private note.")
    lines: Optional[List[ExpenseLine]] = Field(default=None, description="The ExpenseLine object is used to represent an expense's line items.")
    tracking_categories: Optional[List[StrictStr]] = Field(default=None, alias="trackingCategories")
    remote_was_deleted: Optional[StrictBool] = Field(default=None, description="Indicates whether or not this object has been deleted by third party webhooks.", alias="remoteWasDeleted")
    accounting_period: Optional[StrictStr] = Field(default=None, description="The accounting period that the Expense was generated in.", alias="accountingPeriod")
    modified_at: Optional[datetime] = Field(default=None, description="Consider using google.protobuf.Timestamp", alias="modifiedAt")
    merge_record_id: Optional[StrictStr] = Field(default=None, alias="mergeRecordId")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "remoteId", "transactionDate", "remoteCreatedAt", "account", "contact", "totalAmount", "subTotal", "totalTaxAmount", "currency", "exchangeRate", "company", "memo", "lines", "trackingCategories", "remoteWasDeleted", "accountingPeriod", "modifiedAt", "mergeRecordId", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Expense from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in lines (list)
        _items = []
        if self.lines:
            for _item in self.lines:
                if _item:
                    _items.append(_item.to_dict())
            _dict['lines'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Expense from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "remoteId": obj.get("remoteId"),
            "transactionDate": obj.get("transactionDate"),
            "remoteCreatedAt": obj.get("remoteCreatedAt"),
            "account": obj.get("account"),
            "contact": obj.get("contact"),
            "totalAmount": obj.get("totalAmount"),
            "subTotal": obj.get("subTotal"),
            "totalTaxAmount": obj.get("totalTaxAmount"),
            "currency": obj.get("currency"),
            "exchangeRate": obj.get("exchangeRate"),
            "company": obj.get("company"),
            "memo": obj.get("memo"),
            "lines": [ExpenseLine.from_dict(_item) for _item in obj["lines"]] if obj.get("lines") is not None else None,
            "trackingCategories": obj.get("trackingCategories"),
            "remoteWasDeleted": obj.get("remoteWasDeleted"),
            "accountingPeriod": obj.get("accountingPeriod"),
            "modifiedAt": obj.get("modifiedAt"),
            "mergeRecordId": obj.get("mergeRecordId"),
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


