# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from solomonai_backend_client_sdk.models.flsa_status import FlsaStatus
from solomonai_backend_client_sdk.models.pay_frequency import PayFrequency
from solomonai_backend_client_sdk.models.pay_period import PayPeriod
from typing import Optional, Set
from typing_extensions import Self

class EmployeeJobPositionAtCompany(BaseModel):
    """
    The Employment object is used to represent a job position at a company. NOTE: When there is a change in pay or title, integrations with historical data will create new Employment objects while integrations without historical data will update existing ones.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    remote_id: Optional[StrictStr] = Field(default=None, description="The third-party API ID of the matching object.", alias="remoteId")
    job_title: Optional[StrictStr] = Field(default=None, alias="jobTitle")
    pay_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="payRate")
    pay_period: Optional[PayPeriod] = Field(default=PayPeriod.UNSPECIFIED, alias="payPeriod")
    pay_frequency: Optional[PayFrequency] = Field(default=PayFrequency.UNSPECIFIED, alias="payFrequency")
    pay_currency: Optional[StrictStr] = Field(default=None, alias="payCurrency")
    flsa_status: Optional[FlsaStatus] = Field(default=FlsaStatus.UNSPECIFIED, alias="flsaStatus")
    effective_date: Optional[datetime] = Field(default=None, alias="effectiveDate")
    remote_was_deleted: Optional[StrictBool] = Field(default=None, description="Indicates whether or not this object has been deleted in the third party platform.", alias="remoteWasDeleted")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    modified_at: Optional[datetime] = Field(default=None, alias="modifiedAt")
    merge_account_id: Optional[StrictStr] = Field(default=None, alias="mergeAccountId")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "remoteId", "jobTitle", "payRate", "payPeriod", "payFrequency", "payCurrency", "flsaStatus", "effectiveDate", "remoteWasDeleted", "createdAt", "modifiedAt", "mergeAccountId", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmployeeJobPositionAtCompany from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmployeeJobPositionAtCompany from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "remoteId": obj.get("remoteId"),
            "jobTitle": obj.get("jobTitle"),
            "payRate": obj.get("payRate"),
            "payPeriod": obj.get("payPeriod") if obj.get("payPeriod") is not None else PayPeriod.UNSPECIFIED,
            "payFrequency": obj.get("payFrequency") if obj.get("payFrequency") is not None else PayFrequency.UNSPECIFIED,
            "payCurrency": obj.get("payCurrency"),
            "flsaStatus": obj.get("flsaStatus") if obj.get("flsaStatus") is not None else FlsaStatus.UNSPECIFIED,
            "effectiveDate": obj.get("effectiveDate"),
            "remoteWasDeleted": obj.get("remoteWasDeleted"),
            "createdAt": obj.get("createdAt"),
            "modifiedAt": obj.get("modifiedAt"),
            "mergeAccountId": obj.get("mergeAccountId"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


