# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class DeleteFolderResponse(BaseModel):
    """
    DeleteFolderResponse represents the response to a folder deletion request. This message indicates whether the folder was successfully deleted from the system and provides additional details about the deletion operation.  Key features: - Deletion confirmation - Status indication - Error handling support - Deletion metadata - Resource cleanup tracking
    """ # noqa: E501
    is_deleted: Optional[StrictBool] = Field(default=None, alias="isDeleted")
    error_message: Optional[StrictStr] = Field(default=None, alias="errorMessage")
    deletion_timestamp: Optional[StrictStr] = Field(default=None, alias="deletionTimestamp")
    items_deleted: Optional[StrictInt] = Field(default=None, alias="itemsDeleted")
    storage_reclaimed: Optional[StrictStr] = Field(default=None, alias="storageReclaimed")
    pending_deletions: Optional[StrictBool] = Field(default=None, alias="pendingDeletions")
    deletion_id: Optional[StrictStr] = Field(default=None, alias="deletionId")
    __properties: ClassVar[List[str]] = ["isDeleted", "errorMessage", "deletionTimestamp", "itemsDeleted", "storageReclaimed", "pendingDeletions", "deletionId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DeleteFolderResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DeleteFolderResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "isDeleted": obj.get("isDeleted"),
            "errorMessage": obj.get("errorMessage"),
            "deletionTimestamp": obj.get("deletionTimestamp"),
            "itemsDeleted": obj.get("itemsDeleted"),
            "storageReclaimed": obj.get("storageReclaimed"),
            "pendingDeletions": obj.get("pendingDeletions"),
            "deletionId": obj.get("deletionId")
        })
        return _obj


