# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from solomonai_backend_client_sdk.models.workspace_compliance import WorkspaceCompliance
from typing import Optional, Set
from typing_extensions import Self

class CreateWorkspaceComplianceBody(BaseModel):
    """
    CreateWorkspaceComplianceRequest represents a request to set up or update compliance settings for a workspace.  Required Fields: - user_id: The ID of the user creating/updating the settings - workspace_id: The workspace to configure compliance for - compliance: The compliance configuration to apply - org_id: The organization context ID - tenant_id: The tenant context ID  The compliance settings can include: - Data retention policies - Access control requirements - Audit logging configuration - Security controls - Regulatory compliance flags  Example: ```protobuf message request {   user_id: \"user123\"   workspace_id: 456   compliance: {     retention_period_days: 90,     require_2fa: true,     audit_logging_enabled: true   }   org_id: 789   tenant_id: 101112 } ```
    """ # noqa: E501
    user_id: StrictStr = Field(alias="userId")
    compliance: WorkspaceCompliance
    org_id: StrictStr = Field(alias="orgId")
    tenant_id: StrictStr = Field(alias="tenantId")
    __properties: ClassVar[List[str]] = ["userId", "compliance", "orgId", "tenantId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateWorkspaceComplianceBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of compliance
        if self.compliance:
            _dict['compliance'] = self.compliance.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateWorkspaceComplianceBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "userId": obj.get("userId"),
            "compliance": WorkspaceCompliance.from_dict(obj["compliance"]) if obj.get("compliance") is not None else None,
            "orgId": obj.get("orgId"),
            "tenantId": obj.get("tenantId")
        })
        return _obj


