# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CreateUserProfileRequest(BaseModel):
    """
    CreateUserProfileRequest represents the request object for creating a user profile in the social service. This message encapsulates the essential information needed to establish a new social user profile, including identification, contact details, and profile preferences.
    """ # noqa: E501
    user_id: StrictStr = Field(description="Unique identifier for the user", alias="userId")
    email: StrictStr = Field(description="User's email address")
    username: StrictStr = Field(description="User's chosen username")
    is_private: Optional[StrictBool] = Field(default=None, description="Flag indicating if the profile is private", alias="isPrivate")
    profile_image_url: StrictStr = Field(description="URL of the user's profile image", alias="profileImageUrl")
    org_id: StrictStr = Field(alias="orgId")
    tenant_id: StrictStr = Field(alias="tenantId")
    __properties: ClassVar[List[str]] = ["userId", "email", "username", "isPrivate", "profileImageUrl", "orgId", "tenantId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateUserProfileRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateUserProfileRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "userId": obj.get("userId"),
            "email": obj.get("email"),
            "username": obj.get("username"),
            "isPrivate": obj.get("isPrivate"),
            "profileImageUrl": obj.get("profileImageUrl"),
            "orgId": obj.get("orgId"),
            "tenantId": obj.get("tenantId")
        })
        return _obj


