# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CompanyAddress(BaseModel):
    """
    The CompanyAddress object is used to represent a contact's or company's address.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    street1: Optional[StrictStr] = Field(default=None, description="Line 1 of the address's street.")
    street2: Optional[StrictStr] = Field(default=None, description="Line 2 of the address's street.")
    city: Optional[StrictStr] = Field(default=None, description="The address's city.")
    state: Optional[StrictStr] = Field(default=None, description="The address's state or region.")
    country_subdivision: Optional[StrictStr] = Field(default=None, description="Typically, this might just be 'state' but used your field name to keep it consistent with the JSON", alias="countrySubdivision")
    country: Optional[StrictStr] = Field(default=None, description="The address's country.")
    zip_code: Optional[StrictStr] = Field(default=None, description="The address's zip code.", alias="zipCode")
    modified_at: Optional[datetime] = Field(default=None, description="Consider using google.protobuf.Timestamp if precise time manipulation is required", alias="modifiedAt")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "type", "street1", "street2", "city", "state", "countrySubdivision", "country", "zipCode", "modifiedAt", "createdAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CompanyAddress from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CompanyAddress from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "street1": obj.get("street1"),
            "street2": obj.get("street2"),
            "city": obj.get("city"),
            "state": obj.get("state"),
            "countrySubdivision": obj.get("countrySubdivision"),
            "country": obj.get("country"),
            "zipCode": obj.get("zipCode"),
            "modifiedAt": obj.get("modifiedAt"),
            "createdAt": obj.get("createdAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


