# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.account_status import AccountStatus
from solomonai_backend_client_sdk.models.address import Address
from solomonai_backend_client_sdk.models.audit_log import AuditLog
from solomonai_backend_client_sdk.models.org_api_key import OrgAPIKey
from solomonai_backend_client_sdk.models.profile_type import ProfileType
from solomonai_backend_client_sdk.models.settings import Settings
from solomonai_backend_client_sdk.models.tags import Tags
from typing import Optional, Set
from typing_extensions import Self

class BusinessAccount(BaseModel):
    """
    BusinessAccount represents a business account within the context of Solomon AI.
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the business account.")
    email: Optional[StrictStr] = Field(default=None, description="Email associated with the business account.")
    username: Optional[StrictStr] = Field(default=None, description="Username for the business account. Must be at least 10 characters long.")
    phone_number: Optional[StrictStr] = Field(default=None, description="Phone number associated with the business account.", alias="phoneNumber")
    bio: Optional[StrictStr] = Field(default=None, description="Short description of the business account. Maximum of 200 characters.")
    headline: Optional[StrictStr] = Field(default=None, description="Headline for the profile of the business account.")
    profile_image_url: Optional[StrictStr] = Field(default=None, description="Profile image associated with the business account.", alias="profileImageUrl")
    company_name: Optional[StrictStr] = Field(default=None, description="Name of the company associated with the business account.", alias="companyName")
    company_established_date: Optional[StrictStr] = Field(default=None, description="Date when the company associated with the business account was established.", alias="companyEstablishedDate")
    company_industry_type: Optional[StrictStr] = Field(default=None, description="Industry type of the company associated with the business account.", alias="companyIndustryType")
    company_website_url: Optional[StrictStr] = Field(default=None, description="Website URL of the company associated with the business account.", alias="companyWebsiteUrl")
    company_description: Optional[StrictStr] = Field(default=None, description="Description of the company associated with the business account.", alias="companyDescription")
    is_active: Optional[StrictBool] = Field(default=None, description="Indicates whether the business account is active.", alias="isActive")
    is_private: Optional[StrictBool] = Field(default=None, description="Indicates whether the business account is private.", alias="isPrivate")
    is_email_verified: Optional[StrictBool] = Field(default=None, description="Indicates whether the email associated with the business account has been verified.", alias="isEmailVerified")
    status: Optional[AccountStatus] = AccountStatus.UNSPECIFIED
    metadata: Optional[Dict[str, Any]] = Field(default=None, description="Metadata in JSON format.")
    created_at: Optional[datetime] = Field(default=None, description="Timestamp indicating when the business account was created.", alias="createdAt")
    verified_at: Optional[datetime] = Field(default=None, description="Timestamp indicating when the email for the business account was verified.", alias="verifiedAt")
    last_access: Optional[datetime] = Field(default=None, description="Timestamp of the last access.", alias="lastAccess")
    authn_account_id: Optional[StrictStr] = Field(default=None, description="Identifier for the associated authentication service account.", alias="authnAccountId")
    supabase_auth0_user_id: Optional[StrictStr] = Field(default=None, description="auth0 user ID associated with the business account.", alias="supabaseAuth0UserId")
    algolia_user_id: Optional[StrictStr] = Field(default=None, description="Algolia user ID.", alias="algoliaUserId")
    base_directory: Optional[StrictStr] = Field(default=None, description="Base directory for user files.", alias="baseDirectory")
    bucket_location: Optional[StrictStr] = Field(default=None, description="S3 bucket location.", alias="bucketLocation")
    bucket_name: Optional[StrictStr] = Field(default=None, description="S3 bucket name.", alias="bucketName")
    region: Optional[StrictStr] = Field(default=None, description="AWS region.")
    storage_quota: Optional[StrictStr] = Field(default=None, description="Storage quota for the account.", alias="storageQuota")
    used_storage: Optional[StrictStr] = Field(default=None, description="Used storage by the account.", alias="usedStorage")
    address: Optional[Address] = None
    tags: Optional[List[Tags]] = Field(default=None, description="Tags associated with the business account. Between 1 and 10 tags are allowed.")
    settings: Optional[Settings] = None
    account_type: Optional[ProfileType] = Field(default=ProfileType.UNSPECIFIED, alias="accountType")
    organization: Optional[Organization] = None
    tenant: Optional[Tenant] = None
    addresses: Optional[List[Address]] = Field(default=None, description="Addresses associated with the business account.")
    audit_logs: Optional[List[AuditLog]] = Field(default=None, description="Audit logs for the account.", alias="auditLogs")
    org_api_keys: Optional[List[OrgAPIKey]] = Field(default=None, description="Org API keys associated with the business account.", alias="orgApiKeys")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "email", "username", "phoneNumber", "bio", "headline", "profileImageUrl", "companyName", "companyEstablishedDate", "companyIndustryType", "companyWebsiteUrl", "companyDescription", "isActive", "isPrivate", "isEmailVerified", "status", "metadata", "createdAt", "verifiedAt", "lastAccess", "authnAccountId", "supabaseAuth0UserId", "algoliaUserId", "baseDirectory", "bucketLocation", "bucketName", "region", "storageQuota", "usedStorage", "address", "tags", "settings", "accountType", "organization", "tenant", "addresses", "auditLogs", "orgApiKeys", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BusinessAccount from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict['address'] = self.address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item in self.tags:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tags'] = _items
        # override the default output from pydantic by calling `to_dict()` of settings
        if self.settings:
            _dict['settings'] = self.settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of organization
        if self.organization:
            _dict['organization'] = self.organization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tenant
        if self.tenant:
            _dict['tenant'] = self.tenant.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in addresses (list)
        _items = []
        if self.addresses:
            for _item in self.addresses:
                if _item:
                    _items.append(_item.to_dict())
            _dict['addresses'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in audit_logs (list)
        _items = []
        if self.audit_logs:
            for _item in self.audit_logs:
                if _item:
                    _items.append(_item.to_dict())
            _dict['auditLogs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in org_api_keys (list)
        _items = []
        if self.org_api_keys:
            for _item in self.org_api_keys:
                if _item:
                    _items.append(_item.to_dict())
            _dict['orgApiKeys'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BusinessAccount from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "email": obj.get("email"),
            "username": obj.get("username"),
            "phoneNumber": obj.get("phoneNumber"),
            "bio": obj.get("bio"),
            "headline": obj.get("headline"),
            "profileImageUrl": obj.get("profileImageUrl"),
            "companyName": obj.get("companyName"),
            "companyEstablishedDate": obj.get("companyEstablishedDate"),
            "companyIndustryType": obj.get("companyIndustryType"),
            "companyWebsiteUrl": obj.get("companyWebsiteUrl"),
            "companyDescription": obj.get("companyDescription"),
            "isActive": obj.get("isActive"),
            "isPrivate": obj.get("isPrivate"),
            "isEmailVerified": obj.get("isEmailVerified"),
            "status": obj.get("status") if obj.get("status") is not None else AccountStatus.UNSPECIFIED,
            "metadata": obj.get("metadata"),
            "createdAt": obj.get("createdAt"),
            "verifiedAt": obj.get("verifiedAt"),
            "lastAccess": obj.get("lastAccess"),
            "authnAccountId": obj.get("authnAccountId"),
            "supabaseAuth0UserId": obj.get("supabaseAuth0UserId"),
            "algoliaUserId": obj.get("algoliaUserId"),
            "baseDirectory": obj.get("baseDirectory"),
            "bucketLocation": obj.get("bucketLocation"),
            "bucketName": obj.get("bucketName"),
            "region": obj.get("region"),
            "storageQuota": obj.get("storageQuota"),
            "usedStorage": obj.get("usedStorage"),
            "address": Address.from_dict(obj["address"]) if obj.get("address") is not None else None,
            "tags": [Tags.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "settings": Settings.from_dict(obj["settings"]) if obj.get("settings") is not None else None,
            "accountType": obj.get("accountType") if obj.get("accountType") is not None else ProfileType.UNSPECIFIED,
            "organization": Organization.from_dict(obj["organization"]) if obj.get("organization") is not None else None,
            "tenant": Tenant.from_dict(obj["tenant"]) if obj.get("tenant") is not None else None,
            "addresses": [Address.from_dict(_item) for _item in obj["addresses"]] if obj.get("addresses") is not None else None,
            "auditLogs": [AuditLog.from_dict(_item) for _item in obj["auditLogs"]] if obj.get("auditLogs") is not None else None,
            "orgApiKeys": [OrgAPIKey.from_dict(_item) for _item in obj["orgApiKeys"]] if obj.get("orgApiKeys") is not None else None,
            "deletedAt": obj.get("deletedAt")
        })
        return _obj

from solomonai_backend_client_sdk.models.organization import Organization
from solomonai_backend_client_sdk.models.tenant import Tenant
# TODO: Rewrite to not use raise_errors
BusinessAccount.model_rebuild(raise_errors=False)

