# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from solomonai_backend_client_sdk.models.address_type import AddressType
from solomonai_backend_client_sdk.models.addressable_type import AddressableType
from typing import Optional, Set
from typing_extensions import Self

class Address(BaseModel):
    """
    Address
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the address.")
    address: Optional[StrictStr] = Field(default=None, description="Full address line. Must be at least 5 characters long.")
    unit: Optional[StrictStr] = Field(default=None, description="Unit number, if applicable (e.g., apartment).")
    zipcode: Optional[StrictStr] = Field(default=None, description="Zip code, must be exactly 5 characters.")
    city: Optional[StrictStr] = Field(default=None, description="City name, must be at least 3 characters long.")
    state: Optional[StrictStr] = Field(default=None, description="State or municipality, must be at least 2 characters long.")
    longitude: Optional[StrictStr] = Field(default=None, description="Longitude coordinate. Can be empty.")
    latitude: Optional[StrictStr] = Field(default=None, description="Latitude coordinate. Can be empty.")
    addressable_type: Optional[AddressableType] = Field(default=AddressableType.UNSPECIFIED, alias="addressableType")
    is_primary: Optional[StrictBool] = Field(default=None, description="Indicates if this is the primary address for the entity.", alias="isPrimary")
    address_type: Optional[AddressType] = Field(default=AddressType.UNSPECIFIED, alias="addressType")
    metadata: Optional[Dict[str, Any]] = Field(default=None, description="Metadata in JSON format.")
    created_at: Optional[datetime] = Field(default=None, description="Timestamp when the address was created.", alias="createdAt")
    updated_at: Optional[datetime] = Field(default=None, description="Timestamp when the address was last updated.", alias="updatedAt")
    deleted_at: Optional[datetime] = Field(default=None, alias="deletedAt")
    __properties: ClassVar[List[str]] = ["id", "address", "unit", "zipcode", "city", "state", "longitude", "latitude", "addressableType", "isPrimary", "addressType", "metadata", "createdAt", "updatedAt", "deletedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Address from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Address from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "address": obj.get("address"),
            "unit": obj.get("unit"),
            "zipcode": obj.get("zipcode"),
            "city": obj.get("city"),
            "state": obj.get("state"),
            "longitude": obj.get("longitude"),
            "latitude": obj.get("latitude"),
            "addressableType": obj.get("addressableType") if obj.get("addressableType") is not None else AddressableType.UNSPECIFIED,
            "isPrimary": obj.get("isPrimary"),
            "addressType": obj.get("addressType") if obj.get("addressType") is not None else AddressType.UNSPECIFIED,
            "metadata": obj.get("metadata"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "deletedAt": obj.get("deletedAt")
        })
        return _obj


