# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from solomonai_backend_client_sdk.models.bulk_update_comments_request import BulkUpdateCommentsRequest
from solomonai_backend_client_sdk.models.bulk_update_comments_response import BulkUpdateCommentsResponse
from solomonai_backend_client_sdk.models.create_account_request import CreateAccountRequest
from solomonai_backend_client_sdk.models.create_account_response import CreateAccountResponse
from solomonai_backend_client_sdk.models.create_comment_edit_body import CreateCommentEditBody
from solomonai_backend_client_sdk.models.create_comment_edit_response import CreateCommentEditResponse
from solomonai_backend_client_sdk.models.create_comment_request import CreateCommentRequest
from solomonai_backend_client_sdk.models.create_comment_response1 import CreateCommentResponse1
from solomonai_backend_client_sdk.models.create_comment_thread_request import CreateCommentThreadRequest
from solomonai_backend_client_sdk.models.create_comment_thread_response import CreateCommentThreadResponse
from solomonai_backend_client_sdk.models.create_document_snapshot_body import CreateDocumentSnapshotBody
from solomonai_backend_client_sdk.models.create_document_snapshot_response import CreateDocumentSnapshotResponse
from solomonai_backend_client_sdk.models.create_folder_request import CreateFolderRequest
from solomonai_backend_client_sdk.models.create_folder_response import CreateFolderResponse
from solomonai_backend_client_sdk.models.create_markdown_file_request import CreateMarkdownFileRequest
from solomonai_backend_client_sdk.models.create_markdown_file_response import CreateMarkdownFileResponse
from solomonai_backend_client_sdk.models.create_workspace_compliance_body import CreateWorkspaceComplianceBody
from solomonai_backend_client_sdk.models.create_workspace_compliance_response import CreateWorkspaceComplianceResponse
from solomonai_backend_client_sdk.models.create_workspace_request import CreateWorkspaceRequest
from solomonai_backend_client_sdk.models.create_workspace_response import CreateWorkspaceResponse
from solomonai_backend_client_sdk.models.delete_account_response import DeleteAccountResponse
from solomonai_backend_client_sdk.models.delete_comment_edit_response import DeleteCommentEditResponse
from solomonai_backend_client_sdk.models.delete_comment_response1 import DeleteCommentResponse1
from solomonai_backend_client_sdk.models.delete_comment_thread_response import DeleteCommentThreadResponse
from solomonai_backend_client_sdk.models.delete_document_snapshot_response import DeleteDocumentSnapshotResponse
from solomonai_backend_client_sdk.models.delete_file_response import DeleteFileResponse
from solomonai_backend_client_sdk.models.delete_folder_response import DeleteFolderResponse
from solomonai_backend_client_sdk.models.delete_workspace_compliance_response import DeleteWorkspaceComplianceResponse
from solomonai_backend_client_sdk.models.delete_workspace_response import DeleteWorkspaceResponse
from solomonai_backend_client_sdk.models.delete_workspace_share_response import DeleteWorkspaceShareResponse
from solomonai_backend_client_sdk.models.generate_file_embeddings_body import GenerateFileEmbeddingsBody
from solomonai_backend_client_sdk.models.generate_file_embeddings_response import GenerateFileEmbeddingsResponse
from solomonai_backend_client_sdk.models.get_account_response import GetAccountResponse
from solomonai_backend_client_sdk.models.get_background_job_status_response import GetBackgroundJobStatusResponse
from solomonai_backend_client_sdk.models.get_comment_edit_response import GetCommentEditResponse
from solomonai_backend_client_sdk.models.get_comment_response import GetCommentResponse
from solomonai_backend_client_sdk.models.get_comment_thread_response import GetCommentThreadResponse
from solomonai_backend_client_sdk.models.get_document_snapshot_response import GetDocumentSnapshotResponse
from solomonai_backend_client_sdk.models.get_file_version_response import GetFileVersionResponse
from solomonai_backend_client_sdk.models.get_single_comment_thread_response import GetSingleCommentThreadResponse
from solomonai_backend_client_sdk.models.get_workspace_compliance_response import GetWorkspaceComplianceResponse
from solomonai_backend_client_sdk.models.get_workspace_share_response import GetWorkspaceShareResponse
from solomonai_backend_client_sdk.models.list_accounts_response import ListAccountsResponse
from solomonai_backend_client_sdk.models.list_comment_edits_response import ListCommentEditsResponse
from solomonai_backend_client_sdk.models.list_comments_response import ListCommentsResponse
from solomonai_backend_client_sdk.models.list_document_snapshots_response import ListDocumentSnapshotsResponse
from solomonai_backend_client_sdk.models.list_file_versions_response import ListFileVersionsResponse
from solomonai_backend_client_sdk.models.list_files_response import ListFilesResponse
from solomonai_backend_client_sdk.models.list_folder_response import ListFolderResponse
from solomonai_backend_client_sdk.models.list_workspace_activity_response import ListWorkspaceActivityResponse
from solomonai_backend_client_sdk.models.list_workspace_response import ListWorkspaceResponse
from solomonai_backend_client_sdk.models.list_workspace_shares_response import ListWorkspaceSharesResponse
from solomonai_backend_client_sdk.models.share_file_body import ShareFileBody
from solomonai_backend_client_sdk.models.share_file_response import ShareFileResponse
from solomonai_backend_client_sdk.models.share_workspace_body import ShareWorkspaceBody
from solomonai_backend_client_sdk.models.share_workspace_response import ShareWorkspaceResponse
from solomonai_backend_client_sdk.models.unshare_file_response import UnshareFileResponse
from solomonai_backend_client_sdk.models.update_comment_edit_request import UpdateCommentEditRequest
from solomonai_backend_client_sdk.models.update_comment_edit_response import UpdateCommentEditResponse
from solomonai_backend_client_sdk.models.update_comment_request import UpdateCommentRequest
from solomonai_backend_client_sdk.models.update_comment_response import UpdateCommentResponse
from solomonai_backend_client_sdk.models.update_comment_thread_request import UpdateCommentThreadRequest
from solomonai_backend_client_sdk.models.update_comment_thread_response import UpdateCommentThreadResponse
from solomonai_backend_client_sdk.models.update_file_request import UpdateFileRequest
from solomonai_backend_client_sdk.models.update_file_response import UpdateFileResponse
from solomonai_backend_client_sdk.models.update_folder_request import UpdateFolderRequest
from solomonai_backend_client_sdk.models.update_folder_response import UpdateFolderResponse
from solomonai_backend_client_sdk.models.update_workspace_compliance_request import UpdateWorkspaceComplianceRequest
from solomonai_backend_client_sdk.models.update_workspace_compliance_response import UpdateWorkspaceComplianceResponse
from solomonai_backend_client_sdk.models.update_workspace_request import UpdateWorkspaceRequest
from solomonai_backend_client_sdk.models.update_workspace_response import UpdateWorkspaceResponse
from solomonai_backend_client_sdk.models.update_workspace_share_request import UpdateWorkspaceShareRequest
from solomonai_backend_client_sdk.models.update_workspace_share_response import UpdateWorkspaceShareResponse

from solomonai_backend_client_sdk.api_client import ApiClient, RequestSerialized
from solomonai_backend_client_sdk.api_response import ApiResponse
from solomonai_backend_client_sdk.rest import RESTResponseType


class WorkspaceServiceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def bulk_update_comments(
        self,
        bulk_update_comments_request: Annotated[BulkUpdateCommentsRequest, Field(description="BulkUpdateCommentsRequest represents a request to update multiple comments.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BulkUpdateCommentsResponse:
        """Bulk update comments

        This endpoint updates multiple comments in bulk

        :param bulk_update_comments_request: BulkUpdateCommentsRequest represents a request to update multiple comments. (required)
        :type bulk_update_comments_request: BulkUpdateCommentsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bulk_update_comments_serialize(
            bulk_update_comments_request=bulk_update_comments_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkUpdateCommentsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def bulk_update_comments_with_http_info(
        self,
        bulk_update_comments_request: Annotated[BulkUpdateCommentsRequest, Field(description="BulkUpdateCommentsRequest represents a request to update multiple comments.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BulkUpdateCommentsResponse]:
        """Bulk update comments

        This endpoint updates multiple comments in bulk

        :param bulk_update_comments_request: BulkUpdateCommentsRequest represents a request to update multiple comments. (required)
        :type bulk_update_comments_request: BulkUpdateCommentsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bulk_update_comments_serialize(
            bulk_update_comments_request=bulk_update_comments_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkUpdateCommentsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def bulk_update_comments_without_preload_content(
        self,
        bulk_update_comments_request: Annotated[BulkUpdateCommentsRequest, Field(description="BulkUpdateCommentsRequest represents a request to update multiple comments.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Bulk update comments

        This endpoint updates multiple comments in bulk

        :param bulk_update_comments_request: BulkUpdateCommentsRequest represents a request to update multiple comments. (required)
        :type bulk_update_comments_request: BulkUpdateCommentsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._bulk_update_comments_serialize(
            bulk_update_comments_request=bulk_update_comments_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BulkUpdateCommentsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _bulk_update_comments_serialize(
        self,
        bulk_update_comments_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if bulk_update_comments_request is not None:
            _body_params = bulk_update_comments_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/workspace-microservice/api/v1/comments/bulk-update',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_account(
        self,
        create_account_request: Annotated[CreateAccountRequest, Field(description="CreateAccountRequest represents a request to create a new user account in the system. This message contains all necessary information to establish a new user account within a specific organization and tenant context.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateAccountResponse:
        """Create a new account

        This endpoint creates a new user account

        :param create_account_request: CreateAccountRequest represents a request to create a new user account in the system. This message contains all necessary information to establish a new user account within a specific organization and tenant context. (required)
        :type create_account_request: CreateAccountRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_account_serialize(
            create_account_request=create_account_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_account_with_http_info(
        self,
        create_account_request: Annotated[CreateAccountRequest, Field(description="CreateAccountRequest represents a request to create a new user account in the system. This message contains all necessary information to establish a new user account within a specific organization and tenant context.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateAccountResponse]:
        """Create a new account

        This endpoint creates a new user account

        :param create_account_request: CreateAccountRequest represents a request to create a new user account in the system. This message contains all necessary information to establish a new user account within a specific organization and tenant context. (required)
        :type create_account_request: CreateAccountRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_account_serialize(
            create_account_request=create_account_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_account_without_preload_content(
        self,
        create_account_request: Annotated[CreateAccountRequest, Field(description="CreateAccountRequest represents a request to create a new user account in the system. This message contains all necessary information to establish a new user account within a specific organization and tenant context.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a new account

        This endpoint creates a new user account

        :param create_account_request: CreateAccountRequest represents a request to create a new user account in the system. This message contains all necessary information to establish a new user account within a specific organization and tenant context. (required)
        :type create_account_request: CreateAccountRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_account_serialize(
            create_account_request=create_account_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_account_serialize(
        self,
        create_account_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_account_request is not None:
            _body_params = create_account_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/workspace-microservice/api/v1/accounts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_comment1(
        self,
        create_comment_request: CreateCommentRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateCommentResponse1:
        """Create a comment

        This endpoint creates a new comment in a thread

        :param create_comment_request: (required)
        :type create_comment_request: CreateCommentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_comment1_serialize(
            create_comment_request=create_comment_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateCommentResponse1",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_comment1_with_http_info(
        self,
        create_comment_request: CreateCommentRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateCommentResponse1]:
        """Create a comment

        This endpoint creates a new comment in a thread

        :param create_comment_request: (required)
        :type create_comment_request: CreateCommentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_comment1_serialize(
            create_comment_request=create_comment_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateCommentResponse1",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_comment1_without_preload_content(
        self,
        create_comment_request: CreateCommentRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a comment

        This endpoint creates a new comment in a thread

        :param create_comment_request: (required)
        :type create_comment_request: CreateCommentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_comment1_serialize(
            create_comment_request=create_comment_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateCommentResponse1",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_comment1_serialize(
        self,
        create_comment_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_comment_request is not None:
            _body_params = create_comment_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/workspace-microservice/api/v1/comments',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_comment_edit(
        self,
        comment_id: Annotated[StrictStr, Field(description="comment_id identifies the comment being edited")],
        create_comment_edit_body: CreateCommentEditBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateCommentEditResponse:
        """Create a comment edit

        This endpoint creates a new edit for a comment

        :param comment_id: comment_id identifies the comment being edited (required)
        :type comment_id: str
        :param create_comment_edit_body: (required)
        :type create_comment_edit_body: CreateCommentEditBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_comment_edit_serialize(
            comment_id=comment_id,
            create_comment_edit_body=create_comment_edit_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateCommentEditResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_comment_edit_with_http_info(
        self,
        comment_id: Annotated[StrictStr, Field(description="comment_id identifies the comment being edited")],
        create_comment_edit_body: CreateCommentEditBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateCommentEditResponse]:
        """Create a comment edit

        This endpoint creates a new edit for a comment

        :param comment_id: comment_id identifies the comment being edited (required)
        :type comment_id: str
        :param create_comment_edit_body: (required)
        :type create_comment_edit_body: CreateCommentEditBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_comment_edit_serialize(
            comment_id=comment_id,
            create_comment_edit_body=create_comment_edit_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateCommentEditResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_comment_edit_without_preload_content(
        self,
        comment_id: Annotated[StrictStr, Field(description="comment_id identifies the comment being edited")],
        create_comment_edit_body: CreateCommentEditBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a comment edit

        This endpoint creates a new edit for a comment

        :param comment_id: comment_id identifies the comment being edited (required)
        :type comment_id: str
        :param create_comment_edit_body: (required)
        :type create_comment_edit_body: CreateCommentEditBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_comment_edit_serialize(
            comment_id=comment_id,
            create_comment_edit_body=create_comment_edit_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateCommentEditResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_comment_edit_serialize(
        self,
        comment_id,
        create_comment_edit_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if comment_id is not None:
            _path_params['commentId'] = comment_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_comment_edit_body is not None:
            _body_params = create_comment_edit_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/workspace-microservice/api/v1/comments/{commentId}/edits',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_comment_thread(
        self,
        create_comment_thread_request: Annotated[CreateCommentThreadRequest, Field(description="CreateCommentThreadRequest represents a request to create a new comment thread.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateCommentThreadResponse:
        """Create a comment thread

        This endpoint creates a new comment thread on a file

        :param create_comment_thread_request: CreateCommentThreadRequest represents a request to create a new comment thread. (required)
        :type create_comment_thread_request: CreateCommentThreadRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_comment_thread_serialize(
            create_comment_thread_request=create_comment_thread_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateCommentThreadResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_comment_thread_with_http_info(
        self,
        create_comment_thread_request: Annotated[CreateCommentThreadRequest, Field(description="CreateCommentThreadRequest represents a request to create a new comment thread.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateCommentThreadResponse]:
        """Create a comment thread

        This endpoint creates a new comment thread on a file

        :param create_comment_thread_request: CreateCommentThreadRequest represents a request to create a new comment thread. (required)
        :type create_comment_thread_request: CreateCommentThreadRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_comment_thread_serialize(
            create_comment_thread_request=create_comment_thread_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateCommentThreadResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_comment_thread_without_preload_content(
        self,
        create_comment_thread_request: Annotated[CreateCommentThreadRequest, Field(description="CreateCommentThreadRequest represents a request to create a new comment thread.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a comment thread

        This endpoint creates a new comment thread on a file

        :param create_comment_thread_request: CreateCommentThreadRequest represents a request to create a new comment thread. (required)
        :type create_comment_thread_request: CreateCommentThreadRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_comment_thread_serialize(
            create_comment_thread_request=create_comment_thread_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateCommentThreadResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_comment_thread_serialize(
        self,
        create_comment_thread_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_comment_thread_request is not None:
            _body_params = create_comment_thread_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/workspace-microservice/api/v1/comment-threads',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_document_snapshot(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file to snapshot")],
        create_document_snapshot_body: CreateDocumentSnapshotBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateDocumentSnapshotResponse:
        """Create a document snapshot

        This endpoint creates a new snapshot of a document's content

        :param file_id: file_id identifies the file to snapshot (required)
        :type file_id: str
        :param create_document_snapshot_body: (required)
        :type create_document_snapshot_body: CreateDocumentSnapshotBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_document_snapshot_serialize(
            file_id=file_id,
            create_document_snapshot_body=create_document_snapshot_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateDocumentSnapshotResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_document_snapshot_with_http_info(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file to snapshot")],
        create_document_snapshot_body: CreateDocumentSnapshotBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateDocumentSnapshotResponse]:
        """Create a document snapshot

        This endpoint creates a new snapshot of a document's content

        :param file_id: file_id identifies the file to snapshot (required)
        :type file_id: str
        :param create_document_snapshot_body: (required)
        :type create_document_snapshot_body: CreateDocumentSnapshotBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_document_snapshot_serialize(
            file_id=file_id,
            create_document_snapshot_body=create_document_snapshot_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateDocumentSnapshotResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_document_snapshot_without_preload_content(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file to snapshot")],
        create_document_snapshot_body: CreateDocumentSnapshotBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a document snapshot

        This endpoint creates a new snapshot of a document's content

        :param file_id: file_id identifies the file to snapshot (required)
        :type file_id: str
        :param create_document_snapshot_body: (required)
        :type create_document_snapshot_body: CreateDocumentSnapshotBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_document_snapshot_serialize(
            file_id=file_id,
            create_document_snapshot_body=create_document_snapshot_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateDocumentSnapshotResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_document_snapshot_serialize(
        self,
        file_id,
        create_document_snapshot_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if file_id is not None:
            _path_params['fileId'] = file_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_document_snapshot_body is not None:
            _body_params = create_document_snapshot_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/workspace-microservice/api/v1/files/{fileId}/snapshots',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_folder(
        self,
        create_folder_request: Annotated[CreateFolderRequest, Field(description="CreateFolderRequest represents a request to create a new folder within a workspace. This message contains all necessary information to establish a new folder structure while maintaining proper access controls and organizational hierarchy.  Key features: - User authentication and authorization - Workspace organization - Folder naming and validation - Multi-tenant support - Organization context")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateFolderResponse:
        """Create a folder

        This endpoint creates a new folder

        :param create_folder_request: CreateFolderRequest represents a request to create a new folder within a workspace. This message contains all necessary information to establish a new folder structure while maintaining proper access controls and organizational hierarchy.  Key features: - User authentication and authorization - Workspace organization - Folder naming and validation - Multi-tenant support - Organization context (required)
        :type create_folder_request: CreateFolderRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_folder_serialize(
            create_folder_request=create_folder_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateFolderResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_folder_with_http_info(
        self,
        create_folder_request: Annotated[CreateFolderRequest, Field(description="CreateFolderRequest represents a request to create a new folder within a workspace. This message contains all necessary information to establish a new folder structure while maintaining proper access controls and organizational hierarchy.  Key features: - User authentication and authorization - Workspace organization - Folder naming and validation - Multi-tenant support - Organization context")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateFolderResponse]:
        """Create a folder

        This endpoint creates a new folder

        :param create_folder_request: CreateFolderRequest represents a request to create a new folder within a workspace. This message contains all necessary information to establish a new folder structure while maintaining proper access controls and organizational hierarchy.  Key features: - User authentication and authorization - Workspace organization - Folder naming and validation - Multi-tenant support - Organization context (required)
        :type create_folder_request: CreateFolderRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_folder_serialize(
            create_folder_request=create_folder_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateFolderResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_folder_without_preload_content(
        self,
        create_folder_request: Annotated[CreateFolderRequest, Field(description="CreateFolderRequest represents a request to create a new folder within a workspace. This message contains all necessary information to establish a new folder structure while maintaining proper access controls and organizational hierarchy.  Key features: - User authentication and authorization - Workspace organization - Folder naming and validation - Multi-tenant support - Organization context")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a folder

        This endpoint creates a new folder

        :param create_folder_request: CreateFolderRequest represents a request to create a new folder within a workspace. This message contains all necessary information to establish a new folder structure while maintaining proper access controls and organizational hierarchy.  Key features: - User authentication and authorization - Workspace organization - Folder naming and validation - Multi-tenant support - Organization context (required)
        :type create_folder_request: CreateFolderRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_folder_serialize(
            create_folder_request=create_folder_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateFolderResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_folder_serialize(
        self,
        create_folder_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_folder_request is not None:
            _body_params = create_folder_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/workspace-microservice/api/v1/folders',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_markdown_file(
        self,
        create_markdown_file_request: Annotated[CreateMarkdownFileRequest, Field(description="CreateMarkdownFileRequest represents a request to create a new Markdown file in the workspace. This message contains all necessary information to create and store a Markdown file, including content, location details, and organizational context.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateMarkdownFileResponse:
        """Create a markdown file

        This endpoint creates a new file

        :param create_markdown_file_request: CreateMarkdownFileRequest represents a request to create a new Markdown file in the workspace. This message contains all necessary information to create and store a Markdown file, including content, location details, and organizational context. (required)
        :type create_markdown_file_request: CreateMarkdownFileRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_markdown_file_serialize(
            create_markdown_file_request=create_markdown_file_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateMarkdownFileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_markdown_file_with_http_info(
        self,
        create_markdown_file_request: Annotated[CreateMarkdownFileRequest, Field(description="CreateMarkdownFileRequest represents a request to create a new Markdown file in the workspace. This message contains all necessary information to create and store a Markdown file, including content, location details, and organizational context.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateMarkdownFileResponse]:
        """Create a markdown file

        This endpoint creates a new file

        :param create_markdown_file_request: CreateMarkdownFileRequest represents a request to create a new Markdown file in the workspace. This message contains all necessary information to create and store a Markdown file, including content, location details, and organizational context. (required)
        :type create_markdown_file_request: CreateMarkdownFileRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_markdown_file_serialize(
            create_markdown_file_request=create_markdown_file_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateMarkdownFileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_markdown_file_without_preload_content(
        self,
        create_markdown_file_request: Annotated[CreateMarkdownFileRequest, Field(description="CreateMarkdownFileRequest represents a request to create a new Markdown file in the workspace. This message contains all necessary information to create and store a Markdown file, including content, location details, and organizational context.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a markdown file

        This endpoint creates a new file

        :param create_markdown_file_request: CreateMarkdownFileRequest represents a request to create a new Markdown file in the workspace. This message contains all necessary information to create and store a Markdown file, including content, location details, and organizational context. (required)
        :type create_markdown_file_request: CreateMarkdownFileRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_markdown_file_serialize(
            create_markdown_file_request=create_markdown_file_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateMarkdownFileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_markdown_file_serialize(
        self,
        create_markdown_file_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_markdown_file_request is not None:
            _body_params = create_markdown_file_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/workspace-microservice/api/v1/files',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_workspace(
        self,
        create_workspace_request: Annotated[CreateWorkspaceRequest, Field(description="CreateWorkspaceRequest represents a request to create a new workspace in the system. This message contains all necessary information to establish a new workspace within a specific organization and tenant context.  Key features: - User identification and authorization - Workspace naming and configuration - Multi-tenant support - Organization scoping")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateWorkspaceResponse:
        """Create a workspace

        This endpoint creates a new workspace

        :param create_workspace_request: CreateWorkspaceRequest represents a request to create a new workspace in the system. This message contains all necessary information to establish a new workspace within a specific organization and tenant context.  Key features: - User identification and authorization - Workspace naming and configuration - Multi-tenant support - Organization scoping (required)
        :type create_workspace_request: CreateWorkspaceRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_workspace_serialize(
            create_workspace_request=create_workspace_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateWorkspaceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_workspace_with_http_info(
        self,
        create_workspace_request: Annotated[CreateWorkspaceRequest, Field(description="CreateWorkspaceRequest represents a request to create a new workspace in the system. This message contains all necessary information to establish a new workspace within a specific organization and tenant context.  Key features: - User identification and authorization - Workspace naming and configuration - Multi-tenant support - Organization scoping")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateWorkspaceResponse]:
        """Create a workspace

        This endpoint creates a new workspace

        :param create_workspace_request: CreateWorkspaceRequest represents a request to create a new workspace in the system. This message contains all necessary information to establish a new workspace within a specific organization and tenant context.  Key features: - User identification and authorization - Workspace naming and configuration - Multi-tenant support - Organization scoping (required)
        :type create_workspace_request: CreateWorkspaceRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_workspace_serialize(
            create_workspace_request=create_workspace_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateWorkspaceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_workspace_without_preload_content(
        self,
        create_workspace_request: Annotated[CreateWorkspaceRequest, Field(description="CreateWorkspaceRequest represents a request to create a new workspace in the system. This message contains all necessary information to establish a new workspace within a specific organization and tenant context.  Key features: - User identification and authorization - Workspace naming and configuration - Multi-tenant support - Organization scoping")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a workspace

        This endpoint creates a new workspace

        :param create_workspace_request: CreateWorkspaceRequest represents a request to create a new workspace in the system. This message contains all necessary information to establish a new workspace within a specific organization and tenant context.  Key features: - User identification and authorization - Workspace naming and configuration - Multi-tenant support - Organization scoping (required)
        :type create_workspace_request: CreateWorkspaceRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_workspace_serialize(
            create_workspace_request=create_workspace_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateWorkspaceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_workspace_serialize(
        self,
        create_workspace_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_workspace_request is not None:
            _body_params = create_workspace_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/workspace-microservice/api/v1/workspaces',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def create_workspace_compliance(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace")],
        create_workspace_compliance_body: CreateWorkspaceComplianceBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateWorkspaceComplianceResponse:
        """Create workspace compliance settings

        This endpoint creates compliance settings for a workspace

        :param workspace_id: workspace_id identifies the workspace (required)
        :type workspace_id: str
        :param create_workspace_compliance_body: (required)
        :type create_workspace_compliance_body: CreateWorkspaceComplianceBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_workspace_compliance_serialize(
            workspace_id=workspace_id,
            create_workspace_compliance_body=create_workspace_compliance_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateWorkspaceComplianceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_workspace_compliance_with_http_info(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace")],
        create_workspace_compliance_body: CreateWorkspaceComplianceBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateWorkspaceComplianceResponse]:
        """Create workspace compliance settings

        This endpoint creates compliance settings for a workspace

        :param workspace_id: workspace_id identifies the workspace (required)
        :type workspace_id: str
        :param create_workspace_compliance_body: (required)
        :type create_workspace_compliance_body: CreateWorkspaceComplianceBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_workspace_compliance_serialize(
            workspace_id=workspace_id,
            create_workspace_compliance_body=create_workspace_compliance_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateWorkspaceComplianceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_workspace_compliance_without_preload_content(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace")],
        create_workspace_compliance_body: CreateWorkspaceComplianceBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create workspace compliance settings

        This endpoint creates compliance settings for a workspace

        :param workspace_id: workspace_id identifies the workspace (required)
        :type workspace_id: str
        :param create_workspace_compliance_body: (required)
        :type create_workspace_compliance_body: CreateWorkspaceComplianceBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_workspace_compliance_serialize(
            workspace_id=workspace_id,
            create_workspace_compliance_body=create_workspace_compliance_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateWorkspaceComplianceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_workspace_compliance_serialize(
        self,
        workspace_id,
        create_workspace_compliance_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace_id is not None:
            _path_params['workspaceId'] = workspace_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_workspace_compliance_body is not None:
            _body_params = create_workspace_compliance_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/workspace-microservice/api/v1/workspaces/{workspaceId}/compliance',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_account(
        self,
        user_id: Annotated[StrictStr, Field(description="user_id uniquely identifies the account to be deleted Must be a non-empty string matching the authentication system's user ID")],
        org_id: Annotated[StrictStr, Field(description="org_id identifies the organization context for the account deletion Must be a valid organization identifier to ensure deletion occurs in correct scope")],
        tenant_id: Annotated[StrictStr, Field(description="tenant_id identifies the tenant context for multi-tenant deployments Must be a valid tenant identifier to ensure deletion occurs in correct tenant")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteAccountResponse:
        """Delete an account

        This endpoint deletes an account by ID

        :param user_id: user_id uniquely identifies the account to be deleted Must be a non-empty string matching the authentication system's user ID (required)
        :type user_id: str
        :param org_id: org_id identifies the organization context for the account deletion Must be a valid organization identifier to ensure deletion occurs in correct scope (required)
        :type org_id: str
        :param tenant_id: tenant_id identifies the tenant context for multi-tenant deployments Must be a valid tenant identifier to ensure deletion occurs in correct tenant (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_account_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_account_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="user_id uniquely identifies the account to be deleted Must be a non-empty string matching the authentication system's user ID")],
        org_id: Annotated[StrictStr, Field(description="org_id identifies the organization context for the account deletion Must be a valid organization identifier to ensure deletion occurs in correct scope")],
        tenant_id: Annotated[StrictStr, Field(description="tenant_id identifies the tenant context for multi-tenant deployments Must be a valid tenant identifier to ensure deletion occurs in correct tenant")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteAccountResponse]:
        """Delete an account

        This endpoint deletes an account by ID

        :param user_id: user_id uniquely identifies the account to be deleted Must be a non-empty string matching the authentication system's user ID (required)
        :type user_id: str
        :param org_id: org_id identifies the organization context for the account deletion Must be a valid organization identifier to ensure deletion occurs in correct scope (required)
        :type org_id: str
        :param tenant_id: tenant_id identifies the tenant context for multi-tenant deployments Must be a valid tenant identifier to ensure deletion occurs in correct tenant (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_account_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_account_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="user_id uniquely identifies the account to be deleted Must be a non-empty string matching the authentication system's user ID")],
        org_id: Annotated[StrictStr, Field(description="org_id identifies the organization context for the account deletion Must be a valid organization identifier to ensure deletion occurs in correct scope")],
        tenant_id: Annotated[StrictStr, Field(description="tenant_id identifies the tenant context for multi-tenant deployments Must be a valid tenant identifier to ensure deletion occurs in correct tenant")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete an account

        This endpoint deletes an account by ID

        :param user_id: user_id uniquely identifies the account to be deleted Must be a non-empty string matching the authentication system's user ID (required)
        :type user_id: str
        :param org_id: org_id identifies the organization context for the account deletion Must be a valid organization identifier to ensure deletion occurs in correct scope (required)
        :type org_id: str
        :param tenant_id: tenant_id identifies the tenant context for multi-tenant deployments Must be a valid tenant identifier to ensure deletion occurs in correct tenant (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_account_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_account_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/workspace-microservice/api/v1/accounts/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_comment1(
        self,
        comment_id: StrictStr,
        user_id: StrictStr,
        workspace_id: StrictStr,
        folder_id: StrictStr,
        file_id: StrictStr,
        thread_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteCommentResponse1:
        """Delete a comment

        This endpoint deletes a specific comment

        :param comment_id: (required)
        :type comment_id: str
        :param user_id: (required)
        :type user_id: str
        :param workspace_id: (required)
        :type workspace_id: str
        :param folder_id: (required)
        :type folder_id: str
        :param file_id: (required)
        :type file_id: str
        :param thread_id: (required)
        :type thread_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_comment1_serialize(
            comment_id=comment_id,
            user_id=user_id,
            workspace_id=workspace_id,
            folder_id=folder_id,
            file_id=file_id,
            thread_id=thread_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteCommentResponse1",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_comment1_with_http_info(
        self,
        comment_id: StrictStr,
        user_id: StrictStr,
        workspace_id: StrictStr,
        folder_id: StrictStr,
        file_id: StrictStr,
        thread_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteCommentResponse1]:
        """Delete a comment

        This endpoint deletes a specific comment

        :param comment_id: (required)
        :type comment_id: str
        :param user_id: (required)
        :type user_id: str
        :param workspace_id: (required)
        :type workspace_id: str
        :param folder_id: (required)
        :type folder_id: str
        :param file_id: (required)
        :type file_id: str
        :param thread_id: (required)
        :type thread_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_comment1_serialize(
            comment_id=comment_id,
            user_id=user_id,
            workspace_id=workspace_id,
            folder_id=folder_id,
            file_id=file_id,
            thread_id=thread_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteCommentResponse1",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_comment1_without_preload_content(
        self,
        comment_id: StrictStr,
        user_id: StrictStr,
        workspace_id: StrictStr,
        folder_id: StrictStr,
        file_id: StrictStr,
        thread_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete a comment

        This endpoint deletes a specific comment

        :param comment_id: (required)
        :type comment_id: str
        :param user_id: (required)
        :type user_id: str
        :param workspace_id: (required)
        :type workspace_id: str
        :param folder_id: (required)
        :type folder_id: str
        :param file_id: (required)
        :type file_id: str
        :param thread_id: (required)
        :type thread_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_comment1_serialize(
            comment_id=comment_id,
            user_id=user_id,
            workspace_id=workspace_id,
            folder_id=folder_id,
            file_id=file_id,
            thread_id=thread_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteCommentResponse1",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_comment1_serialize(
        self,
        comment_id,
        user_id,
        workspace_id,
        folder_id,
        file_id,
        thread_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if comment_id is not None:
            _path_params['commentId'] = comment_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if workspace_id is not None:
            
            _query_params.append(('workspaceId', workspace_id))
            
        if folder_id is not None:
            
            _query_params.append(('folderId', folder_id))
            
        if file_id is not None:
            
            _query_params.append(('fileId', file_id))
            
        if thread_id is not None:
            
            _query_params.append(('threadId', thread_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/workspace-microservice/api/v1/comments/{commentId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_comment_edit(
        self,
        comment_id: StrictStr,
        edit_id: StrictStr,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteCommentEditResponse:
        """Delete a comment edit

        This endpoint deletes a specific comment edit

        :param comment_id: (required)
        :type comment_id: str
        :param edit_id: (required)
        :type edit_id: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_comment_edit_serialize(
            comment_id=comment_id,
            edit_id=edit_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteCommentEditResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_comment_edit_with_http_info(
        self,
        comment_id: StrictStr,
        edit_id: StrictStr,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteCommentEditResponse]:
        """Delete a comment edit

        This endpoint deletes a specific comment edit

        :param comment_id: (required)
        :type comment_id: str
        :param edit_id: (required)
        :type edit_id: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_comment_edit_serialize(
            comment_id=comment_id,
            edit_id=edit_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteCommentEditResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_comment_edit_without_preload_content(
        self,
        comment_id: StrictStr,
        edit_id: StrictStr,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete a comment edit

        This endpoint deletes a specific comment edit

        :param comment_id: (required)
        :type comment_id: str
        :param edit_id: (required)
        :type edit_id: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_comment_edit_serialize(
            comment_id=comment_id,
            edit_id=edit_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteCommentEditResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_comment_edit_serialize(
        self,
        comment_id,
        edit_id,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if comment_id is not None:
            _path_params['commentId'] = comment_id
        if edit_id is not None:
            _path_params['editId'] = edit_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/workspace-microservice/api/v1/comments/{commentId}/edits/{editId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_comment_thread(
        self,
        thread_id: Annotated[StrictStr, Field(description="thread_id identifies the comment thread to delete")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user deleting the thread Must be authenticated and authorized to delete the thread")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        hard_delete: Annotated[Optional[StrictBool], Field(description="Optional: Force delete even if thread has replies")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteCommentThreadResponse:
        """Delete a comment thread

        This endpoint deletes a comment thread and all its associated comments

        :param thread_id: thread_id identifies the comment thread to delete (required)
        :type thread_id: str
        :param user_id: user_id identifies the user deleting the thread Must be authenticated and authorized to delete the thread (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param hard_delete: Optional: Force delete even if thread has replies
        :type hard_delete: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_comment_thread_serialize(
            thread_id=thread_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            hard_delete=hard_delete,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteCommentThreadResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_comment_thread_with_http_info(
        self,
        thread_id: Annotated[StrictStr, Field(description="thread_id identifies the comment thread to delete")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user deleting the thread Must be authenticated and authorized to delete the thread")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        hard_delete: Annotated[Optional[StrictBool], Field(description="Optional: Force delete even if thread has replies")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteCommentThreadResponse]:
        """Delete a comment thread

        This endpoint deletes a comment thread and all its associated comments

        :param thread_id: thread_id identifies the comment thread to delete (required)
        :type thread_id: str
        :param user_id: user_id identifies the user deleting the thread Must be authenticated and authorized to delete the thread (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param hard_delete: Optional: Force delete even if thread has replies
        :type hard_delete: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_comment_thread_serialize(
            thread_id=thread_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            hard_delete=hard_delete,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteCommentThreadResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_comment_thread_without_preload_content(
        self,
        thread_id: Annotated[StrictStr, Field(description="thread_id identifies the comment thread to delete")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user deleting the thread Must be authenticated and authorized to delete the thread")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        hard_delete: Annotated[Optional[StrictBool], Field(description="Optional: Force delete even if thread has replies")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete a comment thread

        This endpoint deletes a comment thread and all its associated comments

        :param thread_id: thread_id identifies the comment thread to delete (required)
        :type thread_id: str
        :param user_id: user_id identifies the user deleting the thread Must be authenticated and authorized to delete the thread (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param hard_delete: Optional: Force delete even if thread has replies
        :type hard_delete: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_comment_thread_serialize(
            thread_id=thread_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            hard_delete=hard_delete,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteCommentThreadResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_comment_thread_serialize(
        self,
        thread_id,
        user_id,
        org_id,
        tenant_id,
        hard_delete,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if thread_id is not None:
            _path_params['threadId'] = thread_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if hard_delete is not None:
            
            _query_params.append(('hardDelete', hard_delete))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/workspace-microservice/api/v1/comment-threads/{threadId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_document_snapshot(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file")],
        snapshot_id: Annotated[StrictStr, Field(description="snapshot_id identifies the specific snapshot to delete")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user deleting the snapshot")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteDocumentSnapshotResponse:
        """Delete a document snapshot

        This endpoint deletes a specific document snapshot

        :param file_id: file_id identifies the file (required)
        :type file_id: str
        :param snapshot_id: snapshot_id identifies the specific snapshot to delete (required)
        :type snapshot_id: str
        :param user_id: user_id identifies the user deleting the snapshot (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_document_snapshot_serialize(
            file_id=file_id,
            snapshot_id=snapshot_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteDocumentSnapshotResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_document_snapshot_with_http_info(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file")],
        snapshot_id: Annotated[StrictStr, Field(description="snapshot_id identifies the specific snapshot to delete")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user deleting the snapshot")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteDocumentSnapshotResponse]:
        """Delete a document snapshot

        This endpoint deletes a specific document snapshot

        :param file_id: file_id identifies the file (required)
        :type file_id: str
        :param snapshot_id: snapshot_id identifies the specific snapshot to delete (required)
        :type snapshot_id: str
        :param user_id: user_id identifies the user deleting the snapshot (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_document_snapshot_serialize(
            file_id=file_id,
            snapshot_id=snapshot_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteDocumentSnapshotResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_document_snapshot_without_preload_content(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file")],
        snapshot_id: Annotated[StrictStr, Field(description="snapshot_id identifies the specific snapshot to delete")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user deleting the snapshot")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete a document snapshot

        This endpoint deletes a specific document snapshot

        :param file_id: file_id identifies the file (required)
        :type file_id: str
        :param snapshot_id: snapshot_id identifies the specific snapshot to delete (required)
        :type snapshot_id: str
        :param user_id: user_id identifies the user deleting the snapshot (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_document_snapshot_serialize(
            file_id=file_id,
            snapshot_id=snapshot_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteDocumentSnapshotResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_document_snapshot_serialize(
        self,
        file_id,
        snapshot_id,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if file_id is not None:
            _path_params['fileId'] = file_id
        if snapshot_id is not None:
            _path_params['snapshotId'] = snapshot_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/workspace-microservice/api/v1/files/{fileId}/snapshots/{snapshotId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_file(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id uniquely identifies the file to be deleted Must reference an existing file in the system")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the file deletion Must be authenticated and authorized to delete the file")],
        folder_id: Annotated[StrictStr, Field(description="folder_id identifies the folder containing the file Used for hierarchical organization and access control")],
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace context for the file deletion Must be a valid workspace identifier where the file is located")],
        org_id: Annotated[StrictStr, Field(description="org_id identifies the organization context for the file deletion Must be a valid organization identifier to ensure proper scoping")],
        tenant_id: Annotated[StrictStr, Field(description="tenant_id identifies the tenant context for multi-tenant deployments Required to ensure proper isolation between different tenants")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteFileResponse:
        """Delete a file

        This endpoint deletes a file by ID

        :param file_id: file_id uniquely identifies the file to be deleted Must reference an existing file in the system (required)
        :type file_id: str
        :param user_id: user_id identifies the user requesting the file deletion Must be authenticated and authorized to delete the file (required)
        :type user_id: str
        :param folder_id: folder_id identifies the folder containing the file Used for hierarchical organization and access control (required)
        :type folder_id: str
        :param workspace_id: workspace_id identifies the workspace context for the file deletion Must be a valid workspace identifier where the file is located (required)
        :type workspace_id: str
        :param org_id: org_id identifies the organization context for the file deletion Must be a valid organization identifier to ensure proper scoping (required)
        :type org_id: str
        :param tenant_id: tenant_id identifies the tenant context for multi-tenant deployments Required to ensure proper isolation between different tenants (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_file_serialize(
            file_id=file_id,
            user_id=user_id,
            folder_id=folder_id,
            workspace_id=workspace_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteFileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_file_with_http_info(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id uniquely identifies the file to be deleted Must reference an existing file in the system")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the file deletion Must be authenticated and authorized to delete the file")],
        folder_id: Annotated[StrictStr, Field(description="folder_id identifies the folder containing the file Used for hierarchical organization and access control")],
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace context for the file deletion Must be a valid workspace identifier where the file is located")],
        org_id: Annotated[StrictStr, Field(description="org_id identifies the organization context for the file deletion Must be a valid organization identifier to ensure proper scoping")],
        tenant_id: Annotated[StrictStr, Field(description="tenant_id identifies the tenant context for multi-tenant deployments Required to ensure proper isolation between different tenants")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteFileResponse]:
        """Delete a file

        This endpoint deletes a file by ID

        :param file_id: file_id uniquely identifies the file to be deleted Must reference an existing file in the system (required)
        :type file_id: str
        :param user_id: user_id identifies the user requesting the file deletion Must be authenticated and authorized to delete the file (required)
        :type user_id: str
        :param folder_id: folder_id identifies the folder containing the file Used for hierarchical organization and access control (required)
        :type folder_id: str
        :param workspace_id: workspace_id identifies the workspace context for the file deletion Must be a valid workspace identifier where the file is located (required)
        :type workspace_id: str
        :param org_id: org_id identifies the organization context for the file deletion Must be a valid organization identifier to ensure proper scoping (required)
        :type org_id: str
        :param tenant_id: tenant_id identifies the tenant context for multi-tenant deployments Required to ensure proper isolation between different tenants (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_file_serialize(
            file_id=file_id,
            user_id=user_id,
            folder_id=folder_id,
            workspace_id=workspace_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteFileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_file_without_preload_content(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id uniquely identifies the file to be deleted Must reference an existing file in the system")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the file deletion Must be authenticated and authorized to delete the file")],
        folder_id: Annotated[StrictStr, Field(description="folder_id identifies the folder containing the file Used for hierarchical organization and access control")],
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace context for the file deletion Must be a valid workspace identifier where the file is located")],
        org_id: Annotated[StrictStr, Field(description="org_id identifies the organization context for the file deletion Must be a valid organization identifier to ensure proper scoping")],
        tenant_id: Annotated[StrictStr, Field(description="tenant_id identifies the tenant context for multi-tenant deployments Required to ensure proper isolation between different tenants")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete a file

        This endpoint deletes a file by ID

        :param file_id: file_id uniquely identifies the file to be deleted Must reference an existing file in the system (required)
        :type file_id: str
        :param user_id: user_id identifies the user requesting the file deletion Must be authenticated and authorized to delete the file (required)
        :type user_id: str
        :param folder_id: folder_id identifies the folder containing the file Used for hierarchical organization and access control (required)
        :type folder_id: str
        :param workspace_id: workspace_id identifies the workspace context for the file deletion Must be a valid workspace identifier where the file is located (required)
        :type workspace_id: str
        :param org_id: org_id identifies the organization context for the file deletion Must be a valid organization identifier to ensure proper scoping (required)
        :type org_id: str
        :param tenant_id: tenant_id identifies the tenant context for multi-tenant deployments Required to ensure proper isolation between different tenants (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_file_serialize(
            file_id=file_id,
            user_id=user_id,
            folder_id=folder_id,
            workspace_id=workspace_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteFileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_file_serialize(
        self,
        file_id,
        user_id,
        folder_id,
        workspace_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if file_id is not None:
            _path_params['fileId'] = file_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if folder_id is not None:
            
            _query_params.append(('folderId', folder_id))
            
        if workspace_id is not None:
            
            _query_params.append(('workspaceId', workspace_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/workspace-microservice/api/v1/files/{fileId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_folder(
        self,
        folder_id: Annotated[StrictStr, Field(description="folder_id uniquely identifies the folder to be deleted Must reference an existing folder in the system")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the folder deletion Must be authenticated and authorized to delete the folder")],
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace context for the folder deletion Must be a valid workspace identifier where the folder is located")],
        org_id: Annotated[StrictStr, Field(description="org_id identifies the organization context for the folder deletion Must be a valid organization identifier to ensure proper scoping")],
        tenant_id: Annotated[StrictStr, Field(description="tenant_id identifies the tenant context for multi-tenant deployments Required to ensure proper isolation between different tenants")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteFolderResponse:
        """Delete a folder

        This endpoint deletes a folder by ID

        :param folder_id: folder_id uniquely identifies the folder to be deleted Must reference an existing folder in the system (required)
        :type folder_id: str
        :param user_id: user_id identifies the user requesting the folder deletion Must be authenticated and authorized to delete the folder (required)
        :type user_id: str
        :param workspace_id: workspace_id identifies the workspace context for the folder deletion Must be a valid workspace identifier where the folder is located (required)
        :type workspace_id: str
        :param org_id: org_id identifies the organization context for the folder deletion Must be a valid organization identifier to ensure proper scoping (required)
        :type org_id: str
        :param tenant_id: tenant_id identifies the tenant context for multi-tenant deployments Required to ensure proper isolation between different tenants (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_folder_serialize(
            folder_id=folder_id,
            user_id=user_id,
            workspace_id=workspace_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteFolderResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_folder_with_http_info(
        self,
        folder_id: Annotated[StrictStr, Field(description="folder_id uniquely identifies the folder to be deleted Must reference an existing folder in the system")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the folder deletion Must be authenticated and authorized to delete the folder")],
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace context for the folder deletion Must be a valid workspace identifier where the folder is located")],
        org_id: Annotated[StrictStr, Field(description="org_id identifies the organization context for the folder deletion Must be a valid organization identifier to ensure proper scoping")],
        tenant_id: Annotated[StrictStr, Field(description="tenant_id identifies the tenant context for multi-tenant deployments Required to ensure proper isolation between different tenants")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteFolderResponse]:
        """Delete a folder

        This endpoint deletes a folder by ID

        :param folder_id: folder_id uniquely identifies the folder to be deleted Must reference an existing folder in the system (required)
        :type folder_id: str
        :param user_id: user_id identifies the user requesting the folder deletion Must be authenticated and authorized to delete the folder (required)
        :type user_id: str
        :param workspace_id: workspace_id identifies the workspace context for the folder deletion Must be a valid workspace identifier where the folder is located (required)
        :type workspace_id: str
        :param org_id: org_id identifies the organization context for the folder deletion Must be a valid organization identifier to ensure proper scoping (required)
        :type org_id: str
        :param tenant_id: tenant_id identifies the tenant context for multi-tenant deployments Required to ensure proper isolation between different tenants (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_folder_serialize(
            folder_id=folder_id,
            user_id=user_id,
            workspace_id=workspace_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteFolderResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_folder_without_preload_content(
        self,
        folder_id: Annotated[StrictStr, Field(description="folder_id uniquely identifies the folder to be deleted Must reference an existing folder in the system")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the folder deletion Must be authenticated and authorized to delete the folder")],
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace context for the folder deletion Must be a valid workspace identifier where the folder is located")],
        org_id: Annotated[StrictStr, Field(description="org_id identifies the organization context for the folder deletion Must be a valid organization identifier to ensure proper scoping")],
        tenant_id: Annotated[StrictStr, Field(description="tenant_id identifies the tenant context for multi-tenant deployments Required to ensure proper isolation between different tenants")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete a folder

        This endpoint deletes a folder by ID

        :param folder_id: folder_id uniquely identifies the folder to be deleted Must reference an existing folder in the system (required)
        :type folder_id: str
        :param user_id: user_id identifies the user requesting the folder deletion Must be authenticated and authorized to delete the folder (required)
        :type user_id: str
        :param workspace_id: workspace_id identifies the workspace context for the folder deletion Must be a valid workspace identifier where the folder is located (required)
        :type workspace_id: str
        :param org_id: org_id identifies the organization context for the folder deletion Must be a valid organization identifier to ensure proper scoping (required)
        :type org_id: str
        :param tenant_id: tenant_id identifies the tenant context for multi-tenant deployments Required to ensure proper isolation between different tenants (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_folder_serialize(
            folder_id=folder_id,
            user_id=user_id,
            workspace_id=workspace_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteFolderResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_folder_serialize(
        self,
        folder_id,
        user_id,
        workspace_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if folder_id is not None:
            _path_params['folderId'] = folder_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if workspace_id is not None:
            
            _query_params.append(('workspaceId', workspace_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/workspace-microservice/api/v1/folders/{folderId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_workspace(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id uniquely identifies the workspace to be deleted Must reference an existing workspace in the system")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the workspace deletion Must be authenticated and authorized to delete the workspace")],
        org_id: Annotated[StrictStr, Field(description="org_id identifies the organization context for the workspace deletion Must be a valid organization identifier to ensure proper scoping")],
        tenant_id: Annotated[StrictStr, Field(description="tenant_id identifies the tenant context for multi-tenant deployments Required to ensure proper isolation between different tenants")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteWorkspaceResponse:
        """Delete a workspace

        This endpoint deletes a workspace by ID

        :param workspace_id: workspace_id uniquely identifies the workspace to be deleted Must reference an existing workspace in the system (required)
        :type workspace_id: str
        :param user_id: user_id identifies the user requesting the workspace deletion Must be authenticated and authorized to delete the workspace (required)
        :type user_id: str
        :param org_id: org_id identifies the organization context for the workspace deletion Must be a valid organization identifier to ensure proper scoping (required)
        :type org_id: str
        :param tenant_id: tenant_id identifies the tenant context for multi-tenant deployments Required to ensure proper isolation between different tenants (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_workspace_serialize(
            workspace_id=workspace_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteWorkspaceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_workspace_with_http_info(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id uniquely identifies the workspace to be deleted Must reference an existing workspace in the system")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the workspace deletion Must be authenticated and authorized to delete the workspace")],
        org_id: Annotated[StrictStr, Field(description="org_id identifies the organization context for the workspace deletion Must be a valid organization identifier to ensure proper scoping")],
        tenant_id: Annotated[StrictStr, Field(description="tenant_id identifies the tenant context for multi-tenant deployments Required to ensure proper isolation between different tenants")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteWorkspaceResponse]:
        """Delete a workspace

        This endpoint deletes a workspace by ID

        :param workspace_id: workspace_id uniquely identifies the workspace to be deleted Must reference an existing workspace in the system (required)
        :type workspace_id: str
        :param user_id: user_id identifies the user requesting the workspace deletion Must be authenticated and authorized to delete the workspace (required)
        :type user_id: str
        :param org_id: org_id identifies the organization context for the workspace deletion Must be a valid organization identifier to ensure proper scoping (required)
        :type org_id: str
        :param tenant_id: tenant_id identifies the tenant context for multi-tenant deployments Required to ensure proper isolation between different tenants (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_workspace_serialize(
            workspace_id=workspace_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteWorkspaceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_workspace_without_preload_content(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id uniquely identifies the workspace to be deleted Must reference an existing workspace in the system")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the workspace deletion Must be authenticated and authorized to delete the workspace")],
        org_id: Annotated[StrictStr, Field(description="org_id identifies the organization context for the workspace deletion Must be a valid organization identifier to ensure proper scoping")],
        tenant_id: Annotated[StrictStr, Field(description="tenant_id identifies the tenant context for multi-tenant deployments Required to ensure proper isolation between different tenants")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete a workspace

        This endpoint deletes a workspace by ID

        :param workspace_id: workspace_id uniquely identifies the workspace to be deleted Must reference an existing workspace in the system (required)
        :type workspace_id: str
        :param user_id: user_id identifies the user requesting the workspace deletion Must be authenticated and authorized to delete the workspace (required)
        :type user_id: str
        :param org_id: org_id identifies the organization context for the workspace deletion Must be a valid organization identifier to ensure proper scoping (required)
        :type org_id: str
        :param tenant_id: tenant_id identifies the tenant context for multi-tenant deployments Required to ensure proper isolation between different tenants (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_workspace_serialize(
            workspace_id=workspace_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteWorkspaceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_workspace_serialize(
        self,
        workspace_id,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace_id is not None:
            _path_params['workspaceId'] = workspace_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/workspace-microservice/api/v1/workspaces/{workspaceId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_workspace_compliance(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user deleting the compliance settings")],
        workspace_compliance_id: Annotated[StrictStr, Field(description="The workspace compliance to delete")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteWorkspaceComplianceResponse:
        """Delete workspace compliance settings

        This endpoint deletes compliance settings for a workspace

        :param workspace_id: workspace_id identifies the workspace (required)
        :type workspace_id: str
        :param user_id: user_id identifies the user deleting the compliance settings (required)
        :type user_id: str
        :param workspace_compliance_id: The workspace compliance to delete (required)
        :type workspace_compliance_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_workspace_compliance_serialize(
            workspace_id=workspace_id,
            user_id=user_id,
            workspace_compliance_id=workspace_compliance_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteWorkspaceComplianceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_workspace_compliance_with_http_info(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user deleting the compliance settings")],
        workspace_compliance_id: Annotated[StrictStr, Field(description="The workspace compliance to delete")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteWorkspaceComplianceResponse]:
        """Delete workspace compliance settings

        This endpoint deletes compliance settings for a workspace

        :param workspace_id: workspace_id identifies the workspace (required)
        :type workspace_id: str
        :param user_id: user_id identifies the user deleting the compliance settings (required)
        :type user_id: str
        :param workspace_compliance_id: The workspace compliance to delete (required)
        :type workspace_compliance_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_workspace_compliance_serialize(
            workspace_id=workspace_id,
            user_id=user_id,
            workspace_compliance_id=workspace_compliance_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteWorkspaceComplianceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_workspace_compliance_without_preload_content(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user deleting the compliance settings")],
        workspace_compliance_id: Annotated[StrictStr, Field(description="The workspace compliance to delete")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete workspace compliance settings

        This endpoint deletes compliance settings for a workspace

        :param workspace_id: workspace_id identifies the workspace (required)
        :type workspace_id: str
        :param user_id: user_id identifies the user deleting the compliance settings (required)
        :type user_id: str
        :param workspace_compliance_id: The workspace compliance to delete (required)
        :type workspace_compliance_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_workspace_compliance_serialize(
            workspace_id=workspace_id,
            user_id=user_id,
            workspace_compliance_id=workspace_compliance_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteWorkspaceComplianceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_workspace_compliance_serialize(
        self,
        workspace_id,
        user_id,
        workspace_compliance_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace_id is not None:
            _path_params['workspaceId'] = workspace_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if workspace_compliance_id is not None:
            
            _query_params.append(('workspaceComplianceId', workspace_compliance_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/workspace-microservice/api/v1/workspaces/{workspaceId}/compliance',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_workspace_share(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace")],
        share_id: Annotated[StrictStr, Field(description="share_id identifies the specific share to delete")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user deleting the share")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteWorkspaceShareResponse:
        """Delete a workspace share

        This endpoint removes a share from a workspace

        :param workspace_id: workspace_id identifies the workspace (required)
        :type workspace_id: str
        :param share_id: share_id identifies the specific share to delete (required)
        :type share_id: str
        :param user_id: user_id identifies the user deleting the share (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_workspace_share_serialize(
            workspace_id=workspace_id,
            share_id=share_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteWorkspaceShareResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_workspace_share_with_http_info(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace")],
        share_id: Annotated[StrictStr, Field(description="share_id identifies the specific share to delete")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user deleting the share")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteWorkspaceShareResponse]:
        """Delete a workspace share

        This endpoint removes a share from a workspace

        :param workspace_id: workspace_id identifies the workspace (required)
        :type workspace_id: str
        :param share_id: share_id identifies the specific share to delete (required)
        :type share_id: str
        :param user_id: user_id identifies the user deleting the share (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_workspace_share_serialize(
            workspace_id=workspace_id,
            share_id=share_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteWorkspaceShareResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_workspace_share_without_preload_content(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace")],
        share_id: Annotated[StrictStr, Field(description="share_id identifies the specific share to delete")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user deleting the share")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete a workspace share

        This endpoint removes a share from a workspace

        :param workspace_id: workspace_id identifies the workspace (required)
        :type workspace_id: str
        :param share_id: share_id identifies the specific share to delete (required)
        :type share_id: str
        :param user_id: user_id identifies the user deleting the share (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_workspace_share_serialize(
            workspace_id=workspace_id,
            share_id=share_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteWorkspaceShareResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_workspace_share_serialize(
        self,
        workspace_id,
        share_id,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace_id is not None:
            _path_params['workspaceId'] = workspace_id
        if share_id is not None:
            _path_params['shareId'] = share_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/workspace-microservice/api/v1/workspaces/{workspaceId}/shares/{shareId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def generate_file_embeddings(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file to generate embeddings for")],
        generate_file_embeddings_body: GenerateFileEmbeddingsBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GenerateFileEmbeddingsResponse:
        """Generate file embeddings

        This endpoint triggers the generation of embeddings for the current state of a file

        :param file_id: file_id identifies the file to generate embeddings for (required)
        :type file_id: str
        :param generate_file_embeddings_body: (required)
        :type generate_file_embeddings_body: GenerateFileEmbeddingsBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._generate_file_embeddings_serialize(
            file_id=file_id,
            generate_file_embeddings_body=generate_file_embeddings_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GenerateFileEmbeddingsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def generate_file_embeddings_with_http_info(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file to generate embeddings for")],
        generate_file_embeddings_body: GenerateFileEmbeddingsBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GenerateFileEmbeddingsResponse]:
        """Generate file embeddings

        This endpoint triggers the generation of embeddings for the current state of a file

        :param file_id: file_id identifies the file to generate embeddings for (required)
        :type file_id: str
        :param generate_file_embeddings_body: (required)
        :type generate_file_embeddings_body: GenerateFileEmbeddingsBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._generate_file_embeddings_serialize(
            file_id=file_id,
            generate_file_embeddings_body=generate_file_embeddings_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GenerateFileEmbeddingsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def generate_file_embeddings_without_preload_content(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file to generate embeddings for")],
        generate_file_embeddings_body: GenerateFileEmbeddingsBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Generate file embeddings

        This endpoint triggers the generation of embeddings for the current state of a file

        :param file_id: file_id identifies the file to generate embeddings for (required)
        :type file_id: str
        :param generate_file_embeddings_body: (required)
        :type generate_file_embeddings_body: GenerateFileEmbeddingsBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._generate_file_embeddings_serialize(
            file_id=file_id,
            generate_file_embeddings_body=generate_file_embeddings_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GenerateFileEmbeddingsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _generate_file_embeddings_serialize(
        self,
        file_id,
        generate_file_embeddings_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if file_id is not None:
            _path_params['fileId'] = file_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if generate_file_embeddings_body is not None:
            _body_params = generate_file_embeddings_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/workspace-microservice/api/v1/files/{fileId}/embeddings',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_account(
        self,
        user_id: Annotated[StrictStr, Field(description="user_id uniquely identifies the user whose account information is being requested Must be a non-empty string, typically matching the authentication system's user ID")],
        org_id: Annotated[StrictStr, Field(description="org_id identifies the organization context for the account lookup Must be a valid organization identifier")],
        tenant_id: Annotated[StrictStr, Field(description="tenant_id identifies the tenant context for multi-tenant deployments Must be a valid tenant identifier")],
        create_if_not_exists: Annotated[Optional[StrictBool], Field(description="create_if_not_exists determines whether to create a new account if one doesn't exist If true, a new account will be created with default settings when no matching account is found")] = None,
        email: Annotated[Optional[StrictStr], Field(description="email is the user's email address, used as an alternative lookup method Must be a valid email format if provided")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="include_metadata determines whether to include the account's metadata in the response When true, all custom fields and extended properties will be returned")] = None,
        include_permissions: Annotated[Optional[StrictBool], Field(description="include_permissions determines whether to include the user's permissions in the response When true, returns the complete permission set associated with the account")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetAccountResponse:
        """Get account by ID

        This endpoint retrieves account details by ID

        :param user_id: user_id uniquely identifies the user whose account information is being requested Must be a non-empty string, typically matching the authentication system's user ID (required)
        :type user_id: str
        :param org_id: org_id identifies the organization context for the account lookup Must be a valid organization identifier (required)
        :type org_id: str
        :param tenant_id: tenant_id identifies the tenant context for multi-tenant deployments Must be a valid tenant identifier (required)
        :type tenant_id: str
        :param create_if_not_exists: create_if_not_exists determines whether to create a new account if one doesn't exist If true, a new account will be created with default settings when no matching account is found
        :type create_if_not_exists: bool
        :param email: email is the user's email address, used as an alternative lookup method Must be a valid email format if provided
        :type email: str
        :param include_metadata: include_metadata determines whether to include the account's metadata in the response When true, all custom fields and extended properties will be returned
        :type include_metadata: bool
        :param include_permissions: include_permissions determines whether to include the user's permissions in the response When true, returns the complete permission set associated with the account
        :type include_permissions: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_account_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            create_if_not_exists=create_if_not_exists,
            email=email,
            include_metadata=include_metadata,
            include_permissions=include_permissions,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_account_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="user_id uniquely identifies the user whose account information is being requested Must be a non-empty string, typically matching the authentication system's user ID")],
        org_id: Annotated[StrictStr, Field(description="org_id identifies the organization context for the account lookup Must be a valid organization identifier")],
        tenant_id: Annotated[StrictStr, Field(description="tenant_id identifies the tenant context for multi-tenant deployments Must be a valid tenant identifier")],
        create_if_not_exists: Annotated[Optional[StrictBool], Field(description="create_if_not_exists determines whether to create a new account if one doesn't exist If true, a new account will be created with default settings when no matching account is found")] = None,
        email: Annotated[Optional[StrictStr], Field(description="email is the user's email address, used as an alternative lookup method Must be a valid email format if provided")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="include_metadata determines whether to include the account's metadata in the response When true, all custom fields and extended properties will be returned")] = None,
        include_permissions: Annotated[Optional[StrictBool], Field(description="include_permissions determines whether to include the user's permissions in the response When true, returns the complete permission set associated with the account")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetAccountResponse]:
        """Get account by ID

        This endpoint retrieves account details by ID

        :param user_id: user_id uniquely identifies the user whose account information is being requested Must be a non-empty string, typically matching the authentication system's user ID (required)
        :type user_id: str
        :param org_id: org_id identifies the organization context for the account lookup Must be a valid organization identifier (required)
        :type org_id: str
        :param tenant_id: tenant_id identifies the tenant context for multi-tenant deployments Must be a valid tenant identifier (required)
        :type tenant_id: str
        :param create_if_not_exists: create_if_not_exists determines whether to create a new account if one doesn't exist If true, a new account will be created with default settings when no matching account is found
        :type create_if_not_exists: bool
        :param email: email is the user's email address, used as an alternative lookup method Must be a valid email format if provided
        :type email: str
        :param include_metadata: include_metadata determines whether to include the account's metadata in the response When true, all custom fields and extended properties will be returned
        :type include_metadata: bool
        :param include_permissions: include_permissions determines whether to include the user's permissions in the response When true, returns the complete permission set associated with the account
        :type include_permissions: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_account_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            create_if_not_exists=create_if_not_exists,
            email=email,
            include_metadata=include_metadata,
            include_permissions=include_permissions,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_account_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="user_id uniquely identifies the user whose account information is being requested Must be a non-empty string, typically matching the authentication system's user ID")],
        org_id: Annotated[StrictStr, Field(description="org_id identifies the organization context for the account lookup Must be a valid organization identifier")],
        tenant_id: Annotated[StrictStr, Field(description="tenant_id identifies the tenant context for multi-tenant deployments Must be a valid tenant identifier")],
        create_if_not_exists: Annotated[Optional[StrictBool], Field(description="create_if_not_exists determines whether to create a new account if one doesn't exist If true, a new account will be created with default settings when no matching account is found")] = None,
        email: Annotated[Optional[StrictStr], Field(description="email is the user's email address, used as an alternative lookup method Must be a valid email format if provided")] = None,
        include_metadata: Annotated[Optional[StrictBool], Field(description="include_metadata determines whether to include the account's metadata in the response When true, all custom fields and extended properties will be returned")] = None,
        include_permissions: Annotated[Optional[StrictBool], Field(description="include_permissions determines whether to include the user's permissions in the response When true, returns the complete permission set associated with the account")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get account by ID

        This endpoint retrieves account details by ID

        :param user_id: user_id uniquely identifies the user whose account information is being requested Must be a non-empty string, typically matching the authentication system's user ID (required)
        :type user_id: str
        :param org_id: org_id identifies the organization context for the account lookup Must be a valid organization identifier (required)
        :type org_id: str
        :param tenant_id: tenant_id identifies the tenant context for multi-tenant deployments Must be a valid tenant identifier (required)
        :type tenant_id: str
        :param create_if_not_exists: create_if_not_exists determines whether to create a new account if one doesn't exist If true, a new account will be created with default settings when no matching account is found
        :type create_if_not_exists: bool
        :param email: email is the user's email address, used as an alternative lookup method Must be a valid email format if provided
        :type email: str
        :param include_metadata: include_metadata determines whether to include the account's metadata in the response When true, all custom fields and extended properties will be returned
        :type include_metadata: bool
        :param include_permissions: include_permissions determines whether to include the user's permissions in the response When true, returns the complete permission set associated with the account
        :type include_permissions: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_account_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            create_if_not_exists=create_if_not_exists,
            email=email,
            include_metadata=include_metadata,
            include_permissions=include_permissions,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetAccountResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_account_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        create_if_not_exists,
        email,
        include_metadata,
        include_permissions,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if user_id is not None:
            _path_params['userId'] = user_id
        # process the query parameters
        if create_if_not_exists is not None:
            
            _query_params.append(('createIfNotExists', create_if_not_exists))
            
        if email is not None:
            
            _query_params.append(('email', email))
            
        if include_metadata is not None:
            
            _query_params.append(('includeMetadata', include_metadata))
            
        if include_permissions is not None:
            
            _query_params.append(('includePermissions', include_permissions))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/workspace-microservice/api/v1/accounts/{userId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_background_job_status(
        self,
        job_id: Annotated[StrictStr, Field(description="job_id identifies the specific background job")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the job status")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetBackgroundJobStatusResponse:
        """Get background job status

        This endpoint retrieves the status of a background job like embedding generation

        :param job_id: job_id identifies the specific background job (required)
        :type job_id: str
        :param user_id: user_id identifies the user requesting the job status (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_background_job_status_serialize(
            job_id=job_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBackgroundJobStatusResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_background_job_status_with_http_info(
        self,
        job_id: Annotated[StrictStr, Field(description="job_id identifies the specific background job")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the job status")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetBackgroundJobStatusResponse]:
        """Get background job status

        This endpoint retrieves the status of a background job like embedding generation

        :param job_id: job_id identifies the specific background job (required)
        :type job_id: str
        :param user_id: user_id identifies the user requesting the job status (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_background_job_status_serialize(
            job_id=job_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBackgroundJobStatusResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_background_job_status_without_preload_content(
        self,
        job_id: Annotated[StrictStr, Field(description="job_id identifies the specific background job")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the job status")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get background job status

        This endpoint retrieves the status of a background job like embedding generation

        :param job_id: job_id identifies the specific background job (required)
        :type job_id: str
        :param user_id: user_id identifies the user requesting the job status (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_background_job_status_serialize(
            job_id=job_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBackgroundJobStatusResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_background_job_status_serialize(
        self,
        job_id,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if job_id is not None:
            _path_params['jobId'] = job_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/workspace-microservice/api/v1/jobs/{jobId}/status',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_comment(
        self,
        comment_id: Annotated[StrictStr, Field(description="comment_id identifies the comment to retrieve")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the comment Must be authenticated and authorized to view the comment")],
        workspace_id: StrictStr,
        folder_id: StrictStr,
        file_id: StrictStr,
        thread_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetCommentResponse:
        """Get a comment

        This endpoint retrieves a specific comment by its ID

        :param comment_id: comment_id identifies the comment to retrieve (required)
        :type comment_id: str
        :param user_id: user_id identifies the user requesting the comment Must be authenticated and authorized to view the comment (required)
        :type user_id: str
        :param workspace_id: (required)
        :type workspace_id: str
        :param folder_id: (required)
        :type folder_id: str
        :param file_id: (required)
        :type file_id: str
        :param thread_id: (required)
        :type thread_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_comment_serialize(
            comment_id=comment_id,
            user_id=user_id,
            workspace_id=workspace_id,
            folder_id=folder_id,
            file_id=file_id,
            thread_id=thread_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommentResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_comment_with_http_info(
        self,
        comment_id: Annotated[StrictStr, Field(description="comment_id identifies the comment to retrieve")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the comment Must be authenticated and authorized to view the comment")],
        workspace_id: StrictStr,
        folder_id: StrictStr,
        file_id: StrictStr,
        thread_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetCommentResponse]:
        """Get a comment

        This endpoint retrieves a specific comment by its ID

        :param comment_id: comment_id identifies the comment to retrieve (required)
        :type comment_id: str
        :param user_id: user_id identifies the user requesting the comment Must be authenticated and authorized to view the comment (required)
        :type user_id: str
        :param workspace_id: (required)
        :type workspace_id: str
        :param folder_id: (required)
        :type folder_id: str
        :param file_id: (required)
        :type file_id: str
        :param thread_id: (required)
        :type thread_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_comment_serialize(
            comment_id=comment_id,
            user_id=user_id,
            workspace_id=workspace_id,
            folder_id=folder_id,
            file_id=file_id,
            thread_id=thread_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommentResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_comment_without_preload_content(
        self,
        comment_id: Annotated[StrictStr, Field(description="comment_id identifies the comment to retrieve")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the comment Must be authenticated and authorized to view the comment")],
        workspace_id: StrictStr,
        folder_id: StrictStr,
        file_id: StrictStr,
        thread_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a comment

        This endpoint retrieves a specific comment by its ID

        :param comment_id: comment_id identifies the comment to retrieve (required)
        :type comment_id: str
        :param user_id: user_id identifies the user requesting the comment Must be authenticated and authorized to view the comment (required)
        :type user_id: str
        :param workspace_id: (required)
        :type workspace_id: str
        :param folder_id: (required)
        :type folder_id: str
        :param file_id: (required)
        :type file_id: str
        :param thread_id: (required)
        :type thread_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_comment_serialize(
            comment_id=comment_id,
            user_id=user_id,
            workspace_id=workspace_id,
            folder_id=folder_id,
            file_id=file_id,
            thread_id=thread_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommentResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_comment_serialize(
        self,
        comment_id,
        user_id,
        workspace_id,
        folder_id,
        file_id,
        thread_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if comment_id is not None:
            _path_params['commentId'] = comment_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if workspace_id is not None:
            
            _query_params.append(('workspaceId', workspace_id))
            
        if folder_id is not None:
            
            _query_params.append(('folderId', folder_id))
            
        if file_id is not None:
            
            _query_params.append(('fileId', file_id))
            
        if thread_id is not None:
            
            _query_params.append(('threadId', thread_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/workspace-microservice/api/v1/comments/{commentId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_comment_edit(
        self,
        comment_id: StrictStr,
        edit_id: StrictStr,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetCommentEditResponse:
        """Get a comment edit

        This endpoint retrieves a specific comment edit

        :param comment_id: (required)
        :type comment_id: str
        :param edit_id: (required)
        :type edit_id: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_comment_edit_serialize(
            comment_id=comment_id,
            edit_id=edit_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommentEditResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_comment_edit_with_http_info(
        self,
        comment_id: StrictStr,
        edit_id: StrictStr,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetCommentEditResponse]:
        """Get a comment edit

        This endpoint retrieves a specific comment edit

        :param comment_id: (required)
        :type comment_id: str
        :param edit_id: (required)
        :type edit_id: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_comment_edit_serialize(
            comment_id=comment_id,
            edit_id=edit_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommentEditResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_comment_edit_without_preload_content(
        self,
        comment_id: StrictStr,
        edit_id: StrictStr,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a comment edit

        This endpoint retrieves a specific comment edit

        :param comment_id: (required)
        :type comment_id: str
        :param edit_id: (required)
        :type edit_id: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_comment_edit_serialize(
            comment_id=comment_id,
            edit_id=edit_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommentEditResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_comment_edit_serialize(
        self,
        comment_id,
        edit_id,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if comment_id is not None:
            _path_params['commentId'] = comment_id
        if edit_id is not None:
            _path_params['editId'] = edit_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/workspace-microservice/api/v1/comments/{commentId}/edits/{editId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_comment_thread(
        self,
        file_id: Annotated[StrictStr, Field(description="thread_id identifies the comment thread to retrieve")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the thread Must be authenticated and authorized to view the thread")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        page_size: StrictStr,
        page_number: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetCommentThreadResponse:
        """Get a comment thread

        This endpoint retrieves a specific comment thread and its comments

        :param file_id: thread_id identifies the comment thread to retrieve (required)
        :type file_id: str
        :param user_id: user_id identifies the user requesting the thread Must be authenticated and authorized to view the thread (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param page_size: (required)
        :type page_size: str
        :param page_number: (required)
        :type page_number: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_comment_thread_serialize(
            file_id=file_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommentThreadResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_comment_thread_with_http_info(
        self,
        file_id: Annotated[StrictStr, Field(description="thread_id identifies the comment thread to retrieve")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the thread Must be authenticated and authorized to view the thread")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        page_size: StrictStr,
        page_number: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetCommentThreadResponse]:
        """Get a comment thread

        This endpoint retrieves a specific comment thread and its comments

        :param file_id: thread_id identifies the comment thread to retrieve (required)
        :type file_id: str
        :param user_id: user_id identifies the user requesting the thread Must be authenticated and authorized to view the thread (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param page_size: (required)
        :type page_size: str
        :param page_number: (required)
        :type page_number: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_comment_thread_serialize(
            file_id=file_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommentThreadResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_comment_thread_without_preload_content(
        self,
        file_id: Annotated[StrictStr, Field(description="thread_id identifies the comment thread to retrieve")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the thread Must be authenticated and authorized to view the thread")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        page_size: StrictStr,
        page_number: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a comment thread

        This endpoint retrieves a specific comment thread and its comments

        :param file_id: thread_id identifies the comment thread to retrieve (required)
        :type file_id: str
        :param user_id: user_id identifies the user requesting the thread Must be authenticated and authorized to view the thread (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param page_size: (required)
        :type page_size: str
        :param page_number: (required)
        :type page_number: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_comment_thread_serialize(
            file_id=file_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetCommentThreadResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_comment_thread_serialize(
        self,
        file_id,
        user_id,
        org_id,
        tenant_id,
        page_size,
        page_number,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if file_id is not None:
            _path_params['fileId'] = file_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/workspace-microservice/api/v1/comment-threads/file/{fileId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_document_snapshot(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file")],
        snapshot_id: Annotated[StrictStr, Field(description="snapshot_id identifies the specific snapshot")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the snapshot")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetDocumentSnapshotResponse:
        """Get a document snapshot

        This endpoint retrieves a specific document snapshot

        :param file_id: file_id identifies the file (required)
        :type file_id: str
        :param snapshot_id: snapshot_id identifies the specific snapshot (required)
        :type snapshot_id: str
        :param user_id: user_id identifies the user requesting the snapshot (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_document_snapshot_serialize(
            file_id=file_id,
            snapshot_id=snapshot_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetDocumentSnapshotResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_document_snapshot_with_http_info(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file")],
        snapshot_id: Annotated[StrictStr, Field(description="snapshot_id identifies the specific snapshot")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the snapshot")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetDocumentSnapshotResponse]:
        """Get a document snapshot

        This endpoint retrieves a specific document snapshot

        :param file_id: file_id identifies the file (required)
        :type file_id: str
        :param snapshot_id: snapshot_id identifies the specific snapshot (required)
        :type snapshot_id: str
        :param user_id: user_id identifies the user requesting the snapshot (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_document_snapshot_serialize(
            file_id=file_id,
            snapshot_id=snapshot_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetDocumentSnapshotResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_document_snapshot_without_preload_content(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file")],
        snapshot_id: Annotated[StrictStr, Field(description="snapshot_id identifies the specific snapshot")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the snapshot")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a document snapshot

        This endpoint retrieves a specific document snapshot

        :param file_id: file_id identifies the file (required)
        :type file_id: str
        :param snapshot_id: snapshot_id identifies the specific snapshot (required)
        :type snapshot_id: str
        :param user_id: user_id identifies the user requesting the snapshot (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_document_snapshot_serialize(
            file_id=file_id,
            snapshot_id=snapshot_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetDocumentSnapshotResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_document_snapshot_serialize(
        self,
        file_id,
        snapshot_id,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if file_id is not None:
            _path_params['fileId'] = file_id
        if snapshot_id is not None:
            _path_params['snapshotId'] = snapshot_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/workspace-microservice/api/v1/files/{fileId}/snapshots/{snapshotId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_file_version(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file")],
        version_id: Annotated[StrictStr, Field(description="version_id identifies the specific version to retrieve")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the file version")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetFileVersionResponse:
        """Get file version

        This endpoint retrieves a specific version of a file

        :param file_id: file_id identifies the file (required)
        :type file_id: str
        :param version_id: version_id identifies the specific version to retrieve (required)
        :type version_id: str
        :param user_id: user_id identifies the user requesting the file version (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_file_version_serialize(
            file_id=file_id,
            version_id=version_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetFileVersionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_file_version_with_http_info(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file")],
        version_id: Annotated[StrictStr, Field(description="version_id identifies the specific version to retrieve")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the file version")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetFileVersionResponse]:
        """Get file version

        This endpoint retrieves a specific version of a file

        :param file_id: file_id identifies the file (required)
        :type file_id: str
        :param version_id: version_id identifies the specific version to retrieve (required)
        :type version_id: str
        :param user_id: user_id identifies the user requesting the file version (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_file_version_serialize(
            file_id=file_id,
            version_id=version_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetFileVersionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_file_version_without_preload_content(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file")],
        version_id: Annotated[StrictStr, Field(description="version_id identifies the specific version to retrieve")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the file version")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get file version

        This endpoint retrieves a specific version of a file

        :param file_id: file_id identifies the file (required)
        :type file_id: str
        :param version_id: version_id identifies the specific version to retrieve (required)
        :type version_id: str
        :param user_id: user_id identifies the user requesting the file version (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_file_version_serialize(
            file_id=file_id,
            version_id=version_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetFileVersionResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_file_version_serialize(
        self,
        file_id,
        version_id,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if file_id is not None:
            _path_params['fileId'] = file_id
        if version_id is not None:
            _path_params['versionId'] = version_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/workspace-microservice/api/v1/files/{fileId}/versions/{versionId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_single_comment_thread(
        self,
        thread_id: Annotated[StrictStr, Field(description="thread_id identifies the specific comment thread to retrieve")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the thread Must be authenticated and authorized to view the thread")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetSingleCommentThreadResponse:
        """Get a single comment thread

        This endpoint retrieves a single comment thread by its ID

        :param thread_id: thread_id identifies the specific comment thread to retrieve (required)
        :type thread_id: str
        :param user_id: user_id identifies the user requesting the thread Must be authenticated and authorized to view the thread (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_single_comment_thread_serialize(
            thread_id=thread_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetSingleCommentThreadResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_single_comment_thread_with_http_info(
        self,
        thread_id: Annotated[StrictStr, Field(description="thread_id identifies the specific comment thread to retrieve")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the thread Must be authenticated and authorized to view the thread")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetSingleCommentThreadResponse]:
        """Get a single comment thread

        This endpoint retrieves a single comment thread by its ID

        :param thread_id: thread_id identifies the specific comment thread to retrieve (required)
        :type thread_id: str
        :param user_id: user_id identifies the user requesting the thread Must be authenticated and authorized to view the thread (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_single_comment_thread_serialize(
            thread_id=thread_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetSingleCommentThreadResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_single_comment_thread_without_preload_content(
        self,
        thread_id: Annotated[StrictStr, Field(description="thread_id identifies the specific comment thread to retrieve")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the thread Must be authenticated and authorized to view the thread")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a single comment thread

        This endpoint retrieves a single comment thread by its ID

        :param thread_id: thread_id identifies the specific comment thread to retrieve (required)
        :type thread_id: str
        :param user_id: user_id identifies the user requesting the thread Must be authenticated and authorized to view the thread (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_single_comment_thread_serialize(
            thread_id=thread_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetSingleCommentThreadResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_single_comment_thread_serialize(
        self,
        thread_id,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if thread_id is not None:
            _path_params['threadId'] = thread_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/workspace-microservice/api/v1/comment-threads/{threadId}/single',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_workspace_compliance(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the compliance settings")],
        workspace_compliance_id: Annotated[StrictStr, Field(description="The workspace compliance to get")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetWorkspaceComplianceResponse:
        """Get workspace compliance settings

        This endpoint retrieves compliance settings for a workspace

        :param workspace_id: workspace_id identifies the workspace (required)
        :type workspace_id: str
        :param user_id: user_id identifies the user requesting the compliance settings (required)
        :type user_id: str
        :param workspace_compliance_id: The workspace compliance to get (required)
        :type workspace_compliance_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_workspace_compliance_serialize(
            workspace_id=workspace_id,
            user_id=user_id,
            workspace_compliance_id=workspace_compliance_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetWorkspaceComplianceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_workspace_compliance_with_http_info(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the compliance settings")],
        workspace_compliance_id: Annotated[StrictStr, Field(description="The workspace compliance to get")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetWorkspaceComplianceResponse]:
        """Get workspace compliance settings

        This endpoint retrieves compliance settings for a workspace

        :param workspace_id: workspace_id identifies the workspace (required)
        :type workspace_id: str
        :param user_id: user_id identifies the user requesting the compliance settings (required)
        :type user_id: str
        :param workspace_compliance_id: The workspace compliance to get (required)
        :type workspace_compliance_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_workspace_compliance_serialize(
            workspace_id=workspace_id,
            user_id=user_id,
            workspace_compliance_id=workspace_compliance_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetWorkspaceComplianceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_workspace_compliance_without_preload_content(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the compliance settings")],
        workspace_compliance_id: Annotated[StrictStr, Field(description="The workspace compliance to get")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get workspace compliance settings

        This endpoint retrieves compliance settings for a workspace

        :param workspace_id: workspace_id identifies the workspace (required)
        :type workspace_id: str
        :param user_id: user_id identifies the user requesting the compliance settings (required)
        :type user_id: str
        :param workspace_compliance_id: The workspace compliance to get (required)
        :type workspace_compliance_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_workspace_compliance_serialize(
            workspace_id=workspace_id,
            user_id=user_id,
            workspace_compliance_id=workspace_compliance_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetWorkspaceComplianceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_workspace_compliance_serialize(
        self,
        workspace_id,
        user_id,
        workspace_compliance_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace_id is not None:
            _path_params['workspaceId'] = workspace_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if workspace_compliance_id is not None:
            
            _query_params.append(('workspaceComplianceId', workspace_compliance_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/workspace-microservice/api/v1/workspaces/{workspaceId}/compliance',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_workspace_share(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace")],
        share_id: Annotated[StrictStr, Field(description="share_id identifies the specific share to retrieve")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the share")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetWorkspaceShareResponse:
        """Get a workspace share

        This endpoint retrieves a specific workspace share

        :param workspace_id: workspace_id identifies the workspace (required)
        :type workspace_id: str
        :param share_id: share_id identifies the specific share to retrieve (required)
        :type share_id: str
        :param user_id: user_id identifies the user requesting the share (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_workspace_share_serialize(
            workspace_id=workspace_id,
            share_id=share_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetWorkspaceShareResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_workspace_share_with_http_info(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace")],
        share_id: Annotated[StrictStr, Field(description="share_id identifies the specific share to retrieve")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the share")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetWorkspaceShareResponse]:
        """Get a workspace share

        This endpoint retrieves a specific workspace share

        :param workspace_id: workspace_id identifies the workspace (required)
        :type workspace_id: str
        :param share_id: share_id identifies the specific share to retrieve (required)
        :type share_id: str
        :param user_id: user_id identifies the user requesting the share (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_workspace_share_serialize(
            workspace_id=workspace_id,
            share_id=share_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetWorkspaceShareResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_workspace_share_without_preload_content(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace")],
        share_id: Annotated[StrictStr, Field(description="share_id identifies the specific share to retrieve")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the share")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a workspace share

        This endpoint retrieves a specific workspace share

        :param workspace_id: workspace_id identifies the workspace (required)
        :type workspace_id: str
        :param share_id: share_id identifies the specific share to retrieve (required)
        :type share_id: str
        :param user_id: user_id identifies the user requesting the share (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_workspace_share_serialize(
            workspace_id=workspace_id,
            share_id=share_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetWorkspaceShareResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_workspace_share_serialize(
        self,
        workspace_id,
        share_id,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace_id is not None:
            _path_params['workspaceId'] = workspace_id
        if share_id is not None:
            _path_params['shareId'] = share_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/workspace-microservice/api/v1/workspaces/{workspaceId}/shares/{shareId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_accounts(
        self,
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the account list Must be authenticated and authorized to view accounts")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        email_filter: Annotated[Optional[StrictStr], Field(description="Filter by email pattern")] = None,
        created_after: Annotated[Optional[datetime], Field(description="Filter by creation date range")] = None,
        created_before: Optional[datetime] = None,
        include_deleted: Annotated[Optional[StrictBool], Field(description="Include deleted accounts in results")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Pagination parameters")] = None,
        page_number: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListAccountsResponse:
        """List accounts

        This endpoint retrieves a paginated list of accounts with optional filtering

        :param user_id: user_id identifies the user requesting the account list Must be authenticated and authorized to view accounts (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param email_filter: Filter by email pattern
        :type email_filter: str
        :param created_after: Filter by creation date range
        :type created_after: datetime
        :param created_before:
        :type created_before: datetime
        :param include_deleted: Include deleted accounts in results
        :type include_deleted: bool
        :param page_size: Pagination parameters
        :type page_size: int
        :param page_number:
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_accounts_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            email_filter=email_filter,
            created_after=created_after,
            created_before=created_before,
            include_deleted=include_deleted,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListAccountsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_accounts_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the account list Must be authenticated and authorized to view accounts")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        email_filter: Annotated[Optional[StrictStr], Field(description="Filter by email pattern")] = None,
        created_after: Annotated[Optional[datetime], Field(description="Filter by creation date range")] = None,
        created_before: Optional[datetime] = None,
        include_deleted: Annotated[Optional[StrictBool], Field(description="Include deleted accounts in results")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Pagination parameters")] = None,
        page_number: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListAccountsResponse]:
        """List accounts

        This endpoint retrieves a paginated list of accounts with optional filtering

        :param user_id: user_id identifies the user requesting the account list Must be authenticated and authorized to view accounts (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param email_filter: Filter by email pattern
        :type email_filter: str
        :param created_after: Filter by creation date range
        :type created_after: datetime
        :param created_before:
        :type created_before: datetime
        :param include_deleted: Include deleted accounts in results
        :type include_deleted: bool
        :param page_size: Pagination parameters
        :type page_size: int
        :param page_number:
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_accounts_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            email_filter=email_filter,
            created_after=created_after,
            created_before=created_before,
            include_deleted=include_deleted,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListAccountsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_accounts_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the account list Must be authenticated and authorized to view accounts")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        email_filter: Annotated[Optional[StrictStr], Field(description="Filter by email pattern")] = None,
        created_after: Annotated[Optional[datetime], Field(description="Filter by creation date range")] = None,
        created_before: Optional[datetime] = None,
        include_deleted: Annotated[Optional[StrictBool], Field(description="Include deleted accounts in results")] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Pagination parameters")] = None,
        page_number: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List accounts

        This endpoint retrieves a paginated list of accounts with optional filtering

        :param user_id: user_id identifies the user requesting the account list Must be authenticated and authorized to view accounts (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param email_filter: Filter by email pattern
        :type email_filter: str
        :param created_after: Filter by creation date range
        :type created_after: datetime
        :param created_before:
        :type created_before: datetime
        :param include_deleted: Include deleted accounts in results
        :type include_deleted: bool
        :param page_size: Pagination parameters
        :type page_size: int
        :param page_number:
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_accounts_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            email_filter=email_filter,
            created_after=created_after,
            created_before=created_before,
            include_deleted=include_deleted,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListAccountsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_accounts_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        email_filter,
        created_after,
        created_before,
        include_deleted,
        page_size,
        page_number,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if email_filter is not None:
            
            _query_params.append(('emailFilter', email_filter))
            
        if created_after is not None:
            if isinstance(created_after, datetime):
                _query_params.append(
                    (
                        'createdAfter',
                        created_after.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('createdAfter', created_after))
            
        if created_before is not None:
            if isinstance(created_before, datetime):
                _query_params.append(
                    (
                        'createdBefore',
                        created_before.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('createdBefore', created_before))
            
        if include_deleted is not None:
            
            _query_params.append(('includeDeleted', include_deleted))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/workspace-microservice/api/v1/accounts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_comment_edits(
        self,
        comment_id: StrictStr,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        page_size: Optional[StrictInt] = None,
        page_number: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListCommentEditsResponse:
        """List comment edits

        This endpoint retrieves a list of edits for a comment

        :param comment_id: (required)
        :type comment_id: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param page_size:
        :type page_size: int
        :param page_number:
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_comment_edits_serialize(
            comment_id=comment_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListCommentEditsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_comment_edits_with_http_info(
        self,
        comment_id: StrictStr,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        page_size: Optional[StrictInt] = None,
        page_number: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListCommentEditsResponse]:
        """List comment edits

        This endpoint retrieves a list of edits for a comment

        :param comment_id: (required)
        :type comment_id: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param page_size:
        :type page_size: int
        :param page_number:
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_comment_edits_serialize(
            comment_id=comment_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListCommentEditsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_comment_edits_without_preload_content(
        self,
        comment_id: StrictStr,
        user_id: StrictStr,
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        page_size: Optional[StrictInt] = None,
        page_number: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List comment edits

        This endpoint retrieves a list of edits for a comment

        :param comment_id: (required)
        :type comment_id: str
        :param user_id: (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param page_size:
        :type page_size: int
        :param page_number:
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_comment_edits_serialize(
            comment_id=comment_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListCommentEditsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_comment_edits_serialize(
        self,
        comment_id,
        user_id,
        org_id,
        tenant_id,
        page_size,
        page_number,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if comment_id is not None:
            _path_params['commentId'] = comment_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/workspace-microservice/api/v1/comments/{commentId}/edits',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_comments(
        self,
        user_id: StrictStr,
        workspace_id: StrictStr,
        folder_id: StrictStr,
        file_id: StrictStr,
        thread_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListCommentsResponse:
        """List comments

        This endpoint retrieves a paginated list of comments with optional filtering

        :param user_id: (required)
        :type user_id: str
        :param workspace_id: (required)
        :type workspace_id: str
        :param folder_id: (required)
        :type folder_id: str
        :param file_id: (required)
        :type file_id: str
        :param thread_id: (required)
        :type thread_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_comments_serialize(
            user_id=user_id,
            workspace_id=workspace_id,
            folder_id=folder_id,
            file_id=file_id,
            thread_id=thread_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListCommentsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_comments_with_http_info(
        self,
        user_id: StrictStr,
        workspace_id: StrictStr,
        folder_id: StrictStr,
        file_id: StrictStr,
        thread_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListCommentsResponse]:
        """List comments

        This endpoint retrieves a paginated list of comments with optional filtering

        :param user_id: (required)
        :type user_id: str
        :param workspace_id: (required)
        :type workspace_id: str
        :param folder_id: (required)
        :type folder_id: str
        :param file_id: (required)
        :type file_id: str
        :param thread_id: (required)
        :type thread_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_comments_serialize(
            user_id=user_id,
            workspace_id=workspace_id,
            folder_id=folder_id,
            file_id=file_id,
            thread_id=thread_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListCommentsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_comments_without_preload_content(
        self,
        user_id: StrictStr,
        workspace_id: StrictStr,
        folder_id: StrictStr,
        file_id: StrictStr,
        thread_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List comments

        This endpoint retrieves a paginated list of comments with optional filtering

        :param user_id: (required)
        :type user_id: str
        :param workspace_id: (required)
        :type workspace_id: str
        :param folder_id: (required)
        :type folder_id: str
        :param file_id: (required)
        :type file_id: str
        :param thread_id: (required)
        :type thread_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_comments_serialize(
            user_id=user_id,
            workspace_id=workspace_id,
            folder_id=folder_id,
            file_id=file_id,
            thread_id=thread_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListCommentsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_comments_serialize(
        self,
        user_id,
        workspace_id,
        folder_id,
        file_id,
        thread_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if workspace_id is not None:
            
            _query_params.append(('workspaceId', workspace_id))
            
        if folder_id is not None:
            
            _query_params.append(('folderId', folder_id))
            
        if file_id is not None:
            
            _query_params.append(('fileId', file_id))
            
        if thread_id is not None:
            
            _query_params.append(('threadId', thread_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/workspace-microservice/api/v1/comments',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_document_snapshots(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the snapshots")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        created_after: Annotated[Optional[datetime], Field(description="Filter options")] = None,
        created_before: Optional[datetime] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Pagination")] = None,
        page_number: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListDocumentSnapshotsResponse:
        """List document snapshots

        This endpoint retrieves a list of document snapshots for a file

        :param file_id: file_id identifies the file (required)
        :type file_id: str
        :param user_id: user_id identifies the user requesting the snapshots (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param created_after: Filter options
        :type created_after: datetime
        :param created_before:
        :type created_before: datetime
        :param page_size: Pagination
        :type page_size: int
        :param page_number:
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_document_snapshots_serialize(
            file_id=file_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            created_after=created_after,
            created_before=created_before,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListDocumentSnapshotsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_document_snapshots_with_http_info(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the snapshots")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        created_after: Annotated[Optional[datetime], Field(description="Filter options")] = None,
        created_before: Optional[datetime] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Pagination")] = None,
        page_number: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListDocumentSnapshotsResponse]:
        """List document snapshots

        This endpoint retrieves a list of document snapshots for a file

        :param file_id: file_id identifies the file (required)
        :type file_id: str
        :param user_id: user_id identifies the user requesting the snapshots (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param created_after: Filter options
        :type created_after: datetime
        :param created_before:
        :type created_before: datetime
        :param page_size: Pagination
        :type page_size: int
        :param page_number:
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_document_snapshots_serialize(
            file_id=file_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            created_after=created_after,
            created_before=created_before,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListDocumentSnapshotsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_document_snapshots_without_preload_content(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the snapshots")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        created_after: Annotated[Optional[datetime], Field(description="Filter options")] = None,
        created_before: Optional[datetime] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Pagination")] = None,
        page_number: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List document snapshots

        This endpoint retrieves a list of document snapshots for a file

        :param file_id: file_id identifies the file (required)
        :type file_id: str
        :param user_id: user_id identifies the user requesting the snapshots (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param created_after: Filter options
        :type created_after: datetime
        :param created_before:
        :type created_before: datetime
        :param page_size: Pagination
        :type page_size: int
        :param page_number:
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_document_snapshots_serialize(
            file_id=file_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            created_after=created_after,
            created_before=created_before,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListDocumentSnapshotsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_document_snapshots_serialize(
        self,
        file_id,
        user_id,
        org_id,
        tenant_id,
        created_after,
        created_before,
        page_size,
        page_number,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if file_id is not None:
            _path_params['fileId'] = file_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if created_after is not None:
            if isinstance(created_after, datetime):
                _query_params.append(
                    (
                        'createdAfter',
                        created_after.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('createdAfter', created_after))
            
        if created_before is not None:
            if isinstance(created_before, datetime):
                _query_params.append(
                    (
                        'createdBefore',
                        created_before.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('createdBefore', created_before))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/workspace-microservice/api/v1/files/{fileId}/snapshots',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_file_versions(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the file versions")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        created_after: Annotated[Optional[datetime], Field(description="Filter options")] = None,
        created_before: Optional[datetime] = None,
        modified_by: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Pagination")] = None,
        page_number: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListFileVersionsResponse:
        """List file versions

        This endpoint retrieves all versions of a specific file

        :param file_id: file_id identifies the file (required)
        :type file_id: str
        :param user_id: user_id identifies the user requesting the file versions (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param created_after: Filter options
        :type created_after: datetime
        :param created_before:
        :type created_before: datetime
        :param modified_by:
        :type modified_by: str
        :param page_size: Pagination
        :type page_size: int
        :param page_number:
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_file_versions_serialize(
            file_id=file_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            created_after=created_after,
            created_before=created_before,
            modified_by=modified_by,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListFileVersionsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_file_versions_with_http_info(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the file versions")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        created_after: Annotated[Optional[datetime], Field(description="Filter options")] = None,
        created_before: Optional[datetime] = None,
        modified_by: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Pagination")] = None,
        page_number: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListFileVersionsResponse]:
        """List file versions

        This endpoint retrieves all versions of a specific file

        :param file_id: file_id identifies the file (required)
        :type file_id: str
        :param user_id: user_id identifies the user requesting the file versions (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param created_after: Filter options
        :type created_after: datetime
        :param created_before:
        :type created_before: datetime
        :param modified_by:
        :type modified_by: str
        :param page_size: Pagination
        :type page_size: int
        :param page_number:
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_file_versions_serialize(
            file_id=file_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            created_after=created_after,
            created_before=created_before,
            modified_by=modified_by,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListFileVersionsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_file_versions_without_preload_content(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the file versions")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        created_after: Annotated[Optional[datetime], Field(description="Filter options")] = None,
        created_before: Optional[datetime] = None,
        modified_by: Optional[StrictStr] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Pagination")] = None,
        page_number: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List file versions

        This endpoint retrieves all versions of a specific file

        :param file_id: file_id identifies the file (required)
        :type file_id: str
        :param user_id: user_id identifies the user requesting the file versions (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param created_after: Filter options
        :type created_after: datetime
        :param created_before:
        :type created_before: datetime
        :param modified_by:
        :type modified_by: str
        :param page_size: Pagination
        :type page_size: int
        :param page_number:
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_file_versions_serialize(
            file_id=file_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            created_after=created_after,
            created_before=created_before,
            modified_by=modified_by,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListFileVersionsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_file_versions_serialize(
        self,
        file_id,
        user_id,
        org_id,
        tenant_id,
        created_after,
        created_before,
        modified_by,
        page_size,
        page_number,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if file_id is not None:
            _path_params['fileId'] = file_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if created_after is not None:
            if isinstance(created_after, datetime):
                _query_params.append(
                    (
                        'createdAfter',
                        created_after.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('createdAfter', created_after))
            
        if created_before is not None:
            if isinstance(created_before, datetime):
                _query_params.append(
                    (
                        'createdBefore',
                        created_before.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('createdBefore', created_before))
            
        if modified_by is not None:
            
            _query_params.append(('modifiedBy', modified_by))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/workspace-microservice/api/v1/files/{fileId}/versions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_files(
        self,
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the file list")],
        workspace_id: Annotated[StrictStr, Field(description="Required workspace_id to filter files by workspace")],
        folder_id: Annotated[StrictStr, Field(description="Required folder_id to filter files by folder")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        file_types: Annotated[Optional[List[StrictStr]], Field(description="Filter options  Filter by file type")] = None,
        name_pattern: Annotated[Optional[StrictStr], Field(description="Filter by name pattern")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="Filter by tags")] = None,
        include_deleted: Annotated[Optional[StrictBool], Field(description="Include soft-deleted files")] = None,
        created_after: Annotated[Optional[datetime], Field(description="Date range filters")] = None,
        created_before: Optional[datetime] = None,
        modified_after: Optional[datetime] = None,
        modified_before: Optional[datetime] = None,
        min_size: Annotated[Optional[StrictStr], Field(description="Size range filters (in bytes)")] = None,
        max_size: Optional[StrictStr] = None,
        sort_by: Annotated[Optional[StrictStr], Field(description=" - SORT_FIELD_UNSPECIFIED: Default value, no sort specified  - SORT_FIELD_NAME: Sort by item name (alphabetical)  - SORT_FIELD_CREATED_AT: Sort by creation timestamp  - SORT_FIELD_UPDATED_AT: Sort by last modification time  - SORT_FIELD_SIZE: Sort by file size (bytes)")] = None,
        sort_descending: Optional[StrictBool] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Pagination")] = None,
        page_number: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListFilesResponse:
        """List files

        This endpoint retrieves a paginated list of files with optional filtering

        :param user_id: user_id identifies the user requesting the file list (required)
        :type user_id: str
        :param workspace_id: Required workspace_id to filter files by workspace (required)
        :type workspace_id: str
        :param folder_id: Required folder_id to filter files by folder (required)
        :type folder_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param file_types: Filter options  Filter by file type
        :type file_types: List[str]
        :param name_pattern: Filter by name pattern
        :type name_pattern: str
        :param tags: Filter by tags
        :type tags: List[str]
        :param include_deleted: Include soft-deleted files
        :type include_deleted: bool
        :param created_after: Date range filters
        :type created_after: datetime
        :param created_before:
        :type created_before: datetime
        :param modified_after:
        :type modified_after: datetime
        :param modified_before:
        :type modified_before: datetime
        :param min_size: Size range filters (in bytes)
        :type min_size: str
        :param max_size:
        :type max_size: str
        :param sort_by:  - SORT_FIELD_UNSPECIFIED: Default value, no sort specified  - SORT_FIELD_NAME: Sort by item name (alphabetical)  - SORT_FIELD_CREATED_AT: Sort by creation timestamp  - SORT_FIELD_UPDATED_AT: Sort by last modification time  - SORT_FIELD_SIZE: Sort by file size (bytes)
        :type sort_by: str
        :param sort_descending:
        :type sort_descending: bool
        :param page_size: Pagination
        :type page_size: int
        :param page_number:
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_files_serialize(
            user_id=user_id,
            workspace_id=workspace_id,
            folder_id=folder_id,
            org_id=org_id,
            tenant_id=tenant_id,
            file_types=file_types,
            name_pattern=name_pattern,
            tags=tags,
            include_deleted=include_deleted,
            created_after=created_after,
            created_before=created_before,
            modified_after=modified_after,
            modified_before=modified_before,
            min_size=min_size,
            max_size=max_size,
            sort_by=sort_by,
            sort_descending=sort_descending,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListFilesResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_files_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the file list")],
        workspace_id: Annotated[StrictStr, Field(description="Required workspace_id to filter files by workspace")],
        folder_id: Annotated[StrictStr, Field(description="Required folder_id to filter files by folder")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        file_types: Annotated[Optional[List[StrictStr]], Field(description="Filter options  Filter by file type")] = None,
        name_pattern: Annotated[Optional[StrictStr], Field(description="Filter by name pattern")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="Filter by tags")] = None,
        include_deleted: Annotated[Optional[StrictBool], Field(description="Include soft-deleted files")] = None,
        created_after: Annotated[Optional[datetime], Field(description="Date range filters")] = None,
        created_before: Optional[datetime] = None,
        modified_after: Optional[datetime] = None,
        modified_before: Optional[datetime] = None,
        min_size: Annotated[Optional[StrictStr], Field(description="Size range filters (in bytes)")] = None,
        max_size: Optional[StrictStr] = None,
        sort_by: Annotated[Optional[StrictStr], Field(description=" - SORT_FIELD_UNSPECIFIED: Default value, no sort specified  - SORT_FIELD_NAME: Sort by item name (alphabetical)  - SORT_FIELD_CREATED_AT: Sort by creation timestamp  - SORT_FIELD_UPDATED_AT: Sort by last modification time  - SORT_FIELD_SIZE: Sort by file size (bytes)")] = None,
        sort_descending: Optional[StrictBool] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Pagination")] = None,
        page_number: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListFilesResponse]:
        """List files

        This endpoint retrieves a paginated list of files with optional filtering

        :param user_id: user_id identifies the user requesting the file list (required)
        :type user_id: str
        :param workspace_id: Required workspace_id to filter files by workspace (required)
        :type workspace_id: str
        :param folder_id: Required folder_id to filter files by folder (required)
        :type folder_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param file_types: Filter options  Filter by file type
        :type file_types: List[str]
        :param name_pattern: Filter by name pattern
        :type name_pattern: str
        :param tags: Filter by tags
        :type tags: List[str]
        :param include_deleted: Include soft-deleted files
        :type include_deleted: bool
        :param created_after: Date range filters
        :type created_after: datetime
        :param created_before:
        :type created_before: datetime
        :param modified_after:
        :type modified_after: datetime
        :param modified_before:
        :type modified_before: datetime
        :param min_size: Size range filters (in bytes)
        :type min_size: str
        :param max_size:
        :type max_size: str
        :param sort_by:  - SORT_FIELD_UNSPECIFIED: Default value, no sort specified  - SORT_FIELD_NAME: Sort by item name (alphabetical)  - SORT_FIELD_CREATED_AT: Sort by creation timestamp  - SORT_FIELD_UPDATED_AT: Sort by last modification time  - SORT_FIELD_SIZE: Sort by file size (bytes)
        :type sort_by: str
        :param sort_descending:
        :type sort_descending: bool
        :param page_size: Pagination
        :type page_size: int
        :param page_number:
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_files_serialize(
            user_id=user_id,
            workspace_id=workspace_id,
            folder_id=folder_id,
            org_id=org_id,
            tenant_id=tenant_id,
            file_types=file_types,
            name_pattern=name_pattern,
            tags=tags,
            include_deleted=include_deleted,
            created_after=created_after,
            created_before=created_before,
            modified_after=modified_after,
            modified_before=modified_before,
            min_size=min_size,
            max_size=max_size,
            sort_by=sort_by,
            sort_descending=sort_descending,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListFilesResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_files_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the file list")],
        workspace_id: Annotated[StrictStr, Field(description="Required workspace_id to filter files by workspace")],
        folder_id: Annotated[StrictStr, Field(description="Required folder_id to filter files by folder")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        file_types: Annotated[Optional[List[StrictStr]], Field(description="Filter options  Filter by file type")] = None,
        name_pattern: Annotated[Optional[StrictStr], Field(description="Filter by name pattern")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="Filter by tags")] = None,
        include_deleted: Annotated[Optional[StrictBool], Field(description="Include soft-deleted files")] = None,
        created_after: Annotated[Optional[datetime], Field(description="Date range filters")] = None,
        created_before: Optional[datetime] = None,
        modified_after: Optional[datetime] = None,
        modified_before: Optional[datetime] = None,
        min_size: Annotated[Optional[StrictStr], Field(description="Size range filters (in bytes)")] = None,
        max_size: Optional[StrictStr] = None,
        sort_by: Annotated[Optional[StrictStr], Field(description=" - SORT_FIELD_UNSPECIFIED: Default value, no sort specified  - SORT_FIELD_NAME: Sort by item name (alphabetical)  - SORT_FIELD_CREATED_AT: Sort by creation timestamp  - SORT_FIELD_UPDATED_AT: Sort by last modification time  - SORT_FIELD_SIZE: Sort by file size (bytes)")] = None,
        sort_descending: Optional[StrictBool] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Pagination")] = None,
        page_number: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List files

        This endpoint retrieves a paginated list of files with optional filtering

        :param user_id: user_id identifies the user requesting the file list (required)
        :type user_id: str
        :param workspace_id: Required workspace_id to filter files by workspace (required)
        :type workspace_id: str
        :param folder_id: Required folder_id to filter files by folder (required)
        :type folder_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param file_types: Filter options  Filter by file type
        :type file_types: List[str]
        :param name_pattern: Filter by name pattern
        :type name_pattern: str
        :param tags: Filter by tags
        :type tags: List[str]
        :param include_deleted: Include soft-deleted files
        :type include_deleted: bool
        :param created_after: Date range filters
        :type created_after: datetime
        :param created_before:
        :type created_before: datetime
        :param modified_after:
        :type modified_after: datetime
        :param modified_before:
        :type modified_before: datetime
        :param min_size: Size range filters (in bytes)
        :type min_size: str
        :param max_size:
        :type max_size: str
        :param sort_by:  - SORT_FIELD_UNSPECIFIED: Default value, no sort specified  - SORT_FIELD_NAME: Sort by item name (alphabetical)  - SORT_FIELD_CREATED_AT: Sort by creation timestamp  - SORT_FIELD_UPDATED_AT: Sort by last modification time  - SORT_FIELD_SIZE: Sort by file size (bytes)
        :type sort_by: str
        :param sort_descending:
        :type sort_descending: bool
        :param page_size: Pagination
        :type page_size: int
        :param page_number:
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_files_serialize(
            user_id=user_id,
            workspace_id=workspace_id,
            folder_id=folder_id,
            org_id=org_id,
            tenant_id=tenant_id,
            file_types=file_types,
            name_pattern=name_pattern,
            tags=tags,
            include_deleted=include_deleted,
            created_after=created_after,
            created_before=created_before,
            modified_after=modified_after,
            modified_before=modified_before,
            min_size=min_size,
            max_size=max_size,
            sort_by=sort_by,
            sort_descending=sort_descending,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListFilesResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_files_serialize(
        self,
        user_id,
        workspace_id,
        folder_id,
        org_id,
        tenant_id,
        file_types,
        name_pattern,
        tags,
        include_deleted,
        created_after,
        created_before,
        modified_after,
        modified_before,
        min_size,
        max_size,
        sort_by,
        sort_descending,
        page_size,
        page_number,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'fileTypes': 'multi',
            'tags': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if workspace_id is not None:
            
            _query_params.append(('workspaceId', workspace_id))
            
        if folder_id is not None:
            
            _query_params.append(('folderId', folder_id))
            
        if file_types is not None:
            
            _query_params.append(('fileTypes', file_types))
            
        if name_pattern is not None:
            
            _query_params.append(('namePattern', name_pattern))
            
        if tags is not None:
            
            _query_params.append(('tags', tags))
            
        if include_deleted is not None:
            
            _query_params.append(('includeDeleted', include_deleted))
            
        if created_after is not None:
            if isinstance(created_after, datetime):
                _query_params.append(
                    (
                        'createdAfter',
                        created_after.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('createdAfter', created_after))
            
        if created_before is not None:
            if isinstance(created_before, datetime):
                _query_params.append(
                    (
                        'createdBefore',
                        created_before.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('createdBefore', created_before))
            
        if modified_after is not None:
            if isinstance(modified_after, datetime):
                _query_params.append(
                    (
                        'modifiedAfter',
                        modified_after.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('modifiedAfter', modified_after))
            
        if modified_before is not None:
            if isinstance(modified_before, datetime):
                _query_params.append(
                    (
                        'modifiedBefore',
                        modified_before.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('modifiedBefore', modified_before))
            
        if min_size is not None:
            
            _query_params.append(('minSize', min_size))
            
        if max_size is not None:
            
            _query_params.append(('maxSize', max_size))
            
        if sort_by is not None:
            
            _query_params.append(('sortBy', sort_by))
            
        if sort_descending is not None:
            
            _query_params.append(('sortDescending', sort_descending))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/workspace-microservice/api/v1/files',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_folder(
        self,
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user making the folder listing request Must be authenticated and authorized to access the workspace")],
        folder_id: Annotated[StrictStr, Field(description="folder_id optionally specifies a parent folder to list contents from If not provided, lists from the workspace root")],
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the specific workspace context Required to scope the folder listing to the correct workspace")],
        org_id: Annotated[StrictStr, Field(description="org_id identifies the organization context for the folder listing Must be a valid organization identifier that the user belongs to")],
        tenant_id: Annotated[StrictStr, Field(description="tenant_id identifies the tenant context for the folder listing Required for multi-tenant deployments to maintain proper data isolation")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListFolderResponse:
        """List folders

        This endpoint lists all folders

        :param user_id: user_id identifies the user making the folder listing request Must be authenticated and authorized to access the workspace (required)
        :type user_id: str
        :param folder_id: folder_id optionally specifies a parent folder to list contents from If not provided, lists from the workspace root (required)
        :type folder_id: str
        :param workspace_id: workspace_id identifies the specific workspace context Required to scope the folder listing to the correct workspace (required)
        :type workspace_id: str
        :param org_id: org_id identifies the organization context for the folder listing Must be a valid organization identifier that the user belongs to (required)
        :type org_id: str
        :param tenant_id: tenant_id identifies the tenant context for the folder listing Required for multi-tenant deployments to maintain proper data isolation (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_folder_serialize(
            user_id=user_id,
            folder_id=folder_id,
            workspace_id=workspace_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListFolderResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_folder_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user making the folder listing request Must be authenticated and authorized to access the workspace")],
        folder_id: Annotated[StrictStr, Field(description="folder_id optionally specifies a parent folder to list contents from If not provided, lists from the workspace root")],
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the specific workspace context Required to scope the folder listing to the correct workspace")],
        org_id: Annotated[StrictStr, Field(description="org_id identifies the organization context for the folder listing Must be a valid organization identifier that the user belongs to")],
        tenant_id: Annotated[StrictStr, Field(description="tenant_id identifies the tenant context for the folder listing Required for multi-tenant deployments to maintain proper data isolation")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListFolderResponse]:
        """List folders

        This endpoint lists all folders

        :param user_id: user_id identifies the user making the folder listing request Must be authenticated and authorized to access the workspace (required)
        :type user_id: str
        :param folder_id: folder_id optionally specifies a parent folder to list contents from If not provided, lists from the workspace root (required)
        :type folder_id: str
        :param workspace_id: workspace_id identifies the specific workspace context Required to scope the folder listing to the correct workspace (required)
        :type workspace_id: str
        :param org_id: org_id identifies the organization context for the folder listing Must be a valid organization identifier that the user belongs to (required)
        :type org_id: str
        :param tenant_id: tenant_id identifies the tenant context for the folder listing Required for multi-tenant deployments to maintain proper data isolation (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_folder_serialize(
            user_id=user_id,
            folder_id=folder_id,
            workspace_id=workspace_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListFolderResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_folder_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user making the folder listing request Must be authenticated and authorized to access the workspace")],
        folder_id: Annotated[StrictStr, Field(description="folder_id optionally specifies a parent folder to list contents from If not provided, lists from the workspace root")],
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the specific workspace context Required to scope the folder listing to the correct workspace")],
        org_id: Annotated[StrictStr, Field(description="org_id identifies the organization context for the folder listing Must be a valid organization identifier that the user belongs to")],
        tenant_id: Annotated[StrictStr, Field(description="tenant_id identifies the tenant context for the folder listing Required for multi-tenant deployments to maintain proper data isolation")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List folders

        This endpoint lists all folders

        :param user_id: user_id identifies the user making the folder listing request Must be authenticated and authorized to access the workspace (required)
        :type user_id: str
        :param folder_id: folder_id optionally specifies a parent folder to list contents from If not provided, lists from the workspace root (required)
        :type folder_id: str
        :param workspace_id: workspace_id identifies the specific workspace context Required to scope the folder listing to the correct workspace (required)
        :type workspace_id: str
        :param org_id: org_id identifies the organization context for the folder listing Must be a valid organization identifier that the user belongs to (required)
        :type org_id: str
        :param tenant_id: tenant_id identifies the tenant context for the folder listing Required for multi-tenant deployments to maintain proper data isolation (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_folder_serialize(
            user_id=user_id,
            folder_id=folder_id,
            workspace_id=workspace_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListFolderResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_folder_serialize(
        self,
        user_id,
        folder_id,
        workspace_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if folder_id is not None:
            
            _query_params.append(('folderId', folder_id))
            
        if workspace_id is not None:
            
            _query_params.append(('workspaceId', workspace_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/workspace-microservice/api/v1/folders',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_workspace(
        self,
        user_id: Annotated[StrictStr, Field(description="user_id uniquely identifies the user requesting the workspace list Must be a valid, authenticated user ID from the authentication system")],
        org_id: Annotated[StrictStr, Field(description="org_id identifies the organization context for listing workspaces Must be a valid organization identifier to ensure proper scoping of results")],
        tenant_id: Annotated[StrictStr, Field(description="tenant_id identifies the tenant context for multi-tenant deployments Required to ensure proper isolation between different tenants")],
        page_size: Annotated[Optional[StrictInt], Field(description="page_size specifies the maximum number of workspaces to return in a single response Server may return fewer workspaces than specified If unspecified, server will decide the default page size")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="page_number specifies which page of results to return Pages are 1-based (first page is 1) If unspecified, defaults to page 1")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListWorkspaceResponse:
        """List workspaces

        This endpoint lists all workspaces

        :param user_id: user_id uniquely identifies the user requesting the workspace list Must be a valid, authenticated user ID from the authentication system (required)
        :type user_id: str
        :param org_id: org_id identifies the organization context for listing workspaces Must be a valid organization identifier to ensure proper scoping of results (required)
        :type org_id: str
        :param tenant_id: tenant_id identifies the tenant context for multi-tenant deployments Required to ensure proper isolation between different tenants (required)
        :type tenant_id: str
        :param page_size: page_size specifies the maximum number of workspaces to return in a single response Server may return fewer workspaces than specified If unspecified, server will decide the default page size
        :type page_size: int
        :param page_number: page_number specifies which page of results to return Pages are 1-based (first page is 1) If unspecified, defaults to page 1
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_workspace_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListWorkspaceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_workspace_with_http_info(
        self,
        user_id: Annotated[StrictStr, Field(description="user_id uniquely identifies the user requesting the workspace list Must be a valid, authenticated user ID from the authentication system")],
        org_id: Annotated[StrictStr, Field(description="org_id identifies the organization context for listing workspaces Must be a valid organization identifier to ensure proper scoping of results")],
        tenant_id: Annotated[StrictStr, Field(description="tenant_id identifies the tenant context for multi-tenant deployments Required to ensure proper isolation between different tenants")],
        page_size: Annotated[Optional[StrictInt], Field(description="page_size specifies the maximum number of workspaces to return in a single response Server may return fewer workspaces than specified If unspecified, server will decide the default page size")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="page_number specifies which page of results to return Pages are 1-based (first page is 1) If unspecified, defaults to page 1")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListWorkspaceResponse]:
        """List workspaces

        This endpoint lists all workspaces

        :param user_id: user_id uniquely identifies the user requesting the workspace list Must be a valid, authenticated user ID from the authentication system (required)
        :type user_id: str
        :param org_id: org_id identifies the organization context for listing workspaces Must be a valid organization identifier to ensure proper scoping of results (required)
        :type org_id: str
        :param tenant_id: tenant_id identifies the tenant context for multi-tenant deployments Required to ensure proper isolation between different tenants (required)
        :type tenant_id: str
        :param page_size: page_size specifies the maximum number of workspaces to return in a single response Server may return fewer workspaces than specified If unspecified, server will decide the default page size
        :type page_size: int
        :param page_number: page_number specifies which page of results to return Pages are 1-based (first page is 1) If unspecified, defaults to page 1
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_workspace_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListWorkspaceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_workspace_without_preload_content(
        self,
        user_id: Annotated[StrictStr, Field(description="user_id uniquely identifies the user requesting the workspace list Must be a valid, authenticated user ID from the authentication system")],
        org_id: Annotated[StrictStr, Field(description="org_id identifies the organization context for listing workspaces Must be a valid organization identifier to ensure proper scoping of results")],
        tenant_id: Annotated[StrictStr, Field(description="tenant_id identifies the tenant context for multi-tenant deployments Required to ensure proper isolation between different tenants")],
        page_size: Annotated[Optional[StrictInt], Field(description="page_size specifies the maximum number of workspaces to return in a single response Server may return fewer workspaces than specified If unspecified, server will decide the default page size")] = None,
        page_number: Annotated[Optional[StrictInt], Field(description="page_number specifies which page of results to return Pages are 1-based (first page is 1) If unspecified, defaults to page 1")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List workspaces

        This endpoint lists all workspaces

        :param user_id: user_id uniquely identifies the user requesting the workspace list Must be a valid, authenticated user ID from the authentication system (required)
        :type user_id: str
        :param org_id: org_id identifies the organization context for listing workspaces Must be a valid organization identifier to ensure proper scoping of results (required)
        :type org_id: str
        :param tenant_id: tenant_id identifies the tenant context for multi-tenant deployments Required to ensure proper isolation between different tenants (required)
        :type tenant_id: str
        :param page_size: page_size specifies the maximum number of workspaces to return in a single response Server may return fewer workspaces than specified If unspecified, server will decide the default page size
        :type page_size: int
        :param page_number: page_number specifies which page of results to return Pages are 1-based (first page is 1) If unspecified, defaults to page 1
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_workspace_serialize(
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListWorkspaceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_workspace_serialize(
        self,
        user_id,
        org_id,
        tenant_id,
        page_size,
        page_number,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/workspace-microservice/api/v1/workspaces',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_workspace_activity(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the activity list")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        start_time: Annotated[Optional[datetime], Field(description="Filter options")] = None,
        end_time: Optional[datetime] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Pagination")] = None,
        page_number: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListWorkspaceActivityResponse:
        """List workspace activity

        This endpoint retrieves activity history for a workspace

        :param workspace_id: workspace_id identifies the workspace (required)
        :type workspace_id: str
        :param user_id: user_id identifies the user requesting the activity list (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param start_time: Filter options
        :type start_time: datetime
        :param end_time:
        :type end_time: datetime
        :param page_size: Pagination
        :type page_size: int
        :param page_number:
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_workspace_activity_serialize(
            workspace_id=workspace_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            start_time=start_time,
            end_time=end_time,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListWorkspaceActivityResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_workspace_activity_with_http_info(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the activity list")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        start_time: Annotated[Optional[datetime], Field(description="Filter options")] = None,
        end_time: Optional[datetime] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Pagination")] = None,
        page_number: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListWorkspaceActivityResponse]:
        """List workspace activity

        This endpoint retrieves activity history for a workspace

        :param workspace_id: workspace_id identifies the workspace (required)
        :type workspace_id: str
        :param user_id: user_id identifies the user requesting the activity list (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param start_time: Filter options
        :type start_time: datetime
        :param end_time:
        :type end_time: datetime
        :param page_size: Pagination
        :type page_size: int
        :param page_number:
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_workspace_activity_serialize(
            workspace_id=workspace_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            start_time=start_time,
            end_time=end_time,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListWorkspaceActivityResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_workspace_activity_without_preload_content(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the activity list")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        start_time: Annotated[Optional[datetime], Field(description="Filter options")] = None,
        end_time: Optional[datetime] = None,
        page_size: Annotated[Optional[StrictInt], Field(description="Pagination")] = None,
        page_number: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List workspace activity

        This endpoint retrieves activity history for a workspace

        :param workspace_id: workspace_id identifies the workspace (required)
        :type workspace_id: str
        :param user_id: user_id identifies the user requesting the activity list (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param start_time: Filter options
        :type start_time: datetime
        :param end_time:
        :type end_time: datetime
        :param page_size: Pagination
        :type page_size: int
        :param page_number:
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_workspace_activity_serialize(
            workspace_id=workspace_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            start_time=start_time,
            end_time=end_time,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListWorkspaceActivityResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_workspace_activity_serialize(
        self,
        workspace_id,
        user_id,
        org_id,
        tenant_id,
        start_time,
        end_time,
        page_size,
        page_number,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace_id is not None:
            _path_params['workspaceId'] = workspace_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if start_time is not None:
            if isinstance(start_time, datetime):
                _query_params.append(
                    (
                        'startTime',
                        start_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('startTime', start_time))
            
        if end_time is not None:
            if isinstance(end_time, datetime):
                _query_params.append(
                    (
                        'endTime',
                        end_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('endTime', end_time))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/workspace-microservice/api/v1/workspaces/{workspaceId}/activity',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def list_workspace_shares(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the shares")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        page_size: Annotated[Optional[StrictInt], Field(description="Pagination")] = None,
        page_number: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListWorkspaceSharesResponse:
        """List workspace shares

        This endpoint lists all shares for a workspace

        :param workspace_id: workspace_id identifies the workspace (required)
        :type workspace_id: str
        :param user_id: user_id identifies the user requesting the shares (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param page_size: Pagination
        :type page_size: int
        :param page_number:
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_workspace_shares_serialize(
            workspace_id=workspace_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListWorkspaceSharesResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def list_workspace_shares_with_http_info(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the shares")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        page_size: Annotated[Optional[StrictInt], Field(description="Pagination")] = None,
        page_number: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListWorkspaceSharesResponse]:
        """List workspace shares

        This endpoint lists all shares for a workspace

        :param workspace_id: workspace_id identifies the workspace (required)
        :type workspace_id: str
        :param user_id: user_id identifies the user requesting the shares (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param page_size: Pagination
        :type page_size: int
        :param page_number:
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_workspace_shares_serialize(
            workspace_id=workspace_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListWorkspaceSharesResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def list_workspace_shares_without_preload_content(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace")],
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user requesting the shares")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        page_size: Annotated[Optional[StrictInt], Field(description="Pagination")] = None,
        page_number: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List workspace shares

        This endpoint lists all shares for a workspace

        :param workspace_id: workspace_id identifies the workspace (required)
        :type workspace_id: str
        :param user_id: user_id identifies the user requesting the shares (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param page_size: Pagination
        :type page_size: int
        :param page_number:
        :type page_number: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_workspace_shares_serialize(
            workspace_id=workspace_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            page_size=page_size,
            page_number=page_number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListWorkspaceSharesResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_workspace_shares_serialize(
        self,
        workspace_id,
        user_id,
        org_id,
        tenant_id,
        page_size,
        page_number,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace_id is not None:
            _path_params['workspaceId'] = workspace_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if page_number is not None:
            
            _query_params.append(('pageNumber', page_number))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/workspace-microservice/api/v1/workspaces/{workspaceId}/shares',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def share_file(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file to be shared")],
        share_file_body: ShareFileBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ShareFileResponse:
        """Share a file

        This endpoint shares a file with specified users or generates a sharing link

        :param file_id: file_id identifies the file to be shared (required)
        :type file_id: str
        :param share_file_body: (required)
        :type share_file_body: ShareFileBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._share_file_serialize(
            file_id=file_id,
            share_file_body=share_file_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ShareFileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def share_file_with_http_info(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file to be shared")],
        share_file_body: ShareFileBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ShareFileResponse]:
        """Share a file

        This endpoint shares a file with specified users or generates a sharing link

        :param file_id: file_id identifies the file to be shared (required)
        :type file_id: str
        :param share_file_body: (required)
        :type share_file_body: ShareFileBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._share_file_serialize(
            file_id=file_id,
            share_file_body=share_file_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ShareFileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def share_file_without_preload_content(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file to be shared")],
        share_file_body: ShareFileBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Share a file

        This endpoint shares a file with specified users or generates a sharing link

        :param file_id: file_id identifies the file to be shared (required)
        :type file_id: str
        :param share_file_body: (required)
        :type share_file_body: ShareFileBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._share_file_serialize(
            file_id=file_id,
            share_file_body=share_file_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ShareFileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _share_file_serialize(
        self,
        file_id,
        share_file_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if file_id is not None:
            _path_params['fileId'] = file_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if share_file_body is not None:
            _body_params = share_file_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/workspace-microservice/api/v1/files/{fileId}/share',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def share_workspace(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace to share")],
        share_workspace_body: ShareWorkspaceBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ShareWorkspaceResponse:
        """Share a workspace

        This endpoint shares a workspace with a specified user

        :param workspace_id: workspace_id identifies the workspace to share (required)
        :type workspace_id: str
        :param share_workspace_body: (required)
        :type share_workspace_body: ShareWorkspaceBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._share_workspace_serialize(
            workspace_id=workspace_id,
            share_workspace_body=share_workspace_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ShareWorkspaceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def share_workspace_with_http_info(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace to share")],
        share_workspace_body: ShareWorkspaceBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ShareWorkspaceResponse]:
        """Share a workspace

        This endpoint shares a workspace with a specified user

        :param workspace_id: workspace_id identifies the workspace to share (required)
        :type workspace_id: str
        :param share_workspace_body: (required)
        :type share_workspace_body: ShareWorkspaceBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._share_workspace_serialize(
            workspace_id=workspace_id,
            share_workspace_body=share_workspace_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ShareWorkspaceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def share_workspace_without_preload_content(
        self,
        workspace_id: Annotated[StrictStr, Field(description="workspace_id identifies the workspace to share")],
        share_workspace_body: ShareWorkspaceBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Share a workspace

        This endpoint shares a workspace with a specified user

        :param workspace_id: workspace_id identifies the workspace to share (required)
        :type workspace_id: str
        :param share_workspace_body: (required)
        :type share_workspace_body: ShareWorkspaceBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._share_workspace_serialize(
            workspace_id=workspace_id,
            share_workspace_body=share_workspace_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ShareWorkspaceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _share_workspace_serialize(
        self,
        workspace_id,
        share_workspace_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workspace_id is not None:
            _path_params['workspaceId'] = workspace_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if share_workspace_body is not None:
            _body_params = share_workspace_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/workspace-microservice/api/v1/workspaces/{workspaceId}/shares',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def unshare_file(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file to unshare")],
        share_id: StrictStr,
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user unsharing the file")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UnshareFileResponse:
        """Unshare a file

        This endpoint revokes file sharing for specified users or disables sharing links

        :param file_id: file_id identifies the file to unshare (required)
        :type file_id: str
        :param share_id: (required)
        :type share_id: str
        :param user_id: user_id identifies the user unsharing the file (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._unshare_file_serialize(
            file_id=file_id,
            share_id=share_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UnshareFileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def unshare_file_with_http_info(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file to unshare")],
        share_id: StrictStr,
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user unsharing the file")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UnshareFileResponse]:
        """Unshare a file

        This endpoint revokes file sharing for specified users or disables sharing links

        :param file_id: file_id identifies the file to unshare (required)
        :type file_id: str
        :param share_id: (required)
        :type share_id: str
        :param user_id: user_id identifies the user unsharing the file (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._unshare_file_serialize(
            file_id=file_id,
            share_id=share_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UnshareFileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def unshare_file_without_preload_content(
        self,
        file_id: Annotated[StrictStr, Field(description="file_id identifies the file to unshare")],
        share_id: StrictStr,
        user_id: Annotated[StrictStr, Field(description="user_id identifies the user unsharing the file")],
        org_id: Annotated[StrictStr, Field(description="Organization and tenant context")],
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Unshare a file

        This endpoint revokes file sharing for specified users or disables sharing links

        :param file_id: file_id identifies the file to unshare (required)
        :type file_id: str
        :param share_id: (required)
        :type share_id: str
        :param user_id: user_id identifies the user unsharing the file (required)
        :type user_id: str
        :param org_id: Organization and tenant context (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._unshare_file_serialize(
            file_id=file_id,
            share_id=share_id,
            user_id=user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UnshareFileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _unshare_file_serialize(
        self,
        file_id,
        share_id,
        user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if file_id is not None:
            _path_params['fileId'] = file_id
        if share_id is not None:
            _path_params['shareId'] = share_id
        # process the query parameters
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/workspace-microservice/api/v1/files/{fileId}/share/{shareId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def update_comment(
        self,
        update_comment_request: Annotated[UpdateCommentRequest, Field(description="Comment Update Operations UpdateCommentRequest represents a request to update various aspects of a comment including content, metadata, visibility, and status.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UpdateCommentResponse:
        """Update a comment

        This endpoint updates a comment's content or metadata

        :param update_comment_request: Comment Update Operations UpdateCommentRequest represents a request to update various aspects of a comment including content, metadata, visibility, and status. (required)
        :type update_comment_request: UpdateCommentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_comment_serialize(
            update_comment_request=update_comment_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateCommentResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def update_comment_with_http_info(
        self,
        update_comment_request: Annotated[UpdateCommentRequest, Field(description="Comment Update Operations UpdateCommentRequest represents a request to update various aspects of a comment including content, metadata, visibility, and status.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UpdateCommentResponse]:
        """Update a comment

        This endpoint updates a comment's content or metadata

        :param update_comment_request: Comment Update Operations UpdateCommentRequest represents a request to update various aspects of a comment including content, metadata, visibility, and status. (required)
        :type update_comment_request: UpdateCommentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_comment_serialize(
            update_comment_request=update_comment_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateCommentResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def update_comment_without_preload_content(
        self,
        update_comment_request: Annotated[UpdateCommentRequest, Field(description="Comment Update Operations UpdateCommentRequest represents a request to update various aspects of a comment including content, metadata, visibility, and status.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update a comment

        This endpoint updates a comment's content or metadata

        :param update_comment_request: Comment Update Operations UpdateCommentRequest represents a request to update various aspects of a comment including content, metadata, visibility, and status. (required)
        :type update_comment_request: UpdateCommentRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_comment_serialize(
            update_comment_request=update_comment_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateCommentResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_comment_serialize(
        self,
        update_comment_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_comment_request is not None:
            _body_params = update_comment_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/workspace-microservice/api/v1/comments',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def update_comment_edit(
        self,
        update_comment_edit_request: UpdateCommentEditRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UpdateCommentEditResponse:
        """Update a comment edit

        This endpoint updates a specific comment edit

        :param update_comment_edit_request: (required)
        :type update_comment_edit_request: UpdateCommentEditRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_comment_edit_serialize(
            update_comment_edit_request=update_comment_edit_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateCommentEditResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def update_comment_edit_with_http_info(
        self,
        update_comment_edit_request: UpdateCommentEditRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UpdateCommentEditResponse]:
        """Update a comment edit

        This endpoint updates a specific comment edit

        :param update_comment_edit_request: (required)
        :type update_comment_edit_request: UpdateCommentEditRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_comment_edit_serialize(
            update_comment_edit_request=update_comment_edit_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateCommentEditResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def update_comment_edit_without_preload_content(
        self,
        update_comment_edit_request: UpdateCommentEditRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update a comment edit

        This endpoint updates a specific comment edit

        :param update_comment_edit_request: (required)
        :type update_comment_edit_request: UpdateCommentEditRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_comment_edit_serialize(
            update_comment_edit_request=update_comment_edit_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateCommentEditResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_comment_edit_serialize(
        self,
        update_comment_edit_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_comment_edit_request is not None:
            _body_params = update_comment_edit_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/workspace-microservice/api/v1/comments/edits',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def update_comment_thread(
        self,
        update_comment_thread_request: UpdateCommentThreadRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UpdateCommentThreadResponse:
        """Update a comment thread

        This endpoint updates a comment thread's properties

        :param update_comment_thread_request: (required)
        :type update_comment_thread_request: UpdateCommentThreadRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_comment_thread_serialize(
            update_comment_thread_request=update_comment_thread_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateCommentThreadResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def update_comment_thread_with_http_info(
        self,
        update_comment_thread_request: UpdateCommentThreadRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UpdateCommentThreadResponse]:
        """Update a comment thread

        This endpoint updates a comment thread's properties

        :param update_comment_thread_request: (required)
        :type update_comment_thread_request: UpdateCommentThreadRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_comment_thread_serialize(
            update_comment_thread_request=update_comment_thread_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateCommentThreadResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def update_comment_thread_without_preload_content(
        self,
        update_comment_thread_request: UpdateCommentThreadRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update a comment thread

        This endpoint updates a comment thread's properties

        :param update_comment_thread_request: (required)
        :type update_comment_thread_request: UpdateCommentThreadRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_comment_thread_serialize(
            update_comment_thread_request=update_comment_thread_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateCommentThreadResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_comment_thread_serialize(
        self,
        update_comment_thread_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_comment_thread_request is not None:
            _body_params = update_comment_thread_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/workspace-microservice/api/v1/comment-threads',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def update_file(
        self,
        update_file_request: Annotated[UpdateFileRequest, Field(description="UpdateFileRequest represents a request to update an existing file's metadata in the system. This message contains the updated metadata for the file, allowing modification of file attributes while maintaining version history and access controls.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UpdateFileResponse:
        """Update a file

        This endpoint updates a file by ID

        :param update_file_request: UpdateFileRequest represents a request to update an existing file's metadata in the system. This message contains the updated metadata for the file, allowing modification of file attributes while maintaining version history and access controls. (required)
        :type update_file_request: UpdateFileRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_file_serialize(
            update_file_request=update_file_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateFileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def update_file_with_http_info(
        self,
        update_file_request: Annotated[UpdateFileRequest, Field(description="UpdateFileRequest represents a request to update an existing file's metadata in the system. This message contains the updated metadata for the file, allowing modification of file attributes while maintaining version history and access controls.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UpdateFileResponse]:
        """Update a file

        This endpoint updates a file by ID

        :param update_file_request: UpdateFileRequest represents a request to update an existing file's metadata in the system. This message contains the updated metadata for the file, allowing modification of file attributes while maintaining version history and access controls. (required)
        :type update_file_request: UpdateFileRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_file_serialize(
            update_file_request=update_file_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateFileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def update_file_without_preload_content(
        self,
        update_file_request: Annotated[UpdateFileRequest, Field(description="UpdateFileRequest represents a request to update an existing file's metadata in the system. This message contains the updated metadata for the file, allowing modification of file attributes while maintaining version history and access controls.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update a file

        This endpoint updates a file by ID

        :param update_file_request: UpdateFileRequest represents a request to update an existing file's metadata in the system. This message contains the updated metadata for the file, allowing modification of file attributes while maintaining version history and access controls. (required)
        :type update_file_request: UpdateFileRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_file_serialize(
            update_file_request=update_file_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateFileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_file_serialize(
        self,
        update_file_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_file_request is not None:
            _body_params = update_file_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/workspace-microservice/api/v1/files',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def update_folder(
        self,
        update_folder_request: Annotated[UpdateFolderRequest, Field(description="UpdateFolderRequest represents a request to update an existing folder's metadata. This message contains the updated folder metadata, allowing modification of folder attributes while maintaining proper access controls and organizational hierarchy.  Key features: - Complete folder metadata updates - Maintains folder relationships - Preserves access controls - Supports audit trail")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UpdateFolderResponse:
        """Update a folder

        This endpoint updates a folder by ID

        :param update_folder_request: UpdateFolderRequest represents a request to update an existing folder's metadata. This message contains the updated folder metadata, allowing modification of folder attributes while maintaining proper access controls and organizational hierarchy.  Key features: - Complete folder metadata updates - Maintains folder relationships - Preserves access controls - Supports audit trail (required)
        :type update_folder_request: UpdateFolderRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_folder_serialize(
            update_folder_request=update_folder_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateFolderResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def update_folder_with_http_info(
        self,
        update_folder_request: Annotated[UpdateFolderRequest, Field(description="UpdateFolderRequest represents a request to update an existing folder's metadata. This message contains the updated folder metadata, allowing modification of folder attributes while maintaining proper access controls and organizational hierarchy.  Key features: - Complete folder metadata updates - Maintains folder relationships - Preserves access controls - Supports audit trail")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UpdateFolderResponse]:
        """Update a folder

        This endpoint updates a folder by ID

        :param update_folder_request: UpdateFolderRequest represents a request to update an existing folder's metadata. This message contains the updated folder metadata, allowing modification of folder attributes while maintaining proper access controls and organizational hierarchy.  Key features: - Complete folder metadata updates - Maintains folder relationships - Preserves access controls - Supports audit trail (required)
        :type update_folder_request: UpdateFolderRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_folder_serialize(
            update_folder_request=update_folder_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateFolderResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def update_folder_without_preload_content(
        self,
        update_folder_request: Annotated[UpdateFolderRequest, Field(description="UpdateFolderRequest represents a request to update an existing folder's metadata. This message contains the updated folder metadata, allowing modification of folder attributes while maintaining proper access controls and organizational hierarchy.  Key features: - Complete folder metadata updates - Maintains folder relationships - Preserves access controls - Supports audit trail")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update a folder

        This endpoint updates a folder by ID

        :param update_folder_request: UpdateFolderRequest represents a request to update an existing folder's metadata. This message contains the updated folder metadata, allowing modification of folder attributes while maintaining proper access controls and organizational hierarchy.  Key features: - Complete folder metadata updates - Maintains folder relationships - Preserves access controls - Supports audit trail (required)
        :type update_folder_request: UpdateFolderRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_folder_serialize(
            update_folder_request=update_folder_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateFolderResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_folder_serialize(
        self,
        update_folder_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_folder_request is not None:
            _body_params = update_folder_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/workspace-microservice/api/v1/folders',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def update_workspace(
        self,
        update_workspace_request: Annotated[UpdateWorkspaceRequest, Field(description="UpdateWorkspaceRequest represents a request to update an existing workspace's properties. This message contains the complete workspace object with updated fields, allowing modification of workspace attributes while maintaining data consistency and access controls.  Key features: - Full workspace object updates - Validation of required fields - Version tracking support - Access control preservation")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UpdateWorkspaceResponse:
        """Update a workspace

        This endpoint updates a workspace by ID

        :param update_workspace_request: UpdateWorkspaceRequest represents a request to update an existing workspace's properties. This message contains the complete workspace object with updated fields, allowing modification of workspace attributes while maintaining data consistency and access controls.  Key features: - Full workspace object updates - Validation of required fields - Version tracking support - Access control preservation (required)
        :type update_workspace_request: UpdateWorkspaceRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_workspace_serialize(
            update_workspace_request=update_workspace_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateWorkspaceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def update_workspace_with_http_info(
        self,
        update_workspace_request: Annotated[UpdateWorkspaceRequest, Field(description="UpdateWorkspaceRequest represents a request to update an existing workspace's properties. This message contains the complete workspace object with updated fields, allowing modification of workspace attributes while maintaining data consistency and access controls.  Key features: - Full workspace object updates - Validation of required fields - Version tracking support - Access control preservation")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UpdateWorkspaceResponse]:
        """Update a workspace

        This endpoint updates a workspace by ID

        :param update_workspace_request: UpdateWorkspaceRequest represents a request to update an existing workspace's properties. This message contains the complete workspace object with updated fields, allowing modification of workspace attributes while maintaining data consistency and access controls.  Key features: - Full workspace object updates - Validation of required fields - Version tracking support - Access control preservation (required)
        :type update_workspace_request: UpdateWorkspaceRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_workspace_serialize(
            update_workspace_request=update_workspace_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateWorkspaceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def update_workspace_without_preload_content(
        self,
        update_workspace_request: Annotated[UpdateWorkspaceRequest, Field(description="UpdateWorkspaceRequest represents a request to update an existing workspace's properties. This message contains the complete workspace object with updated fields, allowing modification of workspace attributes while maintaining data consistency and access controls.  Key features: - Full workspace object updates - Validation of required fields - Version tracking support - Access control preservation")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update a workspace

        This endpoint updates a workspace by ID

        :param update_workspace_request: UpdateWorkspaceRequest represents a request to update an existing workspace's properties. This message contains the complete workspace object with updated fields, allowing modification of workspace attributes while maintaining data consistency and access controls.  Key features: - Full workspace object updates - Validation of required fields - Version tracking support - Access control preservation (required)
        :type update_workspace_request: UpdateWorkspaceRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_workspace_serialize(
            update_workspace_request=update_workspace_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateWorkspaceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_workspace_serialize(
        self,
        update_workspace_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_workspace_request is not None:
            _body_params = update_workspace_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/workspace-microservice/api/v1/workspaces',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def update_workspace_compliance(
        self,
        update_workspace_compliance_request: Annotated[UpdateWorkspaceComplianceRequest, Field(description="UpdateWorkspaceComplianceRequest represents a request to update compliance settings for a workspace. This operation modifies the existing compliance configuration with new settings.  Required Fields: - compliance: The new compliance settings to apply to the workspace  The compliance settings include: - Data retention policies - Access control requirements - Audit logging configurations - Security controls - Regulatory compliance flags  Example: ```protobuf message request {   compliance: {     data_retention_days: 90     require_2fa: true     audit_logging_enabled: true   } } ```")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UpdateWorkspaceComplianceResponse:
        """Update workspace compliance settings

        This endpoint updates compliance settings for a workspace

        :param update_workspace_compliance_request: UpdateWorkspaceComplianceRequest represents a request to update compliance settings for a workspace. This operation modifies the existing compliance configuration with new settings.  Required Fields: - compliance: The new compliance settings to apply to the workspace  The compliance settings include: - Data retention policies - Access control requirements - Audit logging configurations - Security controls - Regulatory compliance flags  Example: ```protobuf message request {   compliance: {     data_retention_days: 90     require_2fa: true     audit_logging_enabled: true   } } ``` (required)
        :type update_workspace_compliance_request: UpdateWorkspaceComplianceRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_workspace_compliance_serialize(
            update_workspace_compliance_request=update_workspace_compliance_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateWorkspaceComplianceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def update_workspace_compliance_with_http_info(
        self,
        update_workspace_compliance_request: Annotated[UpdateWorkspaceComplianceRequest, Field(description="UpdateWorkspaceComplianceRequest represents a request to update compliance settings for a workspace. This operation modifies the existing compliance configuration with new settings.  Required Fields: - compliance: The new compliance settings to apply to the workspace  The compliance settings include: - Data retention policies - Access control requirements - Audit logging configurations - Security controls - Regulatory compliance flags  Example: ```protobuf message request {   compliance: {     data_retention_days: 90     require_2fa: true     audit_logging_enabled: true   } } ```")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UpdateWorkspaceComplianceResponse]:
        """Update workspace compliance settings

        This endpoint updates compliance settings for a workspace

        :param update_workspace_compliance_request: UpdateWorkspaceComplianceRequest represents a request to update compliance settings for a workspace. This operation modifies the existing compliance configuration with new settings.  Required Fields: - compliance: The new compliance settings to apply to the workspace  The compliance settings include: - Data retention policies - Access control requirements - Audit logging configurations - Security controls - Regulatory compliance flags  Example: ```protobuf message request {   compliance: {     data_retention_days: 90     require_2fa: true     audit_logging_enabled: true   } } ``` (required)
        :type update_workspace_compliance_request: UpdateWorkspaceComplianceRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_workspace_compliance_serialize(
            update_workspace_compliance_request=update_workspace_compliance_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateWorkspaceComplianceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def update_workspace_compliance_without_preload_content(
        self,
        update_workspace_compliance_request: Annotated[UpdateWorkspaceComplianceRequest, Field(description="UpdateWorkspaceComplianceRequest represents a request to update compliance settings for a workspace. This operation modifies the existing compliance configuration with new settings.  Required Fields: - compliance: The new compliance settings to apply to the workspace  The compliance settings include: - Data retention policies - Access control requirements - Audit logging configurations - Security controls - Regulatory compliance flags  Example: ```protobuf message request {   compliance: {     data_retention_days: 90     require_2fa: true     audit_logging_enabled: true   } } ```")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update workspace compliance settings

        This endpoint updates compliance settings for a workspace

        :param update_workspace_compliance_request: UpdateWorkspaceComplianceRequest represents a request to update compliance settings for a workspace. This operation modifies the existing compliance configuration with new settings.  Required Fields: - compliance: The new compliance settings to apply to the workspace  The compliance settings include: - Data retention policies - Access control requirements - Audit logging configurations - Security controls - Regulatory compliance flags  Example: ```protobuf message request {   compliance: {     data_retention_days: 90     require_2fa: true     audit_logging_enabled: true   } } ``` (required)
        :type update_workspace_compliance_request: UpdateWorkspaceComplianceRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_workspace_compliance_serialize(
            update_workspace_compliance_request=update_workspace_compliance_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateWorkspaceComplianceResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_workspace_compliance_serialize(
        self,
        update_workspace_compliance_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_workspace_compliance_request is not None:
            _body_params = update_workspace_compliance_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/workspace-microservice/api/v1/workspaces/compliance',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def update_workspace_share(
        self,
        update_workspace_share_request: Annotated[UpdateWorkspaceShareRequest, Field(description="UpdateWorkspaceShareRequest represents a request to update an existing workspace share. Contains the modified share object with updated permissions or settings.  Required Fields: - share: The WorkspaceSharing object containing the updated share configuration")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UpdateWorkspaceShareResponse:
        """Update a workspace share

        This endpoint updates a workspace share's properties

        :param update_workspace_share_request: UpdateWorkspaceShareRequest represents a request to update an existing workspace share. Contains the modified share object with updated permissions or settings.  Required Fields: - share: The WorkspaceSharing object containing the updated share configuration (required)
        :type update_workspace_share_request: UpdateWorkspaceShareRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_workspace_share_serialize(
            update_workspace_share_request=update_workspace_share_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateWorkspaceShareResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def update_workspace_share_with_http_info(
        self,
        update_workspace_share_request: Annotated[UpdateWorkspaceShareRequest, Field(description="UpdateWorkspaceShareRequest represents a request to update an existing workspace share. Contains the modified share object with updated permissions or settings.  Required Fields: - share: The WorkspaceSharing object containing the updated share configuration")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UpdateWorkspaceShareResponse]:
        """Update a workspace share

        This endpoint updates a workspace share's properties

        :param update_workspace_share_request: UpdateWorkspaceShareRequest represents a request to update an existing workspace share. Contains the modified share object with updated permissions or settings.  Required Fields: - share: The WorkspaceSharing object containing the updated share configuration (required)
        :type update_workspace_share_request: UpdateWorkspaceShareRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_workspace_share_serialize(
            update_workspace_share_request=update_workspace_share_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateWorkspaceShareResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def update_workspace_share_without_preload_content(
        self,
        update_workspace_share_request: Annotated[UpdateWorkspaceShareRequest, Field(description="UpdateWorkspaceShareRequest represents a request to update an existing workspace share. Contains the modified share object with updated permissions or settings.  Required Fields: - share: The WorkspaceSharing object containing the updated share configuration")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update a workspace share

        This endpoint updates a workspace share's properties

        :param update_workspace_share_request: UpdateWorkspaceShareRequest represents a request to update an existing workspace share. Contains the modified share object with updated permissions or settings.  Required Fields: - share: The WorkspaceSharing object containing the updated share configuration (required)
        :type update_workspace_share_request: UpdateWorkspaceShareRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_workspace_share_serialize(
            update_workspace_share_request=update_workspace_share_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateWorkspaceShareResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_workspace_share_serialize(
        self,
        update_workspace_share_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_workspace_share_request is not None:
            _body_params = update_workspace_share_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/workspace-microservice/api/v1/workspaces/shares',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


