# coding: utf-8

"""
    User Service API

    Solomon AI User Service API - Manages user profiles and authentication

    The version of the OpenAPI document: 1.0
    Contact: yoanyomba@solomon-ai.co
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing_extensions import Annotated
from solomonai_backend_client_sdk.models.create_accounting_profile_request import CreateAccountingProfileRequest
from solomonai_backend_client_sdk.models.create_accounting_profile_response import CreateAccountingProfileResponse
from solomonai_backend_client_sdk.models.delete_accounting_profile_response import DeleteAccountingProfileResponse
from solomonai_backend_client_sdk.models.exchange_public_link_token_for_account_token_request import ExchangePublicLinkTokenForAccountTokenRequest
from solomonai_backend_client_sdk.models.exchange_public_link_token_for_account_token_response import ExchangePublicLinkTokenForAccountTokenResponse
from solomonai_backend_client_sdk.models.get_merge_link_token_request import GetMergeLinkTokenRequest
from solomonai_backend_client_sdk.models.get_merge_link_token_response import GetMergeLinkTokenResponse
from solomonai_backend_client_sdk.models.get_workflow_execution_status_response import GetWorkflowExecutionStatusResponse
from solomonai_backend_client_sdk.models.health_check_response2 import HealthCheckResponse2
from solomonai_backend_client_sdk.models.read_accounting_profile_response import ReadAccountingProfileResponse
from solomonai_backend_client_sdk.models.read_balance_sheets_request import ReadBalanceSheetsRequest
from solomonai_backend_client_sdk.models.read_balance_sheets_response import ReadBalanceSheetsResponse
from solomonai_backend_client_sdk.models.read_business_chart_of_accounts_request import ReadBusinessChartOfAccountsRequest
from solomonai_backend_client_sdk.models.read_business_chart_of_accounts_response import ReadBusinessChartOfAccountsResponse
from solomonai_backend_client_sdk.models.read_business_transactions_request import ReadBusinessTransactionsRequest
from solomonai_backend_client_sdk.models.read_business_transactions_response import ReadBusinessTransactionsResponse
from solomonai_backend_client_sdk.models.read_cash_flow_statements_request import ReadCashFlowStatementsRequest
from solomonai_backend_client_sdk.models.read_cash_flow_statements_response import ReadCashFlowStatementsResponse
from solomonai_backend_client_sdk.models.read_income_statements_request import ReadIncomeStatementsRequest
from solomonai_backend_client_sdk.models.read_income_statements_response import ReadIncomeStatementsResponse
from solomonai_backend_client_sdk.models.readyness_check_response3 import ReadynessCheckResponse3
from solomonai_backend_client_sdk.models.update_accounting_profile_request import UpdateAccountingProfileRequest
from solomonai_backend_client_sdk.models.update_accounting_profile_response import UpdateAccountingProfileResponse

from solomonai_backend_client_sdk.api_client import ApiClient, RequestSerialized
from solomonai_backend_client_sdk.api_response import ApiResponse
from solomonai_backend_client_sdk.rest import RESTResponseType


class AccountingServiceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    async def create_payroll_profile(
        self,
        create_accounting_profile_request: Annotated[CreateAccountingProfileRequest, Field(description="Defines a message named CreateAccountingProfileRequest.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateAccountingProfileResponse:
        """Create Payroll Profile

        Creates a payroll profile.

        :param create_accounting_profile_request: Defines a message named CreateAccountingProfileRequest. (required)
        :type create_accounting_profile_request: CreateAccountingProfileRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_payroll_profile_serialize(
            create_accounting_profile_request=create_accounting_profile_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateAccountingProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def create_payroll_profile_with_http_info(
        self,
        create_accounting_profile_request: Annotated[CreateAccountingProfileRequest, Field(description="Defines a message named CreateAccountingProfileRequest.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateAccountingProfileResponse]:
        """Create Payroll Profile

        Creates a payroll profile.

        :param create_accounting_profile_request: Defines a message named CreateAccountingProfileRequest. (required)
        :type create_accounting_profile_request: CreateAccountingProfileRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_payroll_profile_serialize(
            create_accounting_profile_request=create_accounting_profile_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateAccountingProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def create_payroll_profile_without_preload_content(
        self,
        create_accounting_profile_request: Annotated[CreateAccountingProfileRequest, Field(description="Defines a message named CreateAccountingProfileRequest.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create Payroll Profile

        Creates a payroll profile.

        :param create_accounting_profile_request: Defines a message named CreateAccountingProfileRequest. (required)
        :type create_accounting_profile_request: CreateAccountingProfileRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_payroll_profile_serialize(
            create_accounting_profile_request=create_accounting_profile_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateAccountingProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_payroll_profile_serialize(
        self,
        create_accounting_profile_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_accounting_profile_request is not None:
            _body_params = create_accounting_profile_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/accounting-microservice/api/v1/profile',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def delete_profile(
        self,
        auth_zero_user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DeleteAccountingProfileResponse:
        """Delete Payroll Profile

        Deletes a business payroll profile.

        :param auth_zero_user_id: (required)
        :type auth_zero_user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_profile_serialize(
            auth_zero_user_id=auth_zero_user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteAccountingProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def delete_profile_with_http_info(
        self,
        auth_zero_user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DeleteAccountingProfileResponse]:
        """Delete Payroll Profile

        Deletes a business payroll profile.

        :param auth_zero_user_id: (required)
        :type auth_zero_user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_profile_serialize(
            auth_zero_user_id=auth_zero_user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteAccountingProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def delete_profile_without_preload_content(
        self,
        auth_zero_user_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete Payroll Profile

        Deletes a business payroll profile.

        :param auth_zero_user_id: (required)
        :type auth_zero_user_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_profile_serialize(
            auth_zero_user_id=auth_zero_user_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DeleteAccountingProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_profile_serialize(
        self,
        auth_zero_user_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if auth_zero_user_id is not None:
            _path_params['authZeroUserId'] = auth_zero_user_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/accounting-microservice/api/v1/profile/{authZeroUserId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def exchange_public_link_token_for_account_token_response(
        self,
        exchange_public_link_token_for_account_token_request: ExchangePublicLinkTokenForAccountTokenRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ExchangePublicLinkTokenForAccountTokenResponse:
        """Exchange Link Token

        Exchanges a public link token for an account token.

        :param exchange_public_link_token_for_account_token_request: (required)
        :type exchange_public_link_token_for_account_token_request: ExchangePublicLinkTokenForAccountTokenRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._exchange_public_link_token_for_account_token_response_serialize(
            exchange_public_link_token_for_account_token_request=exchange_public_link_token_for_account_token_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ExchangePublicLinkTokenForAccountTokenResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def exchange_public_link_token_for_account_token_response_with_http_info(
        self,
        exchange_public_link_token_for_account_token_request: ExchangePublicLinkTokenForAccountTokenRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ExchangePublicLinkTokenForAccountTokenResponse]:
        """Exchange Link Token

        Exchanges a public link token for an account token.

        :param exchange_public_link_token_for_account_token_request: (required)
        :type exchange_public_link_token_for_account_token_request: ExchangePublicLinkTokenForAccountTokenRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._exchange_public_link_token_for_account_token_response_serialize(
            exchange_public_link_token_for_account_token_request=exchange_public_link_token_for_account_token_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ExchangePublicLinkTokenForAccountTokenResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def exchange_public_link_token_for_account_token_response_without_preload_content(
        self,
        exchange_public_link_token_for_account_token_request: ExchangePublicLinkTokenForAccountTokenRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Exchange Link Token

        Exchanges a public link token for an account token.

        :param exchange_public_link_token_for_account_token_request: (required)
        :type exchange_public_link_token_for_account_token_request: ExchangePublicLinkTokenForAccountTokenRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._exchange_public_link_token_for_account_token_response_serialize(
            exchange_public_link_token_for_account_token_request=exchange_public_link_token_for_account_token_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ExchangePublicLinkTokenForAccountTokenResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _exchange_public_link_token_for_account_token_response_serialize(
        self,
        exchange_public_link_token_for_account_token_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if exchange_public_link_token_for_account_token_request is not None:
            _body_params = exchange_public_link_token_for_account_token_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/accounting-microservice/api/v1/merge/exchange-token',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_link_token(
        self,
        get_merge_link_token_request: Annotated[GetMergeLinkTokenRequest, Field(description="Defines a message named GetMergeLinkTokenRequest.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetMergeLinkTokenResponse:
        """Get Link Token

        Provides a link token to initialize a Link session for the user.

        :param get_merge_link_token_request: Defines a message named GetMergeLinkTokenRequest. (required)
        :type get_merge_link_token_request: GetMergeLinkTokenRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_link_token_serialize(
            get_merge_link_token_request=get_merge_link_token_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMergeLinkTokenResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_link_token_with_http_info(
        self,
        get_merge_link_token_request: Annotated[GetMergeLinkTokenRequest, Field(description="Defines a message named GetMergeLinkTokenRequest.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetMergeLinkTokenResponse]:
        """Get Link Token

        Provides a link token to initialize a Link session for the user.

        :param get_merge_link_token_request: Defines a message named GetMergeLinkTokenRequest. (required)
        :type get_merge_link_token_request: GetMergeLinkTokenRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_link_token_serialize(
            get_merge_link_token_request=get_merge_link_token_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMergeLinkTokenResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_link_token_without_preload_content(
        self,
        get_merge_link_token_request: Annotated[GetMergeLinkTokenRequest, Field(description="Defines a message named GetMergeLinkTokenRequest.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Link Token

        Provides a link token to initialize a Link session for the user.

        :param get_merge_link_token_request: Defines a message named GetMergeLinkTokenRequest. (required)
        :type get_merge_link_token_request: GetMergeLinkTokenRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_link_token_serialize(
            get_merge_link_token_request=get_merge_link_token_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetMergeLinkTokenResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_link_token_serialize(
        self,
        get_merge_link_token_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if get_merge_link_token_request is not None:
            _body_params = get_merge_link_token_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/accounting-microservice/api/v1/merge/initiate-token-exchange',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def get_workflow_execution_status(
        self,
        workflow_id: Annotated[StrictStr, Field(description="The task id Validations: - workflow id cannot be empty")],
        workflow_run_id: Annotated[StrictStr, Field(description="The run id Validations: - run id cannot be empty")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetWorkflowExecutionStatusResponse:
        """polls the status of an async task

        This endpoint polls the status of an async task

        :param workflow_id: The task id Validations: - workflow id cannot be empty (required)
        :type workflow_id: str
        :param workflow_run_id: The run id Validations: - run id cannot be empty (required)
        :type workflow_run_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_workflow_execution_status_serialize(
            workflow_id=workflow_id,
            workflow_run_id=workflow_run_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetWorkflowExecutionStatusResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def get_workflow_execution_status_with_http_info(
        self,
        workflow_id: Annotated[StrictStr, Field(description="The task id Validations: - workflow id cannot be empty")],
        workflow_run_id: Annotated[StrictStr, Field(description="The run id Validations: - run id cannot be empty")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetWorkflowExecutionStatusResponse]:
        """polls the status of an async task

        This endpoint polls the status of an async task

        :param workflow_id: The task id Validations: - workflow id cannot be empty (required)
        :type workflow_id: str
        :param workflow_run_id: The run id Validations: - run id cannot be empty (required)
        :type workflow_run_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_workflow_execution_status_serialize(
            workflow_id=workflow_id,
            workflow_run_id=workflow_run_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetWorkflowExecutionStatusResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def get_workflow_execution_status_without_preload_content(
        self,
        workflow_id: Annotated[StrictStr, Field(description="The task id Validations: - workflow id cannot be empty")],
        workflow_run_id: Annotated[StrictStr, Field(description="The run id Validations: - run id cannot be empty")],
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """polls the status of an async task

        This endpoint polls the status of an async task

        :param workflow_id: The task id Validations: - workflow id cannot be empty (required)
        :type workflow_id: str
        :param workflow_run_id: The run id Validations: - run id cannot be empty (required)
        :type workflow_run_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_workflow_execution_status_serialize(
            workflow_id=workflow_id,
            workflow_run_id=workflow_run_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetWorkflowExecutionStatusResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_workflow_execution_status_serialize(
        self,
        workflow_id,
        workflow_run_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workflow_id is not None:
            _path_params['workflowId'] = workflow_id
        if workflow_run_id is not None:
            _path_params['workflowRunId'] = workflow_run_id
        # process the query parameters
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/accounting-microservice/api/v1/async-task/{workflowId}/run/{workflowRunId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def health_check3(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> HealthCheckResponse2:
        """Health Check

        Performs a health check on the service.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._health_check3_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "HealthCheckResponse2",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def health_check3_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[HealthCheckResponse2]:
        """Health Check

        Performs a health check on the service.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._health_check3_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "HealthCheckResponse2",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def health_check3_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Health Check

        Performs a health check on the service.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._health_check3_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "HealthCheckResponse2",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _health_check3_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/accounting-microservice/api/v1/health',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def read_accounting_profile_response(
        self,
        auth_zero_user_id: StrictStr,
        linked_accounting_account_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ReadAccountingProfileResponse:
        """Get Business Account Profile

        Retrieves a business account profile.

        :param auth_zero_user_id: (required)
        :type auth_zero_user_id: str
        :param linked_accounting_account_id: (required)
        :type linked_accounting_account_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_accounting_profile_response_serialize(
            auth_zero_user_id=auth_zero_user_id,
            linked_accounting_account_id=linked_accounting_account_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReadAccountingProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def read_accounting_profile_response_with_http_info(
        self,
        auth_zero_user_id: StrictStr,
        linked_accounting_account_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ReadAccountingProfileResponse]:
        """Get Business Account Profile

        Retrieves a business account profile.

        :param auth_zero_user_id: (required)
        :type auth_zero_user_id: str
        :param linked_accounting_account_id: (required)
        :type linked_accounting_account_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_accounting_profile_response_serialize(
            auth_zero_user_id=auth_zero_user_id,
            linked_accounting_account_id=linked_accounting_account_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReadAccountingProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def read_accounting_profile_response_without_preload_content(
        self,
        auth_zero_user_id: StrictStr,
        linked_accounting_account_id: StrictStr,
        org_id: StrictStr,
        tenant_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Business Account Profile

        Retrieves a business account profile.

        :param auth_zero_user_id: (required)
        :type auth_zero_user_id: str
        :param linked_accounting_account_id: (required)
        :type linked_accounting_account_id: str
        :param org_id: (required)
        :type org_id: str
        :param tenant_id: (required)
        :type tenant_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_accounting_profile_response_serialize(
            auth_zero_user_id=auth_zero_user_id,
            linked_accounting_account_id=linked_accounting_account_id,
            org_id=org_id,
            tenant_id=tenant_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReadAccountingProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _read_accounting_profile_response_serialize(
        self,
        auth_zero_user_id,
        linked_accounting_account_id,
        org_id,
        tenant_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if auth_zero_user_id is not None:
            _path_params['authZeroUserId'] = auth_zero_user_id
        # process the query parameters
        if linked_accounting_account_id is not None:
            
            _query_params.append(('linkedAccountingAccountId', linked_accounting_account_id))
            
        if org_id is not None:
            
            _query_params.append(('orgId', org_id))
            
        if tenant_id is not None:
            
            _query_params.append(('tenantId', tenant_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/accounting-microservice/api/v1/profile/{authZeroUserId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def read_balance_sheets(
        self,
        read_balance_sheets_request: ReadBalanceSheetsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ReadBalanceSheetsResponse:
        """Gets Balance Sheets

        Queries balance sheets for a business.

        :param read_balance_sheets_request: (required)
        :type read_balance_sheets_request: ReadBalanceSheetsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_balance_sheets_serialize(
            read_balance_sheets_request=read_balance_sheets_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReadBalanceSheetsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def read_balance_sheets_with_http_info(
        self,
        read_balance_sheets_request: ReadBalanceSheetsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ReadBalanceSheetsResponse]:
        """Gets Balance Sheets

        Queries balance sheets for a business.

        :param read_balance_sheets_request: (required)
        :type read_balance_sheets_request: ReadBalanceSheetsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_balance_sheets_serialize(
            read_balance_sheets_request=read_balance_sheets_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReadBalanceSheetsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def read_balance_sheets_without_preload_content(
        self,
        read_balance_sheets_request: ReadBalanceSheetsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets Balance Sheets

        Queries balance sheets for a business.

        :param read_balance_sheets_request: (required)
        :type read_balance_sheets_request: ReadBalanceSheetsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_balance_sheets_serialize(
            read_balance_sheets_request=read_balance_sheets_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReadBalanceSheetsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _read_balance_sheets_serialize(
        self,
        read_balance_sheets_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if read_balance_sheets_request is not None:
            _body_params = read_balance_sheets_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/accounting-microservice/api/v1/balance-sheets',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def read_business_chart_of_accounts(
        self,
        read_business_chart_of_accounts_request: ReadBusinessChartOfAccountsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ReadBusinessChartOfAccountsResponse:
        """Gets Chart of Accounts

        Queries chart of accounts for a business.

        :param read_business_chart_of_accounts_request: (required)
        :type read_business_chart_of_accounts_request: ReadBusinessChartOfAccountsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_business_chart_of_accounts_serialize(
            read_business_chart_of_accounts_request=read_business_chart_of_accounts_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReadBusinessChartOfAccountsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def read_business_chart_of_accounts_with_http_info(
        self,
        read_business_chart_of_accounts_request: ReadBusinessChartOfAccountsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ReadBusinessChartOfAccountsResponse]:
        """Gets Chart of Accounts

        Queries chart of accounts for a business.

        :param read_business_chart_of_accounts_request: (required)
        :type read_business_chart_of_accounts_request: ReadBusinessChartOfAccountsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_business_chart_of_accounts_serialize(
            read_business_chart_of_accounts_request=read_business_chart_of_accounts_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReadBusinessChartOfAccountsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def read_business_chart_of_accounts_without_preload_content(
        self,
        read_business_chart_of_accounts_request: ReadBusinessChartOfAccountsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets Chart of Accounts

        Queries chart of accounts for a business.

        :param read_business_chart_of_accounts_request: (required)
        :type read_business_chart_of_accounts_request: ReadBusinessChartOfAccountsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_business_chart_of_accounts_serialize(
            read_business_chart_of_accounts_request=read_business_chart_of_accounts_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReadBusinessChartOfAccountsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _read_business_chart_of_accounts_serialize(
        self,
        read_business_chart_of_accounts_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if read_business_chart_of_accounts_request is not None:
            _body_params = read_business_chart_of_accounts_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/accounting-microservice/api/v1/chart-of-accounts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def read_business_transactions(
        self,
        read_business_transactions_request: Annotated[ReadBusinessTransactionsRequest, Field(description="Request for reading business transactions with pagination and time filtering.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ReadBusinessTransactionsResponse:
        """Gets Business Transactions

        Queries transactions for a business.

        :param read_business_transactions_request: Request for reading business transactions with pagination and time filtering. (required)
        :type read_business_transactions_request: ReadBusinessTransactionsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_business_transactions_serialize(
            read_business_transactions_request=read_business_transactions_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReadBusinessTransactionsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def read_business_transactions_with_http_info(
        self,
        read_business_transactions_request: Annotated[ReadBusinessTransactionsRequest, Field(description="Request for reading business transactions with pagination and time filtering.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ReadBusinessTransactionsResponse]:
        """Gets Business Transactions

        Queries transactions for a business.

        :param read_business_transactions_request: Request for reading business transactions with pagination and time filtering. (required)
        :type read_business_transactions_request: ReadBusinessTransactionsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_business_transactions_serialize(
            read_business_transactions_request=read_business_transactions_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReadBusinessTransactionsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def read_business_transactions_without_preload_content(
        self,
        read_business_transactions_request: Annotated[ReadBusinessTransactionsRequest, Field(description="Request for reading business transactions with pagination and time filtering.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets Business Transactions

        Queries transactions for a business.

        :param read_business_transactions_request: Request for reading business transactions with pagination and time filtering. (required)
        :type read_business_transactions_request: ReadBusinessTransactionsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_business_transactions_serialize(
            read_business_transactions_request=read_business_transactions_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReadBusinessTransactionsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _read_business_transactions_serialize(
        self,
        read_business_transactions_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if read_business_transactions_request is not None:
            _body_params = read_business_transactions_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/accounting-microservice/api/v1/business-transactions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def read_cash_flow_statements(
        self,
        read_cash_flow_statements_request: ReadCashFlowStatementsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ReadCashFlowStatementsResponse:
        """Gets Cashfloe Sheets

        Queries cashflow sheets for a business.

        :param read_cash_flow_statements_request: (required)
        :type read_cash_flow_statements_request: ReadCashFlowStatementsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_cash_flow_statements_serialize(
            read_cash_flow_statements_request=read_cash_flow_statements_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReadCashFlowStatementsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def read_cash_flow_statements_with_http_info(
        self,
        read_cash_flow_statements_request: ReadCashFlowStatementsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ReadCashFlowStatementsResponse]:
        """Gets Cashfloe Sheets

        Queries cashflow sheets for a business.

        :param read_cash_flow_statements_request: (required)
        :type read_cash_flow_statements_request: ReadCashFlowStatementsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_cash_flow_statements_serialize(
            read_cash_flow_statements_request=read_cash_flow_statements_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReadCashFlowStatementsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def read_cash_flow_statements_without_preload_content(
        self,
        read_cash_flow_statements_request: ReadCashFlowStatementsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets Cashfloe Sheets

        Queries cashflow sheets for a business.

        :param read_cash_flow_statements_request: (required)
        :type read_cash_flow_statements_request: ReadCashFlowStatementsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_cash_flow_statements_serialize(
            read_cash_flow_statements_request=read_cash_flow_statements_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReadCashFlowStatementsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _read_cash_flow_statements_serialize(
        self,
        read_cash_flow_statements_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if read_cash_flow_statements_request is not None:
            _body_params = read_cash_flow_statements_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/accounting-microservice/api/v1/cashflow-statements',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def read_income_statements(
        self,
        read_income_statements_request: ReadIncomeStatementsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ReadIncomeStatementsResponse:
        """Gets Cashfloe Sheets

        Queries income sheets for a business.

        :param read_income_statements_request: (required)
        :type read_income_statements_request: ReadIncomeStatementsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_income_statements_serialize(
            read_income_statements_request=read_income_statements_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReadIncomeStatementsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def read_income_statements_with_http_info(
        self,
        read_income_statements_request: ReadIncomeStatementsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ReadIncomeStatementsResponse]:
        """Gets Cashfloe Sheets

        Queries income sheets for a business.

        :param read_income_statements_request: (required)
        :type read_income_statements_request: ReadIncomeStatementsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_income_statements_serialize(
            read_income_statements_request=read_income_statements_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReadIncomeStatementsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def read_income_statements_without_preload_content(
        self,
        read_income_statements_request: ReadIncomeStatementsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Gets Cashfloe Sheets

        Queries income sheets for a business.

        :param read_income_statements_request: (required)
        :type read_income_statements_request: ReadIncomeStatementsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_income_statements_serialize(
            read_income_statements_request=read_income_statements_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReadIncomeStatementsResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _read_income_statements_serialize(
        self,
        read_income_statements_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if read_income_statements_request is not None:
            _body_params = read_income_statements_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/accounting-microservice/api/v1/income-statements',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def readiness_check(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ReadynessCheckResponse3:
        """Readiness Check

        Performs a readiness check on the service.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._readiness_check_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReadynessCheckResponse3",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def readiness_check_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ReadynessCheckResponse3]:
        """Readiness Check

        Performs a readiness check on the service.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._readiness_check_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReadynessCheckResponse3",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def readiness_check_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Readiness Check

        Performs a readiness check on the service.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._readiness_check_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ReadynessCheckResponse3",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _readiness_check_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/accounting-microservice/api/v1/ready',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    async def update_payroll_profile(
        self,
        update_accounting_profile_request: Annotated[UpdateAccountingProfileRequest, Field(description="Defines a message named UpdateAccountingProfileRequest.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> UpdateAccountingProfileResponse:
        """Update Payroll Profile

        Updates a payroll profile.

        :param update_accounting_profile_request: Defines a message named UpdateAccountingProfileRequest. (required)
        :type update_accounting_profile_request: UpdateAccountingProfileRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_payroll_profile_serialize(
            update_accounting_profile_request=update_accounting_profile_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateAccountingProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    async def update_payroll_profile_with_http_info(
        self,
        update_accounting_profile_request: Annotated[UpdateAccountingProfileRequest, Field(description="Defines a message named UpdateAccountingProfileRequest.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[UpdateAccountingProfileResponse]:
        """Update Payroll Profile

        Updates a payroll profile.

        :param update_accounting_profile_request: Defines a message named UpdateAccountingProfileRequest. (required)
        :type update_accounting_profile_request: UpdateAccountingProfileRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_payroll_profile_serialize(
            update_accounting_profile_request=update_accounting_profile_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateAccountingProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        await response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    async def update_payroll_profile_without_preload_content(
        self,
        update_accounting_profile_request: Annotated[UpdateAccountingProfileRequest, Field(description="Defines a message named UpdateAccountingProfileRequest.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update Payroll Profile

        Updates a payroll profile.

        :param update_accounting_profile_request: Defines a message named UpdateAccountingProfileRequest. (required)
        :type update_accounting_profile_request: UpdateAccountingProfileRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_payroll_profile_serialize(
            update_accounting_profile_request=update_accounting_profile_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UpdateAccountingProfileResponse",
            '400': "ValidationErrorMessageResponse",
            '401': "AuthenticationErrorMessageResponse",
            '402': "PaymentRequiredErrorMessageResponse",
            '403': "ForbiddenErrorMessageResponse",
            '404': "NotFoundErrorMessageResponse",
            '405': "MethodNotAllowedErrorMessageResponse",
            '409': "ConflictErrorMessageResponse",
            '410': "GoneErrorMessageResponse",
            '412': "PreconditionFailedErrorMessageResponse",
            '422': "UnprocessableEntityErrorMessageResponse",
            '425': "TooEarlyErrorMessageResponse",
            '429': "RateLimitErrorMessageResponse",
            '500': "InternalErrorMessageResponse",
            '501': "NotImplementedErrorMessageResponse",
            '502': "BadGatewayErrorMessageResponse",
            '503': "ServiceUnavailableErrorMessageResponse",
            '504': "GatewayTimeoutErrorMessageResponse",
        }
        response_data = await self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_payroll_profile_serialize(
        self,
        update_accounting_profile_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_accounting_profile_request is not None:
            _body_params = update_accounting_profile_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    ''
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json', 
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/accounting-microservice/api/v1/profile',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


