"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RuleMetadata = exports.PackName = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const cdk_nag_1 = require("cdk-nag");
/**
 * Pack name
 *
 */
exports.PackName = "AwsPrototyping";
/**
 * Rule metadata
 *
 */
exports.RuleMetadata = [
    {
        info: "The S3 bucket does not prohibit public access through bucket level settings.",
        explanation: "Keep sensitive data safe from unauthorized remote users by preventing public access at the bucket level.",
        level: cdk_nag_1.NagMessageLevel.ERROR,
        rule: cdk_nag_1.rules.s3.S3BucketLevelPublicAccessProhibited,
    },
    {
        info: "The S3 Bucket does not have object lock enabled.",
        explanation: "Because sensitive data can exist at rest in S3 buckets, enforce object locks at rest to help protect that data.",
        level: cdk_nag_1.NagMessageLevel.WARN,
        rule: cdk_nag_1.rules.s3.S3BucketDefaultLockEnabled,
    },
    {
        info: "The Lambda Function URL allows for public, unauthenticated access.",
        explanation: "AWS Lambda Function URLs allow you to invoke your function via a HTTPS end-point, setting the authentication to NONE allows anyone on the internet to invoke your function.",
        level: cdk_nag_1.NagMessageLevel.ERROR,
        rule: cdk_nag_1.rules.lambda.LambdaFunctionUrlAuth,
    },
];
//# sourceMappingURL=data:application/json;base64,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