from phonenumber_field.serializerfields import PhoneNumberField
from rest_framework import serializers

from garpix_user.mixins.serializers import ToLowerMixin


class RestoreByEmailSerializer(ToLowerMixin, serializers.Serializer):
    email = serializers.EmailField(required=True)


class RestoreByPhoneSerializer(serializers.Serializer):
    phone = PhoneNumberField(required=True)


class RestoreSetPasswordSerializer(serializers.Serializer):
    new_password = serializers.CharField(max_length=255, required=True)


class RestoreCheckCodeSerializer(serializers.Serializer):
    restore_confirmation_code = serializers.CharField(max_length=15, required=True)
