__version__ = "0.0.1"
# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_core.ipynb.

# %% auto 0
__all__ = ['update_factor', 'read_factor']

# %% ../nbs/00_core.ipynb 2
import numpy as np
import pandas as pd
import deeplake
from loguru import logger
import tqdm

# %% ../nbs/00_core.ipynb 4
def __initialize_factor(fac_key:str,fac_df:pd.DataFrame,token:str):
    '''请勿使用此函数'''
    ds_object = deeplake.load("hub://chenzongwei/factor",token=token)
    '''处理df数据的部分'''
    fac_df.index=fac_df.index.strftime('%Y%m%d').astype(int)
    fac_df.columns=fac_df.columns.str.slice(start=0,stop=-3).astype(int)
    fac_df=fac_df.stack().reset_index()
    fac_df.columns=['date','code','fac']
    dates=fac_df.iloc[:,0]
    dates=sorted(list(set(dates)))
    '''创建新的group和tensor'''
    ds_object.create_group(fac_key)
    ds_object[fac_key].create_tensor('value')
    ds_object[fac_key].create_tensor('date', htype = 'class_label')
    logger.success('已经成功创建新的group和tensor')
    '''每天写入'''
    for date in tqdm.auto.tqdm(dates):
        son=fac_df[fac_df.date==date].to_numpy()
        ds_object[fac_key].append({'value':son,'date':date})
    logger.success(f'{dates[0]}到{dates[-1]}的数据全部写入完成了')

# %% ../nbs/00_core.ipynb 5
def update_factor(fac_key:str,fac_df:pd.DataFrame,token:str):
    '''请勿使用此函数'''
    ds_object = deeplake.load("hub://chenzongwei/factor",token=token)
    '''找到最近新增的部分，处理df数据的部分'''
    old_dates=[i[0] for i in ds_object[fac_key].date.numpy().tolist()]
    new_dates=[i for i in list(fac_df.index) if i not in [pd.Timestamp(str(j)) for j in old_dates]]
    fac_df=fac_df[fac_df.index.isin(new_dates)]
    fac_df.index=fac_df.index.strftime('%Y%m%d').astype(int)
    fac_df.columns=fac_df.columns.str.slice(start=0,stop=-3).astype(int)
    fac_df=fac_df.stack().reset_index()
    fac_df.columns=['date','code','fac']
    dates=fac_df.iloc[:,0]
    dates=sorted(list(set(dates)))
    if len(dates)>0:
        '''每天更新写入'''
        for date in tqdm.auto.tqdm(dates):
            son=fac_df[fac_df.date==date].to_numpy()
            ds_object[fac_key].append({'value':son,'date':date})
        logger.success(f'{dates[0]}到{dates[-1]}的数据全部更新完成了')
    else:
        logger.warning('已经是最新的了，无需更新')

# %% ../nbs/00_core.ipynb 6
def read_factor(fac_key:str,token:str,start_date:int=None,end_date:int=None)->pd.DataFrame:
    """通过表名，读取因子数据

    Parameters
    ----------
    fac_key : str
        表的名称
    token : str
        验证码
    start_date : int, optional
        读取因子值的起始日期，形如20130101, by default None
    end_date : int, optional
        读取因子值的终止日期，形如20221231, by default None

    Returns
    -------
    pd.DataFrame
        因子值，index为每天的日期，columns为股票代码，values为因子值
    """    
    def wind_code(x):
        if x[0] in ['0','3']:
            return x+'.SZ'
        elif x[0]=='6':
            return x+'.SH'
        elif x[0]=='8':
            return x+'.BJ'
        else:
            return x+'.UN'
    ds_object = deeplake.load("hub://chenzongwei/factor",token=token)
    '''找到起止日期的序号'''
    all_dates=[i[0] for i in ds_object[fac_key].date.numpy().tolist()]
    if start_date is not None:
        start_num=all_dates.index(start_date)
    else:
        start_num=0
    if end_date is not None:
        fac_data=np.vstack(ds_object[fac_key].value[start_num:(all_dates.index(end_date)+1)].numpy(aslist=True))
    else:
        fac_data=np.vstack(ds_object[fac_key].value[start_num:].numpy(aslist=True))
    '''整理数据'''
    fac_data=pd.DataFrame(fac_data,columns=['date','code',fac_key])
    fac_data.date=pd.to_datetime(fac_data.date.astype(int).astype(str),format='%Y%m%d')
    fac_data.code=fac_data.code.astype(int).astype(str).str.zfill(6)
    fac_data=fac_data.pivot(index='date',columns='code',values=fac_key)
    fac_data.columns=[wind_code(i) for i in list(fac_data.columns)]
    return fac_data
