import * as apigwy from '@aws-cdk/aws-apigatewayv2-alpha';
import { RemovalPolicy } from 'aws-cdk-lib';
import * as acm from 'aws-cdk-lib/aws-certificatemanager';
import * as cf from 'aws-cdk-lib/aws-cloudfront';
import * as cforigins from 'aws-cdk-lib/aws-cloudfront-origins';
import * as r53 from 'aws-cdk-lib/aws-route53';
import * as s3 from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
/**
 * Represents a MicroApps CloudFront
 */
export interface IMicroAppsCF {
    /**
     * The CloudFront distribution
     */
    readonly cloudFrontDistro: cf.Distribution;
}
/**
 * Properties to initialize an instance of `MicroAppsCF`.
 */
export interface MicroAppsCFProps {
    /**
     * RemovalPolicy override for child resources
     *
     * Note: if set to DESTROY the S3 buckes will have `autoDeleteObjects` set to `true`
     *
     * @default - per resource default
     */
    readonly removalPolicy?: RemovalPolicy;
    /**
     * S3 bucket origin for deployed applications
     */
    readonly bucketAppsOrigin: cforigins.S3Origin;
    /**
     * S3 bucket for CloudFront logs
     */
    readonly bucketLogs?: s3.IBucket;
    /**
     * CloudFront Distribution domain name
     *
     * @example apps.pwrdrvr.com
     * @default auto-assigned
     */
    readonly domainNameEdge?: string;
    /**
     * API Gateway custom origin domain name
     *
     * @example apps.pwrdrvr.com
     * @default - retrieved from httpApi, if possible
     */
    readonly domainNameOrigin?: string;
    /**
     * API Gateway v2 HTTP API for apps
     */
    readonly httpApi?: apigwy.HttpApi;
    /**
     * Optional asset name root
     *
     * @example microapps
     * @default - resource names auto assigned
     */
    readonly assetNameRoot?: string;
    /**
     * Optional asset name suffix
     *
     * @example -dev-pr-12
     * @default none
     */
    readonly assetNameSuffix?: string;
    /**
     * ACM Certificate that covers `domainNameEdge` name
     */
    readonly certEdge?: acm.ICertificate;
    /**
     * Route53 zone in which to create optional `domainNameEdge` record
     */
    readonly r53Zone?: r53.IHostedZone;
    /**
     * Path prefix on the root of the CloudFront distribution
     *
     * @example dev/
     */
    readonly rootPathPrefix?: string;
    /**
     * Create an extra Behavior (Route) for /api/ that allows
     * API routes to have a period in them.
     *
     * When false API routes with a period in the path will get routed to S3.
     *
     * When true API routes that contain /api/ in the path will get routed to API Gateway
     * even if they have a period in the path.
     *
     * @default true if httpApi is provided
     */
    readonly createAPIPathRoute?: boolean;
    /**
     * Create an extra Behavior (Route) for /_next/data/
     * This route is used by Next.js to load data from the API Gateway
     * on `getServerSideProps` calls.  The requests can end in `.json`,
     * which would cause them to be routed to S3 if this route is not created.
     *
     * When false API routes with a period in the path will get routed to S3.
     *
     * When true API routes that contain /_next/data/ in the path will get routed to API Gateway
     * even if they have a period in the path.
     *
     * @default true if httpApi is provided
     */
    readonly createNextDataPathRoute?: boolean;
    /**
     * Configuration of the edge to origin lambda functions
     *
     * @default - no edge to API Gateway origin functions added
     */
    readonly edgeLambdas?: cf.EdgeLambda[];
    /**
     * Optional Origin Shield Region
     *
     * This should be the region where the DynamoDB is located so the
     * EdgeToOrigin calls have the lowest latency (~1 ms).
     *
     * @default - none
     */
    readonly originShieldRegion?: string;
}
/**
 * Options for the `CreateAPIOriginPolicy`
 */
export interface CreateAPIOriginPolicyOptions {
    /**
     * Optional asset name root
     *
     * @example microapps
     * @default - resource names auto assigned
     */
    readonly assetNameRoot?: string;
    /**
     * Optional asset name suffix
     *
     * @example -dev-pr-12
     * @default none
     */
    readonly assetNameSuffix?: string;
    /**
     * Edge domain name used by CloudFront - If set a custom
     * OriginRequestPolicy will be created that prevents
     * the Host header from being passed to the origin.
     */
    readonly domainNameEdge?: string;
}
/**
 * Options for `AddRoutes`
 */
export interface AddRoutesOptions {
    /**
     * Default origin (invalid URL or API Gateway)
     *
     * @default invalid URL (never used)
     */
    readonly appOrigin: cf.IOrigin;
    /**
     * S3 Bucket CloudFront Origin for static assets
     */
    readonly bucketAppsOrigin: cforigins.S3Origin;
    /**
     * CloudFront Distribution to add the Behaviors (Routes) to
     */
    readonly distro: cf.Distribution;
    /**
     * Origin Request policy for API Gateway Origin
     */
    readonly appOriginRequestPolicy: cf.IOriginRequestPolicy;
    /**
     * Path prefix on the root of the CloudFront distribution
     *
     * @example dev/
     */
    readonly rootPathPrefix?: string;
    /**
     * Create an extra Behavior (Route) for /api/ that allows
     * API routes to have a period in them.
     *
     * When false API routes with a period in the path will get routed to S3.
     *
     * When true API routes that contain /api/ in the path will get routed to API Gateway
     * even if they have a period in the path.
     *
     * @default false
     */
    readonly createAPIPathRoute?: boolean;
    /**
     * Create an extra Behavior (Route) for /_next/data/
     * This route is used by Next.js to load data from the API Gateway
     * on `getServerSideProps` calls.  The requests can end in `.json`,
     * which would cause them to be routed to S3 if this route is not created.
     *
     * When false API routes with a period in the path will get routed to S3.
     *
     * When true API routes that contain /_next/data/ in the path will get routed to API Gateway
     * even if they have a period in the path.
     *
     * @default false
     */
    readonly createNextDataPathRoute?: boolean;
    /**
     * Edge lambdas to associate with the API Gateway routes
     */
    readonly edgeLambdas?: cf.EdgeLambda[];
}
/**
 * Create a new MicroApps CloudFront Distribution.
 */
export declare class MicroAppsCF extends Construct implements IMicroAppsCF {
    /**
     * Create or get the origin request policy
     *
     * If a custom domain name is NOT used for the origin then a policy
     * will be created.
     *
     * If a custom domain name IS used for the origin then the ALL_VIEWER
     * policy will be returned.  This policy passes the Host header to the
     * origin, which is fine when using a custom domain name on the origin.
     *
     * @param _scope
     * @param _props
     */
    static createAPIOriginPolicy(_scope: Construct, _props: CreateAPIOriginPolicyOptions): cf.IOriginRequestPolicy;
    /**
     * Add API Gateway and S3 routes to an existing CloudFront Distribution
     * @param _scope
     * @param props
     */
    static addRoutes(_scope: Construct, props: AddRoutesOptions): void;
    private _cloudFrontDistro;
    get cloudFrontDistro(): cf.Distribution;
    constructor(scope: Construct, id: string, props: MicroAppsCFProps);
}
//# sourceMappingURL=MicroAppsCF.d.ts.map