"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicroApps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const MicroAppsAPIGwy_1 = require("./MicroAppsAPIGwy");
const MicroAppsCF_1 = require("./MicroAppsCF");
const MicroAppsEdgeToOrigin_1 = require("./MicroAppsEdgeToOrigin");
const MicroAppsS3_1 = require("./MicroAppsS3");
const MicroAppsSvcs_1 = require("./MicroAppsSvcs");
const ReverseDomain_1 = require("./utils/ReverseDomain");
/**
 * Create a new MicroApps "turnkey" construct for simple
 * deployments and for initial evaulation of the MicroApps framework.
 *
 * Use this construct to create a PoC working entire stack.
 *
 * Do not use this construct when adding MicroApps to an existing
 * CloudFront, API Gateway, S3 Bucket, etc. or where access
 * to all features of the AWS Resources are needed (e.g. to
 * add additional Behaviors to the CloudFront distribution, set authorizors
 * on API Gateway, etc.).
 *
 * @warning This construct is not intended for production use.
 * In a production stack the DynamoDB Table, API Gateway, S3 Buckets,
 * etc. should be created in a "durable" stack where the IDs will not
 * change and where changes to the MicroApps construct will not
 * cause failures to deploy or data to be deleted.
 *
 *  @see {@link https://github.com/pwrdrvr/microapps-core/blob/main/packages/cdk/lib/MicroApps.ts | example usage in a CDK Stack }
 */
class MicroApps extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        if (props === undefined) {
            throw new Error('props must be set');
        }
        const { domainNameEdge, domainNameOrigin, assetNameRoot, assetNameSuffix, r53Zone, certEdge, appEnv = 'dev', certOrigin, removalPolicy, s3PolicyBypassAROAs, s3PolicyBypassPrincipalARNs, s3StrictBucketPolicy, rootPathPrefix, createAPIGateway = false, createAPIPathRoute = true, createNextDataPathRoute = true, addXForwardedHostHeader = true, replaceHostHeader = true, signingMode = 'sign', originRegion, table, tableNameForEdgeToOrigin, originShieldRegion = originRegion, allowedFunctionUrlAccounts = [], } = props;
        this._s3 = new MicroAppsS3_1.MicroAppsS3(this, 's3', {
            removalPolicy,
            bucketLogsName: domainNameEdge ? `${ReverseDomain_1.reverseDomain(domainNameEdge)}-logs` : undefined,
            bucketAppsName: domainNameEdge ? `${ReverseDomain_1.reverseDomain(domainNameEdge)}` : undefined,
            bucketAppsStagingName: domainNameEdge
                ? `${ReverseDomain_1.reverseDomain(domainNameEdge)}-staging`
                : undefined,
            assetNameRoot,
            assetNameSuffix,
            originShieldRegion,
        });
        if (createAPIGateway) {
            this._apigwy = new MicroAppsAPIGwy_1.MicroAppsAPIGwy(this, 'api', {
                removalPolicy,
                assetNameRoot,
                assetNameSuffix,
                domainNameEdge,
                domainNameOrigin,
                r53Zone,
                certOrigin,
                rootPathPrefix,
                requireIAMAuthorization: signingMode !== 'none',
            });
        }
        this._svcs = new MicroAppsSvcs_1.MicroAppsSvcs(this, 'svcs', {
            ...(this._apigwy ? { httpApi: this._apigwy.httpApi } : {}),
            removalPolicy,
            bucketApps: this._s3.bucketApps,
            bucketAppsOAI: this._s3.bucketAppsOAI,
            bucketAppsStaging: this._s3.bucketAppsStaging,
            assetNameRoot,
            assetNameSuffix,
            appEnv,
            s3PolicyBypassAROAs,
            s3PolicyBypassPrincipalARNs,
            s3StrictBucketPolicy,
            rootPathPrefix,
            requireIAMAuthorization: signingMode !== 'none',
            table,
        });
        const edgeLambdas = [];
        if (signingMode !== 'none' || replaceHostHeader || addXForwardedHostHeader) {
            this._edgeToOrigin = new MicroAppsEdgeToOrigin_1.MicroAppsEdgeToOrigin(this, 'edgeToOrigin', {
                assetNameRoot,
                assetNameSuffix,
                removalPolicy,
                addXForwardedHostHeader,
                setupApiGatewayPermissions: createAPIGateway,
                replaceHostHeader,
                originRegion,
                signingMode,
                rootPathPrefix,
                tableRulesArn: tableNameForEdgeToOrigin || this._svcs.table.tableName,
                allowedFunctionUrlAccounts,
            });
            edgeLambdas.push(...this._edgeToOrigin.edgeToOriginLambdas);
        }
        // Add any extra lambdas
        if ((_b = props.edgeLambdas) === null || _b === void 0 ? void 0 : _b.length) {
            edgeLambdas.push(...props.edgeLambdas);
        }
        this._cf = new MicroAppsCF_1.MicroAppsCF(this, 'cft', {
            removalPolicy,
            assetNameRoot,
            assetNameSuffix,
            domainNameEdge,
            domainNameOrigin,
            ...(this._apigwy ? { httpApi: this._apigwy.httpApi } : {}),
            r53Zone,
            certEdge,
            bucketAppsOrigin: this._s3.bucketAppsOrigin,
            bucketLogs: this._s3.bucketLogs,
            rootPathPrefix,
            createAPIPathRoute,
            createNextDataPathRoute,
            originShieldRegion,
            ...(edgeLambdas.length ? { edgeLambdas } : {}),
        });
    }
    get cf() {
        return this._cf;
    }
    get edgeToOrigin() {
        return this._edgeToOrigin;
    }
    get s3() {
        return this._s3;
    }
    get apigwy() {
        return this._apigwy;
    }
    get svcs() {
        return this._svcs;
    }
}
exports.MicroApps = MicroApps;
_a = JSII_RTTI_SYMBOL_1;
MicroApps[_a] = { fqn: "@pwrdrvr/microapps-cdk.MicroApps", version: "0.4.0-alpha.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiTWljcm9BcHBzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL01pY3JvQXBwcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUtBLDJDQUF1QztBQUN2Qyx1REFBc0U7QUFDdEUsK0NBQTBEO0FBQzFELG1FQUF3RjtBQUN4RiwrQ0FBMEQ7QUFDMUQsbURBQWdFO0FBQ2hFLHlEQUFzRDtBQTJUdEQ7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7R0FtQkc7QUFDSCxNQUFhLFNBQVUsU0FBUSxzQkFBUztJQTBCdEMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFzQjs7UUFDOUQsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDdkIsTUFBTSxJQUFJLEtBQUssQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO1NBQ3RDO1FBRUQsTUFBTSxFQUNKLGNBQWMsRUFDZCxnQkFBZ0IsRUFDaEIsYUFBYSxFQUNiLGVBQWUsRUFDZixPQUFPLEVBQ1AsUUFBUSxFQUNSLE1BQU0sR0FBRyxLQUFLLEVBQ2QsVUFBVSxFQUNWLGFBQWEsRUFDYixtQkFBbUIsRUFDbkIsMkJBQTJCLEVBQzNCLG9CQUFvQixFQUNwQixjQUFjLEVBQ2QsZ0JBQWdCLEdBQUcsS0FBSyxFQUN4QixrQkFBa0IsR0FBRyxJQUFJLEVBQ3pCLHVCQUF1QixHQUFHLElBQUksRUFDOUIsdUJBQXVCLEdBQUcsSUFBSSxFQUM5QixpQkFBaUIsR0FBRyxJQUFJLEVBQ3hCLFdBQVcsR0FBRyxNQUFNLEVBQ3BCLFlBQVksRUFDWixLQUFLLEVBQ0wsd0JBQXdCLEVBQ3hCLGtCQUFrQixHQUFHLFlBQVksRUFDakMsMEJBQTBCLEdBQUcsRUFBRSxHQUNoQyxHQUFHLEtBQUssQ0FBQztRQUVWLElBQUksQ0FBQyxHQUFHLEdBQUcsSUFBSSx5QkFBVyxDQUFDLElBQUksRUFBRSxJQUFJLEVBQUU7WUFDckMsYUFBYTtZQUNiLGNBQWMsRUFBRSxjQUFjLENBQUMsQ0FBQyxDQUFDLEdBQUcsNkJBQWEsQ0FBQyxjQUFjLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxTQUFTO1lBQ3BGLGNBQWMsRUFBRSxjQUFjLENBQUMsQ0FBQyxDQUFDLEdBQUcsNkJBQWEsQ0FBQyxjQUFjLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxTQUFTO1lBQy9FLHFCQUFxQixFQUFFLGNBQWM7Z0JBQ25DLENBQUMsQ0FBQyxHQUFHLDZCQUFhLENBQUMsY0FBYyxDQUFDLFVBQVU7Z0JBQzVDLENBQUMsQ0FBQyxTQUFTO1lBQ2IsYUFBYTtZQUNiLGVBQWU7WUFDZixrQkFBa0I7U0FDbkIsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxnQkFBZ0IsRUFBRTtZQUNwQixJQUFJLENBQUMsT0FBTyxHQUFHLElBQUksaUNBQWUsQ0FBQyxJQUFJLEVBQUUsS0FBSyxFQUFFO2dCQUM5QyxhQUFhO2dCQUNiLGFBQWE7Z0JBQ2IsZUFBZTtnQkFDZixjQUFjO2dCQUNkLGdCQUFnQjtnQkFDaEIsT0FBTztnQkFDUCxVQUFVO2dCQUNWLGNBQWM7Z0JBQ2QsdUJBQXVCLEVBQUUsV0FBVyxLQUFLLE1BQU07YUFDaEQsQ0FBQyxDQUFDO1NBQ0o7UUFDRCxJQUFJLENBQUMsS0FBSyxHQUFHLElBQUksNkJBQWEsQ0FBQyxJQUFJLEVBQUUsTUFBTSxFQUFFO1lBQzNDLEdBQUcsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUFFLE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7WUFDMUQsYUFBYTtZQUNiLFVBQVUsRUFBRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVU7WUFDL0IsYUFBYSxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsYUFBYTtZQUNyQyxpQkFBaUIsRUFBRSxJQUFJLENBQUMsR0FBRyxDQUFDLGlCQUFpQjtZQUM3QyxhQUFhO1lBQ2IsZUFBZTtZQUNmLE1BQU07WUFDTixtQkFBbUI7WUFDbkIsMkJBQTJCO1lBQzNCLG9CQUFvQjtZQUNwQixjQUFjO1lBQ2QsdUJBQXVCLEVBQUUsV0FBVyxLQUFLLE1BQU07WUFDL0MsS0FBSztTQUNOLENBQUMsQ0FBQztRQUNILE1BQU0sV0FBVyxHQUFvQixFQUFFLENBQUM7UUFFeEMsSUFBSSxXQUFXLEtBQUssTUFBTSxJQUFJLGlCQUFpQixJQUFJLHVCQUF1QixFQUFFO1lBQzFFLElBQUksQ0FBQyxhQUFhLEdBQUcsSUFBSSw2Q0FBcUIsQ0FBQyxJQUFJLEVBQUUsY0FBYyxFQUFFO2dCQUNuRSxhQUFhO2dCQUNiLGVBQWU7Z0JBQ2YsYUFBYTtnQkFDYix1QkFBdUI7Z0JBQ3ZCLDBCQUEwQixFQUFFLGdCQUFnQjtnQkFDNUMsaUJBQWlCO2dCQUNqQixZQUFZO2dCQUNaLFdBQVc7Z0JBQ1gsY0FBYztnQkFDZCxhQUFhLEVBQUUsd0JBQXdCLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsU0FBUztnQkFDckUsMEJBQTBCO2FBQzNCLENBQUMsQ0FBQztZQUVILFdBQVcsQ0FBQyxJQUFJLENBQUMsR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDLG1CQUFtQixDQUFDLENBQUM7U0FDN0Q7UUFDRCx3QkFBd0I7UUFDeEIsVUFBSSxLQUFLLENBQUMsV0FBVywwQ0FBRSxNQUFNLEVBQUU7WUFDN0IsV0FBVyxDQUFDLElBQUksQ0FBQyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUMsQ0FBQztTQUN4QztRQUNELElBQUksQ0FBQyxHQUFHLEdBQUcsSUFBSSx5QkFBVyxDQUFDLElBQUksRUFBRSxLQUFLLEVBQUU7WUFDdEMsYUFBYTtZQUNiLGFBQWE7WUFDYixlQUFlO1lBQ2YsY0FBYztZQUNkLGdCQUFnQjtZQUNoQixHQUFHLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRSxPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDO1lBQzFELE9BQU87WUFDUCxRQUFRO1lBQ1IsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxnQkFBZ0I7WUFDM0MsVUFBVSxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVTtZQUMvQixjQUFjO1lBQ2Qsa0JBQWtCO1lBQ2xCLHVCQUF1QjtZQUN2QixrQkFBa0I7WUFDbEIsR0FBRyxDQUFDLFdBQVcsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsV0FBVyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztTQUMvQyxDQUFDLENBQUM7SUFDTCxDQUFDO0lBMUlELElBQVcsRUFBRTtRQUNYLE9BQU8sSUFBSSxDQUFDLEdBQUcsQ0FBQztJQUNsQixDQUFDO0lBR0QsSUFBVyxZQUFZO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQztJQUM1QixDQUFDO0lBR0QsSUFBVyxFQUFFO1FBQ1gsT0FBTyxJQUFJLENBQUMsR0FBRyxDQUFDO0lBQ2xCLENBQUM7SUFHRCxJQUFXLE1BQU07UUFDZixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUM7SUFDdEIsQ0FBQztJQUdELElBQVcsSUFBSTtRQUNiLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDOztBQXhCSCw4QkE2SUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBSZW1vdmFsUG9saWN5IH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0ICogYXMgYWNtIGZyb20gJ2F3cy1jZGstbGliL2F3cy1jZXJ0aWZpY2F0ZW1hbmFnZXInO1xuaW1wb3J0ICogYXMgY2YgZnJvbSAnYXdzLWNkay1saWIvYXdzLWNsb3VkZnJvbnQnO1xuaW1wb3J0ICogYXMgZHluYW1vZGIgZnJvbSAnYXdzLWNkay1saWIvYXdzLWR5bmFtb2RiJztcbmltcG9ydCAqIGFzIHI1MyBmcm9tICdhd3MtY2RrLWxpYi9hd3Mtcm91dGU1Myc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IElNaWNyb0FwcHNBUElHd3ksIE1pY3JvQXBwc0FQSUd3eSB9IGZyb20gJy4vTWljcm9BcHBzQVBJR3d5JztcbmltcG9ydCB7IElNaWNyb0FwcHNDRiwgTWljcm9BcHBzQ0YgfSBmcm9tICcuL01pY3JvQXBwc0NGJztcbmltcG9ydCB7IElNaWNyb0FwcHNFZGdlVG9PcmlnaW4sIE1pY3JvQXBwc0VkZ2VUb09yaWdpbiB9IGZyb20gJy4vTWljcm9BcHBzRWRnZVRvT3JpZ2luJztcbmltcG9ydCB7IElNaWNyb0FwcHNTMywgTWljcm9BcHBzUzMgfSBmcm9tICcuL01pY3JvQXBwc1MzJztcbmltcG9ydCB7IElNaWNyb0FwcHNTdmNzLCBNaWNyb0FwcHNTdmNzIH0gZnJvbSAnLi9NaWNyb0FwcHNTdmNzJztcbmltcG9ydCB7IHJldmVyc2VEb21haW4gfSBmcm9tICcuL3V0aWxzL1JldmVyc2VEb21haW4nO1xuXG4vKipcbiAqIEEgQ0RLIENvbnN0cnVjdCBmb3IgY3JlYXRpbmcgYSBNaWNyb0FwcHMgcnVudGltZSBlbnZpcm9ubWVudCB1c2VkXG4gKiB0byBob3N0IE5leHQuanMsIFJlYWN0LCBvciBhbnkgb3RoZXIgc29ydCBvZiB3ZWIgYXBwbGljYXRpb24gd2l0aFxuICogbXVsdGlwbGUgdmVyc2lvbnMgYXZhaWxhYmxlIGZvciBjb21wYXJpc29uLCBxdWljayByb2xsYmFja3MsIHF1aWNrXG4gKiByZWxlYXNlcywgYW5kIGEgY29tcGxldGUgbGFjayBvZiB1c2VyIGRpc3R1cmJhbmNlIG9uIGRlcGxveXMuXG4gKlxuICogQHJlbWFya3NcbiAqXG4gKiB7QGxpbmsgTWljcm9BcHBzfSBwcm92aWRlcyBhIHR1cm4ta2V5IGNvbnN0cnVjdCB0aGF0IGNyZWF0ZXMgYWxsXG4gKiBkZXBlbmRlbmNpZXMgd2l0aCBsaW1pdGVkIGV4cG9zdXJlIG9mIHVuZGVybHlpbmcgQVdTIFJlc291cmNlIG9wdGlvbnMuXG4gKiBUaGlzIGNvbnN0cnVjdCBpcyB0aGUgZWFzaWVzdCB0byB1c2Ugd2hlbiBleHBsb3JpbmcgTWljcm9BcHBzIGZvciB0aGVcbiAqIGZpcnN0IHRpbWUuXG4gKlxuICoge0BsaW5rIE1pY3JvQXBwc0FQSUd3eX0sIHtAbGluayBNaWNyb0FwcHNDRn0sIHtAbGluayBNaWNyb0FwcHNTM30sXG4gKiBhbmQge0BsaW5rIE1pY3JvQXBwc1N2Y3N9LCBhbmQgdGhlaXIgaGVscGVyIHN0YXRpYyBtZXRob2RzLCBjYW4gYmUgdXNlZFxuICogdG8gY3JlYXRlIEFXUyBSZXNvdXJjZXMgbW9yZSBkaXJlY3RseSwgdG8gcHJvdmlkZSB5b3VyIG93biBBV1MgUmVzb3VyY2VzXG4gKiAoZS5nLiBhbiBleGlzdGluZyBDbG91ZEZyb250IERpc3RyaWJ1dGlvbiksIGFuZCB0byBoYXZlIG1vcmUgZmxleGliaWxpdHlcbiAqIHRoYW4gdGhlIHtAbGluayBNaWNyb0FwcHN9IGNvbnN0cnVjdCBvZmZlcnMuXG4gKlxuICogQHBhY2thZ2VEb2N1bWVudGF0aW9uXG4gKi9cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIHRvIGluaXRpYWxpemUgYW4gaW5zdGFuY2Ugb2YgYE1pY3JvQXBwc2AuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgTWljcm9BcHBzUHJvcHMge1xuICAvKipcbiAgICogUmVtb3ZhbFBvbGljeSBvdmVycmlkZSBmb3IgY2hpbGQgcmVzb3VyY2VzXG4gICAqXG4gICAqIE5vdGU6IGlmIHNldCB0byBERVNUUk9ZIHRoZSBTMyBidWNrZXMgd2lsbCBoYXZlIGBhdXRvRGVsZXRlT2JqZWN0c2Agc2V0IHRvIGB0cnVlYFxuICAgKlxuICAgKiBAZGVmYXVsdCAtIHBlciByZXNvdXJjZSBkZWZhdWx0XG4gICAqL1xuICByZWFkb25seSByZW1vdmFsUG9saWN5PzogUmVtb3ZhbFBvbGljeTtcblxuICAvKipcbiAgICogUGFzc2VkIHRvIE5PREVfRU5WIG9mIFJvdXRlciBhbmQgRGVwbG95ZXIgTGFtYmRhIGZ1bmN0aW9ucy5cbiAgICpcbiAgICogQGRlZmF1bHQgZGV2XG4gICAqL1xuICByZWFkb25seSBhcHBFbnY6IHN0cmluZztcblxuICAvKipcbiAgICogT3B0aW9uYWwgYXNzZXQgbmFtZSByb290XG4gICAqXG4gICAqIEBleGFtcGxlIG1pY3JvYXBwc1xuICAgKiBAZGVmYXVsdCAtIHJlc291cmNlIG5hbWVzIGF1dG8gYXNzaWduZWRcbiAgICovXG4gIHJlYWRvbmx5IGFzc2V0TmFtZVJvb3Q/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIE9wdGlvbmFsIGFzc2V0IG5hbWUgc3VmZml4XG4gICAqXG4gICAqIEBleGFtcGxlIC1kZXYtcHItMTJcbiAgICogQGRlZmF1bHQgbm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgYXNzZXROYW1lU3VmZml4Pzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBSb3V0ZTUzIHpvbmUgaW4gd2hpY2ggdG8gY3JlYXRlIG9wdGlvbmFsIGBkb21haW5OYW1lRWRnZWAgcmVjb3JkXG4gICAqL1xuICByZWFkb25seSByNTNab25lPzogcjUzLklIb3N0ZWRab25lO1xuXG4gIC8qKlxuICAgKiBDZXJ0aWZpY2F0ZSBpbiBVUy1FYXN0LTEgZm9yIHRoZSBDbG91ZEZyb250IGRpc3RyaWJ1dGlvbi5cbiAgICovXG4gIHJlYWRvbmx5IGNlcnRFZGdlPzogYWNtLklDZXJ0aWZpY2F0ZTtcblxuICAvKipcbiAgICogQ2VydGlmaWNhdGUgaW4gZGVwbG95ZWQgcmVnaW9uIGZvciB0aGUgQVBJIEdhdGV3YXkuXG4gICAqL1xuICByZWFkb25seSBjZXJ0T3JpZ2luPzogYWNtLklDZXJ0aWZpY2F0ZTtcblxuICAvKipcbiAgICogVXNlIGEgc3RyaWN0IFMzIEJ1Y2tldCBQb2xpY3kgdGhhdCBwcmV2ZW50cyBhcHBsaWNhdGlvbnNcbiAgICogZnJvbSByZWFkaW5nL3dyaXRpbmcvbW9kaWZ5aW5nL2RlbGV0aW5nIGZpbGVzIGluIHRoZSBTMyBCdWNrZXRcbiAgICogb3V0c2lkZSBvZiB0aGUgcGF0aCB0aGF0IGlzIHNwZWNpZmljIHRvIHRoZWlyIGFwcC92ZXJzaW9uLlxuICAgKlxuICAgKiBUaGlzIHNldHRpbmcgc2hvdWxkIGJlIHVzZWQgd2hlbiBhcHBsaWNhdGlvbnMgYXJlIGxlc3MgdGhhblxuICAgKiBmdWxseSB0cnVzdGVkLlxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgczNTdHJpY3RCdWNrZXRQb2xpY3k/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBBcHBsaWVzIHdoZW4gdXNpbmcgczNTdHJpY3RCdWNrZXRQb2xpY3kgPSB0cnVlXG4gICAqXG4gICAqIElBTSBSb2xlIG9yIElBTSBVc2VyIG5hbWVzIHRvIGV4Y2x1ZGUgZnJvbSB0aGUgREVOWSBydWxlcyBvbiB0aGUgUzMgQnVja2V0IFBvbGljeS5cbiAgICpcbiAgICogUm9sZXMgdGhhdCBhcmUgQXNzdW1lZCBtdXN0IGluc3RlYWQgaGF2ZSB0aGVpciBBUk9BIGFkZGVkIHRvIGBzM1BvbGljeUJ5cGFzc0FST0FzYC5cbiAgICpcbiAgICogVHlwaWNhbGx5IGFueSBhZG1pbiByb2xlcyAvIHVzZXJzIHRoYXQgbmVlZCB0byB2aWV3IG9yIG1hbmFnZSB0aGUgUzMgQnVja2V0XG4gICAqIHdvdWxkIGJlIGFkZGVkIHRvIHRoaXMgbGlzdC5cbiAgICpcbiAgICogQGV4YW1wbGUgWydhcm46YXdzOmlhbTo6MTIzNDU2Nzg5MDEyMzpyb2xlL0FkbWluQWNjZXNzJywgJ2Fybjphd3M6aWFtOjoxMjM0NTY3ODkwMTIzOnVzZXIvTXlBZG1pblVzZXInXVxuICAgKlxuICAgKiBAc2VlIHMzUG9saWN5QnlwYXNzQVJPQXNcbiAgICovXG4gIHJlYWRvbmx5IHMzUG9saWN5QnlwYXNzUHJpbmNpcGFsQVJOcz86IHN0cmluZ1tdO1xuXG4gIC8qKlxuICAgKiBBcHBsaWVzIHdoZW4gdXNpbmcgczNTdHJpY3RCdWNrZXRQb2xpY3kgPSB0cnVlXG4gICAqXG4gICAqIEFST0FzIG9mIHRoZSBJQU0gUm9sZSB0byBleGNsdWRlIGZyb20gdGhlIERFTlkgcnVsZXMgb24gdGhlIFMzIEJ1Y2tldCBQb2xpY3kuXG4gICAqIFRoaXMgYWxsb3dzIHNlc3Npb25zIHRoYXQgYXNzdW1lIHRoZSBJQU0gUm9sZSB0byBiZSBleGNsdWRlZCBmcm9tIHRoZVxuICAgKiBERU5ZIHJ1bGVzIG9uIHRoZSBTMyBCdWNrZXQgUG9saWN5LlxuICAgKlxuICAgKiBUeXBpY2FsbHkgYW55IGFkbWluIHJvbGVzIC8gdXNlcnMgdGhhdCBuZWVkIHRvIHZpZXcgb3IgbWFuYWdlIHRoZSBTMyBCdWNrZXRcbiAgICogd291bGQgYmUgYWRkZWQgdG8gdGhpcyBsaXN0LlxuICAgKlxuICAgKiBSb2xlcyAvIHVzZXJzIHRoYXQgYXJlIHVzZWQgZGlyZWN0bHksIG5vdCBhc3N1bWVkLCBjYW4gYmUgYWRkZWQgdG8gYHMzUG9saWN5QnlwYXNzUm9sZU5hbWVzYCBpbnN0ZWFkLlxuICAgKlxuICAgKiBOb3RlOiBUaGlzIEFST0EgbXVzdCBiZSBzcGVjaWZpZWQgdG8gcHJldmVudCB0aGlzIHBvbGljeSBmcm9tIGxvY2tpbmdcbiAgICogb3V0IG5vbi1yb290IHNlc3Npb25zIHRoYXQgaGF2ZSBhc3N1bWVkIHRoZSBhZG1pbiByb2xlLlxuICAgKlxuICAgKiBUaGUgbm90UHJpbmNpcGFscyB3aWxsIG9ubHkgbWF0Y2ggdGhlIHJvbGUgbmFtZSBleGFjdGx5IGFuZCB3aWxsIG5vdCBtYXRjaFxuICAgKiBhbnkgc2Vzc2lvbiB0aGF0IGhhcyBhc3N1bWVkIHRoZSByb2xlIHNpbmNlIG5vdFByaW5jaXBhbHMgZG9lcyBub3QgYWxsb3dcbiAgICogd2lsZGNhcmQgbWF0Y2hlcyBhbmQgZG9lcyBub3QgZG8gd2lsZGNhcmQgbWF0Y2hlcyBpbXBsaWNpdGx5IGVpdGhlci5cbiAgICpcbiAgICogVGhlIEFST0EgbXVzdCBiZSB1c2VkIGJlY2F1c2UgdGhlcmUgYXJlIG9ubHkgMyBQcmluY2lwYWwgdmFyaWFibGVzIGF2YWlsYWJsZTpcbiAgICogIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfdmFyaWFibGVzLmh0bWwjcHJpbmNpcGFsdGFibGVcbiAgICogIGF3czp1c2VybmFtZSwgYXdzOnVzZXJpZCwgYXdzOlByaW5jaXBhbFRhZ1xuICAgKlxuICAgKiBGb3IgYW4gYXNzdW1lZCByb2xlLCBhd3M6dXNlcm5hbWUgaXMgYmxhbmssIGF3czp1c2VyaWQgaXM6XG4gICAqICBbdW5pcXVlIGlkIEFLQSBBUk9BIGZvciBSb2xlXTpbc2Vzc2lvbiBuYW1lXVxuICAgKlxuICAgKiBUYWJsZSBvZiB1bmlxdWUgSUQgcHJlZml4ZXMgc3VjaCBhcyBBUk9BOlxuICAgKiAgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9pZGVudGlmaWVycy5odG1sI2lkZW50aWZpZXJzLXByZWZpeGVzXG4gICAqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSByb2xlIGlzIHNpbXBseSBub3QgYXZhaWxhYmxlIGZvciBhbiBhc3N1bWVkIHJvbGUgYW5kLCBpZiBpdCB3YXMsXG4gICAqIGEgY29tcGxpY2F0ZWQgY29tcGFyaXNvbiB3b3VsZCBiZSByZXF1aWVyZCB0byBwcmV2ZW50IGV4Y2x1c2lvblxuICAgKiBvZiBhcHBseWluZyB0aGUgRGVueSBSdWxlIHRvIHJvbGVzIGZyb20gb3RoZXIgYWNjb3VudHMuXG4gICAqXG4gICAqIFRvIGdldCB0aGUgQVJPQSB3aXRoIHRoZSBBV1MgQ0xJOlxuICAgKiAgIGF3cyBpYW0gZ2V0LXJvbGUgLS1yb2xlLW5hbWUgUk9MRS1OQU1FXG4gICAqICAgYXdzIGlhbSBnZXQtdXNlciAt4oCTdXNlci1uYW1lIFVTRVItTkFNRVxuICAgKlxuICAgKiBAZXhhbXBsZSBbICdBUk9BMTIzNDU2Nzg5MDEyMycgXVxuICAgKlxuICAgKiBAc2VlIHMzU3RyaWN0QnVja2V0UG9saWN5XG4gICAqL1xuICByZWFkb25seSBzM1BvbGljeUJ5cGFzc0FST0FzPzogc3RyaW5nW107XG5cbiAgLyoqXG4gICAqIE9wdGlvbmFsIGN1c3RvbSBkb21haW4gbmFtZSBmb3IgdGhlIENsb3VkRnJvbnQgZGlzdHJpYnV0aW9uLlxuICAgKlxuICAgKiBAZXhhbXBsZSBhcHBzLnB3cmRydnIuY29tXG4gICAqIEBkZWZhdWx0IGF1dG8tYXNzaWduZWRcbiAgICovXG4gIHJlYWRvbmx5IGRvbWFpbk5hbWVFZGdlPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBPcHRpb25hbCBjdXN0b20gZG9tYWluIG5hbWUgZm9yIHRoZSBBUEkgR2F0ZXdheSBIVFRQdjIgQVBJLlxuICAgKlxuICAgKiBAZXhhbXBsZSBhcHBzLW9yaWdpbi5wd3JkcnZyLmNvbVxuICAgKiBAZGVmYXVsdCBhdXRvLWFzc2lnbmVkXG4gICAqL1xuICByZWFkb25seSBkb21haW5OYW1lT3JpZ2luPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBQYXRoIHByZWZpeCBvbiB0aGUgcm9vdCBvZiB0aGUgQ2xvdWRGcm9udCBkaXN0cmlidXRpb25cbiAgICpcbiAgICogQGV4YW1wbGUgZGV2L1xuICAgKi9cbiAgcmVhZG9ubHkgcm9vdFBhdGhQcmVmaXg/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIENyZWF0ZSBBUEkgR2F0ZXdheSBmb3Igbm9uLWVkZ2UgaW52b2NhdGlvblxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgY3JlYXRlQVBJR2F0ZXdheT86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIENyZWF0ZSBhbiBleHRyYSBCZWhhdmlvciAoUm91dGUpIGZvciAvYXBpLyB0aGF0IGFsbG93c1xuICAgKiBBUEkgcm91dGVzIHRvIGhhdmUgYSBwZXJpb2QgaW4gdGhlbS5cbiAgICpcbiAgICogV2hlbiBmYWxzZSBBUEkgcm91dGVzIHdpdGggYSBwZXJpb2QgaW4gdGhlIHBhdGggd2lsbCBnZXQgcm91dGVkIHRvIFMzLlxuICAgKlxuICAgKiBXaGVuIHRydWUgQVBJIHJvdXRlcyB0aGF0IGNvbnRhaW4gL2FwaS8gaW4gdGhlIHBhdGggd2lsbCBnZXQgcm91dGVkIHRvIEFQSSBHYXRld2F5XG4gICAqIGV2ZW4gaWYgdGhleSBoYXZlIGEgcGVyaW9kIGluIHRoZSBwYXRoLlxuICAgKlxuICAgKiBAZGVmYXVsdCB0cnVlXG4gICAqL1xuICByZWFkb25seSBjcmVhdGVBUElQYXRoUm91dGU/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBDcmVhdGUgYW4gZXh0cmEgQmVoYXZpb3IgKFJvdXRlKSBmb3IgL19uZXh0L2RhdGEvXG4gICAqIFRoaXMgcm91dGUgaXMgdXNlZCBieSBOZXh0LmpzIHRvIGxvYWQgZGF0YSBmcm9tIHRoZSBBUEkgR2F0ZXdheVxuICAgKiBvbiBgZ2V0U2VydmVyU2lkZVByb3BzYCBjYWxscy4gIFRoZSByZXF1ZXN0cyBjYW4gZW5kIGluIGAuanNvbmAsXG4gICAqIHdoaWNoIHdvdWxkIGNhdXNlIHRoZW0gdG8gYmUgcm91dGVkIHRvIFMzIGlmIHRoaXMgcm91dGUgaXMgbm90IGNyZWF0ZWQuXG4gICAqXG4gICAqIFdoZW4gZmFsc2UgQVBJIHJvdXRlcyB3aXRoIGEgcGVyaW9kIGluIHRoZSBwYXRoIHdpbGwgZ2V0IHJvdXRlZCB0byBTMy5cbiAgICpcbiAgICogV2hlbiB0cnVlIEFQSSByb3V0ZXMgdGhhdCBjb250YWluIC9fbmV4dC9kYXRhLyBpbiB0aGUgcGF0aCB3aWxsIGdldCByb3V0ZWQgdG8gQVBJIEdhdGV3YXlcbiAgICogZXZlbiBpZiB0aGV5IGhhdmUgYSBwZXJpb2QgaW4gdGhlIHBhdGguXG4gICAqXG4gICAqIEBkZWZhdWx0IHRydWVcbiAgICovXG4gIHJlYWRvbmx5IGNyZWF0ZU5leHREYXRhUGF0aFJvdXRlPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogQWRkcyBhbiBYLUZvcndhcmRlZC1Ib3N0LUhlYWRlciB3aGVuIGNhbGxpbmcgQVBJIEdhdGV3YXlcbiAgICpcbiAgICogQ2FuIG9ubHkgYmUgdHJ1c3RlZCBpZiBgc2lnbmluZ01vZGVgIGlzIGVuYWJsZWQsIHdoaWNoIHJlc3RyaWN0c1xuICAgKiBhY2Nlc3MgdG8gQVBJIEdhdGV3YXkgdG8gb25seSBJQU0gc2lnbmVkIHJlcXVlc3RzLlxuICAgKlxuICAgKiBOb3RlOiBpZiB0cnVlLCBjcmVhdGVzIE9yaWdpblJlcXVlc3QgTGFtYmRhIEAgRWRnZSBmdW5jdGlvbiBmb3IgQVBJIEdhdGV3YXkgT3JpZ2luXG4gICAqIEBkZWZhdWx0IHRydWVcbiAgICovXG4gIHJlYWRvbmx5IGFkZFhGb3J3YXJkZWRIb3N0SGVhZGVyPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogUmVwbGFjZXMgSG9zdCBoZWFkZXIgKHdoaWNoIHdpbGwgYmUgdGhlIEVkZ2UgZG9tYWluIG5hbWUpIHdpdGggdGhlIE9yaWdpbiBkb21haW4gbmFtZVxuICAgKiB3aGVuIGVuYWJsZWQuICBUaGlzIGlzIG5lY2Vzc2FyeSB3aGVuIEFQSSBHYXRld2F5IGhhcyBub3QgYmVlbiBjb25maWd1cmVkXG4gICAqIHdpdGggYSBjdXN0b20gZG9tYWluIG5hbWUgdGhhdCBtYXRjaGVzIHRoZSBleGFjdCBkb21haW4gbmFtZSB1c2VkIGJ5IHRoZSBDbG91ZEZyb250XG4gICAqIERpc3RyaWJ1dGlvbiBBTkQgd2hlbiB0aGUgT3JpZ2luUmVxdWVzdFBvbGljeS5IZWFkZXJzQmVoYXZpb3IgaXMgc2V0XG4gICAqIHRvIHBhc3MgYWxsIGhlYWRlcnMgdG8gdGhlIG9yaWdpbi5cbiAgICpcbiAgICogTm90ZTogaWYgdHJ1ZSwgY3JlYXRlcyBPcmlnaW5SZXF1ZXN0IExhbWJkYSBAIEVkZ2UgZnVuY3Rpb24gZm9yIEFQSSBHYXRld2F5IE9yaWdpblxuICAgKiBAZGVmYXVsdCB0cnVlXG4gICAqL1xuICByZWFkb25seSByZXBsYWNlSG9zdEhlYWRlcj86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFJlcXVpcmVzIElBTSBhdXRoIG9uIHRoZSBBUEkgR2F0ZXdheSBvcmlnaW4gaWYgbm90IHNldCB0byAnbm9uZScuXG4gICAqXG4gICAqICdzaWduJyAtIFVzZXMgcmVxdWVzdCBoZWFkZXJzIGZvciBhdXRoLlxuICAgKiAncHJlc2lnbicgLSBVc2VzIHF1ZXJ5IHN0cmluZyBmb3IgYXV0aC5cbiAgICpcbiAgICogSWYgZW5hYmxlZCxcbiAgICpcbiAgICogTm90ZTogaWYgJ3NpZ24nIG9yICdwcmVzaWduJywgY3JlYXRlcyBPcmlnaW5SZXF1ZXN0IExhbWJkYSBAIEVkZ2UgZnVuY3Rpb24gZm9yIEFQSSBHYXRld2F5IE9yaWdpblxuICAgKiBAZGVmYXVsdCAnc2lnbidcbiAgICovXG4gIHJlYWRvbmx5IHNpZ25pbmdNb2RlPzogJ3NpZ24nIHwgJ3ByZXNpZ24nIHwgJ25vbmUnO1xuXG4gIC8qKlxuICAgKiBPcmlnaW4gcmVnaW9uIHRoYXQgQVBJIEdhdGV3YXkgb3IgTGFtYmRhIGZ1bmN0aW9uIHdpbGwgYmUgZGVwbG95ZWQgdG8sIHVzZWRcbiAgICogZm9yIHRoZSBjb25maWcueW1sIG9uIHRoZSBFZGdlIGZ1bmN0aW9uIHRvIHNpZ24gcmVxdWVzdHMgZm9yXG4gICAqIHRoZSBjb3JyZWN0IHJlZ2lvblxuICAgKlxuICAgKiBAZGVmYXVsdCB1bmRlZmluZWRcbiAgICovXG4gIHJlYWRvbmx5IG9yaWdpblJlZ2lvbj86IHN0cmluZztcblxuICAvKipcbiAgICogT3B0aW9uYWwgT3JpZ2luIFNoaWVsZCBSZWdpb25cbiAgICpcbiAgICogVGhpcyBzaG91bGQgYmUgdGhlIHJlZ2lvbiB3aGVyZSB0aGUgRHluYW1vREIgaXMgbG9jYXRlZCBzbyB0aGVcbiAgICogRWRnZVRvT3JpZ2luIGNhbGxzIGhhdmUgdGhlIGxvd2VzdCBsYXRlbmN5ICh+MSBtcykuXG4gICAqXG4gICAqIEBkZWZhdWx0IG9yaWdpblJlZ2lvbiBpZiBzcGVjaWZpZWQsIG90aGVyd2lzZSB1bmRlZmluZWRcbiAgICovXG4gIHJlYWRvbmx5IG9yaWdpblNoaWVsZFJlZ2lvbj86IHN0cmluZztcblxuICAvKipcbiAgICogRXhpc3RpbmcgdGFibGUgZm9yIGFwcHMvdmVyc2lvbnMvcnVsZXNcbiAgICpcbiAgICogQHdhcm5pbmcgLSBJdCBpcyAqc3Ryb25nbHkqIHN1Z2dlc3RlZCB0aGF0IHByb2R1Y3Rpb24gc3RhY2tzIGNyZWF0ZVxuICAgKiB0aGVpciBvd24gRHluYW1vREIgVGFibGUgYW5kIHBhc3MgaXQgaW50byB0aGlzIGNvbnN0cnVjdCwgZm9yIHByb3RlY3Rpb25cbiAgICogYWdhaW5zdCBkYXRhIGxvc3MgZHVlIHRvIGxvZ2ljYWwgSUQgY2hhbmdlcywgdGhlIGFiaWxpdHkgdG8gY29uZmlndXJlXG4gICAqIFByb3Zpc2lvbmVkIGNhcGFjaXR5IHdpdGggQXV0byBTY2FsaW5nLCB0aGUgYWJpbGl0eSB0byBhZGQgYWRkaXRpb25hbCBpbmRpY2VzLCBldGMuXG4gICAqXG4gICAqIFJlcXVpcmVtZW50czpcbiAgICogLSBIYXNoIEtleTogYFBLYFxuICAgKiAtIFNvcnQgS2V5OiBgU0tgXG4gICAqXG4gICAqIEBkZWZhdWx0IGNyZWF0ZWQgYnkgY29uc3RydWN0XG4gICAqL1xuICByZWFkb25seSB0YWJsZT86IGR5bmFtb2RiLklUYWJsZTtcblxuICAvKipcbiAgICogUHJlLXNldCB0YWJsZSBuYW1lIGZvciBhcHBzL3ZlcnNpb25zL3J1bGVzXG4gICAqXG4gICAqIFRoaXMgaXMgcmVxdWlyZWQgd2hlbiB1c2luZyB2MiByb3V0aW5nXG4gICAqL1xuICByZWFkb25seSB0YWJsZU5hbWVGb3JFZGdlVG9PcmlnaW4/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEFkZGl0aW9uYWwgZWRnZSBsYW1iZGEgZnVuY3Rpb25zXG4gICAqL1xuICByZWFkb25seSBlZGdlTGFtYmRhcz86IGNmLkVkZ2VMYW1iZGFbXTtcblxuICAvKipcbiAgICogQWNjb3VudCBJRHMgYWxsb3dlZCBmb3IgY3Jvc3MtYWNjb3VudCBGdW5jdGlvbiBVUkwgaW52b2NhdGlvbnNcbiAgICpcbiAgICogQGRlZmF1bHQgW11cbiAgICovXG4gIHJlYWRvbmx5IGFsbG93ZWRGdW5jdGlvblVybEFjY291bnRzPzogc3RyaW5nW107XG59XG5cbi8qKlxuICogUmVwcmVzZW50cyBhIE1pY3JvQXBwc1xuICovXG5leHBvcnQgaW50ZXJmYWNlIElNaWNyb0FwcHMge1xuICAvKioge0Bpbmhlcml0ZG9jIElNaWNyb0FwcHNDRn0gKi9cbiAgcmVhZG9ubHkgY2Y6IElNaWNyb0FwcHNDRjtcblxuICAvKioge0Bpbmhlcml0ZG9jIElNaWNyb0FwcHNFZGdlVG9PcmlnaW59ICovXG4gIHJlYWRvbmx5IGVkZ2VUb09yaWdpbj86IElNaWNyb0FwcHNFZGdlVG9PcmlnaW47XG5cbiAgLyoqIHtAaW5oZXJpdGRvYyBJTWljcm9BcHBzUzN9ICovXG4gIHJlYWRvbmx5IHMzOiBJTWljcm9BcHBzUzM7XG5cbiAgLyoqIHtAaW5oZXJpdGRvYyBJTWljcm9BcHBzU3Zjc30gKi9cbiAgcmVhZG9ubHkgc3ZjczogSU1pY3JvQXBwc1N2Y3M7XG5cbiAgLyoqIHtAaW5oZXJpdGRvYyBJTWljcm9BcHBzQVBJR3d5fSAqL1xuICByZWFkb25seSBhcGlnd3k/OiBJTWljcm9BcHBzQVBJR3d5O1xufVxuXG4vKipcbiAqIENyZWF0ZSBhIG5ldyBNaWNyb0FwcHMgXCJ0dXJua2V5XCIgY29uc3RydWN0IGZvciBzaW1wbGVcbiAqIGRlcGxveW1lbnRzIGFuZCBmb3IgaW5pdGlhbCBldmF1bGF0aW9uIG9mIHRoZSBNaWNyb0FwcHMgZnJhbWV3b3JrLlxuICpcbiAqIFVzZSB0aGlzIGNvbnN0cnVjdCB0byBjcmVhdGUgYSBQb0Mgd29ya2luZyBlbnRpcmUgc3RhY2suXG4gKlxuICogRG8gbm90IHVzZSB0aGlzIGNvbnN0cnVjdCB3aGVuIGFkZGluZyBNaWNyb0FwcHMgdG8gYW4gZXhpc3RpbmdcbiAqIENsb3VkRnJvbnQsIEFQSSBHYXRld2F5LCBTMyBCdWNrZXQsIGV0Yy4gb3Igd2hlcmUgYWNjZXNzXG4gKiB0byBhbGwgZmVhdHVyZXMgb2YgdGhlIEFXUyBSZXNvdXJjZXMgYXJlIG5lZWRlZCAoZS5nLiB0b1xuICogYWRkIGFkZGl0aW9uYWwgQmVoYXZpb3JzIHRvIHRoZSBDbG91ZEZyb250IGRpc3RyaWJ1dGlvbiwgc2V0IGF1dGhvcml6b3JzXG4gKiBvbiBBUEkgR2F0ZXdheSwgZXRjLikuXG4gKlxuICogQHdhcm5pbmcgVGhpcyBjb25zdHJ1Y3QgaXMgbm90IGludGVuZGVkIGZvciBwcm9kdWN0aW9uIHVzZS5cbiAqIEluIGEgcHJvZHVjdGlvbiBzdGFjayB0aGUgRHluYW1vREIgVGFibGUsIEFQSSBHYXRld2F5LCBTMyBCdWNrZXRzLFxuICogZXRjLiBzaG91bGQgYmUgY3JlYXRlZCBpbiBhIFwiZHVyYWJsZVwiIHN0YWNrIHdoZXJlIHRoZSBJRHMgd2lsbCBub3RcbiAqIGNoYW5nZSBhbmQgd2hlcmUgY2hhbmdlcyB0byB0aGUgTWljcm9BcHBzIGNvbnN0cnVjdCB3aWxsIG5vdFxuICogY2F1c2UgZmFpbHVyZXMgdG8gZGVwbG95IG9yIGRhdGEgdG8gYmUgZGVsZXRlZC5cbiAqXG4gKiAgQHNlZSB7QGxpbmsgaHR0cHM6Ly9naXRodWIuY29tL3B3cmRydnIvbWljcm9hcHBzLWNvcmUvYmxvYi9tYWluL3BhY2thZ2VzL2Nkay9saWIvTWljcm9BcHBzLnRzIHwgZXhhbXBsZSB1c2FnZSBpbiBhIENESyBTdGFjayB9XG4gKi9cbmV4cG9ydCBjbGFzcyBNaWNyb0FwcHMgZXh0ZW5kcyBDb25zdHJ1Y3QgaW1wbGVtZW50cyBJTWljcm9BcHBzIHtcbiAgcHJpdmF0ZSBfY2Y6IE1pY3JvQXBwc0NGO1xuICBwdWJsaWMgZ2V0IGNmKCk6IElNaWNyb0FwcHNDRiB7XG4gICAgcmV0dXJuIHRoaXMuX2NmO1xuICB9XG5cbiAgcHJpdmF0ZSBfZWRnZVRvT3JpZ2luPzogTWljcm9BcHBzRWRnZVRvT3JpZ2luO1xuICBwdWJsaWMgZ2V0IGVkZ2VUb09yaWdpbigpOiBJTWljcm9BcHBzRWRnZVRvT3JpZ2luIHwgdW5kZWZpbmVkIHtcbiAgICByZXR1cm4gdGhpcy5fZWRnZVRvT3JpZ2luO1xuICB9XG5cbiAgcHJpdmF0ZSBfczM6IE1pY3JvQXBwc1MzO1xuICBwdWJsaWMgZ2V0IHMzKCk6IElNaWNyb0FwcHNTMyB7XG4gICAgcmV0dXJuIHRoaXMuX3MzO1xuICB9XG5cbiAgcHJpdmF0ZSBfYXBpZ3d5PzogTWljcm9BcHBzQVBJR3d5O1xuICBwdWJsaWMgZ2V0IGFwaWd3eSgpOiBJTWljcm9BcHBzQVBJR3d5IHwgdW5kZWZpbmVkIHtcbiAgICByZXR1cm4gdGhpcy5fYXBpZ3d5O1xuICB9XG5cbiAgcHJpdmF0ZSBfc3ZjczogTWljcm9BcHBzU3ZjcztcbiAgcHVibGljIGdldCBzdmNzKCk6IElNaWNyb0FwcHNTdmNzIHtcbiAgICByZXR1cm4gdGhpcy5fc3ZjcztcbiAgfVxuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzPzogTWljcm9BcHBzUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgaWYgKHByb3BzID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcigncHJvcHMgbXVzdCBiZSBzZXQnKTtcbiAgICB9XG5cbiAgICBjb25zdCB7XG4gICAgICBkb21haW5OYW1lRWRnZSxcbiAgICAgIGRvbWFpbk5hbWVPcmlnaW4sXG4gICAgICBhc3NldE5hbWVSb290LFxuICAgICAgYXNzZXROYW1lU3VmZml4LFxuICAgICAgcjUzWm9uZSxcbiAgICAgIGNlcnRFZGdlLFxuICAgICAgYXBwRW52ID0gJ2RldicsXG4gICAgICBjZXJ0T3JpZ2luLFxuICAgICAgcmVtb3ZhbFBvbGljeSxcbiAgICAgIHMzUG9saWN5QnlwYXNzQVJPQXMsXG4gICAgICBzM1BvbGljeUJ5cGFzc1ByaW5jaXBhbEFSTnMsXG4gICAgICBzM1N0cmljdEJ1Y2tldFBvbGljeSxcbiAgICAgIHJvb3RQYXRoUHJlZml4LFxuICAgICAgY3JlYXRlQVBJR2F0ZXdheSA9IGZhbHNlLFxuICAgICAgY3JlYXRlQVBJUGF0aFJvdXRlID0gdHJ1ZSxcbiAgICAgIGNyZWF0ZU5leHREYXRhUGF0aFJvdXRlID0gdHJ1ZSxcbiAgICAgIGFkZFhGb3J3YXJkZWRIb3N0SGVhZGVyID0gdHJ1ZSxcbiAgICAgIHJlcGxhY2VIb3N0SGVhZGVyID0gdHJ1ZSxcbiAgICAgIHNpZ25pbmdNb2RlID0gJ3NpZ24nLFxuICAgICAgb3JpZ2luUmVnaW9uLFxuICAgICAgdGFibGUsXG4gICAgICB0YWJsZU5hbWVGb3JFZGdlVG9PcmlnaW4sXG4gICAgICBvcmlnaW5TaGllbGRSZWdpb24gPSBvcmlnaW5SZWdpb24sXG4gICAgICBhbGxvd2VkRnVuY3Rpb25VcmxBY2NvdW50cyA9IFtdLFxuICAgIH0gPSBwcm9wcztcblxuICAgIHRoaXMuX3MzID0gbmV3IE1pY3JvQXBwc1MzKHRoaXMsICdzMycsIHtcbiAgICAgIHJlbW92YWxQb2xpY3ksXG4gICAgICBidWNrZXRMb2dzTmFtZTogZG9tYWluTmFtZUVkZ2UgPyBgJHtyZXZlcnNlRG9tYWluKGRvbWFpbk5hbWVFZGdlKX0tbG9nc2AgOiB1bmRlZmluZWQsXG4gICAgICBidWNrZXRBcHBzTmFtZTogZG9tYWluTmFtZUVkZ2UgPyBgJHtyZXZlcnNlRG9tYWluKGRvbWFpbk5hbWVFZGdlKX1gIDogdW5kZWZpbmVkLFxuICAgICAgYnVja2V0QXBwc1N0YWdpbmdOYW1lOiBkb21haW5OYW1lRWRnZVxuICAgICAgICA/IGAke3JldmVyc2VEb21haW4oZG9tYWluTmFtZUVkZ2UpfS1zdGFnaW5nYFxuICAgICAgICA6IHVuZGVmaW5lZCxcbiAgICAgIGFzc2V0TmFtZVJvb3QsXG4gICAgICBhc3NldE5hbWVTdWZmaXgsXG4gICAgICBvcmlnaW5TaGllbGRSZWdpb24sXG4gICAgfSk7XG4gICAgaWYgKGNyZWF0ZUFQSUdhdGV3YXkpIHtcbiAgICAgIHRoaXMuX2FwaWd3eSA9IG5ldyBNaWNyb0FwcHNBUElHd3kodGhpcywgJ2FwaScsIHtcbiAgICAgICAgcmVtb3ZhbFBvbGljeSxcbiAgICAgICAgYXNzZXROYW1lUm9vdCxcbiAgICAgICAgYXNzZXROYW1lU3VmZml4LFxuICAgICAgICBkb21haW5OYW1lRWRnZSxcbiAgICAgICAgZG9tYWluTmFtZU9yaWdpbixcbiAgICAgICAgcjUzWm9uZSxcbiAgICAgICAgY2VydE9yaWdpbixcbiAgICAgICAgcm9vdFBhdGhQcmVmaXgsXG4gICAgICAgIHJlcXVpcmVJQU1BdXRob3JpemF0aW9uOiBzaWduaW5nTW9kZSAhPT0gJ25vbmUnLFxuICAgICAgfSk7XG4gICAgfVxuICAgIHRoaXMuX3N2Y3MgPSBuZXcgTWljcm9BcHBzU3Zjcyh0aGlzLCAnc3ZjcycsIHtcbiAgICAgIC4uLih0aGlzLl9hcGlnd3kgPyB7IGh0dHBBcGk6IHRoaXMuX2FwaWd3eS5odHRwQXBpIH0gOiB7fSksXG4gICAgICByZW1vdmFsUG9saWN5LFxuICAgICAgYnVja2V0QXBwczogdGhpcy5fczMuYnVja2V0QXBwcyxcbiAgICAgIGJ1Y2tldEFwcHNPQUk6IHRoaXMuX3MzLmJ1Y2tldEFwcHNPQUksXG4gICAgICBidWNrZXRBcHBzU3RhZ2luZzogdGhpcy5fczMuYnVja2V0QXBwc1N0YWdpbmcsXG4gICAgICBhc3NldE5hbWVSb290LFxuICAgICAgYXNzZXROYW1lU3VmZml4LFxuICAgICAgYXBwRW52LFxuICAgICAgczNQb2xpY3lCeXBhc3NBUk9BcyxcbiAgICAgIHMzUG9saWN5QnlwYXNzUHJpbmNpcGFsQVJOcyxcbiAgICAgIHMzU3RyaWN0QnVja2V0UG9saWN5LFxuICAgICAgcm9vdFBhdGhQcmVmaXgsXG4gICAgICByZXF1aXJlSUFNQXV0aG9yaXphdGlvbjogc2lnbmluZ01vZGUgIT09ICdub25lJyxcbiAgICAgIHRhYmxlLFxuICAgIH0pO1xuICAgIGNvbnN0IGVkZ2VMYW1iZGFzOiBjZi5FZGdlTGFtYmRhW10gPSBbXTtcblxuICAgIGlmIChzaWduaW5nTW9kZSAhPT0gJ25vbmUnIHx8IHJlcGxhY2VIb3N0SGVhZGVyIHx8IGFkZFhGb3J3YXJkZWRIb3N0SGVhZGVyKSB7XG4gICAgICB0aGlzLl9lZGdlVG9PcmlnaW4gPSBuZXcgTWljcm9BcHBzRWRnZVRvT3JpZ2luKHRoaXMsICdlZGdlVG9PcmlnaW4nLCB7XG4gICAgICAgIGFzc2V0TmFtZVJvb3QsXG4gICAgICAgIGFzc2V0TmFtZVN1ZmZpeCxcbiAgICAgICAgcmVtb3ZhbFBvbGljeSxcbiAgICAgICAgYWRkWEZvcndhcmRlZEhvc3RIZWFkZXIsXG4gICAgICAgIHNldHVwQXBpR2F0ZXdheVBlcm1pc3Npb25zOiBjcmVhdGVBUElHYXRld2F5LFxuICAgICAgICByZXBsYWNlSG9zdEhlYWRlcixcbiAgICAgICAgb3JpZ2luUmVnaW9uLFxuICAgICAgICBzaWduaW5nTW9kZSxcbiAgICAgICAgcm9vdFBhdGhQcmVmaXgsXG4gICAgICAgIHRhYmxlUnVsZXNBcm46IHRhYmxlTmFtZUZvckVkZ2VUb09yaWdpbiB8fCB0aGlzLl9zdmNzLnRhYmxlLnRhYmxlTmFtZSxcbiAgICAgICAgYWxsb3dlZEZ1bmN0aW9uVXJsQWNjb3VudHMsXG4gICAgICB9KTtcblxuICAgICAgZWRnZUxhbWJkYXMucHVzaCguLi50aGlzLl9lZGdlVG9PcmlnaW4uZWRnZVRvT3JpZ2luTGFtYmRhcyk7XG4gICAgfVxuICAgIC8vIEFkZCBhbnkgZXh0cmEgbGFtYmRhc1xuICAgIGlmIChwcm9wcy5lZGdlTGFtYmRhcz8ubGVuZ3RoKSB7XG4gICAgICBlZGdlTGFtYmRhcy5wdXNoKC4uLnByb3BzLmVkZ2VMYW1iZGFzKTtcbiAgICB9XG4gICAgdGhpcy5fY2YgPSBuZXcgTWljcm9BcHBzQ0YodGhpcywgJ2NmdCcsIHtcbiAgICAgIHJlbW92YWxQb2xpY3ksXG4gICAgICBhc3NldE5hbWVSb290LFxuICAgICAgYXNzZXROYW1lU3VmZml4LFxuICAgICAgZG9tYWluTmFtZUVkZ2UsXG4gICAgICBkb21haW5OYW1lT3JpZ2luLFxuICAgICAgLi4uKHRoaXMuX2FwaWd3eSA/IHsgaHR0cEFwaTogdGhpcy5fYXBpZ3d5Lmh0dHBBcGkgfSA6IHt9KSxcbiAgICAgIHI1M1pvbmUsXG4gICAgICBjZXJ0RWRnZSxcbiAgICAgIGJ1Y2tldEFwcHNPcmlnaW46IHRoaXMuX3MzLmJ1Y2tldEFwcHNPcmlnaW4sXG4gICAgICBidWNrZXRMb2dzOiB0aGlzLl9zMy5idWNrZXRMb2dzLFxuICAgICAgcm9vdFBhdGhQcmVmaXgsXG4gICAgICBjcmVhdGVBUElQYXRoUm91dGUsXG4gICAgICBjcmVhdGVOZXh0RGF0YVBhdGhSb3V0ZSxcbiAgICAgIG9yaWdpblNoaWVsZFJlZ2lvbixcbiAgICAgIC4uLihlZGdlTGFtYmRhcy5sZW5ndGggPyB7IGVkZ2VMYW1iZGFzIH0gOiB7fSksXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==