"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Counter = void 0;
/**
 * Counter class provides utils for adding/subtracting key based counts.
 *
 * For example, you can create a counter to track number of each CfnResourceType based on resource type key.
 *
 * @internal
 */
class Counter {
    constructor() {
        /** @internal */
        this._counts = new Map();
    }
    /** Gets record of keyed counts */
    get counts() {
        return Object.fromEntries(this._counts);
    }
    /** Increment key count by 1 */
    add(key) {
        const count = (this._counts.get(key) || 0) + 1;
        this._counts.set(key, count);
        return count;
    }
    /** Decrement key count by 1 */
    subtract(key) {
        const count = (this._counts.get(key) || 0) - 1;
        if (count < 0) {
            throw new Error(`Attempt to subtract count from zero`);
        }
        this._counts.set(key, count);
        return count;
    }
    /** Gets the current count for given key */
    getCount(key) {
        return this._counts.get(key) || 0;
    }
}
exports.Counter = Counter;
//# sourceMappingURL=data:application/json;base64,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