/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/**
 * ICounterRecord is record of keyed counts from {@link Counters}.
 *
 * The record is a mapping of `key => count` values.
 */
export interface ICounterRecord {
    /**
     * Counter key => count value properties
     */
    [key: string]: number;
}
/**
 * Counter class provides utils for adding/subtracting key based counts.
 *
 * For example, you can create a counter to track number of each CfnResourceType based on resource type key.
 *
 * @internal
 */
export declare class Counter<T = string> {
    /** @internal */
    private _counts;
    /** Gets record of keyed counts */
    get counts(): ICounterRecord;
    /** Increment key count by 1 */
    add(key: T): number;
    /** Decrement key count by 1 */
    subtract(key: T): number;
    /** Gets the current count for given key */
    getCount(key: T): number;
}
