"""initial

Revision ID: b1ee0f1e8fb4
Revises: 
Create Date: 2022-10-07 23:20:30.560370

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "b1ee0f1e8fb4"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "roles",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.Text(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "themes",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.Text(), nullable=False),
        sa.Column("bg_color", sa.Text(), nullable=False),
        sa.Column("bg_secondary_color", sa.Text(), nullable=False),
        sa.Column("color_primary", sa.Text(), nullable=False),
        sa.Column("color_lightGrey", sa.Text(), nullable=False),
        sa.Column("color_grey", sa.Text(), nullable=False),
        sa.Column("color_darkGrey", sa.Text(), nullable=False),
        sa.Column("color_error", sa.Text(), nullable=False),
        sa.Column("color_success", sa.Text(), nullable=False),
        sa.Column("grid_maxWidth", sa.Text(), nullable=False),
        sa.Column("grid_gutter", sa.Text(), nullable=False),
        sa.Column("font_size", sa.Text(), nullable=False),
        sa.Column("font_color", sa.Text(), nullable=False),
        sa.Column("font_family_sans", sa.Text(), nullable=False),
        sa.Column("font_family_mono", sa.Text(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("name"),
    )
    op.create_table(
        "users",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("email", sa.Text(), nullable=False),
        sa.Column("password", sa.Text(), nullable=False),
        sa.Column("active", sa.Boolean(), nullable=True),
        sa.Column("admin", sa.Boolean(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("email"),
    )
    op.create_table(
        "users_roles",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("role", sa.Integer(), nullable=True),
        sa.Column("user", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["role"],
            ["roles.id"],
            name="fk_users_roles_roles_role_id",
            onupdate="CASCADE",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["user"],
            ["users.id"],
            name="fk_users_roles_users_user_id",
            onupdate="CASCADE",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("users_roles")
    op.drop_table("users")
    op.drop_table("themes")
    op.drop_table("roles")
    # ### end Alembic commands ###
