#! /usr/bin/env python3
# -*- coding: utf-8 -*-
#
# Copyright © 2016-2018 Cyril Desjouy <ipselium@free.fr>
#
# This file is part of cpyvke
#
# cpyvke is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# cpyvke is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with cpyvke. If not, see <http://www.gnu.org/licenses/>.
#
#
# Creation Date : Mon Nov 14 09:08:25 2016
# Last Modified : jeu. 29 mars 2018 23:38:43 CEST
"""
-----------
DOCSTRING

@author: Cyril Desjouy
"""

import curses
from cpyvke.objects.panel import ListPanel


class ClassWin(ListPanel):
    """ Class inspector panel """

    def __init__(self, app, sock, logger, varval, varname):
        super(ClassWin, self).__init__(app, sock, logger)
        self.varval = varval
        self.varname = varname

    @property
    def title(self):
        return ' {} inspection '.format(self.varname)

    @property
    def panel_name(self):
        return 'class-inspector'

    @property
    def empty(self):
        return 'No objects in this class instance'

    def color(self, item):

        if item == 'txt':
            return self.app.c_exp_txt
        elif item == 'bdr':
            return self.app.c_exp_bdr | curses.A_BOLD
        elif item == 'ttl':
            return self.app.c_exp_ttl | curses.A_BOLD
        elif item == 'hh':
            return self.app.c_exp_hh | curses.A_BOLD
        elif item == 'pwf':
            return self.app.c_exp_pwf | curses.A_BOLD

    def get_items(self):
        """ List of items :

            varval : generated by utils.inspector.inspect_class_instance()

        """

        return self.varval
