/**
 * Prevents supplied object from being modified.
 *
 * @remarks
 * Has no problem with cycles.
 * Can receive frozen or parially frozen objects.
 *
 * @typeParam T - The type of the object.
 *
 * @param object - The object to be recursively frozen.
 * @param freeze - Function that does the freezing. Object.seal or anything with the same API can be used instead.
 *
 * @returns The frozen object (the same instance as object param).
 */
export declare function deepFreeze<T extends object>(object: T, freeze?: (object: T) => T): T;
//# sourceMappingURL=index.d.ts.map