/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.common.sql.builtin.string;

import org.apache.commons.lang3.StringUtils;
import org.apache.flink.table.functions.ScalarFunction;

public class SplitPart
extends ScalarFunction {
    public String eval(String src, String delimiter, Integer nth) {
        if (src == null || delimiter == null || nth == null) {
            return null;
        }
        if (nth < 1) {
            return "";
        }
        String[] L = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)src, (String)delimiter);
        if (L.length < nth) {
            return "";
        }
        return L[nth - 1];
    }

    public String eval(String src, String delimiter, Integer start, Integer end) {
        if (src == null || delimiter == null || start == null || end == null) {
            return null;
        }
        if (delimiter.isEmpty()) {
            return src;
        }
        if (start > end) {
            return "";
        }
        if (start < 0) {
            start = 1;
        }
        Object[] L = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)src, (String)delimiter);
        if (end > L.length) {
            end = L.length;
        }
        if (start > end) {
            return "";
        }
        return StringUtils.join((Object[])L, (String)delimiter, (int)(start - 1), (int)end);
    }
}

