<a id="mypy-boto3-opensearch"></a>

# mypy-boto3-opensearch

[![PyPI - mypy-boto3-opensearch](https://img.shields.io/pypi/v/mypy-boto3-opensearch.svg?color=blue)](https://pypi.org/project/mypy-boto3-opensearch)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-opensearch.svg?color=blue)](https://pypi.org/project/mypy-boto3-opensearch)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-opensearch?color=blue)](https://pypistats.org/packages/mypy-boto3-opensearch)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.OpenSearchService 1.18.44](https://boto3.amazonaws.com/v1/documentation/api/1.18.44/reference/services/opensearch.html#OpenSearchService)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.3.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-opensearch docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_opensearch/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-opensearch](#mypy-boto3-opensearch)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `OpenSearchService` service.

```bash
python -m pip install boto3-stubs[opensearch]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[opensearch]` in your environment:
  `python -m pip install 'boto3-stubs[opensearch]'`

Both type checking and auto-complete should work for `OpenSearchService`
service. No explicit type annotations required, write your `boto3` code as
usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[opensearch]` in your environment:
  `python -m pip install 'boto3-stubs[opensearch]'`

Both type checking and auto-complete should work for `OpenSearchService`
service. No explicit type annotations required, write your `boto3` code as
usual. Auto-complete can be slow on big projects or if you have a lot of
installed `boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[opensearch]` in your environment:
  `python -m pip install 'boto3-stubs[opensearch]'`
- Run `mypy` as usual

Type checking should work for `OpenSearchService` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[opensearch]` in your environment:
  `python -m pip install 'boto3-stubs[opensearch]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `OpenSearchService` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`OpenSearchServiceClient` provides annotations for
`boto3.client("opensearch")`.

```python
import boto3

from mypy_boto3_opensearch import OpenSearchServiceClient

client: OpenSearchServiceClient = boto3.client("opensearch")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: OpenSearchServiceClient = session.client("opensearch")
```

<a id="literals"></a>

### Literals

`mypy_boto3_opensearch.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_opensearch.literals import (
    AutoTuneDesiredStateType,
    AutoTuneStateType,
    AutoTuneTypeType,
    DeploymentStatusType,
    DescribePackagesFilterNameType,
    DomainPackageStatusType,
    EngineTypeType,
    InboundConnectionStatusCodeType,
    LogTypeType,
    OpenSearchPartitionInstanceTypeType,
    OpenSearchWarmPartitionInstanceTypeType,
    OptionStateType,
    OutboundConnectionStatusCodeType,
    PackageStatusType,
    PackageTypeType,
    ReservedInstancePaymentOptionType,
    RollbackOnDisableType,
    ScheduledAutoTuneActionTypeType,
    ScheduledAutoTuneSeverityTypeType,
    TLSSecurityPolicyType,
    TimeUnitType,
    UpgradeStatusType,
    UpgradeStepType,
    VolumeTypeType,
    ServiceName,
)

def check_value(value: AutoTuneDesiredStateType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_opensearch.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_opensearch.type_defs import (
    AWSDomainInformationTypeDef,
    AcceptInboundConnectionRequestRequestTypeDef,
    AcceptInboundConnectionResponseTypeDef,
    AccessPoliciesStatusTypeDef,
    AddTagsRequestRequestTypeDef,
    AdditionalLimitTypeDef,
    AdvancedOptionsStatusTypeDef,
    AdvancedSecurityOptionsInputTypeDef,
    AdvancedSecurityOptionsStatusTypeDef,
    AdvancedSecurityOptionsTypeDef,
    AssociatePackageRequestRequestTypeDef,
    AssociatePackageResponseTypeDef,
    AutoTuneDetailsTypeDef,
    AutoTuneMaintenanceScheduleTypeDef,
    AutoTuneOptionsInputTypeDef,
    AutoTuneOptionsOutputTypeDef,
    AutoTuneOptionsStatusTypeDef,
    AutoTuneOptionsTypeDef,
    AutoTuneStatusTypeDef,
    AutoTuneTypeDef,
    CancelServiceSoftwareUpdateRequestRequestTypeDef,
    CancelServiceSoftwareUpdateResponseTypeDef,
    ClusterConfigStatusTypeDef,
    ClusterConfigTypeDef,
    CognitoOptionsStatusTypeDef,
    CognitoOptionsTypeDef,
    ColdStorageOptionsTypeDef,
    CompatibleVersionsMapTypeDef,
    CreateDomainRequestRequestTypeDef,
    CreateDomainResponseTypeDef,
    CreateOutboundConnectionRequestRequestTypeDef,
    CreateOutboundConnectionResponseTypeDef,
    CreatePackageRequestRequestTypeDef,
    CreatePackageResponseTypeDef,
    DeleteDomainRequestRequestTypeDef,
    DeleteDomainResponseTypeDef,
    DeleteInboundConnectionRequestRequestTypeDef,
    DeleteInboundConnectionResponseTypeDef,
    DeleteOutboundConnectionRequestRequestTypeDef,
    DeleteOutboundConnectionResponseTypeDef,
    DeletePackageRequestRequestTypeDef,
    DeletePackageResponseTypeDef,
    DescribeDomainAutoTunesRequestRequestTypeDef,
    DescribeDomainAutoTunesResponseTypeDef,
    DescribeDomainConfigRequestRequestTypeDef,
    DescribeDomainConfigResponseTypeDef,
    DescribeDomainRequestRequestTypeDef,
    DescribeDomainResponseTypeDef,
    DescribeDomainsRequestRequestTypeDef,
    DescribeDomainsResponseTypeDef,
    DescribeInboundConnectionsRequestRequestTypeDef,
    DescribeInboundConnectionsResponseTypeDef,
    DescribeInstanceTypeLimitsRequestRequestTypeDef,
    DescribeInstanceTypeLimitsResponseTypeDef,
    DescribeOutboundConnectionsRequestRequestTypeDef,
    DescribeOutboundConnectionsResponseTypeDef,
    DescribePackagesFilterTypeDef,
    DescribePackagesRequestRequestTypeDef,
    DescribePackagesResponseTypeDef,
    DescribeReservedInstanceOfferingsRequestRequestTypeDef,
    DescribeReservedInstanceOfferingsResponseTypeDef,
    DescribeReservedInstancesRequestRequestTypeDef,
    DescribeReservedInstancesResponseTypeDef,
    DissociatePackageRequestRequestTypeDef,
    DissociatePackageResponseTypeDef,
    DomainConfigTypeDef,
    DomainEndpointOptionsStatusTypeDef,
    DomainEndpointOptionsTypeDef,
    DomainInfoTypeDef,
    DomainInformationContainerTypeDef,
    DomainPackageDetailsTypeDef,
    DomainStatusTypeDef,
    DurationTypeDef,
    EBSOptionsStatusTypeDef,
    EBSOptionsTypeDef,
    EncryptionAtRestOptionsStatusTypeDef,
    EncryptionAtRestOptionsTypeDef,
    ErrorDetailsTypeDef,
    FilterTypeDef,
    GetCompatibleVersionsRequestRequestTypeDef,
    GetCompatibleVersionsResponseTypeDef,
    GetPackageVersionHistoryRequestRequestTypeDef,
    GetPackageVersionHistoryResponseTypeDef,
    GetUpgradeHistoryRequestRequestTypeDef,
    GetUpgradeHistoryResponseTypeDef,
    GetUpgradeStatusRequestRequestTypeDef,
    GetUpgradeStatusResponseTypeDef,
    InboundConnectionStatusTypeDef,
    InboundConnectionTypeDef,
    InstanceCountLimitsTypeDef,
    InstanceLimitsTypeDef,
    InstanceTypeDetailsTypeDef,
    LimitsTypeDef,
    ListDomainNamesRequestRequestTypeDef,
    ListDomainNamesResponseTypeDef,
    ListDomainsForPackageRequestRequestTypeDef,
    ListDomainsForPackageResponseTypeDef,
    ListInstanceTypeDetailsRequestRequestTypeDef,
    ListInstanceTypeDetailsResponseTypeDef,
    ListPackagesForDomainRequestRequestTypeDef,
    ListPackagesForDomainResponseTypeDef,
    ListTagsRequestRequestTypeDef,
    ListTagsResponseTypeDef,
    ListVersionsRequestRequestTypeDef,
    ListVersionsResponseTypeDef,
    LogPublishingOptionTypeDef,
    LogPublishingOptionsStatusTypeDef,
    MasterUserOptionsTypeDef,
    NodeToNodeEncryptionOptionsStatusTypeDef,
    NodeToNodeEncryptionOptionsTypeDef,
    OptionStatusTypeDef,
    OutboundConnectionStatusTypeDef,
    OutboundConnectionTypeDef,
    PackageDetailsTypeDef,
    PackageSourceTypeDef,
    PackageVersionHistoryTypeDef,
    PurchaseReservedInstanceOfferingRequestRequestTypeDef,
    PurchaseReservedInstanceOfferingResponseTypeDef,
    RecurringChargeTypeDef,
    RejectInboundConnectionRequestRequestTypeDef,
    RejectInboundConnectionResponseTypeDef,
    RemoveTagsRequestRequestTypeDef,
    ReservedInstanceOfferingTypeDef,
    ReservedInstanceTypeDef,
    ResponseMetadataTypeDef,
    SAMLIdpTypeDef,
    SAMLOptionsInputTypeDef,
    SAMLOptionsOutputTypeDef,
    ScheduledAutoTuneDetailsTypeDef,
    ServiceSoftwareOptionsTypeDef,
    SnapshotOptionsStatusTypeDef,
    SnapshotOptionsTypeDef,
    StartServiceSoftwareUpdateRequestRequestTypeDef,
    StartServiceSoftwareUpdateResponseTypeDef,
    StorageTypeLimitTypeDef,
    StorageTypeTypeDef,
    TagTypeDef,
    UpdateDomainConfigRequestRequestTypeDef,
    UpdateDomainConfigResponseTypeDef,
    UpdatePackageRequestRequestTypeDef,
    UpdatePackageResponseTypeDef,
    UpgradeDomainRequestRequestTypeDef,
    UpgradeDomainResponseTypeDef,
    UpgradeHistoryTypeDef,
    UpgradeStepItemTypeDef,
    VPCDerivedInfoStatusTypeDef,
    VPCDerivedInfoTypeDef,
    VPCOptionsTypeDef,
    VersionStatusTypeDef,
    ZoneAwarenessConfigTypeDef,
)

def get_structure() -> AWSDomainInformationTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-opensearch` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-opensearch docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_opensearch/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
