# Generated by Django 2.1.7 on 2019-07-14 09:56

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Batch',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=140, verbose_name='Optional name')),
                ('date_created', models.DateTimeField(default=django.utils.timezone.now)),
                ('initiator', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='massmailer_batches', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Batch',
                'verbose_name_plural': 'Batches',
                'ordering': ['-date_created'],
            },
        ),
        migrations.CreateModel(
            name='BatchEmail',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('state', models.PositiveIntegerField(db_index=True, default=1)),
                ('to', models.EmailField(max_length=254)),
                ('subject', models.TextField(blank=True)),
                ('body', models.TextField(blank=True)),
                ('html_body', models.TextField(blank=True, default='')),
                ('batch', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='emails', to='massmailer.Batch')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['state'],
            },
        ),
        migrations.CreateModel(
            name='Query',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=144, verbose_name='Name')),
                ('description', models.TextField(blank=True, verbose_name='Description')),
                ('query', models.TextField(verbose_name='Query')),
            ],
            options={
                'verbose_name': 'Query',
                'verbose_name_plural': 'Queries',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='Template',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=144, verbose_name='Name')),
                ('description', models.TextField(blank=True, verbose_name='Description')),
                ('subject', models.TextField(verbose_name='Subject template')),
                ('plain_body', models.TextField(verbose_name='Plaintext body template')),
                ('html_body', models.TextField(blank=True, verbose_name='HTML body template')),
                ('language', models.CharField(max_length=10, verbose_name='Language')),
            ],
            options={
                'verbose_name': 'Template',
                'verbose_name_plural': 'Templates',
                'ordering': ['name'],
            },
        ),
        migrations.AddField(
            model_name='query',
            name='useful_with',
            field=models.ManyToManyField(blank=True, related_name='useful_queries', to='massmailer.Template', verbose_name='Useful with templates'),
        ),
        migrations.AddField(
            model_name='batch',
            name='query',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='batches', to='massmailer.Query', verbose_name='Query'),
        ),
        migrations.AddField(
            model_name='batch',
            name='template',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='batches', to='massmailer.Template', verbose_name='Template'),
        ),
    ]
