import logging

from . import ApiNotFoundError

try:
    from py3coap import (
        setDebugLevel,
        Request,
        __version__,
        POST,
        PUT,
        GET,
        CloseConnection,
    )
    from py3coap.errors import (
        HandshakeError,
        UriNotFoundError,
        WriteTimeoutError,
        ReadTimeoutError,
        MethodNotAllowedError,
    )

except (ImportError, ModuleNotFoundError):
    ApiNotFoundError("pycoap", "Module 'py3coap' not found.")

from .config import get_config


def close_connection():
    CloseConnection()


def set_debug_level(level):
    global _debug
    _debug = level
    setDebugLevel(level)
    if level == 1:
        logging.basicConfig(level=logging.DEBUG)


def request(uri, payload=None, method="put"):
    conf = get_config().configuation

    if conf["Gateway"] is None:
        logging.critical("Gateway not specified")
        return

    if payload == None:

        # print ("Calling with method GET for uri: {}".format(uri))

        res = Request(
            uri="coaps://{}:{}/{}".format(conf["Gateway"], 5684, uri),
            ident=conf["Identity"],
            key=conf["Passkey"],
        )

    else:
        method = POST if method == "post" else PUT
        # print ("Calling with method {} for uri: {} with payload: {}".format(method, uri, payload))
        res = Request(
            uri="coaps://{}:{}/{}".format(conf["Gateway"], 5684, uri),
            payload=payload,
            method=method,
            ident=conf["Identity"],
            key=conf["Passkey"],
        )

    # print("Returning: {}\n".format(res))
    return res


def create_ident(ip, key, conf_obj):
    import uuid
    from .config import host_config, get_config
    from json import loads, dumps

    identity = uuid.uuid4().hex

    payload = '{{"{}":"{}"}}'.format(9090, identity)
    uri = "coaps://{}:{}/{}".format(ip, 5684, "15011/9063")

    result = Request(
        uri, payload=payload, method=POST, ident="Client_identity", key=key
    )

    logging.debug("Create ident result: {}".format(result))

    if result is None:
        logging.critical("Create_ident: No data from gateway")
        return None

    res = loads(result)

    conf_obj.set_config_items(Gateway=ip, Identity=identity, Passkey=res["9091"])
    conf_obj.save()
