from .guardpoint_dataclasses import Area
from .guardpoint_error import GuardPointError


class AreasAPI:
    def get_areas(self):
        url = "/odata/API_Areas"
        headers = {
            'Content-Type': 'application/json',
            'Accept': 'application/json'
        }

        code, json_body = self.gp_json_query("GET", headers=headers, url=url)

        if code != 200:
            if isinstance(json_body, dict):
                if 'error' in json_body:
                    raise GuardPointError(json_body['error'])

        if not isinstance(json_body, dict):
            raise GuardPointError("Badly formatted response.")
        if 'value' not in json_body:
            raise GuardPointError("Badly formatted response.")
        if not isinstance(json_body['value'], list):
            raise GuardPointError("Badly formatted response.")

        areas = []
        for x in json_body['value']:
            areas.append(Area(x))
        return areas