# coding: utf-8

"""
    Wavefront REST API

    <p>The Wavefront REST API enables you to interact with Wavefront servers using standard REST API tools. You can use the REST API to automate commonly executed operations such as automatically tagging sources.</p><p>When you make REST API calls outside the Wavefront REST API documentation you must add the header \"Authorization: Bearer &lt;&lt;API-TOKEN&gt;&gt;\" to your HTTP requests.</p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class VropsConfiguration(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'adapter_names': 'dict(str, list[str])',
        'base_url': 'str',
        'categories_to_fetch': 'list[str]',
        'metric_filter_regex': 'str',
        'organization_id': 'str',
        'vrops_api_token': 'str'
    }

    attribute_map = {
        'adapter_names': 'adapterNames',
        'base_url': 'baseURL',
        'categories_to_fetch': 'categoriesToFetch',
        'metric_filter_regex': 'metricFilterRegex',
        'organization_id': 'organizationID',
        'vrops_api_token': 'vropsAPIToken'
    }

    def __init__(self, adapter_names=None, base_url=None, categories_to_fetch=None, metric_filter_regex=None, organization_id=None, vrops_api_token=None, _configuration=None):  # noqa: E501
        """VropsConfiguration - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._adapter_names = None
        self._base_url = None
        self._categories_to_fetch = None
        self._metric_filter_regex = None
        self._organization_id = None
        self._vrops_api_token = None
        self.discriminator = None

        if adapter_names is not None:
            self.adapter_names = adapter_names
        if base_url is not None:
            self.base_url = base_url
        if categories_to_fetch is not None:
            self.categories_to_fetch = categories_to_fetch
        if metric_filter_regex is not None:
            self.metric_filter_regex = metric_filter_regex
        if organization_id is not None:
            self.organization_id = organization_id
        self.vrops_api_token = vrops_api_token

    @property
    def adapter_names(self):
        """Gets the adapter_names of this VropsConfiguration.  # noqa: E501

        Adapter names: Metrics will be fetched of only these adapter if given  # noqa: E501

        :return: The adapter_names of this VropsConfiguration.  # noqa: E501
        :rtype: dict(str, list[str])
        """
        return self._adapter_names

    @adapter_names.setter
    def adapter_names(self, adapter_names):
        """Sets the adapter_names of this VropsConfiguration.

        Adapter names: Metrics will be fetched of only these adapter if given  # noqa: E501

        :param adapter_names: The adapter_names of this VropsConfiguration.  # noqa: E501
        :type: dict(str, list[str])
        """

        self._adapter_names = adapter_names

    @property
    def base_url(self):
        """Gets the base_url of this VropsConfiguration.  # noqa: E501

        The base url for vrops api, Default : https://www.mgmt.cloud.vmware.com/vrops-cloud  # noqa: E501

        :return: The base_url of this VropsConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._base_url

    @base_url.setter
    def base_url(self, base_url):
        """Sets the base_url of this VropsConfiguration.

        The base url for vrops api, Default : https://www.mgmt.cloud.vmware.com/vrops-cloud  # noqa: E501

        :param base_url: The base_url of this VropsConfiguration.  # noqa: E501
        :type: str
        """

        self._base_url = base_url

    @property
    def categories_to_fetch(self):
        """Gets the categories_to_fetch of this VropsConfiguration.  # noqa: E501

        A list of vRops Adpater and Resource kind to fetch metrics.  Allowable values are VMWARE_DATASTORE, VMWARE_DATASTORE)  # noqa: E501

        :return: The categories_to_fetch of this VropsConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._categories_to_fetch

    @categories_to_fetch.setter
    def categories_to_fetch(self, categories_to_fetch):
        """Sets the categories_to_fetch of this VropsConfiguration.

        A list of vRops Adpater and Resource kind to fetch metrics.  Allowable values are VMWARE_DATASTORE, VMWARE_DATASTORE)  # noqa: E501

        :param categories_to_fetch: The categories_to_fetch of this VropsConfiguration.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["VMWARE_CLUSTERCOMPUTERESOURCE", "VMWARE_DATASTORE"]  # noqa: E501
        if (self._configuration.client_side_validation and
                not set(categories_to_fetch).issubset(set(allowed_values))):  # noqa: E501
            raise ValueError(
                "Invalid values for `categories_to_fetch` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(categories_to_fetch) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._categories_to_fetch = categories_to_fetch

    @property
    def metric_filter_regex(self):
        """Gets the metric_filter_regex of this VropsConfiguration.  # noqa: E501

        A regular expression that a metric name must match (case-insensitively) in order to be ingested  # noqa: E501

        :return: The metric_filter_regex of this VropsConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._metric_filter_regex

    @metric_filter_regex.setter
    def metric_filter_regex(self, metric_filter_regex):
        """Sets the metric_filter_regex of this VropsConfiguration.

        A regular expression that a metric name must match (case-insensitively) in order to be ingested  # noqa: E501

        :param metric_filter_regex: The metric_filter_regex of this VropsConfiguration.  # noqa: E501
        :type: str
        """

        self._metric_filter_regex = metric_filter_regex

    @property
    def organization_id(self):
        """Gets the organization_id of this VropsConfiguration.  # noqa: E501

        OrganizationID will be derived from api token  # noqa: E501

        :return: The organization_id of this VropsConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._organization_id

    @organization_id.setter
    def organization_id(self, organization_id):
        """Sets the organization_id of this VropsConfiguration.

        OrganizationID will be derived from api token  # noqa: E501

        :param organization_id: The organization_id of this VropsConfiguration.  # noqa: E501
        :type: str
        """

        self._organization_id = organization_id

    @property
    def vrops_api_token(self):
        """Gets the vrops_api_token of this VropsConfiguration.  # noqa: E501

        The vRops API Token  # noqa: E501

        :return: The vrops_api_token of this VropsConfiguration.  # noqa: E501
        :rtype: str
        """
        return self._vrops_api_token

    @vrops_api_token.setter
    def vrops_api_token(self, vrops_api_token):
        """Sets the vrops_api_token of this VropsConfiguration.

        The vRops API Token  # noqa: E501

        :param vrops_api_token: The vrops_api_token of this VropsConfiguration.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and vrops_api_token is None:
            raise ValueError("Invalid value for `vrops_api_token`, must not be `None`")  # noqa: E501

        self._vrops_api_token = vrops_api_token

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(VropsConfiguration, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VropsConfiguration):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VropsConfiguration):
            return True

        return self.to_dict() != other.to_dict()
