# coding: utf-8

"""
    Wavefront REST API

    <p>The Wavefront REST API enables you to interact with Wavefront servers using standard REST API tools. You can use the REST API to automate commonly executed operations such as automatically tagging sources.</p><p>When you make REST API calls outside the Wavefront REST API documentation you must add the header \"Authorization: Bearer &lt;&lt;API-TOKEN&gt;&gt;\" to your HTTP requests.</p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class SpecificData(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'class_loader': 'ClassLoader',
        'conversions': 'list[ConversionObject]',
        'fast_reader_builder': 'FastReaderBuilder',
        'fast_reader_enabled': 'bool'
    }

    attribute_map = {
        'class_loader': 'classLoader',
        'conversions': 'conversions',
        'fast_reader_builder': 'fastReaderBuilder',
        'fast_reader_enabled': 'fastReaderEnabled'
    }

    def __init__(self, class_loader=None, conversions=None, fast_reader_builder=None, fast_reader_enabled=None, _configuration=None):  # noqa: E501
        """SpecificData - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._class_loader = None
        self._conversions = None
        self._fast_reader_builder = None
        self._fast_reader_enabled = None
        self.discriminator = None

        if class_loader is not None:
            self.class_loader = class_loader
        if conversions is not None:
            self.conversions = conversions
        if fast_reader_builder is not None:
            self.fast_reader_builder = fast_reader_builder
        if fast_reader_enabled is not None:
            self.fast_reader_enabled = fast_reader_enabled

    @property
    def class_loader(self):
        """Gets the class_loader of this SpecificData.  # noqa: E501


        :return: The class_loader of this SpecificData.  # noqa: E501
        :rtype: ClassLoader
        """
        return self._class_loader

    @class_loader.setter
    def class_loader(self, class_loader):
        """Sets the class_loader of this SpecificData.


        :param class_loader: The class_loader of this SpecificData.  # noqa: E501
        :type: ClassLoader
        """

        self._class_loader = class_loader

    @property
    def conversions(self):
        """Gets the conversions of this SpecificData.  # noqa: E501


        :return: The conversions of this SpecificData.  # noqa: E501
        :rtype: list[ConversionObject]
        """
        return self._conversions

    @conversions.setter
    def conversions(self, conversions):
        """Sets the conversions of this SpecificData.


        :param conversions: The conversions of this SpecificData.  # noqa: E501
        :type: list[ConversionObject]
        """

        self._conversions = conversions

    @property
    def fast_reader_builder(self):
        """Gets the fast_reader_builder of this SpecificData.  # noqa: E501


        :return: The fast_reader_builder of this SpecificData.  # noqa: E501
        :rtype: FastReaderBuilder
        """
        return self._fast_reader_builder

    @fast_reader_builder.setter
    def fast_reader_builder(self, fast_reader_builder):
        """Sets the fast_reader_builder of this SpecificData.


        :param fast_reader_builder: The fast_reader_builder of this SpecificData.  # noqa: E501
        :type: FastReaderBuilder
        """

        self._fast_reader_builder = fast_reader_builder

    @property
    def fast_reader_enabled(self):
        """Gets the fast_reader_enabled of this SpecificData.  # noqa: E501


        :return: The fast_reader_enabled of this SpecificData.  # noqa: E501
        :rtype: bool
        """
        return self._fast_reader_enabled

    @fast_reader_enabled.setter
    def fast_reader_enabled(self, fast_reader_enabled):
        """Sets the fast_reader_enabled of this SpecificData.


        :param fast_reader_enabled: The fast_reader_enabled of this SpecificData.  # noqa: E501
        :type: bool
        """

        self._fast_reader_enabled = fast_reader_enabled

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SpecificData, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SpecificData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SpecificData):
            return True

        return self.to_dict() != other.to_dict()
