# coding: utf-8

"""
    Wavefront REST API

    <p>The Wavefront REST API enables you to interact with Wavefront servers using standard REST API tools. You can use the REST API to automate commonly executed operations such as automatically tagging sources.</p><p>When you make REST API calls outside the Wavefront REST API documentation you must add the header \"Authorization: Bearer &lt;&lt;API-TOKEN&gt;&gt;\" to your HTTP requests.</p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class ReportEventAnomalyDTO(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'related_anomaly_dto': 'RelatedAnomaly',
        'related_event_dto': 'RelatedEvent',
        'similarity_score': 'float'
    }

    attribute_map = {
        'related_anomaly_dto': 'relatedAnomalyDTO',
        'related_event_dto': 'relatedEventDTO',
        'similarity_score': 'similarityScore'
    }

    def __init__(self, related_anomaly_dto=None, related_event_dto=None, similarity_score=None, _configuration=None):  # noqa: E501
        """ReportEventAnomalyDTO - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._related_anomaly_dto = None
        self._related_event_dto = None
        self._similarity_score = None
        self.discriminator = None

        if related_anomaly_dto is not None:
            self.related_anomaly_dto = related_anomaly_dto
        if related_event_dto is not None:
            self.related_event_dto = related_event_dto
        if similarity_score is not None:
            self.similarity_score = similarity_score

    @property
    def related_anomaly_dto(self):
        """Gets the related_anomaly_dto of this ReportEventAnomalyDTO.  # noqa: E501


        :return: The related_anomaly_dto of this ReportEventAnomalyDTO.  # noqa: E501
        :rtype: RelatedAnomaly
        """
        return self._related_anomaly_dto

    @related_anomaly_dto.setter
    def related_anomaly_dto(self, related_anomaly_dto):
        """Sets the related_anomaly_dto of this ReportEventAnomalyDTO.


        :param related_anomaly_dto: The related_anomaly_dto of this ReportEventAnomalyDTO.  # noqa: E501
        :type: RelatedAnomaly
        """

        self._related_anomaly_dto = related_anomaly_dto

    @property
    def related_event_dto(self):
        """Gets the related_event_dto of this ReportEventAnomalyDTO.  # noqa: E501


        :return: The related_event_dto of this ReportEventAnomalyDTO.  # noqa: E501
        :rtype: RelatedEvent
        """
        return self._related_event_dto

    @related_event_dto.setter
    def related_event_dto(self, related_event_dto):
        """Sets the related_event_dto of this ReportEventAnomalyDTO.


        :param related_event_dto: The related_event_dto of this ReportEventAnomalyDTO.  # noqa: E501
        :type: RelatedEvent
        """

        self._related_event_dto = related_event_dto

    @property
    def similarity_score(self):
        """Gets the similarity_score of this ReportEventAnomalyDTO.  # noqa: E501


        :return: The similarity_score of this ReportEventAnomalyDTO.  # noqa: E501
        :rtype: float
        """
        return self._similarity_score

    @similarity_score.setter
    def similarity_score(self, similarity_score):
        """Sets the similarity_score of this ReportEventAnomalyDTO.


        :param similarity_score: The similarity_score of this ReportEventAnomalyDTO.  # noqa: E501
        :type: float
        """

        self._similarity_score = similarity_score

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ReportEventAnomalyDTO, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ReportEventAnomalyDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ReportEventAnomalyDTO):
            return True

        return self.to_dict() != other.to_dict()
