# coding: utf-8

"""
    Wavefront REST API

    <p>The Wavefront REST API enables you to interact with Wavefront servers using standard REST API tools. You can use the REST API to automate commonly executed operations such as automatically tagging sources.</p><p>When you make REST API calls outside the Wavefront REST API documentation you must add the header \"Authorization: Bearer &lt;&lt;API-TOKEN&gt;&gt;\" to your HTTP requests.</p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class Proxy(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'bytes_left_for_buffer': 'int',
        'bytes_per_minute_for_buffer': 'int',
        'collector_rate_limit': 'int',
        'collector_sets_rate_limit': 'bool',
        'customer_id': 'str',
        'deleted': 'bool',
        'ephemeral': 'bool',
        'events_rate_limit': 'float',
        'histogram_rate_limit': 'int',
        'hostname': 'str',
        'id': 'str',
        'in_trash': 'bool',
        'ingestion_policy': 'IngestionPolicy',
        'last_check_in_time': 'int',
        'last_error_event': 'Event',
        'last_error_time': 'int',
        'last_known_error': 'str',
        'local_queue_size': 'int',
        'name': 'str',
        'preprocessor_rules': 'str',
        'shutdown': 'bool',
        'source_tags_rate_limit': 'float',
        'span_logs_rate_limit': 'int',
        'span_rate_limit': 'int',
        'ssh_agent': 'bool',
        'status': 'str',
        'status_cause': 'str',
        'time_drift': 'int',
        'user_id': 'str',
        'version': 'str'
    }

    attribute_map = {
        'bytes_left_for_buffer': 'bytesLeftForBuffer',
        'bytes_per_minute_for_buffer': 'bytesPerMinuteForBuffer',
        'collector_rate_limit': 'collectorRateLimit',
        'collector_sets_rate_limit': 'collectorSetsRateLimit',
        'customer_id': 'customerId',
        'deleted': 'deleted',
        'ephemeral': 'ephemeral',
        'events_rate_limit': 'eventsRateLimit',
        'histogram_rate_limit': 'histogramRateLimit',
        'hostname': 'hostname',
        'id': 'id',
        'in_trash': 'inTrash',
        'ingestion_policy': 'ingestionPolicy',
        'last_check_in_time': 'lastCheckInTime',
        'last_error_event': 'lastErrorEvent',
        'last_error_time': 'lastErrorTime',
        'last_known_error': 'lastKnownError',
        'local_queue_size': 'localQueueSize',
        'name': 'name',
        'preprocessor_rules': 'preprocessorRules',
        'shutdown': 'shutdown',
        'source_tags_rate_limit': 'sourceTagsRateLimit',
        'span_logs_rate_limit': 'spanLogsRateLimit',
        'span_rate_limit': 'spanRateLimit',
        'ssh_agent': 'sshAgent',
        'status': 'status',
        'status_cause': 'statusCause',
        'time_drift': 'timeDrift',
        'user_id': 'userId',
        'version': 'version'
    }

    def __init__(self, bytes_left_for_buffer=None, bytes_per_minute_for_buffer=None, collector_rate_limit=None, collector_sets_rate_limit=None, customer_id=None, deleted=None, ephemeral=None, events_rate_limit=None, histogram_rate_limit=None, hostname=None, id=None, in_trash=None, ingestion_policy=None, last_check_in_time=None, last_error_event=None, last_error_time=None, last_known_error=None, local_queue_size=None, name=None, preprocessor_rules=None, shutdown=None, source_tags_rate_limit=None, span_logs_rate_limit=None, span_rate_limit=None, ssh_agent=None, status=None, status_cause=None, time_drift=None, user_id=None, version=None, _configuration=None):  # noqa: E501
        """Proxy - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._bytes_left_for_buffer = None
        self._bytes_per_minute_for_buffer = None
        self._collector_rate_limit = None
        self._collector_sets_rate_limit = None
        self._customer_id = None
        self._deleted = None
        self._ephemeral = None
        self._events_rate_limit = None
        self._histogram_rate_limit = None
        self._hostname = None
        self._id = None
        self._in_trash = None
        self._ingestion_policy = None
        self._last_check_in_time = None
        self._last_error_event = None
        self._last_error_time = None
        self._last_known_error = None
        self._local_queue_size = None
        self._name = None
        self._preprocessor_rules = None
        self._shutdown = None
        self._source_tags_rate_limit = None
        self._span_logs_rate_limit = None
        self._span_rate_limit = None
        self._ssh_agent = None
        self._status = None
        self._status_cause = None
        self._time_drift = None
        self._user_id = None
        self._version = None
        self.discriminator = None

        if bytes_left_for_buffer is not None:
            self.bytes_left_for_buffer = bytes_left_for_buffer
        if bytes_per_minute_for_buffer is not None:
            self.bytes_per_minute_for_buffer = bytes_per_minute_for_buffer
        if collector_rate_limit is not None:
            self.collector_rate_limit = collector_rate_limit
        if collector_sets_rate_limit is not None:
            self.collector_sets_rate_limit = collector_sets_rate_limit
        if customer_id is not None:
            self.customer_id = customer_id
        if deleted is not None:
            self.deleted = deleted
        if ephemeral is not None:
            self.ephemeral = ephemeral
        if events_rate_limit is not None:
            self.events_rate_limit = events_rate_limit
        if histogram_rate_limit is not None:
            self.histogram_rate_limit = histogram_rate_limit
        if hostname is not None:
            self.hostname = hostname
        if id is not None:
            self.id = id
        if in_trash is not None:
            self.in_trash = in_trash
        if ingestion_policy is not None:
            self.ingestion_policy = ingestion_policy
        if last_check_in_time is not None:
            self.last_check_in_time = last_check_in_time
        if last_error_event is not None:
            self.last_error_event = last_error_event
        if last_error_time is not None:
            self.last_error_time = last_error_time
        if last_known_error is not None:
            self.last_known_error = last_known_error
        if local_queue_size is not None:
            self.local_queue_size = local_queue_size
        self.name = name
        if preprocessor_rules is not None:
            self.preprocessor_rules = preprocessor_rules
        if shutdown is not None:
            self.shutdown = shutdown
        if source_tags_rate_limit is not None:
            self.source_tags_rate_limit = source_tags_rate_limit
        if span_logs_rate_limit is not None:
            self.span_logs_rate_limit = span_logs_rate_limit
        if span_rate_limit is not None:
            self.span_rate_limit = span_rate_limit
        if ssh_agent is not None:
            self.ssh_agent = ssh_agent
        if status is not None:
            self.status = status
        if status_cause is not None:
            self.status_cause = status_cause
        if time_drift is not None:
            self.time_drift = time_drift
        if user_id is not None:
            self.user_id = user_id
        if version is not None:
            self.version = version

    @property
    def bytes_left_for_buffer(self):
        """Gets the bytes_left_for_buffer of this Proxy.  # noqa: E501

        Number of bytes of space remaining in the persistent disk queue of this proxy  # noqa: E501

        :return: The bytes_left_for_buffer of this Proxy.  # noqa: E501
        :rtype: int
        """
        return self._bytes_left_for_buffer

    @bytes_left_for_buffer.setter
    def bytes_left_for_buffer(self, bytes_left_for_buffer):
        """Sets the bytes_left_for_buffer of this Proxy.

        Number of bytes of space remaining in the persistent disk queue of this proxy  # noqa: E501

        :param bytes_left_for_buffer: The bytes_left_for_buffer of this Proxy.  # noqa: E501
        :type: int
        """

        self._bytes_left_for_buffer = bytes_left_for_buffer

    @property
    def bytes_per_minute_for_buffer(self):
        """Gets the bytes_per_minute_for_buffer of this Proxy.  # noqa: E501

        Bytes used per minute by the persistent disk queue of this proxy  # noqa: E501

        :return: The bytes_per_minute_for_buffer of this Proxy.  # noqa: E501
        :rtype: int
        """
        return self._bytes_per_minute_for_buffer

    @bytes_per_minute_for_buffer.setter
    def bytes_per_minute_for_buffer(self, bytes_per_minute_for_buffer):
        """Sets the bytes_per_minute_for_buffer of this Proxy.

        Bytes used per minute by the persistent disk queue of this proxy  # noqa: E501

        :param bytes_per_minute_for_buffer: The bytes_per_minute_for_buffer of this Proxy.  # noqa: E501
        :type: int
        """

        self._bytes_per_minute_for_buffer = bytes_per_minute_for_buffer

    @property
    def collector_rate_limit(self):
        """Gets the collector_rate_limit of this Proxy.  # noqa: E501

        Proxy's rate limit  # noqa: E501

        :return: The collector_rate_limit of this Proxy.  # noqa: E501
        :rtype: int
        """
        return self._collector_rate_limit

    @collector_rate_limit.setter
    def collector_rate_limit(self, collector_rate_limit):
        """Sets the collector_rate_limit of this Proxy.

        Proxy's rate limit  # noqa: E501

        :param collector_rate_limit: The collector_rate_limit of this Proxy.  # noqa: E501
        :type: int
        """

        self._collector_rate_limit = collector_rate_limit

    @property
    def collector_sets_rate_limit(self):
        """Gets the collector_sets_rate_limit of this Proxy.  # noqa: E501

        When true, this proxy's rate limit is controlled remotely  # noqa: E501

        :return: The collector_sets_rate_limit of this Proxy.  # noqa: E501
        :rtype: bool
        """
        return self._collector_sets_rate_limit

    @collector_sets_rate_limit.setter
    def collector_sets_rate_limit(self, collector_sets_rate_limit):
        """Sets the collector_sets_rate_limit of this Proxy.

        When true, this proxy's rate limit is controlled remotely  # noqa: E501

        :param collector_sets_rate_limit: The collector_sets_rate_limit of this Proxy.  # noqa: E501
        :type: bool
        """

        self._collector_sets_rate_limit = collector_sets_rate_limit

    @property
    def customer_id(self):
        """Gets the customer_id of this Proxy.  # noqa: E501


        :return: The customer_id of this Proxy.  # noqa: E501
        :rtype: str
        """
        return self._customer_id

    @customer_id.setter
    def customer_id(self, customer_id):
        """Sets the customer_id of this Proxy.


        :param customer_id: The customer_id of this Proxy.  # noqa: E501
        :type: str
        """

        self._customer_id = customer_id

    @property
    def deleted(self):
        """Gets the deleted of this Proxy.  # noqa: E501


        :return: The deleted of this Proxy.  # noqa: E501
        :rtype: bool
        """
        return self._deleted

    @deleted.setter
    def deleted(self, deleted):
        """Sets the deleted of this Proxy.


        :param deleted: The deleted of this Proxy.  # noqa: E501
        :type: bool
        """

        self._deleted = deleted

    @property
    def ephemeral(self):
        """Gets the ephemeral of this Proxy.  # noqa: E501

        When true, this proxy is expected to be ephemeral (possibly hosted on a short-lived container) and will be deleted after a period of inactivity (not checking in)  # noqa: E501

        :return: The ephemeral of this Proxy.  # noqa: E501
        :rtype: bool
        """
        return self._ephemeral

    @ephemeral.setter
    def ephemeral(self, ephemeral):
        """Sets the ephemeral of this Proxy.

        When true, this proxy is expected to be ephemeral (possibly hosted on a short-lived container) and will be deleted after a period of inactivity (not checking in)  # noqa: E501

        :param ephemeral: The ephemeral of this Proxy.  # noqa: E501
        :type: bool
        """

        self._ephemeral = ephemeral

    @property
    def events_rate_limit(self):
        """Gets the events_rate_limit of this Proxy.  # noqa: E501

        Proxy's rate limit for events  # noqa: E501

        :return: The events_rate_limit of this Proxy.  # noqa: E501
        :rtype: float
        """
        return self._events_rate_limit

    @events_rate_limit.setter
    def events_rate_limit(self, events_rate_limit):
        """Sets the events_rate_limit of this Proxy.

        Proxy's rate limit for events  # noqa: E501

        :param events_rate_limit: The events_rate_limit of this Proxy.  # noqa: E501
        :type: float
        """

        self._events_rate_limit = events_rate_limit

    @property
    def histogram_rate_limit(self):
        """Gets the histogram_rate_limit of this Proxy.  # noqa: E501

        Proxy's rate limit for histograms  # noqa: E501

        :return: The histogram_rate_limit of this Proxy.  # noqa: E501
        :rtype: int
        """
        return self._histogram_rate_limit

    @histogram_rate_limit.setter
    def histogram_rate_limit(self, histogram_rate_limit):
        """Sets the histogram_rate_limit of this Proxy.

        Proxy's rate limit for histograms  # noqa: E501

        :param histogram_rate_limit: The histogram_rate_limit of this Proxy.  # noqa: E501
        :type: int
        """

        self._histogram_rate_limit = histogram_rate_limit

    @property
    def hostname(self):
        """Gets the hostname of this Proxy.  # noqa: E501

        Host name of the machine running the proxy  # noqa: E501

        :return: The hostname of this Proxy.  # noqa: E501
        :rtype: str
        """
        return self._hostname

    @hostname.setter
    def hostname(self, hostname):
        """Sets the hostname of this Proxy.

        Host name of the machine running the proxy  # noqa: E501

        :param hostname: The hostname of this Proxy.  # noqa: E501
        :type: str
        """

        self._hostname = hostname

    @property
    def id(self):
        """Gets the id of this Proxy.  # noqa: E501


        :return: The id of this Proxy.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Proxy.


        :param id: The id of this Proxy.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def in_trash(self):
        """Gets the in_trash of this Proxy.  # noqa: E501


        :return: The in_trash of this Proxy.  # noqa: E501
        :rtype: bool
        """
        return self._in_trash

    @in_trash.setter
    def in_trash(self, in_trash):
        """Sets the in_trash of this Proxy.


        :param in_trash: The in_trash of this Proxy.  # noqa: E501
        :type: bool
        """

        self._in_trash = in_trash

    @property
    def ingestion_policy(self):
        """Gets the ingestion_policy of this Proxy.  # noqa: E501

        Ingestion policy associated with the proxy  # noqa: E501

        :return: The ingestion_policy of this Proxy.  # noqa: E501
        :rtype: IngestionPolicy
        """
        return self._ingestion_policy

    @ingestion_policy.setter
    def ingestion_policy(self, ingestion_policy):
        """Sets the ingestion_policy of this Proxy.

        Ingestion policy associated with the proxy  # noqa: E501

        :param ingestion_policy: The ingestion_policy of this Proxy.  # noqa: E501
        :type: IngestionPolicy
        """

        self._ingestion_policy = ingestion_policy

    @property
    def last_check_in_time(self):
        """Gets the last_check_in_time of this Proxy.  # noqa: E501

        Last time when this proxy checked in (in milliseconds since the unix epoch)  # noqa: E501

        :return: The last_check_in_time of this Proxy.  # noqa: E501
        :rtype: int
        """
        return self._last_check_in_time

    @last_check_in_time.setter
    def last_check_in_time(self, last_check_in_time):
        """Sets the last_check_in_time of this Proxy.

        Last time when this proxy checked in (in milliseconds since the unix epoch)  # noqa: E501

        :param last_check_in_time: The last_check_in_time of this Proxy.  # noqa: E501
        :type: int
        """

        self._last_check_in_time = last_check_in_time

    @property
    def last_error_event(self):
        """Gets the last_error_event of this Proxy.  # noqa: E501


        :return: The last_error_event of this Proxy.  # noqa: E501
        :rtype: Event
        """
        return self._last_error_event

    @last_error_event.setter
    def last_error_event(self, last_error_event):
        """Sets the last_error_event of this Proxy.


        :param last_error_event: The last_error_event of this Proxy.  # noqa: E501
        :type: Event
        """

        self._last_error_event = last_error_event

    @property
    def last_error_time(self):
        """Gets the last_error_time of this Proxy.  # noqa: E501

        deprecated  # noqa: E501

        :return: The last_error_time of this Proxy.  # noqa: E501
        :rtype: int
        """
        return self._last_error_time

    @last_error_time.setter
    def last_error_time(self, last_error_time):
        """Sets the last_error_time of this Proxy.

        deprecated  # noqa: E501

        :param last_error_time: The last_error_time of this Proxy.  # noqa: E501
        :type: int
        """

        self._last_error_time = last_error_time

    @property
    def last_known_error(self):
        """Gets the last_known_error of this Proxy.  # noqa: E501

        deprecated  # noqa: E501

        :return: The last_known_error of this Proxy.  # noqa: E501
        :rtype: str
        """
        return self._last_known_error

    @last_known_error.setter
    def last_known_error(self, last_known_error):
        """Sets the last_known_error of this Proxy.

        deprecated  # noqa: E501

        :param last_known_error: The last_known_error of this Proxy.  # noqa: E501
        :type: str
        """

        self._last_known_error = last_known_error

    @property
    def local_queue_size(self):
        """Gets the local_queue_size of this Proxy.  # noqa: E501

        Number of items in the persistent disk queue of this proxy  # noqa: E501

        :return: The local_queue_size of this Proxy.  # noqa: E501
        :rtype: int
        """
        return self._local_queue_size

    @local_queue_size.setter
    def local_queue_size(self, local_queue_size):
        """Sets the local_queue_size of this Proxy.

        Number of items in the persistent disk queue of this proxy  # noqa: E501

        :param local_queue_size: The local_queue_size of this Proxy.  # noqa: E501
        :type: int
        """

        self._local_queue_size = local_queue_size

    @property
    def name(self):
        """Gets the name of this Proxy.  # noqa: E501

        Proxy name (modifiable)  # noqa: E501

        :return: The name of this Proxy.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Proxy.

        Proxy name (modifiable)  # noqa: E501

        :param name: The name of this Proxy.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def preprocessor_rules(self):
        """Gets the preprocessor_rules of this Proxy.  # noqa: E501

        Proxy's preprocessor rules  # noqa: E501

        :return: The preprocessor_rules of this Proxy.  # noqa: E501
        :rtype: str
        """
        return self._preprocessor_rules

    @preprocessor_rules.setter
    def preprocessor_rules(self, preprocessor_rules):
        """Sets the preprocessor_rules of this Proxy.

        Proxy's preprocessor rules  # noqa: E501

        :param preprocessor_rules: The preprocessor_rules of this Proxy.  # noqa: E501
        :type: str
        """

        self._preprocessor_rules = preprocessor_rules

    @property
    def shutdown(self):
        """Gets the shutdown of this Proxy.  # noqa: E501

        When true, attempt to shut down this proxy remotely  # noqa: E501

        :return: The shutdown of this Proxy.  # noqa: E501
        :rtype: bool
        """
        return self._shutdown

    @shutdown.setter
    def shutdown(self, shutdown):
        """Sets the shutdown of this Proxy.

        When true, attempt to shut down this proxy remotely  # noqa: E501

        :param shutdown: The shutdown of this Proxy.  # noqa: E501
        :type: bool
        """

        self._shutdown = shutdown

    @property
    def source_tags_rate_limit(self):
        """Gets the source_tags_rate_limit of this Proxy.  # noqa: E501

        Proxy's rate limit for source tag operations  # noqa: E501

        :return: The source_tags_rate_limit of this Proxy.  # noqa: E501
        :rtype: float
        """
        return self._source_tags_rate_limit

    @source_tags_rate_limit.setter
    def source_tags_rate_limit(self, source_tags_rate_limit):
        """Sets the source_tags_rate_limit of this Proxy.

        Proxy's rate limit for source tag operations  # noqa: E501

        :param source_tags_rate_limit: The source_tags_rate_limit of this Proxy.  # noqa: E501
        :type: float
        """

        self._source_tags_rate_limit = source_tags_rate_limit

    @property
    def span_logs_rate_limit(self):
        """Gets the span_logs_rate_limit of this Proxy.  # noqa: E501

        Proxy's rate limit for span logs  # noqa: E501

        :return: The span_logs_rate_limit of this Proxy.  # noqa: E501
        :rtype: int
        """
        return self._span_logs_rate_limit

    @span_logs_rate_limit.setter
    def span_logs_rate_limit(self, span_logs_rate_limit):
        """Sets the span_logs_rate_limit of this Proxy.

        Proxy's rate limit for span logs  # noqa: E501

        :param span_logs_rate_limit: The span_logs_rate_limit of this Proxy.  # noqa: E501
        :type: int
        """

        self._span_logs_rate_limit = span_logs_rate_limit

    @property
    def span_rate_limit(self):
        """Gets the span_rate_limit of this Proxy.  # noqa: E501

        Proxy's rate limit for spans  # noqa: E501

        :return: The span_rate_limit of this Proxy.  # noqa: E501
        :rtype: int
        """
        return self._span_rate_limit

    @span_rate_limit.setter
    def span_rate_limit(self, span_rate_limit):
        """Sets the span_rate_limit of this Proxy.

        Proxy's rate limit for spans  # noqa: E501

        :param span_rate_limit: The span_rate_limit of this Proxy.  # noqa: E501
        :type: int
        """

        self._span_rate_limit = span_rate_limit

    @property
    def ssh_agent(self):
        """Gets the ssh_agent of this Proxy.  # noqa: E501

        deprecated  # noqa: E501

        :return: The ssh_agent of this Proxy.  # noqa: E501
        :rtype: bool
        """
        return self._ssh_agent

    @ssh_agent.setter
    def ssh_agent(self, ssh_agent):
        """Sets the ssh_agent of this Proxy.

        deprecated  # noqa: E501

        :param ssh_agent: The ssh_agent of this Proxy.  # noqa: E501
        :type: bool
        """

        self._ssh_agent = ssh_agent

    @property
    def status(self):
        """Gets the status of this Proxy.  # noqa: E501

        the proxy's status  # noqa: E501

        :return: The status of this Proxy.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Proxy.

        the proxy's status  # noqa: E501

        :param status: The status of this Proxy.  # noqa: E501
        :type: str
        """
        allowed_values = ["ACTIVE", "STOPPED_UNKNOWN", "STOPPED_BY_SERVER"]  # noqa: E501
        if (self._configuration.client_side_validation and
                status not in allowed_values):
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def status_cause(self):
        """Gets the status_cause of this Proxy.  # noqa: E501

        The reason why the proxy is in current status  # noqa: E501

        :return: The status_cause of this Proxy.  # noqa: E501
        :rtype: str
        """
        return self._status_cause

    @status_cause.setter
    def status_cause(self, status_cause):
        """Sets the status_cause of this Proxy.

        The reason why the proxy is in current status  # noqa: E501

        :param status_cause: The status_cause of this Proxy.  # noqa: E501
        :type: str
        """

        self._status_cause = status_cause

    @property
    def time_drift(self):
        """Gets the time_drift of this Proxy.  # noqa: E501

        Time drift of the proxy's clock compared to Wavefront servers  # noqa: E501

        :return: The time_drift of this Proxy.  # noqa: E501
        :rtype: int
        """
        return self._time_drift

    @time_drift.setter
    def time_drift(self, time_drift):
        """Sets the time_drift of this Proxy.

        Time drift of the proxy's clock compared to Wavefront servers  # noqa: E501

        :param time_drift: The time_drift of this Proxy.  # noqa: E501
        :type: int
        """

        self._time_drift = time_drift

    @property
    def user_id(self):
        """Gets the user_id of this Proxy.  # noqa: E501

        The user associated with this proxy  # noqa: E501

        :return: The user_id of this Proxy.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this Proxy.

        The user associated with this proxy  # noqa: E501

        :param user_id: The user_id of this Proxy.  # noqa: E501
        :type: str
        """

        self._user_id = user_id

    @property
    def version(self):
        """Gets the version of this Proxy.  # noqa: E501


        :return: The version of this Proxy.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this Proxy.


        :param version: The version of this Proxy.  # noqa: E501
        :type: str
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Proxy, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Proxy):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Proxy):
            return True

        return self.to_dict() != other.to_dict()
