# coding: utf-8

"""
    Wavefront REST API

    <p>The Wavefront REST API enables you to interact with Wavefront servers using standard REST API tools. You can use the REST API to automate commonly executed operations such as automatically tagging sources.</p><p>When you make REST API calls outside the Wavefront REST API documentation you must add the header \"Authorization: Bearer &lt;&lt;API-TOKEN&gt;&gt;\" to your HTTP requests.</p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class Module(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'annotations': 'list[Annotation]',
        'class_loader': 'ClassLoader',
        'declared_annotations': 'list[Annotation]',
        'descriptor': 'ModuleDescriptor',
        'layer': 'ModuleLayer',
        'name': 'str',
        'named': 'bool',
        'packages': 'list[str]'
    }

    attribute_map = {
        'annotations': 'annotations',
        'class_loader': 'classLoader',
        'declared_annotations': 'declaredAnnotations',
        'descriptor': 'descriptor',
        'layer': 'layer',
        'name': 'name',
        'named': 'named',
        'packages': 'packages'
    }

    def __init__(self, annotations=None, class_loader=None, declared_annotations=None, descriptor=None, layer=None, name=None, named=None, packages=None, _configuration=None):  # noqa: E501
        """Module - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._annotations = None
        self._class_loader = None
        self._declared_annotations = None
        self._descriptor = None
        self._layer = None
        self._name = None
        self._named = None
        self._packages = None
        self.discriminator = None

        if annotations is not None:
            self.annotations = annotations
        if class_loader is not None:
            self.class_loader = class_loader
        if declared_annotations is not None:
            self.declared_annotations = declared_annotations
        if descriptor is not None:
            self.descriptor = descriptor
        if layer is not None:
            self.layer = layer
        if name is not None:
            self.name = name
        if named is not None:
            self.named = named
        if packages is not None:
            self.packages = packages

    @property
    def annotations(self):
        """Gets the annotations of this Module.  # noqa: E501


        :return: The annotations of this Module.  # noqa: E501
        :rtype: list[Annotation]
        """
        return self._annotations

    @annotations.setter
    def annotations(self, annotations):
        """Sets the annotations of this Module.


        :param annotations: The annotations of this Module.  # noqa: E501
        :type: list[Annotation]
        """

        self._annotations = annotations

    @property
    def class_loader(self):
        """Gets the class_loader of this Module.  # noqa: E501


        :return: The class_loader of this Module.  # noqa: E501
        :rtype: ClassLoader
        """
        return self._class_loader

    @class_loader.setter
    def class_loader(self, class_loader):
        """Sets the class_loader of this Module.


        :param class_loader: The class_loader of this Module.  # noqa: E501
        :type: ClassLoader
        """

        self._class_loader = class_loader

    @property
    def declared_annotations(self):
        """Gets the declared_annotations of this Module.  # noqa: E501


        :return: The declared_annotations of this Module.  # noqa: E501
        :rtype: list[Annotation]
        """
        return self._declared_annotations

    @declared_annotations.setter
    def declared_annotations(self, declared_annotations):
        """Sets the declared_annotations of this Module.


        :param declared_annotations: The declared_annotations of this Module.  # noqa: E501
        :type: list[Annotation]
        """

        self._declared_annotations = declared_annotations

    @property
    def descriptor(self):
        """Gets the descriptor of this Module.  # noqa: E501


        :return: The descriptor of this Module.  # noqa: E501
        :rtype: ModuleDescriptor
        """
        return self._descriptor

    @descriptor.setter
    def descriptor(self, descriptor):
        """Sets the descriptor of this Module.


        :param descriptor: The descriptor of this Module.  # noqa: E501
        :type: ModuleDescriptor
        """

        self._descriptor = descriptor

    @property
    def layer(self):
        """Gets the layer of this Module.  # noqa: E501


        :return: The layer of this Module.  # noqa: E501
        :rtype: ModuleLayer
        """
        return self._layer

    @layer.setter
    def layer(self, layer):
        """Sets the layer of this Module.


        :param layer: The layer of this Module.  # noqa: E501
        :type: ModuleLayer
        """

        self._layer = layer

    @property
    def name(self):
        """Gets the name of this Module.  # noqa: E501


        :return: The name of this Module.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Module.


        :param name: The name of this Module.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def named(self):
        """Gets the named of this Module.  # noqa: E501


        :return: The named of this Module.  # noqa: E501
        :rtype: bool
        """
        return self._named

    @named.setter
    def named(self, named):
        """Sets the named of this Module.


        :param named: The named of this Module.  # noqa: E501
        :type: bool
        """

        self._named = named

    @property
    def packages(self):
        """Gets the packages of this Module.  # noqa: E501


        :return: The packages of this Module.  # noqa: E501
        :rtype: list[str]
        """
        return self._packages

    @packages.setter
    def packages(self, packages):
        """Sets the packages of this Module.


        :param packages: The packages of this Module.  # noqa: E501
        :type: list[str]
        """

        self._packages = packages

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Module, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Module):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Module):
            return True

        return self.to_dict() != other.to_dict()
