# coding: utf-8

"""
    Wavefront REST API

    <p>The Wavefront REST API enables you to interact with Wavefront servers using standard REST API tools. You can use the REST API to automate commonly executed operations such as automatically tagging sources.</p><p>When you make REST API calls outside the Wavefront REST API documentation you must add the header \"Authorization: Bearer &lt;&lt;API-TOKEN&gt;&gt;\" to your HTTP requests.</p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class DashboardSectionRow(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'charts': 'list[Chart]',
        'height_factor': 'int'
    }

    attribute_map = {
        'charts': 'charts',
        'height_factor': 'heightFactor'
    }

    def __init__(self, charts=None, height_factor=None, _configuration=None):  # noqa: E501
        """DashboardSectionRow - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._charts = None
        self._height_factor = None
        self.discriminator = None

        self.charts = charts
        if height_factor is not None:
            self.height_factor = height_factor

    @property
    def charts(self):
        """Gets the charts of this DashboardSectionRow.  # noqa: E501

        Charts in this section row  # noqa: E501

        :return: The charts of this DashboardSectionRow.  # noqa: E501
        :rtype: list[Chart]
        """
        return self._charts

    @charts.setter
    def charts(self, charts):
        """Sets the charts of this DashboardSectionRow.

        Charts in this section row  # noqa: E501

        :param charts: The charts of this DashboardSectionRow.  # noqa: E501
        :type: list[Chart]
        """
        if self._configuration.client_side_validation and charts is None:
            raise ValueError("Invalid value for `charts`, must not be `None`")  # noqa: E501

        self._charts = charts

    @property
    def height_factor(self):
        """Gets the height_factor of this DashboardSectionRow.  # noqa: E501

        Scalar for the height of this row. 100 is normal and default. 50 is half height  # noqa: E501

        :return: The height_factor of this DashboardSectionRow.  # noqa: E501
        :rtype: int
        """
        return self._height_factor

    @height_factor.setter
    def height_factor(self, height_factor):
        """Sets the height_factor of this DashboardSectionRow.

        Scalar for the height of this row. 100 is normal and default. 50 is half height  # noqa: E501

        :param height_factor: The height_factor of this DashboardSectionRow.  # noqa: E501
        :type: int
        """

        self._height_factor = height_factor

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DashboardSectionRow, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DashboardSectionRow):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DashboardSectionRow):
            return True

        return self.to_dict() != other.to_dict()
