# coding: utf-8

"""
    Wavefront REST API

    <p>The Wavefront REST API enables you to interact with Wavefront servers using standard REST API tools. You can use the REST API to automate commonly executed operations such as automatically tagging sources.</p><p>When you make REST API calls outside the Wavefront REST API documentation you must add the header \"Authorization: Bearer &lt;&lt;API-TOKEN&gt;&gt;\" to your HTTP requests.</p>  # noqa: E501

    OpenAPI spec version: v2
    Contact: chitimba@wavefront.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from wavefront_api_client.configuration import Configuration


class Account(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'groups': 'list[str]',
        'identifier': 'str',
        'ingestion_policy_id': 'str',
        'roles': 'list[str]',
        'united_permissions': 'list[str]',
        'united_roles': 'list[str]',
        'user_groups': 'list[str]'
    }

    attribute_map = {
        'groups': 'groups',
        'identifier': 'identifier',
        'ingestion_policy_id': 'ingestionPolicyId',
        'roles': 'roles',
        'united_permissions': 'unitedPermissions',
        'united_roles': 'unitedRoles',
        'user_groups': 'userGroups'
    }

    def __init__(self, groups=None, identifier=None, ingestion_policy_id=None, roles=None, united_permissions=None, united_roles=None, user_groups=None, _configuration=None):  # noqa: E501
        """Account - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._groups = None
        self._identifier = None
        self._ingestion_policy_id = None
        self._roles = None
        self._united_permissions = None
        self._united_roles = None
        self._user_groups = None
        self.discriminator = None

        if groups is not None:
            self.groups = groups
        self.identifier = identifier
        if ingestion_policy_id is not None:
            self.ingestion_policy_id = ingestion_policy_id
        if roles is not None:
            self.roles = roles
        if united_permissions is not None:
            self.united_permissions = united_permissions
        if united_roles is not None:
            self.united_roles = united_roles
        if user_groups is not None:
            self.user_groups = user_groups

    @property
    def groups(self):
        """Gets the groups of this Account.  # noqa: E501

        The list of account's permissions.  # noqa: E501

        :return: The groups of this Account.  # noqa: E501
        :rtype: list[str]
        """
        return self._groups

    @groups.setter
    def groups(self, groups):
        """Sets the groups of this Account.

        The list of account's permissions.  # noqa: E501

        :param groups: The groups of this Account.  # noqa: E501
        :type: list[str]
        """

        self._groups = groups

    @property
    def identifier(self):
        """Gets the identifier of this Account.  # noqa: E501

        The unique identifier of an account.  # noqa: E501

        :return: The identifier of this Account.  # noqa: E501
        :rtype: str
        """
        return self._identifier

    @identifier.setter
    def identifier(self, identifier):
        """Sets the identifier of this Account.

        The unique identifier of an account.  # noqa: E501

        :param identifier: The identifier of this Account.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and identifier is None:
            raise ValueError("Invalid value for `identifier`, must not be `None`")  # noqa: E501

        self._identifier = identifier

    @property
    def ingestion_policy_id(self):
        """Gets the ingestion_policy_id of this Account.  # noqa: E501

        The identifier of the ingestion policy linked with account.  # noqa: E501

        :return: The ingestion_policy_id of this Account.  # noqa: E501
        :rtype: str
        """
        return self._ingestion_policy_id

    @ingestion_policy_id.setter
    def ingestion_policy_id(self, ingestion_policy_id):
        """Sets the ingestion_policy_id of this Account.

        The identifier of the ingestion policy linked with account.  # noqa: E501

        :param ingestion_policy_id: The ingestion_policy_id of this Account.  # noqa: E501
        :type: str
        """

        self._ingestion_policy_id = ingestion_policy_id

    @property
    def roles(self):
        """Gets the roles of this Account.  # noqa: E501

        The list of account's roles.  # noqa: E501

        :return: The roles of this Account.  # noqa: E501
        :rtype: list[str]
        """
        return self._roles

    @roles.setter
    def roles(self, roles):
        """Sets the roles of this Account.

        The list of account's roles.  # noqa: E501

        :param roles: The roles of this Account.  # noqa: E501
        :type: list[str]
        """

        self._roles = roles

    @property
    def united_permissions(self):
        """Gets the united_permissions of this Account.  # noqa: E501

        The list of account's permissions assigned directly or through united roles assigned to it  # noqa: E501

        :return: The united_permissions of this Account.  # noqa: E501
        :rtype: list[str]
        """
        return self._united_permissions

    @united_permissions.setter
    def united_permissions(self, united_permissions):
        """Sets the united_permissions of this Account.

        The list of account's permissions assigned directly or through united roles assigned to it  # noqa: E501

        :param united_permissions: The united_permissions of this Account.  # noqa: E501
        :type: list[str]
        """

        self._united_permissions = united_permissions

    @property
    def united_roles(self):
        """Gets the united_roles of this Account.  # noqa: E501

        The list of account's roles assigned directly or through user groups assigned to it  # noqa: E501

        :return: The united_roles of this Account.  # noqa: E501
        :rtype: list[str]
        """
        return self._united_roles

    @united_roles.setter
    def united_roles(self, united_roles):
        """Sets the united_roles of this Account.

        The list of account's roles assigned directly or through user groups assigned to it  # noqa: E501

        :param united_roles: The united_roles of this Account.  # noqa: E501
        :type: list[str]
        """

        self._united_roles = united_roles

    @property
    def user_groups(self):
        """Gets the user_groups of this Account.  # noqa: E501

        The list of account's user groups.  # noqa: E501

        :return: The user_groups of this Account.  # noqa: E501
        :rtype: list[str]
        """
        return self._user_groups

    @user_groups.setter
    def user_groups(self, user_groups):
        """Sets the user_groups of this Account.

        The list of account's user groups.  # noqa: E501

        :param user_groups: The user_groups of this Account.  # noqa: E501
        :type: list[str]
        """

        self._user_groups = user_groups

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Account, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Account):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Account):
            return True

        return self.to_dict() != other.to_dict()
