Lion ORM - возможно, самая примитивная ОРМ в мире. Она работает только с sqlite и поддерживает всего 2 типа данных: int и str. В ней нет никаких ленивых запросов и вообще, ничего интересного. Однако ее исходный код может быть вам полезен, если вы хотите узнать, как можно создать свою ОРМ.

Приступим к примерам использования с подключения базы данных:

```
from lion_orm.connect import SqliteConnect


SqliteConnect("test.db")
```

Обратите внимание, что SqliteConnect() можно вызвать без аргументов, в этом случае база данных будет создана в оперативной памяти.

Теперь попробуем создать модель данных:

```
from lion_orm.model import Model
from lion_orm.field import Field


class CarModel(Model):
    price = Field(int)
    color = Field(str, required=True)
    brand = Field(str)
```

Чего здесь примечательного? Во-первых, вам не нужно создавать поле id. Оно будет создано автоматически и является автоинкрементальным. Во-вторых, Field может принимать тип данных поля как в форме объекта типа данных python, так и в форме строки, соответствующей названию типа данных в sqlite. В третьих, если соответствующая данной модели таблица в базе данных еще не существует, она будет создана вместе с первым же экземпляром.

Что ж, мы создали модель, давайте теперь создадим ее экземпляр:

```
car = CarModel(price=100000, color="red", brand="audi")
car.save()
```

Данные экземпляра модели отправляются в базу только при вызове метода save(). Имейте ввиду, что, если вы попытаетесь сохранить в базу данные экземпляра модели, где не заполнены все обязательные атрибуты, вы получите SaveEmptyModelError.

У нас есть экземпляр модели, что дальше? Дальше мы будем делать запросы к базе данных. И начнем мы с select:

```
rich_cars = car.query.select(price=100000)
```

В данном примере мы сделали select-запрос прямо из экземпляра модели. Почему так? Ну, у нас примитивная ОРМ. А еще так можно делать в Django.

Также можно выбрать все элементы класса, вызвав метод select() без аргументов:

```
all_cars = car.query.select()
```

Как результат select-запроса мы получаем объект класса QuerySet. По своему поведению он напоминает объект списка: по нему можно итерироваться, а также получать из него значения по индексу. Давайте попробуем:

```
for x in all_cars:
    print(x)


first_car = all_cars[0]
print(first_car)
```

Это работает! А еще все объекты из QuerySet можно удалить сразу, вызвав у него метод delete():

```
all_cars.delete()
```

Если после этого вы попытаетесь вновь проитерироваться по данному объекту QuerySet или получить значение по индексу, получите UsingDeletedQuerySetError.

Разумеется, у экземпляров модели тоже есть метод delete():

```
new_car = CarModel(price=100000, color="blue", brand="audi")
new_car.save() # экземпляр модели есть
new_car.delete() # и оп, его нет
```

Присвоить значение атрибутам экземпляра модели вы можете именно так, как ожидаете, что это будет работать:

```
new_car.price = 110000
new_car.save()
```

После сохранения экземпляра в базе, вы можете посмотреть его id:

```
print(new_car.id)
# 1
```
Вроде бы все, ничего не забыл. Да тут и сложно что-то забыть, ведь это самая примитивная ОРМ!
