# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'FlowEncryptionArgs',
    'FlowEntitlementEncryptionArgs',
    'FlowFailoverConfigArgs',
    'FlowOutputEncryptionArgs',
    'FlowOutputVpcInterfaceAttachmentArgs',
    'FlowSourceEncryptionArgs',
    'FlowSourceArgs',
]

@pulumi.input_type
class FlowEncryptionArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input['FlowEncryptionAlgorithm'],
                 role_arn: pulumi.Input[str],
                 constant_initialization_vector: Optional[pulumi.Input[str]] = None,
                 device_id: Optional[pulumi.Input[str]] = None,
                 key_type: Optional[pulumi.Input['FlowEncryptionKeyType']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 secret_arn: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Information about the encryption of the flow.
        :param pulumi.Input['FlowEncryptionAlgorithm'] algorithm: The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        :param pulumi.Input[str] role_arn: The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        :param pulumi.Input[str] constant_initialization_vector: A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        :param pulumi.Input[str] device_id: The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input['FlowEncryptionKeyType'] key_type: The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        :param pulumi.Input[str] region: The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input[str] resource_id: An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input[str] secret_arn:  The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        :param pulumi.Input[str] url: The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "role_arn", role_arn)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if device_id is not None:
            pulumi.set(__self__, "device_id", device_id)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input['FlowEncryptionAlgorithm']:
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input['FlowEncryptionAlgorithm']):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[pulumi.Input[str]]:
        """
        A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        """
        return pulumi.get(self, "constant_initialization_vector")

    @constant_initialization_vector.setter
    def constant_initialization_vector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "constant_initialization_vector", value)

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[pulumi.Input[str]]:
        """
        The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "device_id")

    @device_id.setter
    def device_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_id", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input['FlowEncryptionKeyType']]:
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input['FlowEncryptionKeyType']]):
        pulumi.set(self, "key_type", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[pulumi.Input[str]]:
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_arn", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class FlowEntitlementEncryptionArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input['FlowEntitlementEncryptionAlgorithm'],
                 role_arn: pulumi.Input[str],
                 constant_initialization_vector: Optional[pulumi.Input[str]] = None,
                 device_id: Optional[pulumi.Input[str]] = None,
                 key_type: Optional[pulumi.Input['FlowEntitlementEncryptionKeyType']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 secret_arn: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Information about the encryption of the flow.
        :param pulumi.Input['FlowEntitlementEncryptionAlgorithm'] algorithm: The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        :param pulumi.Input[str] role_arn: The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        :param pulumi.Input[str] constant_initialization_vector: A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        :param pulumi.Input[str] device_id: The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input['FlowEntitlementEncryptionKeyType'] key_type: The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        :param pulumi.Input[str] region: The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input[str] resource_id: An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input[str] secret_arn:  The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        :param pulumi.Input[str] url: The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "role_arn", role_arn)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if device_id is not None:
            pulumi.set(__self__, "device_id", device_id)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input['FlowEntitlementEncryptionAlgorithm']:
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input['FlowEntitlementEncryptionAlgorithm']):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[pulumi.Input[str]]:
        """
        A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        """
        return pulumi.get(self, "constant_initialization_vector")

    @constant_initialization_vector.setter
    def constant_initialization_vector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "constant_initialization_vector", value)

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[pulumi.Input[str]]:
        """
        The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "device_id")

    @device_id.setter
    def device_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_id", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input['FlowEntitlementEncryptionKeyType']]:
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input['FlowEntitlementEncryptionKeyType']]):
        pulumi.set(self, "key_type", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[pulumi.Input[str]]:
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_arn", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class FlowFailoverConfigArgs:
    def __init__(__self__, *,
                 recovery_window: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input['FlowFailoverConfigState']] = None):
        """
        The settings for source failover
        :param pulumi.Input[int] recovery_window: Search window time to look for dash-7 packets
        """
        if recovery_window is not None:
            pulumi.set(__self__, "recovery_window", recovery_window)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="recoveryWindow")
    def recovery_window(self) -> Optional[pulumi.Input[int]]:
        """
        Search window time to look for dash-7 packets
        """
        return pulumi.get(self, "recovery_window")

    @recovery_window.setter
    def recovery_window(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "recovery_window", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input['FlowFailoverConfigState']]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input['FlowFailoverConfigState']]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class FlowOutputEncryptionArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input['FlowOutputEncryptionAlgorithm'],
                 role_arn: pulumi.Input[str],
                 secret_arn: pulumi.Input[str],
                 key_type: Optional[pulumi.Input['FlowOutputEncryptionKeyType']] = None):
        """
        Information about the encryption of the flow.
        :param pulumi.Input['FlowOutputEncryptionAlgorithm'] algorithm: The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        :param pulumi.Input[str] role_arn: The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        :param pulumi.Input[str] secret_arn:  The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        :param pulumi.Input['FlowOutputEncryptionKeyType'] key_type: The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "secret_arn", secret_arn)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)

    @property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input['FlowOutputEncryptionAlgorithm']:
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input['FlowOutputEncryptionAlgorithm']):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> pulumi.Input[str]:
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_arn", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input['FlowOutputEncryptionKeyType']]:
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input['FlowOutputEncryptionKeyType']]):
        pulumi.set(self, "key_type", value)


@pulumi.input_type
class FlowOutputVpcInterfaceAttachmentArgs:
    def __init__(__self__, *,
                 vpc_interface_name: Optional[pulumi.Input[str]] = None):
        """
        The settings for attaching a VPC interface to an output.
        :param pulumi.Input[str] vpc_interface_name: The name of the VPC interface to use for this output.
        """
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPC interface to use for this output.
        """
        return pulumi.get(self, "vpc_interface_name")

    @vpc_interface_name.setter
    def vpc_interface_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_interface_name", value)


@pulumi.input_type
class FlowSourceEncryptionArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input['FlowSourceEncryptionAlgorithm'],
                 role_arn: pulumi.Input[str],
                 constant_initialization_vector: Optional[pulumi.Input[str]] = None,
                 device_id: Optional[pulumi.Input[str]] = None,
                 key_type: Optional[pulumi.Input['FlowSourceEncryptionKeyType']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 secret_arn: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Information about the encryption of the flow.
        :param pulumi.Input['FlowSourceEncryptionAlgorithm'] algorithm: The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        :param pulumi.Input[str] role_arn: The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        :param pulumi.Input[str] constant_initialization_vector: A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        :param pulumi.Input[str] device_id: The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input['FlowSourceEncryptionKeyType'] key_type: The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        :param pulumi.Input[str] region: The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input[str] resource_id: An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        :param pulumi.Input[str] secret_arn:  The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        :param pulumi.Input[str] url: The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "role_arn", role_arn)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if device_id is not None:
            pulumi.set(__self__, "device_id", device_id)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if secret_arn is not None:
            pulumi.set(__self__, "secret_arn", secret_arn)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input['FlowSourceEncryptionAlgorithm']:
        """
        The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input['FlowSourceEncryptionAlgorithm']):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[pulumi.Input[str]]:
        """
        A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        """
        return pulumi.get(self, "constant_initialization_vector")

    @constant_initialization_vector.setter
    def constant_initialization_vector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "constant_initialization_vector", value)

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[pulumi.Input[str]]:
        """
        The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "device_id")

    @device_id.setter
    def device_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_id", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input['FlowSourceEncryptionKeyType']]:
        """
        The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input['FlowSourceEncryptionKeyType']]):
        pulumi.set(self, "key_type", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[pulumi.Input[str]]:
        """
         The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        """
        return pulumi.get(self, "secret_arn")

    @secret_arn.setter
    def secret_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_arn", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class FlowSourceArgs:
    def __init__(__self__, *,
                 decryption: Optional[pulumi.Input['FlowEncryptionArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entitlement_arn: Optional[pulumi.Input[str]] = None,
                 ingest_ip: Optional[pulumi.Input[str]] = None,
                 ingest_port: Optional[pulumi.Input[int]] = None,
                 max_bitrate: Optional[pulumi.Input[int]] = None,
                 max_latency: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input['FlowSourceProtocol']] = None,
                 source_arn: Optional[pulumi.Input[str]] = None,
                 stream_id: Optional[pulumi.Input[str]] = None,
                 vpc_interface_name: Optional[pulumi.Input[str]] = None,
                 whitelist_cidr: Optional[pulumi.Input[str]] = None):
        """
        The settings for the source of the flow.
        :param pulumi.Input['FlowEncryptionArgs'] decryption: The type of encryption that is used on the content ingested from this source.
        :param pulumi.Input[str] description: A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        :param pulumi.Input[str] entitlement_arn: The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
        :param pulumi.Input[str] ingest_ip: The IP address that the flow will be listening on for incoming content.
        :param pulumi.Input[int] ingest_port: The port that the flow will be listening on for incoming content.
        :param pulumi.Input[int] max_bitrate: The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        :param pulumi.Input[int] max_latency: The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
        :param pulumi.Input[str] name: The name of the source.
        :param pulumi.Input['FlowSourceProtocol'] protocol: The protocol that is used by the source or output.
        :param pulumi.Input[str] source_arn: The ARN of the source.
        :param pulumi.Input[str] stream_id: The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        :param pulumi.Input[str] vpc_interface_name: The name of the VPC Interface this Source is configured with.
        :param pulumi.Input[str] whitelist_cidr: The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        """
        if decryption is not None:
            pulumi.set(__self__, "decryption", decryption)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entitlement_arn is not None:
            pulumi.set(__self__, "entitlement_arn", entitlement_arn)
        if ingest_ip is not None:
            pulumi.set(__self__, "ingest_ip", ingest_ip)
        if ingest_port is not None:
            pulumi.set(__self__, "ingest_port", ingest_port)
        if max_bitrate is not None:
            pulumi.set(__self__, "max_bitrate", max_bitrate)
        if max_latency is not None:
            pulumi.set(__self__, "max_latency", max_latency)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_arn is not None:
            pulumi.set(__self__, "source_arn", source_arn)
        if stream_id is not None:
            pulumi.set(__self__, "stream_id", stream_id)
        if vpc_interface_name is not None:
            pulumi.set(__self__, "vpc_interface_name", vpc_interface_name)
        if whitelist_cidr is not None:
            pulumi.set(__self__, "whitelist_cidr", whitelist_cidr)

    @property
    @pulumi.getter
    def decryption(self) -> Optional[pulumi.Input['FlowEncryptionArgs']]:
        """
        The type of encryption that is used on the content ingested from this source.
        """
        return pulumi.get(self, "decryption")

    @decryption.setter
    def decryption(self, value: Optional[pulumi.Input['FlowEncryptionArgs']]):
        pulumi.set(self, "decryption", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="entitlementArn")
    def entitlement_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
        """
        return pulumi.get(self, "entitlement_arn")

    @entitlement_arn.setter
    def entitlement_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entitlement_arn", value)

    @property
    @pulumi.getter(name="ingestIp")
    def ingest_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address that the flow will be listening on for incoming content.
        """
        return pulumi.get(self, "ingest_ip")

    @ingest_ip.setter
    def ingest_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingest_ip", value)

    @property
    @pulumi.getter(name="ingestPort")
    def ingest_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port that the flow will be listening on for incoming content.
        """
        return pulumi.get(self, "ingest_port")

    @ingest_port.setter
    def ingest_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ingest_port", value)

    @property
    @pulumi.getter(name="maxBitrate")
    def max_bitrate(self) -> Optional[pulumi.Input[int]]:
        """
        The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        """
        return pulumi.get(self, "max_bitrate")

    @max_bitrate.setter
    def max_bitrate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_bitrate", value)

    @property
    @pulumi.getter(name="maxLatency")
    def max_latency(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
        """
        return pulumi.get(self, "max_latency")

    @max_latency.setter
    def max_latency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_latency", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input['FlowSourceProtocol']]:
        """
        The protocol that is used by the source or output.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input['FlowSourceProtocol']]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the source.
        """
        return pulumi.get(self, "source_arn")

    @source_arn.setter
    def source_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_arn", value)

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> Optional[pulumi.Input[str]]:
        """
        The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        """
        return pulumi.get(self, "stream_id")

    @stream_id.setter
    def stream_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream_id", value)

    @property
    @pulumi.getter(name="vpcInterfaceName")
    def vpc_interface_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPC Interface this Source is configured with.
        """
        return pulumi.get(self, "vpc_interface_name")

    @vpc_interface_name.setter
    def vpc_interface_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_interface_name", value)

    @property
    @pulumi.getter(name="whitelistCidr")
    def whitelist_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        """
        return pulumi.get(self, "whitelist_cidr")

    @whitelist_cidr.setter
    def whitelist_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "whitelist_cidr", value)


