import { GraphQLError } from 'graphql';
export declare class InvalidTransformerError extends Error {
    constructor(message: string);
}
export declare class SchemaValidationError extends Error {
    constructor(errors: Readonly<GraphQLError[]>);
}
export declare class TransformerContractError extends Error {
    constructor(message: string);
}
export declare class InvalidMigrationError extends Error {
    fix: string;
    cause: string;
    constructor(message: string, cause: string, fix: string);
}
export declare class InvalidGSIMigrationError extends InvalidMigrationError {
    fix: string;
    cause: string;
    constructor(message: string, cause: string, fix: string);
}
export declare class InvalidDirectiveError extends Error {
    constructor(message: string);
}
export declare class UnknownDirectiveError extends Error {
    constructor(message: string);
}
//# sourceMappingURL=errors.d.ts.map