"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.stripDirectives = void 0;
const graphql_1 = require("graphql");
function stripDirectives(doc, except = []) {
    const definitions = [];
    for (const def of doc.definitions) {
        switch (def.kind) {
            case graphql_1.Kind.OBJECT_TYPE_DEFINITION:
                definitions.push(stripObjectDirectives(def));
                break;
            case graphql_1.Kind.INTERFACE_TYPE_DEFINITION:
                definitions.push(stripInterfaceDirectives(def));
                break;
            case graphql_1.Kind.UNION_TYPE_DEFINITION:
                definitions.push(stripUnionDirectives(def));
                break;
            case graphql_1.Kind.INPUT_OBJECT_TYPE_DEFINITION:
                definitions.push(stripInputObjectDirectives(def));
                break;
            case graphql_1.Kind.ENUM_TYPE_DEFINITION:
                definitions.push(stripEnumDirectives(def));
                break;
            case graphql_1.Kind.SCALAR_TYPE_DEFINITION:
                definitions.push(stripScalarDirectives(def));
                break;
        }
    }
    function excepted(dir) {
        return Boolean(except.find(f => dir.name.value === f));
    }
    function stripObjectDirectives(node) {
        const fields = node.fields ? node.fields.map(stripFieldDirectives) : node.fields;
        return {
            ...node,
            fields,
            directives: node.directives.filter(excepted),
        };
    }
    function stripInterfaceDirectives(node) {
        const fields = node.fields ? node.fields.map(stripFieldDirectives) : node.fields;
        return {
            ...node,
            fields,
            directives: node.directives.filter(excepted),
        };
    }
    function stripFieldDirectives(node) {
        const args = node.arguments ? node.arguments.map(stripArgumentDirectives) : node.arguments;
        return {
            ...node,
            arguments: args,
            directives: node.directives.filter(excepted),
        };
    }
    function stripArgumentDirectives(node) {
        return {
            ...node,
            directives: node.directives.filter(excepted),
        };
    }
    function stripUnionDirectives(node) {
        return {
            ...node,
            directives: node.directives.filter(excepted),
        };
    }
    function stripScalarDirectives(node) {
        return {
            ...node,
            directives: node.directives.filter(excepted),
        };
    }
    function stripInputObjectDirectives(node) {
        const fields = node.fields ? node.fields.map(stripArgumentDirectives) : node.fields;
        return {
            ...node,
            fields,
            directives: node.directives.filter(excepted),
        };
    }
    function stripEnumDirectives(node) {
        const values = node.values ? node.values.map(stripEnumValueDirectives) : node.values;
        return {
            ...node,
            values,
            directives: node.directives.filter(excepted),
        };
    }
    function stripEnumValueDirectives(node) {
        return {
            ...node,
            directives: node.directives.filter(excepted),
        };
    }
    return {
        kind: graphql_1.Kind.DOCUMENT,
        definitions,
    };
}
exports.stripDirectives = stripDirectives;
//# sourceMappingURL=stripDirectives.js.map