"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NONE_INT_VALUE = exports.NONE_VALUE = exports.toPascalCase = exports.toCamelCase = exports.toUpper = exports.simplifyName = exports.resourceName = exports.graphqlName = exports.plurality = void 0;
const md5_1 = __importDefault(require("md5"));
function plurality(val) {
    if (!val.trim()) {
        return '';
    }
    return val.concat('s');
}
exports.plurality = plurality;
function graphqlName(val) {
    if (!val.trim()) {
        return '';
    }
    const cleaned = val.replace(/^[^_A-Za-z]+|[^_0-9A-Za-z]/g, '');
    return cleaned;
}
exports.graphqlName = graphqlName;
function resourceName(val) {
    const nonAlpaNumericExp = /[^a-z0-9+]+/gi;
    if (nonAlpaNumericExp.test(val)) {
        return `${val.replace(nonAlpaNumericExp, '')}${md5_1.default(val).slice(0, 4)}`;
    }
    return val;
}
exports.resourceName = resourceName;
function simplifyName(val) {
    if (!val.trim()) {
        return '';
    }
    return toPascalCase(val
        .replace(/-?_?\${[^}]*}/g, '')
        .replace(/^[^_A-Za-z]+|[^_0-9A-Za-z]/g, '|')
        .split('|'));
}
exports.simplifyName = simplifyName;
function toUpper(word) {
    return word.charAt(0).toUpperCase() + word.slice(1);
}
exports.toUpper = toUpper;
function toCamelCase(words) {
    const formatted = words.map((w, i) => (i === 0 ? w.charAt(0).toLowerCase() + w.slice(1) : w.charAt(0).toUpperCase() + w.slice(1)));
    return formatted.join('');
}
exports.toCamelCase = toCamelCase;
function toPascalCase(words) {
    const formatted = words.map((w, i) => w.charAt(0).toUpperCase() + w.slice(1));
    return formatted.join('');
}
exports.toPascalCase = toPascalCase;
exports.NONE_VALUE = '___xamznone____';
exports.NONE_INT_VALUE = -2147483648;
//# sourceMappingURL=util.js.map